#pragma once

#include <vector>

#include <jenga/include/common/Exception.h>

#include <BoostSerializationSupport.h>

void ObpPlus( int step = 1 );

class UserProc;

class Schedule
{
public:
	enum Type
	{
		None = 10000,
		GlobalVar,		// O[oϐXPW[
		DataTable,		// f[^e[u XPW[
		Relocation,		// P[VXPW[
		UserProc,		// [U`֐ĂяoXPW[
		AddressOf,		// [U`֐ʒuXPW[
		DllProc,		// DLL֐ʒuXPW[
	};

private:
	Type type;
	long offset;

	union{
		LONG_PTR lpValue;
		const ::UserProc *pUserProc;
		const ::DllProc *pDllProc;
	};

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Schedule" );

		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( offset );
	}

public:
	Schedule()
	{
	}
	Schedule( Type type, long offset )
		: type( type )
		, offset( offset )
		, lpValue( 0 )
	{
	}
	Schedule( const ::UserProc *pUserProc, long offest )
		: type( Schedule::UserProc )
		, offset( offset )
		, pUserProc( pUserProc )
	{
	}
	Schedule( const ::DllProc *pDllProc, long offest )
		: type( Schedule::DllProc )
		, offset( offset )
		, pDllProc( pDllProc )
	{
	}
	~Schedule()
	{
	}

	Type GetType() const
	{
		return type;
	}
	long GetOffset() const
	{
		return offset;
	}
	const ::DllProc &GetDllProc() const
	{
		if( type != Schedule::DllProc )
		{
			SetError();
		}
		return *pDllProc;
	}
	const ::UserProc &GetUserProc() const
	{
		if( type != Schedule::UserProc )
		{
			SetError();
		}
		return *pUserProc;
	}

	void SpecifyAddressOf()
	{
		if( type != Schedule::UserProc )
		{
			SetError();
		}
		type = Schedule::AddressOf;
	}
};
typedef std::vector<Schedule> Schedules;

class NativeCode
{
	int allocateSize;
	char *codeBuffer;
	int size;

	Schedules schedules;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing(load) - NativeCode" );

		std::string code;
		ar & BOOST_SERIALIZATION_NVP( code );
		ar & BOOST_SERIALIZATION_NVP( size );
		ar & BOOST_SERIALIZATION_NVP( schedules );

		// ǂݍ݌̏
		Realloc( size );
		for( int i=0; i<size; i++ )
		{
			ULONG_PTR l;
			sscanf( code.c_str() + i*3, "%02x,", &l );
			codeBuffer[i] = (char)l;
		}
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		trace_for_serialize( "serializing(save) - NativeCode" );

		// ۑ
		char *tempCode = (char *)calloc( (size+1) * 3, 1 );
		for( int i=0; i<size; i++ )
		{
			char temp[32];
			sprintf( temp, "%02x,", (unsigned char)codeBuffer[i] );
			tempCode[i*3] = temp[0];
			tempCode[i*3+1] = temp[1];
			tempCode[i*3+2] = temp[2];
		}

		std::string code = tempCode;
		free( tempCode );

		ar & BOOST_SERIALIZATION_NVP( code );
		ar & BOOST_SERIALIZATION_NVP( size );
		ar & BOOST_SERIALIZATION_NVP( schedules );
	}


	void Realloc( int newSize )
	{
		if( allocateSize < newSize + 8192 )
		{
			while( allocateSize < newSize + 8192 )
			{
				allocateSize += 8192;
			}
			codeBuffer = (char *)realloc( codeBuffer, allocateSize );
		}
	}

public:
	NativeCode()
		: allocateSize( 8192 )
		, codeBuffer( (char *)malloc( allocateSize ) )
		, size( 0 )
	{
	}
	NativeCode( const NativeCode &nativeCode )
		: allocateSize( 8192 )
		, codeBuffer( (char *)malloc( allocateSize ) )
		, size( 0 )
	{
		Put( nativeCode );
	}
	NativeCode( const char *codeBuffer, int size )
		: allocateSize( 8192 )
		, codeBuffer( (char *)malloc( allocateSize ) )
		, size( 0 )
	{
		Put( codeBuffer, size );
	}
	~NativeCode()
	{
		free( codeBuffer );
	}
	void Clear()
	{
		size = 0;
	}

	void operator =( const NativeCode &nativeCode )
	{
		Clear();
		Put( nativeCode );
	}

	int GetSize() const
	{
		return size;
	}
	const Schedules &GetSchedules() const
	{
		return schedules;
	}

	long GetLong( int codePos ) const
	{
		return *(long *)(this->codeBuffer+codePos);
	}
	long _GetLong_ObpOld( int _obpOld ) const
	{
		extern char *OpBuffer;
		return *(long *)(OpBuffer+_obpOld);
	}

	void Overwrite( int codePos, char c )
	{
		codeBuffer[codePos] = c;
	}
	void OverwriteOld( int _obpOld, char c )
	{
		// 
		extern char *OpBuffer;
		OpBuffer[_obpOld] = c;
	}
	void Overwrite( int codePos, long newLongValue )
	{
		*(long *)(this->codeBuffer+codePos) = newLongValue;
	}
	void OverwriteOld( int _obpOld, long newLongValue )
	{
		// 
		extern char *OpBuffer;
		*(long *)(OpBuffer+_obpOld) = newLongValue;
	}

	void Put( const char *codeBuffer, int size )
	{
		Realloc( this->size + size );

		memcpy( this->codeBuffer + this->size, codeBuffer, size );
		this->size += size;

		// 
		extern char *OpBuffer;
		extern int obp;
		memcpy( OpBuffer + obp, codeBuffer, size );
		ObpPlus( size );
	}
	void Put( const NativeCode &nativeCode );
	void Put( _int64 i64data )
	{
		Put( (const char *)(&i64data), sizeof(_int64) );
	}
	void Put( long l, Schedule::Type scheduleType = Schedule::None )
	{
		if( scheduleType != Schedule::None )
		{
			schedules.push_back( Schedule( scheduleType, size ) );
		}

		*((long *)(codeBuffer+size))=l;
		size += sizeof(long);



		// 
		switch( scheduleType )
		{
		case Schedule::None:
			// Ȃ
			break;
		case Schedule::GlobalVar:
			extern CSchedule *pobj_GlobalVarSchedule;
			pobj_GlobalVarSchedule->add();
			break;
		case Schedule::DataTable:
			extern CSchedule *pobj_DataTableSchedule;
			pobj_DataTableSchedule->add();
			break;
		case Schedule::Relocation:
			// 
			break;
		default:
			Jenga::Throw( "scheduleTypeȒlێĂ" );
			break;
		}
		extern char *OpBuffer;
		extern int obp;
		*((long *)(OpBuffer+obp))=l;
		ObpPlus( sizeof(long) );
	}
	void PutUserProcSchedule( const UserProc *pUserProc, bool isCall );
	void PutDllProcSchedule( const DllProc *pDllProc );
	void Put( short s )
	{
		Put( (const char *)(&s), sizeof(short) );
	}
	void Put( char c )
	{
		Realloc( size + 1 );
		codeBuffer[size++] = c;



		// 
		extern char *OpBuffer;
		extern int obp;
		OpBuffer[obp]=c;
		ObpPlus();
	}
};
