#pragma once

class ObjectModule : public Jenga::Common::BoostSerializationSupport<ObjectModule>
{
public:
	// ^
	Meta meta;

	// O[ö̃lCeBuR[h
	NativeCode globalNativeCode;

	// f[^e[u
	DataTable dataTable;

	// XMLVACYp
private:
	virtual const char *RootTagName() const
	{
		return "objectModule";
	}
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - objectModule" );

		ar & BOOST_SERIALIZATION_NVP( meta );
		ar & BOOST_SERIALIZATION_NVP( globalNativeCode );
		ar & BOOST_SERIALIZATION_NVP( dataTable );
	}
};

class Linker
{
	// f[^e[uXPW[
	void ResolveDataTableSchedules( long dataSectionBaseOffset );

	// DLL֐XPW[
	void ResolveDllProcSchedules( long codeSectionBaseOffset, long importSectionBaseOffset );

	// [U`֐XPW[
	void ResolveUserProcSchedules( long codeSectionBaseOffset );

	// O[oϐXPW[
	void ResolveGlobalVarSchedules( long rwSectionBaseOffset );

	NativeCode nativeCode;

	DWORD imageBase;

public:
	Linker()
	{
	}

	void SetImageBase( DWORD imageBase )
	{
		this->imageBase = imageBase;
	}

	// N
	void Link( vector<ObjectModule *> &objectModules );
};
