#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void Call_DebugSys_SaveContext(){
	//call _System_GetEip
	extern const UserProc *pSub_System_GetEip;
	compiler.codeGenerator.op_call(pSub_System_GetEip);

	//mov rdx,rax
	compiler.codeGenerator.op_mov_RR(REG_RDX,REG_RAX);

	//mov rcx,rsp
	compiler.codeGenerator.op_mov_RR(REG_RCX,REG_RSP);

	//call _DebugSys_SaveContext
	extern const UserProc *pSub_DebugSys_SaveContext;
	compiler.codeGenerator.op_call(pSub_DebugSys_SaveContext);
}

bool Opcode_CallProcPtr( const char *variable, const char *lpszParms,ProcPointer *pProcPointer){

	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0)
		Call_DebugSys_SaveContext();


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(lpszParms);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pProcPointer->Params() );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck(variable,pProcPointer->Params() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	//X^bNt[ɑ݂̃p[^obNAbv
	pobj_parameter->BackupParameter( (int)pProcPointer->Params().size() );

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( variable,pProcPointer->Params() );

	//WX^AX^bNt[ɃZbg
	pobj_parameter->SetParameter(variable,pProcPointer->Params() );



	RELATIVE_VAR RelativeVar;
	GetVarOffsetReadOnly(variable,&RelativeVar,Type());
	SetVarPtrToReg(REG_RAX,&RelativeVar);

	//mov rax,qword ptr[rax]
	compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_RAX,REG_RAX,0,MOD_BASE);

	//call rax
	compiler.codeGenerator.PutOld(
		(char)0xFF,
		(char)0xD0
	);


	//WX^̃ubLO		p[^ZbgɃbNꂽWX^
	pobj_BlockReg->clear();

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//X^bNt[ɑ݂̃p[^𕜌
	pobj_parameter->RestoreParameter( (int)pProcPointer->Params().size() );

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}

bool Opcode_CallProc(const char *Parameter,const UserProc *pUserProc,DWORD dwFlags,const char *ObjectName,int RefType){
	// TODO: RefType͕sKvȂ̂ō폜
	int i2;

	if( pUserProc->IsMacro() ){
		if( lstrcmpi( pUserProc->GetName().c_str(), "Print" ) == 0 ){
			Opcode_Print(Parameter,0);
			return true;
		}
		if( lstrcmpi( pUserProc->GetName().c_str(), "Input" ) == 0 ){
			Opcode_Input(Parameter);
			return true;
		}
		if( lstrcmpi( pUserProc->GetName().c_str(), "Write" ) == 0 ){
			Opcode_Print(Parameter,1);
			return true;
		}
	}

	pUserProc->Using();

	bool isStatic = false;
	const CClass *pobj_c = NULL;
	const CMethod *pMethod = NULL;
	if( pUserProc->GetParentClassPtr() ){
		//NX̃o֐Ăяoꍇ̓ANZX`FbNs
		if(ObjectName[0] && (dwFlags&PROCFLAG_NEW)==0){
			if(lstrcmpi(ObjectName,"Super")==0){
				//NXo֐NX̌Ăяo
				pobj_c=compiler.pCompilingClass;
			}
			else{
				//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
				Type varType;
				GetVarType( ObjectName, varType, false );
				pobj_c = &varType.GetClass();
				if( NATURAL_TYPE( varType.GetBasicType() ) != DEF_OBJECT ){
					pobj_c=compiler.objectModule.meta.GetClasses().Find(ObjectName);
					if( pobj_c ){
						isStatic = true;
					}
					else{
						SetError(300,NULL,cp);
					}
				}
			}
		}
		else{
			if(dwFlags&PROCFLAG_NEW){
				//NewZqɂRXgN^Ăяo
				pobj_c=pUserProc->GetParentClassPtr();
			}
			else{
				//NXo֐瓯NX̃o֐̌Ăяo
				pobj_c=compiler.pCompilingClass;
			}
		}


		/////////////////////////////////
		// \bh擾
		/////////////////////////////////
		pMethod = NULL;
		if( ! isStatic ) pMethod = pobj_c->GetMethods().GetMethodPtr( pUserProc );
		if( ! pMethod ){
			//I\bh擾łȂƂ͐ÓI\bh𓖂
			pMethod = pobj_c->GetStaticMethods().GetMethodPtr( pUserProc );
			if( !pMethod ){
				SetError(300,NULL,cp);
				return false;
			}

			//ÓIo
			isStatic = true;
		}


		//////////////////////////////
		// ANZXG[`FbN
		//////////////////////////////

		if(ObjectName[0]){
			//ǑĂяo
			if(pobj_c==compiler.pCompilingClass){
				//NXIuWFNg̏ꍇ̓vCx[gANZXeF
				if( pMethod->IsNoneAccess() ){
					SetError(109,pUserProc->GetName(),cp);
					return false;
				}
			}
			else{
				if( pMethod->IsPrivate()
					|| pMethod->IsNoneAccess() ){
					SetError(109,pUserProc->GetName(),cp);
					return false;
				}
				if( pMethod->IsProtected() ){
					SetError(110,pUserProc->GetName(),cp);
					return false;
				}
			}
		}
		else{
			//NX̌ĂяoipɂACCESS_NON݂̂G[Ƃj
			if( pMethod->IsNoneAccess() ){
				SetError(109,pUserProc->GetName(),cp);
				return false;
			}
		}
	}


	///////////////////////////////////////////////////////////////
	// _System_LocalThis̃_~[Zbg
	///////////////////////////////////////////////////////////////

	char temporary[VN_SIZE]={0};
	if( pUserProc->GetParentClassPtr() && isStatic == false ){
		//_System_LocalThisip[^j̃_~[쐬
		lstrcpy(temporary,"0,");
	}

	if(Parameter[0]=='\0'&&temporary[0])
		temporary[lstrlen(temporary)-1]=0;
	else lstrcat(temporary,Parameter);


	//p[^ZbgOspItZbg擾iNew̏ꍇ͂This|C^i[Ăj
	int this_sp_offset = pobj_sf->GetNowSp();


	////////////////////////
	// p[^Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(temporary);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pUserProc->RealParams() );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck(pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetSecondParmNum() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	if(pUserProc->IsMacro()){
		//}N֐̏ꍇ́Ap[^ȗl
		pobj_parameter->MacroParameterSupport( pUserProc->RealParams() );
	}

	//X^bNt[ɑ݂̃p[^obNAbv
	pobj_parameter->BackupParameter( (int)pUserProc->RealParams().size() );

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetRealSecondParmNum() );

	//WX^AX^bNt[ɃZbg
	pobj_parameter->SetParameter(pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetRealSecondParmNum() );

	if(pUserProc->ReturnType().IsStruct() ){
		//////////////////////////////////////////////////////
		// ߂lɍ\̃CX^Xꍇ
		// ByRef _System_ReturnValue p[^Zbg
		//////////////////////////////////////////////////////


		//////////////////////////////////////////////////////
		/////    WX^̃obNAbv
		{	BACKUP_REGISTER_RESOURCE
		//////////////////////////////////////////////////////

			int object_size = pUserProc->ReturnType().GetClass().GetSize();

			//mov rcx,object_size
			compiler.codeGenerator.op_mov_RV(sizeof(_int64),REG_RCX,object_size);

			//call calloc
			extern const UserProc *pSub_calloc;
			compiler.codeGenerator.op_call(pSub_calloc);

			//mov r13,rax
			compiler.codeGenerator.op_mov_RR(REG_R13,REG_RAX);

		/////////////////////////////////////////////
		//////   WX^𕜌
			RESTORE_REGISTER_RESOURCE
		}////////////////////////////////////////////

		if( pUserProc->GetParentClassPtr() && isStatic == false ){
			//mov rdx,r13
			compiler.codeGenerator.op_mov_RR(REG_RDX,REG_R13);
		}
		else{
			//mov rcx,r13
			compiler.codeGenerator.op_mov_RR(REG_RCX,REG_R13);
		}
	}


	if( pUserProc->GetParentClassPtr() && isStatic == false ){
		///////////////////////////////
		// o֐̏ꍇ
		// this|C^rcxŎ󂯓n
		///////////////////////////////

		if(ObjectName[0] && (dwFlags&PROCFLAG_NEW)==0){
			if(lstrcmpi(ObjectName,"Super")==0) goto InClassMember;
			else{
				RELATIVE_VAR RelativeVar;
				if( pMethod->IsConst() ){
					//ConstANZX\ȃ\bh̏ꍇ
					if( !GetVarOffsetReadOnly( ObjectName, &RelativeVar, Type() ) ){
						return false;
					}
				}
				else{
					//ConstANZXs\ȃ\bh̏ꍇ
					if( !GetVarOffsetReadWrite( ObjectName, &RelativeVar, Type() ) ){
						return false;
					}
				}

				SetVarPtrToReg(REG_RCX,&RelativeVar);

				// QƂ̃|C^ɂ
				//mov rcx,qword ptr[rcx]
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_RCX,REG_RCX,0,MOD_BASE);
			}
		}
		else{
InClassMember:
			if(dwFlags&PROCFLAG_NEW){
				//NewZqɂRXgN^Ăяȍꍇ

				//mov rcx,qword ptr[rsp+offset]     X^bNt[𗘗p
				pobj_sf->ref_offset_data(REG_RCX, this_sp_offset);
			}
			else{
				//g̃IuWFNgThis|C^rcxɃRs[
				SetThisPtrToReg(REG_RCX);
			}
		}
	}

	if( pUserProc->IsVirtual() ){
		//z֐iIuWFNg\bhjĂяo
		//pObj->func_table->func1
		//                ->func2
		//                ->func3

		//mov r11,qword ptr[rcx]
		compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RCX,0,MOD_BASE);

		i2 = pobj_c->GetFuncNumInVtbl( pUserProc );

		//call qword ptr[r11+func_index]
		if(i2*PTR_SIZE<=0x7F){
			compiler.codeGenerator.PutOld(
				(char)0x41,
				(char)0xFF,
				(char)0x53,
				(char)(i2*PTR_SIZE)
			);
		}
		else{
			compiler.codeGenerator.PutOld(
				(char)0x41,
				(char)0xFF,
				(char)0x93,
				(long)(i2*PTR_SIZE)
			);
		}
	}
	else{
		//ʏĂяo

		//call ProcAddr
		compiler.codeGenerator.op_call(pUserProc);
	}

	/* 64RpCł͕sv
	if(pDllProc->bCdecl){
		//add esp,ParmSize
	}*/


	//WX^̃ubLO		p[^ZbgɃbNꂽWX^
	pobj_BlockReg->clear();

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//X^bNt[ɑ݂̃p[^𕜌
	pobj_parameter->RestoreParameter( (int)pUserProc->RealParams().size() );

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}

bool Opcode_CallDllProc( const char *lpszParms, DllProc *pDllProc ){

	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0&& pDllProc->GetName() != "DebugBreak" ){
		Call_DebugSys_SaveContext();
	}


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(lpszParms);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pDllProc->Params() );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck( pDllProc->GetName(), pDllProc->Params() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	//X^bNt[ɑ݂̃p[^obNAbv
	pobj_parameter->BackupParameter( (int)pDllProc->Params().size() );

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( pDllProc->GetName(), pDllProc->Params() );

	//WX^AX^bNt[ɃZbg
	pobj_parameter->SetParameter(pDllProc->GetName(), pDllProc->Params() );


	//WX^̃ubLO		p[^ZbgɃbNꂽWX^
	pobj_BlockReg->clear();


	//INꂽvV[W̌Ăяo

	//call dword ptr[ImportTable]
	compiler.codeGenerator.op_call( pDllProc );

	/* 64RpCł͕sv
	if(pDllProc->bCdecl){
		//add esp,ParmSize
	}*/

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//X^bNt[ɑ݂̃p[^𕜌
	pobj_parameter->RestoreParameter( (int)pDllProc->Params().size() );

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}
