#include "stdafx.h"

#include <boost/archive/xml_oarchive.hpp>
#include <boost/archive/xml_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/archive/binary_iarchive.hpp>
#include <boost/serialization/string.hpp>
#include <boost/serialization/access.hpp>
#include <boost/serialization/level.hpp>
#include <boost/serialization/vector.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/version.hpp>
#include <boost/serialization/is_abstract.hpp>

#include <BoostSerializationSupport.h>

#include <windows.h>

using namespace Jenga::Common;

template<class T_xml_schema> void BoostSerializationSupport<T_xml_schema>::echo( const char *msg ) const
{
	MessageBox( NULL, msg, "XMLVACY̗O", MB_OK );
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadXml( istream& ifs, bool isShowExceptionMessage )
{
	bool isSuccessful = false;

	try{
		boost::archive::xml_iarchive ia(ifs);

		// t@CǍ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteXml( ostream& ofs, bool isShowExceptionMessage ) const
{
	bool isSuccessful = false;

	try{
		boost::archive::xml_oarchive oa(ofs);

		// t@Cɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadXml( const string &xmlFilePath, bool isShowExceptionMessage )
{
	// ̓A[JCu̍쐬
	std::ifstream ifs( xmlFilePath.c_str() );
	
	bool result = ReadXml(ifs,isShowExceptionMessage);

	// ͂
	ifs.close();

	return result;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteXml( const string &xmlFilePath, bool isShowExceptionMessage ) const
{
	// o̓A[JCu̍쐬
	std::ofstream ofs( xmlFilePath.c_str() );

	bool result = WriteXml(ofs,isShowExceptionMessage);

	// o͂
	ofs.close();

	return result;
}

template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadBinary( const string &filePath, bool isShowExceptionMessage )
{
	// ̓A[JCu̍쐬
	std::ifstream ifs( filePath.c_str() );

	bool isSuccessful = false;
	try{
		boost::archive::binary_iarchive ia(ifs);

		// t@CǍ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// ͂
	ifs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteBinary( const string &filePath, bool isShowExceptionMessage ) const
{
	// o̓A[JCu̍쐬
	std::ofstream ofs( filePath.c_str() );

	bool isSuccessful = false;
	try{
		boost::archive::binary_oarchive oa(ofs);

		// t@Cɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// o͂
	ofs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}

template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadText( const string &filePath, bool isShowExceptionMessage )
{
	// ̓A[JCu̍쐬
	std::ifstream ifs( filePath.c_str() );

	bool isSuccessful = false;
	try{
		boost::archive::text_iarchive ia(ifs);

		// t@CǍ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// ͂
	ifs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::WriteText( const string &filePath, bool isShowExceptionMessage ) const
{
	// o̓A[JCu̍쐬
	std::ofstream ofs( filePath.c_str() );

	bool isSuccessful = false;
	try{
		boost::archive::text_oarchive oa(ofs);

		// t@Cɏo
		oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		if( isShowExceptionMessage )
		{
			echo( e.what() );
		}
	}
	catch(...){
		if( isShowExceptionMessage )
		{
			echo( "archive_exceptionȊO̕sȗO" );
		}
	}

	// o͂
	ofs.close();

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}

template<class T_xml_schema> bool BoostSerializationSupport<T_xml_schema>::ReadXmlFromString( const string &xmlBuffer )
{
	bool isSuccessful = false;

	// ̓A[JCu̍쐬
	std::istringstream iss( xmlBuffer );

	try{
		boost::archive::xml_iarchive ia(iss);

		// Xg[Ǎ
		ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

		isSuccessful = true;
	}
	catch(...){
		// s
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}


#include <Compiler.h>
#include <logger.h>

template class Jenga::Common::BoostSerializationSupport<ObjectModule>;
template class Jenga::Common::BoostSerializationSupport<LoggerSetting>;
