#pragma once

#include <BoostSerializationSupport.h>

//DataTable.cpp
class DataTable{
	char *buffer;
	int size;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		std::string _buffer;
		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( size );

		// ǂݍ݌̏
		Realloc( size );
		for( int i=0; i<size; i++ )
		{
			if( _buffer[i*3+2] != ',' )
			{
				//G[
				DebugBreak();
			}
			ULONG_PTR l;
			sscanf( _buffer.c_str() + i*3, "%02x,", &l );
			buffer[i] = (char)l;
		}
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		// ۑ
		char *tempCode = (char *)calloc( (size+1) * 3, 1 );
		for( int i=0; i<size; i++ )
		{
			char temp[32];
			sprintf( temp, "%02x,", (unsigned char)buffer[i] );
			tempCode[i*3] = temp[0];
			tempCode[i*3+1] = temp[1];
			tempCode[i*3+2] = temp[2];
		}

		std::string _buffer = tempCode;
		free( tempCode );

		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( size );
	}

public:
	DataTable()
		: buffer( (char *)malloc(100) )
		, size( 0 )
	{
		lstrcpy( buffer, "initialized!!!" );
	}
	DataTable( const DataTable &dataTable )
		: buffer( (char *)malloc(100) )
		, size( 0 )
	{
		lstrcpy( buffer, "initialized!!!" );
		AddBinary( dataTable.GetPtr(), dataTable.GetSize() );
	}
	~DataTable()
	{
		free( buffer );
	}
	void Clear()
	{
		size = 0;
	}

	void operator =( const DataTable &dataTable )
	{
		Clear();
		AddBinary( dataTable.GetPtr(), dataTable.GetSize() );
	}

	void Realloc( int size );
	int AddBinary( const void *buffer, int size );
	int Add( _int64 i64data );
	int Add( int i32data );
	int Add( double dbl );
	int Add( float flt );
	int AddString( const char *str, int length );
	int AddString( const char *str );

	const void *GetPtr() const;
	int GetSize() const;
};
