#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Program.h>
#include <Compiler.h>
#include <Class.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void SystemProc( const UserProc &userProc ){
	if( userProc.GetName() == "_System_GetEip" ){
		//mov rax,qword ptr[rsp]
		compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_RAX,REG_RSP,0,MOD_BASE);

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_InitDllGlobalVariables" ){
		////////////////////////////////////////
		// DLL̃O[öRpC
		////////////////////////////////////////
		extern BOOL bDll;
		if(!bDll){
			//ret
			compiler.codeGenerator.op_ret();

			return;
		}

		const UserProc *pBackUserProc = &UserProc::CompilingUserProc();
		UserProc::CompileStartForGlobalArea();

		int BackCp;
		BackCp=cp;
		cp=-1;

		//sub rsp,X^bNt[TCY
		int StackFrameSchedule;
		compiler.codeGenerator.op_sub_rsp(0xFFFFFFFF);
		StackFrameSchedule=obp-sizeof(long);

		extern BOOL bDebugCompile;
		if(bDebugCompile){
			//fobOp̕ϐ`
			DebugVariable();
		}

		//GCp̕ϐ`
		InitGCVariables();

		//_System_StartupProgram̌Ăяo
		extern const UserProc *pSub_System_StartupProgram;
		compiler.codeGenerator.op_call(pSub_System_StartupProgram);

		//NXɑÓIo`
		compiler.GetMeta().GetClasses().InitStaticMember();

		GetGlobalDataForDll();

		//add rsp,X^bNt[TCY
		compiler.codeGenerator.op_add_RV(REG_RSP,pobj_sf->GetFrameSize(0));

		//X^bNt[XPW[isubR}hɓnlj
		*((long *)(OpBuffer+StackFrameSchedule))=pobj_sf->GetFrameSize(0);

		UserProc::CompileStartForUserProc( pBackUserProc );
		cp=BackCp;

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_InitStaticLocalVariables" ){
		//ÓI[JIuWFNg̃RXgN^Ăяo

		//sub rsp,X^bNt[TCY
		int StackFrameSchedule;
		compiler.codeGenerator.op_sub_rsp(0xFFFFFFFF);
		StackFrameSchedule=obp-sizeof(long);

		BOOST_FOREACH( Variable *pVar, compiler.GetMeta().GetGlobalVars() ){
			if(memicmp(pVar->GetName().c_str(),"Static%",7)==0){
				//RXgN^Ăяo
				if( pVar->GetType().IsObject() ){

					//G[p
					cp=pVar->source_code_address;

					CallConstructor(
						pVar->GetName().c_str(),
						pVar->GetSubscripts(),
						pVar->GetType(),
						pVar->GetParamStrForConstructor().c_str());
				}
			}
		}

		//add rsp,X^bNt[TCY
		compiler.codeGenerator.op_add_RV(REG_RSP,pobj_sf->GetFrameSize(0));

		//X^bNt[XPW[isubR}hɓnlj
		*((long *)(OpBuffer+StackFrameSchedule))=pobj_sf->GetFrameSize(0);

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_Call_Destructor_of_GlobalObject" ){
		//sub rsp,8iRSP16oCgEɂ킹邽߁j
		compiler.codeGenerator.op_sub_rsp(0x8);


		const UserProc *pBackUserProc = &UserProc::CompilingUserProc();
		UserProc::CompileStartForGlobalArea();

		compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

		UserProc::CompileStartForUserProc( pBackUserProc );


		//add rsp,8
		compiler.codeGenerator.op_add_RV(REG_RSP,0x8);

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_GetSp" ){
		//mov rax,rsp
		compiler.codeGenerator.op_mov_RR(REG_RAX,REG_RSP);

		//add rax,PTR_SIZE
		compiler.codeGenerator.op_add_RV(REG_RAX,PTR_SIZE);

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_allrem" ){
		//揜Zp̓֐i64rbgΉj
		BYTE Buffer_allrem[]={
			0x53,0x57,0x33,0xFF,0x8B,0x44,0x24,0x10,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x0C,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x10,0x89,0x54,0x24,0x0C,0x8B,0x44,0x24,0x18,0x0B,0xC0,0x7D,0x13,0x8B,0x54,0x24,0x14,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x18,0x89,0x54,0x24,0x14,0x0B,0xC0,0x75,0x1B,0x8B,0x4C,0x24,0x14,0x8B,0x44,0x24,0x10,0x33,0xD2,0xF7,0xF1,0x8B,0x44,0x24,0x0C,0xF7,0xF1,0x8B,0xC2,0x33,0xD2,0x4F,0x79,0x4E,0xEB,0x53,0x8B,0xD8,0x8B,0x4C,0x24,0x14,0x8B,0x54,0x24,0x10,0x8B,0x44,0x24,0x0C,0xD1,0xEB,0xD1,0xD9,0xD1,0xEA,0xD1,0xD8,0x0B,0xDB,0x75,0xF4,0xF7,0xF1,0x8B,0xC8,0xF7,0x64,0x24,0x18,0x91,0xF7,0x64,0x24,0x14,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x10,0x77,0x08,0x72,0x0E,0x3B,0x44,0x24,0x0C,0x76,0x08,0x2B,0x44,0x24,0x14,0x1B,0x54,0x24,0x18,0x2B,0x44,0x24,0x0C,0x1B,0x54,0x24,0x10,0x4F,0x79,0x07,0xF7,0xDA,0xF7,0xD8,0x83,0xDA,0x00,0x5F,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_allrem,178);
		obp+=178;
	}
	else if( userProc.GetName() == "_allmul" ){
		//Zp̓֐i64rbgΉj
		BYTE Buffer_allmul[]={
			0x8B,0x44,0x24,0x08,0x8B,0x4C,0x24,0x10,0x0B,0xC8,0x8B,0x4C,0x24,0x0C,0x75,0x09,0x8B,0x44,0x24,0x04,0xF7,0xE1,0xC2,0x10,0x00,0x53,0xF7,0xE1,0x8B,0xD8,0x8B,0x44,0x24,0x08,0xF7,0x64,0x24,0x14,0x03,0xD8,0x8B,0x44,0x24,0x08,0xF7,0xE1,0x03,0xD3,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_allmul,52);
		obp+=52;
	}
	else if( userProc.GetName() == "_alldiv" ){
		//Zp̓֐i64rbgΉj
		BYTE Buffer_alldiv[]={
			0x57,0x56,0x53,0x33,0xFF,0x8B,0x44,0x24,0x14,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x10,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x14,0x89,0x54,0x24,0x10,0x8B,0x44,0x24,0x1C,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x18,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x1C,0x89,0x54,0x24,0x18,0x0B,0xC0,0x75,0x18,0x8B,0x4C,0x24,0x18,0x8B,0x44,0x24,0x14,0x33,0xD2,0xF7,0xF1,0x8B,0xD8,0x8B,0x44,0x24,0x10,0xF7,0xF1,0x8B,0xD3,0xEB,0x41,0x8B,0xD8,0x8B,0x4C,0x24,0x18,0x8B,0x54,0x24,0x14,0x8B,0x44,0x24,0x10,0xD1,0xEB,0xD1,0xD9,0xD1,0xEA,0xD1,0xD8,0x0B,0xDB,0x75,0xF4,0xF7,0xF1,0x8B,0xF0,0xF7,0x64,0x24,0x1C,0x8B,0xC8,0x8B,0x44,0x24,0x18,0xF7,0xE6,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x14,0x77,0x08,0x72,0x07,0x3B,0x44,0x24,0x10,0x76,0x01,0x4E,0x33,0xD2,0x8B,0xC6,0x4F,0x75,0x07,0xF7,0xDA,0xF7,0xD8,0x83,0xDA,0x00,0x5B,0x5E,0x5F,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_alldiv,170);
		obp+=170;
	}
	else if( userProc.GetName() == "_allshl" ){
		//荶rbgVtgp̓֐i64rbgΉj
		BYTE Buffer_allshl[]={
			0x80,0xF9,0x40,0x73,0x15,0x80,0xF9,0x20,0x73,0x06,0x0F,0xA5,0xC2,0xD3,0xE0,0xC3,0x8B,0xD0,0x33,0xC0,0x80,0xE1,0x1F,0xD3,0xE2,0xC3,0x33,0xC0,0x33,0xD2,0xC3
		};

		memcpy(OpBuffer+obp,Buffer_allshl,31);
		obp+=31;
	}
	else if( userProc.GetName() == "_allshr" ){
		//ErbgVtgp̓֐i64rbgΉj
		BYTE Buffer_allshr[]={
			0x80,0xF9,0x40,0x73,0x16,0x80,0xF9,0x20,0x73,0x06,0x0F,0xAD,0xD0,0xD3,0xFA,0xC3,0x8B,0xC2,0xC1,0xFA,0x1F,0x80,0xE1,0x1F,0xD3,0xF8,0xC3,0xC1,0xFA,0x1F,0x8B,0xC2,0xC3
		};

		memcpy(OpBuffer+obp,Buffer_allshr,33);
		obp+=33;
	}
	else if( userProc.GetName() == "_aullshr" ){
		//ȂErbgVtgp̓֐i64rbgΉj
		BYTE Buffer_aullshr[]={
			0x80,0xF9,0x40,         //cmp         cl,40h
			0x73,0x15,              //jae         RETZERO (0040d71a)
			0x80,0xF9,0x20,         //cmp         cl,20h
			0x73,0x06,              //jae         MORE32 (0040d710)
			0x0F,0xAD,0xD0,         //shrd        eax,edx,cl
			0xD3,0xEA,              //shr         edx,cl
			0xC3,                   //ret
			//MORE32:
			0x8B,0xC2,              //mov         eax,edx
			0x33,0xD2,              //xor         edx,edx
			0x80,0xE1,0x1F,         //and         cl,1Fh
			0xD3,0xE8,              //shr         eax,cl
			0xC3,                   //ret
			//RETZERO:
			0x33,0xC0,              //xor         eax,eax
			0x33,0xD2,              //xor         edx,edx
			0xC3                    //ret
		};

		memcpy(OpBuffer+obp,Buffer_aullshr,31);
		obp+=31;
	}
	else{
		SetError();
	}
}
void AutoGeneration(const UserProc &userProc){
	if( userProc.GetName() == "InitializeUserTypes"
		&& userProc.HasParentClass()
		&& userProc.GetParentClass().GetName() == "_System_TypeBase" ){

			compiler.GetMeta().GetClasses().Compile_System_InitializeUserTypes();
	}
	else if( userProc.GetName() == "RegisterGlobalRoots"
		&& userProc.HasParentClass()
		&& userProc.GetParentClass().GetName() == "_System_CGarbageCollection" ){

			Compile_AddGlobalRootsForGc();
	}
	else{
		SetError();
	}
}
void _compile_proc(const UserProc *pUserProc){
	extern char *basbuf;
	extern HANDLE hHeap;
	extern BOOL bDebugCompile;
	int i3,i4;
	char temporary[VN_SIZE];

	if( pUserProc->IsUsing() == false || pUserProc->IsCompiled() ) return;

	if( pUserProc->GetLocalVars().size() ){
		SetError();
		return;
	}

	trace_for_sourcecodestep( " " << pUserProc->GetFullName() << "̃RpCJn" );

	pUserProc->CompleteCompile();

	extern BOOL bSystemProc;
	if(memcmp(pUserProc->GetName().c_str(),"_System_",8)==0) bSystemProc=1;
	else bSystemProc=0;

	extern BOOL bDebugSupportProc;
	if(memcmp(pUserProc->GetName().c_str(),"_DebugSys_",10)==0){
		if(!bDebugCompile){
			return;
		}
		bDebugSupportProc=1;
	}
	else bDebugSupportProc=0;

	pUserProc->SetBeginOpAddress( obp );

	//RpC̊֐NX
	compiler.pCompilingClass=pUserProc->GetParentClassPtr();

	//RpCX^[gNXǗNXɒǉ
	compiler.GetMeta().GetClasses().StartCompile( pUserProc );

	//RpC̊֐
	UserProc::CompileStartForUserProc( pUserProc );

	// RpC̊֐閼O
	compiler.GetNamespaceSupporter().SetLivingNamespaceScopes( pUserProc->GetNamespaceScopes() );

	// RpC̊֐ImportsĂ閼O
	compiler.GetNamespaceSupporter().SetImportedNamespaces( pUserProc->GetImportedNamespaces() );

	// R[hΏۂI
	compiler.codeGenerator.Select( (const_cast<UserProc *>(pUserProc))->GetNativeCode() );

	if(pUserProc->IsSystem()){
		////////////////////
		// ֐
		////////////////////

		extern int AllLocalVarSize;
		AllLocalVarSize=0;

		//X^bNt[ǗpIuWFNg
		extern CStackFrame *pobj_sf;
		pobj_sf=new CStackFrame();

		SystemProc(*pUserProc);

		//X^bNt[ǗpIuWFNgj
		delete pobj_sf;
		pobj_sf=0;

		pUserProc->SetEndOpAddress( obp );
		return;
	}

	cp=pUserProc->GetCodePos();
	for(;;cp++){
		if(IsCommandDelimitation(basbuf[cp])) break;
	}
	cp--;

	//vV[WoXPW[iExit Sub/Functionj
	compiler.codeGenerator.exitSubCodePositions.clear();
	compiler.codeGenerator._exitSubCodePositions_ObpOld.clear();

	//xp̃m
	extern LABEL *pLabelNames;
	extern int MaxLabelNum;
	pLabelNames=(LABEL *)HeapAlloc(hHeap,0,1);
	MaxLabelNum=0;

	//GotoxXPW[
	compiler.codeGenerator.gotoLabelSchedules.clear();

	//With̃m
	extern WITHINFO WithInfo;
	WithInfo.ppName=(char **)HeapAlloc(hHeap,0,1);
	WithInfo.pWithCp=(int *)HeapAlloc(hHeap,0,1);
	WithInfo.num=0;

	//dG[Ǘ̃m
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	//ContinueAhX
	compiler.codeGenerator.ClearContinueArea();

	//[JϐɊւ
	extern int AllLocalVarSize;
	AllLocalVarSize=0;

	//LVJXR[v
	compiler.codeGenerator.lexicalScopes.Init(obp);


	/////////////////////////////////////
	// p[^p̕ϐf[^l
	/////////////////////////////////////

	//p[^p̕ϐf[^l
	for(i3=(int)pUserProc->RealParams().size()-1;i3>=0;i3--){
		Parameter &param = *pUserProc->RealParams()[i3];

		Variable *pVar = new Variable( param.GetVarName(), param, false, param.IsRef(), "" );

		if( param.IsArray() ){
			pVar->SetArray( param.GetSubscripts() );
		}

		int varSize;
		if( param.IsRef() == false && param.IsStruct() ){
			//\̂ByValp[^
			pVar->ThisIsParameter();
			varSize=PTR_SIZE;
		}
		else{
			if( param.IsArray() == false ){
				varSize = pVar->GetMemorySize();
			}
			else{
				varSize=PTR_SIZE;
			}
		}
		AllLocalVarSize+=varSize;
		pVar->SetOffsetAddress( AllLocalVarSize );

		//LVJXR[v
		pVar->SetScopeLevel( compiler.codeGenerator.lexicalScopes.GetNowLevel() );
		pVar->SetScopeStartAddress( compiler.codeGenerator.lexicalScopes.GetStartAddress() );
		pVar->bLiving=TRUE;

		pUserProc->GetLocalVars().push_back( pVar );
	}

	//This|C^[JItZbglZbg
	extern int LocalVar_ThisPtrOffset;
	LocalVar_ThisPtrOffset=AllLocalVarSize;

	//X^bNt[ǗpNX
	extern CStackFrame *pobj_sf;
	pobj_sf=new CStackFrame();


	///////////////////////
	// R[h

	for(i3=(int)pUserProc->RealParams().size()-1;i3>=0;i3--){
		Parameter &param = *pUserProc->RealParams()[i3];
		if(i3==3){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x20],xmm3
				compiler.codeGenerator.op_movsd_MR(REG_XMM3,REG_RSP,0x20,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x20],r9
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_R9,REG_RSP,0x20,MOD_BASE_DISP32);
			}
		}
		if(i3==2){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x18],xmm2
				compiler.codeGenerator.op_movsd_MR(REG_XMM2,REG_RSP,0x18,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x18],r8
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_R8,REG_RSP,0x18,MOD_BASE_DISP32);
			}
		}
		if(i3==1){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x10],xmm1
				compiler.codeGenerator.op_movsd_MR(REG_XMM1,REG_RSP,0x10,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x10],rdx
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RDX,REG_RSP,0x10,MOD_BASE_DISP32);
			}
		}
		if(i3==0){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x8],xmm0
				compiler.codeGenerator.op_movsd_MR(REG_XMM0,REG_RSP,0x8,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x8],rcx
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RCX,REG_RSP,0x8,MOD_BASE_DISP32);
			}
		}
	}

	//retp̃AhXl
	AllLocalVarSize+=sizeof(_int64);

	//sub rsp,X^bNt[TCY
	int StackFrameSchedule;
	compiler.codeGenerator.op_sub_rsp(0xFFFFFFFF);
	StackFrameSchedule=obp-sizeof(long);

	//mov qword ptr[rsp+offset],reg     X^bNt[𗘗p
	pobj_sf->push(REG_RBX);
	pobj_sf->push(REG_RSI);
	pobj_sf->push(REG_RDI);
	pobj_sf->push(REG_R12);
	pobj_sf->push(REG_R13);
	pobj_sf->push(REG_R14);
	pobj_sf->push(REG_R15);

	//[Jϐ̃x[Xl
	int BaseLocalVar;
	BaseLocalVar=AllLocalVarSize;

	if( !pUserProc->ReturnType().IsNull() ){
		//߂l݂Ƃ

		const char *temp = pUserProc->GetName().c_str();
		if( temp[0]==1&&temp[1]==ESC_OPERATOR ){
			temp = "_System_ReturnValue";
		}

		if( pUserProc->ReturnType().IsStruct() ){
			//߂lp̍\́il^j̓p[^ňn
		}
		else{
			if( pUserProc->ReturnType().IsObject() ){
				sprintf(temporary,"%s=Nothing%c%c%s",temp,1,ESC_AS, Compiler::TypeToString( pUserProc->ReturnType() ).c_str() );
			}
			else{
				//߂lp̕ϐ̒`
				sprintf(temporary,"%s%c%c%s",temp,1,ESC_AS, Compiler::TypeToString( pUserProc->ReturnType() ).c_str() );
			}

			OpcodeDim(temporary,0);
		}
	}

	int RspOffsetSchedule=0;
	int RspOffsetSchedule2;
	if(bDebugCompile&&bDebugSupportProc==0){
		//mov rdx, qword ptr[rsp+X^bNt[TCY]
		compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_RDX,REG_RSP,0,MOD_BASE_DISP32);
		RspOffsetSchedule=obp-sizeof(long);

		//mov rcx,rsp
		compiler.codeGenerator.op_mov_RR(REG_RCX,REG_RSP);

		//add rcx,X^bNt[TCY+sizeof(_int64) retp̃TCYl
		compiler.codeGenerator.op_add_RV(REG_RCX,0);
		RspOffsetSchedule2=obp-sizeof(long);

		//call _DebugSys_StartProc
		extern const UserProc *pSub_DebugSys_StartProc;
		compiler.codeGenerator.op_call(pSub_DebugSys_StartProc);
	}

	if(compiler.pCompilingClass){
		if( pUserProc->GetName() == compiler.pCompilingClass->GetName() ){
			////////////////////////////////////
			// RXgN^RpCƂ
			////////////////////////////////////

			//RXgN^̃RpCJnʒm
			compiler.pCompilingClass->NotifyStartConstructorCompile();

			//NXǂ̎
			//ipC^[tFCX̏ꍇNXƌȂj
			BOOL bThisIsSuperClass;
			if( !compiler.pCompilingClass->HasSuperClass() ) bThisIsSuperClass=1;
			else if( compiler.pCompilingClass->GetSuperClass().GetConstructorMethod() == NULL ){
				//C^[tFCXpƂ̓RXgN^Ȃ
				bThisIsSuperClass=1;
			}
			else bThisIsSuperClass=0;

			if(!bThisIsSuperClass){
				/* TuNXRXgN^RpCĂƂ́A
					NX̃RXgN^Ăяo */

				i3=cp+1;
				while(IsCommandDelimitation(basbuf[i3])) i3++;
				for(i4=0;;i3++,i4++){
					if(!IsVariableChar(basbuf[i3])){
						temporary[i4]=0;
						break;
					}
					temporary[i4]=basbuf[i3];
				}
				if( compiler.pCompilingClass->GetSuperClass().GetName() == temporary ){
					//NX̃RXgN^Ăяo
					cp=i3;
					for(i4=0;;cp++,i4++){
						if(IsCommandDelimitation(basbuf[cp])){
							temporary[i4]=0;
							break;
						}
						temporary[i4]=basbuf[cp];
					}
					if(!(temporary[0]=='('&&temporary[lstrlen(temporary)-1]==')')){
						SetError(1,NULL,cp);
					}
					RemoveStringPare(temporary);

					Type dummyType;
					CallProc( PROC_DEFAULT
						, &compiler.pCompilingClass->GetSuperClass().GetConstructorMethod()->GetUserProc()
						, compiler.pCompilingClass->GetSuperClass().GetConstructorMethod()->GetUserProc().GetName().c_str()
						, temporary
						, dummyType );
				}
				else{
					//NX̃RXgN^ÖٓIɌĂяo
					Opcode_CallProc("",
						&compiler.pCompilingClass->GetSuperClass().GetConstructorMethod()->GetUserProc(),
						0,
						"",
						0);
				}
			}

			//z֐e[u
			if( compiler.pCompilingClass->IsExistVirtualFunctions()
				&& !compiler.pCompilingClass->IsAbstract() ){
					//֐e[uɒlZbg
					int offset = (int)compiler.pCompilingClass->GetVtblGlobalOffset();

					//mov rax,offset
					compiler.codeGenerator.op_mov_RV(sizeof(_int64),REG_RAX,offset, Schedule::DataTable );

					//This|C^rcxɃRs[
					SetThisPtrToReg(REG_RCX);

					//mov qword ptr[rcx],rax
					compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RAX,REG_RCX,0,MOD_BASE);
			}
		}
		else if( pUserProc->IsDestructor() ){
			//fXgN^RpCƂ

			//fXgN^̃RpCJnʒm
			compiler.pCompilingClass->NotifyStartDestructorCompile();
		}
	}

	//////////////////////////////////////////
	//////////////////////////////////////////
	////// vV[WRpC ////////
	if( pUserProc->IsAutoGeneration() ){
		AutoGeneration( *pUserProc );
	}
	else{
		if(pUserProc->IsMacro()){
			CompileBuffer(ESC_ENDMACRO,0);
		}
		else{
			if(pUserProc->IsSub()){
				CompileBuffer(ESC_ENDSUB,0);
			}
			else if(pUserProc->IsFunction()){
				CompileBuffer(ESC_ENDFUNCTION,0);
			}
		}
	}
	//////////////////////////////////////////
	//////////////////////////////////////////

	if( compiler.pCompilingClass ){

		if( compiler.pCompilingClass->IsCompilingConstructor() ){
			// RXgN^RpCĂƂ

			// RXgN^̃RpCƂʒm
			compiler.pCompilingClass->NotifyFinishConstructorCompile();
		}
		else if( pUserProc->IsDestructor() ){
			////////////////////////////////////
			//fXgN^RpCƂ
			////////////////////////////////////

			// fXgN^̃RpCƂʒm
			compiler.pCompilingClass->NotifyFinishDestructorCompile();

			if( compiler.pCompilingClass->HasSuperClass() ){
				/* TuNX̃fXgN^RpCĂƂ́A
					NX̃fXgN^Ăяo */

				const CMethod *method = compiler.pCompilingClass->GetSuperClass().GetDestructorMethod();
				if( method ){
					Opcode_CallProc("",
						&method->GetUserProc(),
						0,
						"",
						0);
				}
			}
		}
	}

	//xp̃
	for(i3=0;i3<MaxLabelNum;i3++){
		if(pLabelNames[i3].pName) HeapDefaultFree(pLabelNames[i3].pName);
	}
	HeapDefaultFree(pLabelNames);

	//With̃
	for(i3=0;i3<WithInfo.num;i3++){
		SetError(22,"With",WithInfo.pWithCp[i3]);
		HeapDefaultFree(WithInfo.ppName[i3]);
	}
	HeapDefaultFree(WithInfo.ppName);
	HeapDefaultFree(WithInfo.pWithCp);

	//[JIuWFNgiLVJXR[vx=0j̉
	compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

	//vV[WoXPW[iExit Sub/Functionj
	compiler.codeGenerator.ResolveExitSubSchedule();

	if(bDebugCompile&&bDebugSupportProc==0){
		//call _DebugSys_EndProc
		extern const UserProc *pSub_DebugSys_EndProc;
		compiler.codeGenerator.op_call(pSub_DebugSys_EndProc);
	}

	if( !pUserProc->ReturnType().IsNull() ){
		//////////////////////////////////
		// ߂lrax܂xmm0ɐݒ
		//////////////////////////////////

		RELATIVE_VAR RelativeVar;

		const char *temp = pUserProc->GetName().c_str();
		if( temp[0]==1 && temp[1]==ESC_OPERATOR ){
			temp="_System_ReturnValue";
		}
		GetVarOffsetReadWrite(temp,&RelativeVar,Type());

		i3=pUserProc->ReturnType().GetBasicType();

		if(i3==DEF_OBJECT || i3==DEF_STRUCT){
			SetVarPtrToReg(REG_RAX,&RelativeVar);
			if( i3==DEF_OBJECT ){
				//mov rax,qword ptr[rax]
				compiler.codeGenerator.op_mov_RM( sizeof(_int64), REG_RAX, REG_RAX, 0, MOD_BASE );
			}
		}
		else if(i3==DEF_DOUBLE){
			//64rbg^
			SetXmmReg_DoubleVariable(&RelativeVar,REG_XMM0);
		}
		else if(i3==DEF_SINGLE){
			//32rbg^
			SetXmmReg_SingleVariable(&RelativeVar,REG_XMM0);
		}
		else if(IsWholeNumberType(i3)){
			//^
			SetReg_WholeVariable(i3,&RelativeVar,REG_RAX);
		}
		else SetError(300,NULL,cp);
	}

	//[Jϐ̈̃TCYX^bNt[ɒʒm
	int localParmSize = AllLocalVarSize - BaseLocalVar;
	int stackFrameSize = pobj_sf->GetFrameSize( localParmSize );

	//[JϐAhXXPW[
	BOOST_FOREACH( const PertialSchedule *pPertialSchedule, compiler.codeGenerator.localVarPertialSchedules )
	{
		compiler.codeGenerator.opfix_offset( pPertialSchedule, AllLocalVarSize );
	}
	compiler.codeGenerator.localVarPertialSchedules.clear();
	BOOST_FOREACH( Variable *pVar, pUserProc->GetLocalVars() ){
		//ɃfobOŗp
		pVar->SetOffsetAddress(
			AllLocalVarSize + stackFrameSize - pVar->GetOffsetAddress()
		);
	}

	//mov reg,qword ptr[rsp+offset]     X^bNt[𗘗p
	pobj_sf->pop(REG_R15);
	pobj_sf->pop(REG_R14);
	pobj_sf->pop(REG_R13);
	pobj_sf->pop(REG_R12);
	pobj_sf->pop(REG_RDI);
	pobj_sf->pop(REG_RSI);
	pobj_sf->pop(REG_RBX);

	int stackFrameAndLocalParamSize = localParmSize + stackFrameSize;

	//add rsp,X^bNt[TCY
	compiler.codeGenerator.op_add_rsp(stackFrameAndLocalParamSize);

	//ret
	compiler.codeGenerator.op_ret();


	//fobOp
	if(RspOffsetSchedule){
		*((long *)(OpBuffer+RspOffsetSchedule))=stackFrameAndLocalParamSize;
		*((long *)(OpBuffer+RspOffsetSchedule2))=stackFrameAndLocalParamSize+sizeof(_int64);
	}


	//X^bNt[XPW[isubR}hj
	*((long *)(OpBuffer+StackFrameSchedule))=stackFrameAndLocalParamSize;

	//X^bNt[XPW[s
	pobj_sf->RunningSchedule( stackFrameSize );
	delete pobj_sf;
	pobj_sf=0;


	pUserProc->SetEndOpAddress( obp );


	//dG[Ǘ̃
	for(i3=0;i3<SynonymErrorNum;i3++) HeapDefaultFree(SynonymErrorWords[i3]);
	HeapDefaultFree(SynonymErrorWords);
}

void CompileBufferInProcedure( const UserProc &userProc ){
	if( userProc.IsUsing() == false || userProc.IsCompiled() ) return;

	_compile_proc( &userProc );

	// O𗚂
	char temporary[8192];
	temporary[0]=0;
	lstrcat( temporary, "------------------------------------------------------------------\n" );
	sprintf( temporary + lstrlen(temporary), "y %s ̃R[hz\n", userProc.GetName().c_str() );
	sprintf( temporary + lstrlen(temporary), "code size: %d bytes\n", userProc.GetCodeSize() );
	lstrcat( temporary, "------------------------------------------------------------------\n" );
	lstrcat( temporary, "\n" );
	trace_for_size( temporary );
}
void CompileLocal(){
	extern BOOL bDll;
	if(bDll){
		//DLL̏ꍇ̓O[oϐ邽߂̊֐ԏ߂ɃRpC
		const UserProc *pUserProc = GetSubHash("_System_InitDllGlobalVariables");
		if(pUserProc){
			CompileBufferInProcedure( *pUserProc );
		}
		else SetError(300,NULL,cp);
	}

	//_System_TypeBase_InitializeUserTypes͈ԍŌɃRpC
	extern const UserProc *pSubStaticMethod_System_TypeBase_InitializeUserTypes;
	pSubStaticMethod_System_TypeBase_InitializeUserTypes->CompleteCompile();

	//_System_InitStaticLocalVariables͈ԍŌɃRpC
	//ʊ֐̐ÓIϐIuWFNgׂĎWȂ΂ȂȂ
	extern const UserProc *pSub_System_InitStaticLocalVariables;
	pSub_System_InitStaticLocalVariables->CompleteCompile();

	//_System_Call_Destructor_of_GlobalObject͈ԍŌɃRpC
	extern const UserProc *pSub_System_Call_Destructor_of_GlobalObject;
	pSub_System_Call_Destructor_of_GlobalObject->CompleteCompile();

repeat:
	compiler.GetMeta().GetUserProcs().Iterator_Reset();
	while( compiler.GetMeta().GetUserProcs().Iterator_HasNext() )
	{
		UserProc *pUserProc = compiler.GetMeta().GetUserProcs().Iterator_GetNext();
		CompileBufferInProcedure( *pUserProc );
	}

	if( IsNeedProcCompile() ){
		//vV[WRpCɂāAvV[WRpCKvɂȂꍇ
		goto repeat;
	}

	//_System_TypeBase_InitializeUserTypes͍Ō̂قŃRpC
	pSubStaticMethod_System_TypeBase_InitializeUserTypes->KillCompileStatus();
	CompileBufferInProcedure( *pSubStaticMethod_System_TypeBase_InitializeUserTypes );

	if( IsNeedProcCompile() ){
		//vV[WRpCɂāAvV[WRpCKvɂȂꍇ

		compiler.GetMeta().GetUserProcs().Iterator_Reset();
		while( compiler.GetMeta().GetUserProcs().Iterator_HasNext() )
		{
			UserProc *pUserProc = compiler.GetMeta().GetUserProcs().Iterator_GetNext();
			CompileBufferInProcedure( *pUserProc );
		}
	}

	//_System_InitStaticLocalVariables͈ԍŌɃRpC
	pSub_System_InitStaticLocalVariables->KillCompileStatus();
	CompileBufferInProcedure( *pSub_System_InitStaticLocalVariables );

	//_System_Call_Destructor_of_GlobalObject͈ԍŌɃRpC
	pSub_System_Call_Destructor_of_GlobalObject->KillCompileStatus();
	CompileBufferInProcedure( *pSub_System_Call_Destructor_of_GlobalObject );
}
