#include "stdafx.h"

#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <LexicalScopingImpl.h>
#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void OpcodeOthers( const char *Command ){
	int i,i2;

	char leftTerm[8192];
	int lastParePos = 0;
	for(i=0;;i++){
		if(Command[i]=='\"'){
			//_uNH[g͕sȂ̂ŃG[
			leftTerm[i]=0;
			SetError(3,leftTerm,cp);
			return;
		}

		if(Command[i]=='('){
			lastParePos = i;
			i2=GetStringInPare(leftTerm+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='['){
			i2=GetStringInBracket(leftTerm+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='\0'){
			leftTerm[i] = 0;
			break;
		}

		if( IsNumCalcMark( Command, i ) ){
			leftTerm[i] = 0;
			break;
		}

		leftTerm[i]=Command[i];
	}
	if(!(
		IsVariableTopChar(leftTerm[0])||
		leftTerm[0]=='.'||
		(leftTerm[0]==1&&leftTerm[1]==ESC_PSMEM)
		)){
		SetError(1,NULL,cp);
		return;
	}


	if(Command[i]=='\0' && lastParePos == 0){
		//////////////////////////////
		// p[^̃}N
		//////////////////////////////

		const UserProc *pUserProc = GetSubHash(Command);

		//GetSubHashŃG[񎦂sꂽꍇ
		if(pUserProc==(UserProc *)-1) return;

		if(pUserProc==0){
			char temporary[VN_SIZE];
			lstrcpy(temporary,Command);

			CharUpper(temporary);
			pUserProc=GetSubHash(temporary);

			//GetSubHashŃG[񎦂sꂽꍇ
			if(pUserProc==(UserProc *)-1) return;
		}

		if(pUserProc){
			if( !pUserProc->IsMacro() ){
				SetError(10,Command,cp);
			}

			Opcode_CallProc("",pUserProc,0,"",0);

			return;
		}
	}
	else if(IsNumCalcMark(Command,i)){
		//Z
		OpcodeCalc(Command);
		return;
	}


	Type resultType;
	bool isLiteral;
	BOOL bUseHeap;
	bool result = TermOpe( leftTerm, Type(), resultType, isLiteral, &bUseHeap, false, NULL, true );
	if( result ){

		/////////////////////
		// ߂l̏
		/////////////////////

		if( resultType.IsReal() ){
			//fstp st(0)
			compiler.codeGenerator.PutOld(
				(char)0xDD,
				(char)0xD8
			);
		}
		else if( resultType.IsStruct() ){
			//mov ebx,eax
			compiler.codeGenerator.op_mov_RR(REG_EBX,REG_EAX);

			FreeTempObject(REG_EBX,&resultType.GetClass());
		}

		//
		return;
	}

	// s
	SetError(1, NULL,cp);
}

void OpcodeIf(char *Parameter){
	int i,i2;
	Type tempType;

	for(i=0;;i++){
		if(Parameter[i]=='\0'){
			SetError(21,NULL,cp);
			return;
		}
		if(Parameter[i]==1&&Parameter[i+1]==ESC_THEN){
			Parameter[i]=0;
			break;
		}
	}

	const CodeGenerator::PertialSchedule *pIfPertialSchedule = NULL;
	if( !NumOpe(Parameter,Type(),tempType) ){
		//NumOpeŃG[
	}
	else if( tempType.IsDouble() ){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,sizeof(double)+sizeof(long)
		compiler.codeGenerator.op_add_esp(sizeof(double)+sizeof(long));

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//test ah,40
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//jne (endifA܂ else ܂)
		pIfPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
	}
	else if( tempType.IsSingle() ){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,sizeof(float)+sizeof(long)
		compiler.codeGenerator.op_add_esp(sizeof(float)+sizeof(long));

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//test ah,40
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//jne (endifA܂ else ܂)
		pIfPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
	}
	else if( tempType.Is64() ){
		//64rbg^

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//cmp eax,0
		compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

		//jne
		const CodeGenerator::PertialSchedule *pTempPertialSchedule1 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//cmp ebx,0
		compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EBX, 0 );

		//jne
		const CodeGenerator::PertialSchedule *pTempPertialSchedule2 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//jmp (endifA܂ else ܂ŃWv)
		pIfPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

		compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );
	}
	else{
		//32rbg^

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//cmp eax,0
		compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

		//je (endifA܂ else ܂ŏWv)
		pIfPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );
	}


	/////////////////////////
	// IfR[h
	/////////////////////////

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_IF );

	i2=CompileBuffer(ESC_ENDIF,0);

	//LVJXR[vx_E
	GetLexicalScopes().End();


	if( pIfPertialSchedule == NULL ) return;

	if(i2==ESC_ELSE){
		//jmp (endif܂)
		const CodeGenerator::PertialSchedule *pTempPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

		compiler.codeGenerator.opfix_JmpPertialSchedule( pIfPertialSchedule );


		/////////////////////////
		// ElseR[h
		/////////////////////////

		//LVJXR[vxAbv
		GetLexicalScopes().Start( obp, SCOPE_TYPE_IF );

		CompileBuffer(ESC_ENDIF,0);

		//LVJXR[vx_E
		GetLexicalScopes().End();


		compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );
	}
	else{
		compiler.codeGenerator.opfix_JmpPertialSchedule( pIfPertialSchedule );
	}
}

int GetLabelAddress(char *LabelName,int LineNum){
	extern int MaxLabelNum;
	extern LABEL *pLabelNames;
	int i;

	if(LabelName){
		for(i=0;i<MaxLabelNum;i++){
			if(pLabelNames[i].pName){
				if(lstrcmp(LabelName,pLabelNames[i].pName)==0) return pLabelNames[i].address;
			}
		}
	}
	else{
		for(i=0;i<MaxLabelNum;i++){
			if(pLabelNames[i].pName==0){
				if(LineNum==pLabelNames[i].line) return pLabelNames[i].address;
			}
		}
	}
	return -1;
}
void OpcodeGoto(char *Parameter){
	extern HANDLE hHeap;
	extern GOTOLABELSCHEDULE *pGotoLabelSchedule;
	extern int GotoLabelScheduleNum;
	int i,LineNum;

	if(Parameter[0]=='*'){
		i=GetLabelAddress(Parameter+1,0);

		//jmp ...
		OpBuffer[obp++]=(char)0xE9;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=(char *)HeapAlloc(hHeap,0,lstrlen(Parameter+1)+1);
			lstrcpy(pGotoLabelSchedule[GotoLabelScheduleNum].pName,Parameter+1);
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}
	else{
		LineNum=atoi(Parameter);
		i=GetLabelAddress(0,LineNum);

		//jmp ...
		OpBuffer[obp++]=(char)0xE9;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=0;
			pGotoLabelSchedule[GotoLabelScheduleNum].line=LineNum;
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}
}
void OpcodeWhile(char *Parameter){
	extern HANDLE hHeap;

	//ContinueAhX̃obNAbvƃZbg
	compiler.codeGenerator.ContinueAreaBegin();

	if(!Parameter[0]) SetError(10,"While",cp);

	const CodeGenerator::PertialSchedule *pWhilePertialSchedule = NULL;
	Type tempType;
	if( !NumOpe(Parameter,Type(),tempType) ){
		//_~[
	}
	else if( tempType.IsDouble() ){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,sizeof(double)+sizeof(long)
		compiler.codeGenerator.op_add_esp(sizeof(double)+sizeof(long));

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//test ah,40
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//jne (Wend ܂)
		pWhilePertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
	}
	else if( tempType.IsSingle() ){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,sizeof(float)+sizeof(long)
		compiler.codeGenerator.op_add_esp(sizeof(float)+sizeof(long));

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//test ah,40h
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//jne (Wend ܂)
		pWhilePertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(long), true );
	}
	else if( tempType.Is64() ){
		//64rbg^

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//cmp eax,0
		compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

		//jne
		const CodeGenerator::PertialSchedule *pTempPertialSchedule1 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//cmp ebx,0
		compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EBX, 0 );

		//jne
		const CodeGenerator::PertialSchedule *pTempPertialSchedule2 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//jmp (Wend܂ŃWv)
		pWhilePertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

		compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );
	}
	else{
		//̑^

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//cmp eax,0
		compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

		//je (Wend ܂)
		pWhilePertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );
	}

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_WHILE );

	//WhileRpC
	CompileBuffer(0,COM_WEND);

	GetLexicalScopes().CallDestructorsOfScopeEnd();

	//jmp ...
	compiler.codeGenerator.op_jmp_continue();

	//LVJXR[vx_E
	GetLexicalScopes().End();

	if( pWhilePertialSchedule )
	{
		compiler.codeGenerator.opfix_JmpPertialSchedule( pWhilePertialSchedule );
	}

	compiler.codeGenerator.ContinueAreaEnd();
}

char szNextVariable[VN_SIZE];
void OpcodeFor(char *Parameter){
	extern HANDLE hHeap;
	int i,i2;
	char temporary[VN_SIZE],variable[VN_SIZE],JudgeNum[VN_SIZE],StepNum[VN_SIZE];

	//Pp[^擾
	i=GetOneParameter(Parameter,0,temporary);
	if(!Parameter[i]){
		SetError(12,"For",cp);
		goto ErrorStep;
	}

	for(i2=0;;i2++){
		if(temporary[i2]=='='){
			variable[i2]=0;

			//JE^
			OpcodeCalc(temporary);
			break;
		}
		if(temporary[i2]=='\0'){
			SetError(12,"For",cp);
			goto ErrorStep;
		}
		variable[i2]=temporary[i2];
	}

	//jmp ...
	const CodeGenerator::PertialSchedule *pTempPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

	//ContinueAhX̃obNAbvƃZbg
	compiler.codeGenerator.ContinueAreaBegin();

	//Qp[^擾ito`j
	i=GetOneParameter(Parameter,i,JudgeNum);

	//Rp[^擾istep`j
	if(Parameter[i]){
		i=GetOneParameter(Parameter,i,StepNum);
		if(Parameter[i]) SetError(12,"For",cp);
	}
	else lstrcpy(StepNum,"1");

	//JE^𑝉
	sprintf(temporary,"%s=(%s)+(%s)",variable,variable,StepNum);
	OpcodeCalc(temporary);

	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//ʂ
	sprintf(temporary,"(%s)>=0",StepNum);
	NumOpe(temporary,Type(),Type());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//cmp eax,0
	compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

	//je [JE^̏ꍇ̔]
	pTempPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );

	//iJE^̏ꍇj
	sprintf(temporary,"%s<=(%s)",variable,JudgeNum);
	NumOpe(temporary,Type(),Type());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//jmp [JE^̏ꍇ̔щz]
	const CodeGenerator::PertialSchedule *pTempPertialSchedule2 = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

	//jeWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//iJE^̏ꍇj
	sprintf(temporary,"%s>=(%s)",variable,JudgeNum);
	NumOpe(temporary,Type(),Type());

	//pop eax
	compiler.codeGenerator.op_pop(REG_EAX);

	//jmpWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule2 );

	//cmp eax,0
	compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

ErrorStep:

	//je ...
	pTempPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(long), true );

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_FOR );

	//ForRpC
	CompileBuffer(0,COM_NEXT);

	GetLexicalScopes().CallDestructorsOfScopeEnd();

	if(szNextVariable[0]){
		if(lstrcmp(szNextVariable,variable)!=0){
			SetError(55,szNextVariable,cp);
		}
	}

	//jmp ...
	compiler.codeGenerator.op_jmp_continue();

	//LVJXR[vx_E
	GetLexicalScopes().End();

	//jeWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//ContinueAhX𕜌
	compiler.codeGenerator.ContinueAreaEnd();
}

void OpcodeDo(char *Parameter){
	extern HANDLE hHeap;
	int i,i2,i3,i4;

	if(Parameter[0]) SetError(10,"Do",cp);

	//ContinueAhX̃obNAbvƃZbg
	compiler.codeGenerator.ContinueAreaBegin();

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_DO );

	//DoRpC
	CompileBuffer(0,COM_LOOP);

	GetLexicalScopes().CallDestructorsOfScopeEnd();

	const CodeGenerator::PertialSchedule *pDoPertialSchedule = NULL;

	extern char *basbuf;
	char temporary[VN_SIZE];
	for(i=cp-1;;i--){
		if(IsCommandDelimitation(basbuf[i])){
			i+=3;
			if(!(basbuf[i]=='0'||basbuf[i]=='1')){
				//[v
				break;
			}
			i3=i;

			for(i+=2,i2=0;;i++,i2++){
				if(IsCommandDelimitation(basbuf[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}

			Type tempType;
			NumOpe(temporary,Type(),tempType);

			if( tempType.IsDouble() ){
				//fld qword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

				//push 0
				compiler.codeGenerator.op_push_V(0);

				//fild dword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

				//add esp,sizeof(double)+sizeof(long)
				compiler.codeGenerator.op_add_esp(sizeof(double)+sizeof(long));

				//fcompp
				compiler.codeGenerator.op_fcompp();

				//fnstsw ax
				compiler.codeGenerator.op_fnstsw_ax();

				//test ah,40
				compiler.codeGenerator.op_test_ah( (char)0x40 );

				if(basbuf[i3]=='0'){
					//While

					//jne 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(char), true );
				}
				else if(basbuf[i3]=='1'){
					//Until

					//je 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(char), true );
				}
			}
			else if( tempType.IsSingle() ){
				//fld dword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

				//push 0
				compiler.codeGenerator.op_push_V(0);

				//fild dword ptr[esp]
				compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

				//add esp,sizeof(float)+sizeof(long)
				compiler.codeGenerator.op_add_esp(sizeof(float)+sizeof(long));

				//fcompp
				compiler.codeGenerator.op_fcompp();

				//fnstsw ax
				compiler.codeGenerator.op_fnstsw_ax();

				//test ah,40
				compiler.codeGenerator.op_test_ah( (char)0x40 );

				if(basbuf[i3]=='0'){
					//While

					//jne 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(char), true );
				}
				else if(basbuf[i3]=='1'){
					//Until

					//je 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(char), true );
				}
			}
			else if( tempType.Is64() ){
				//64rbg^

				//pop eax
				compiler.codeGenerator.op_pop(REG_EAX);

				//pop ebx
				compiler.codeGenerator.op_pop(REG_EBX);

				//cmp eax,0
				compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

				//jne
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0x85;
				obp+=sizeof(long);
				i2=obp;


				//cmp ebx,0
				compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EBX, 0 );

				//jne
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0x85;
				obp+=sizeof(long);
				i4=obp;


				if(basbuf[i3]=='0'){
					//While

					//jmp 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(char), true );

					*((long *)(OpBuffer+i2-sizeof(long)))=obp-i2;
					*((long *)(OpBuffer+i4-sizeof(long)))=obp-i4;
				}
				else if(basbuf[i3]=='1'){
					//Until

					//jmp 2i[v𑱂j
					OpBuffer[obp++]=(char)0xEB;
					OpBuffer[obp++]=(char)0x02;

					*((long *)(OpBuffer+i2-sizeof(long)))=obp-i2;
					*((long *)(OpBuffer+i4-sizeof(long)))=obp-i4;

					//jmp 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(char), true );
				}
			}
			else{
				//pop eax
				compiler.codeGenerator.op_pop(REG_EAX);

				//cmp eax,0
				compiler.codeGenerator.op_cmp_value( sizeof(long), REG_EAX, 0 );

				if(basbuf[i3]=='0'){
					//While

					//je 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_je( 0, sizeof(char), true );
				}
				else if(basbuf[i3]=='1'){
					//Until

					//jne 5i[vIj
					pDoPertialSchedule = compiler.codeGenerator.op_jne( 0, sizeof(char), true );
				}
			}
			break;
		}
	}

	//jmp ...
	compiler.codeGenerator.op_jmp_continue();

	if( pDoPertialSchedule )
	{
		compiler.codeGenerator.opfix_JmpPertialSchedule( pDoPertialSchedule );
	}

	//jmp ...
	const CodeGenerator::PertialSchedule *pTempPertialSchedule = compiler.codeGenerator.op_jmp( 0, sizeof(long), true );

	//LVJXR[vx_E
	GetLexicalScopes().End();

	//jmpWṽItZbgl
	compiler.codeGenerator.opfix_JmpPertialSchedule( pTempPertialSchedule );

	//ContinueAhX𕜌
	compiler.codeGenerator.ContinueAreaEnd();
}
void OpcodeContinue(void){
	//jmp ...(Continue addr)
	compiler.codeGenerator.op_jmp_continue();
}

void OpcodeExitSub(void){
	extern DWORD *pExitSubSchedule;
	extern int ExitSubScheduleNum;
	extern HANDLE hHeap;

	if( UserProc::IsGlobalAreaCompiling() ){
		SetError(12,"Exit Sub/Function",cp);
		return;
	}

	//̃[JIuWFNg̃fXgN^Ăяo
	GetLexicalScopes().CallDestructorsOfReturn();

	//jmp ...(End Sub/Function)
	OpBuffer[obp++]=(char)0xE9;

	pExitSubSchedule=(DWORD *)HeapReAlloc(hHeap,0,pExitSubSchedule,(ExitSubScheduleNum+1)*sizeof(DWORD));
	pExitSubSchedule[ExitSubScheduleNum]=obp;
	ExitSubScheduleNum++;

	obp+=sizeof(long);
}

void AddCaseSchedule(void){
	extern DWORD *pCaseSchedule;
	extern int CaseScheduleNum;
	extern HANDLE hHeap;

	pCaseSchedule=(DWORD *)HeapReAlloc(hHeap,0,pCaseSchedule,(CaseScheduleNum+1)*sizeof(DWORD));
	pCaseSchedule[CaseScheduleNum]=obp;
	CaseScheduleNum++;
}

int CaseTypeSize;
void OpcodeSelect(const char *lpszParms){
	extern DWORD *pCaseSchedule;
	extern int CaseScheduleNum;
	extern int NowCaseSchedule;
	extern int CaseTypeSize;
	extern HANDLE hHeap;
	extern char *basbuf;
	int i,i2,i3,sw,NowCaseCp;
	char temporary[VN_SIZE];

	DWORD *temp_pCaseSchedule;
	int temp_CaseScheduleNum;
	int temp_NowCaseSchedule;
	int temp_CaseTypeSize;

	temp_pCaseSchedule=pCaseSchedule;
	temp_CaseScheduleNum=CaseScheduleNum;
	temp_NowCaseSchedule=NowCaseSchedule;
	temp_CaseTypeSize=CaseTypeSize;
	pCaseSchedule=(DWORD *)HeapAlloc(hHeap,0,1);
	CaseScheduleNum=0;
	NowCaseSchedule=0;

	Type type1;
	if( !NumOpe(lpszParms,Type(), type1 ) ){
		return;
	}

	CaseTypeSize = type1.GetSize();
	if( CaseTypeSize < sizeof(long) ){
		CaseTypeSize=sizeof(long);
	}

	for(i=cp,sw=0;;i++){
		if(basbuf[i]=='\0'){
			HeapDefaultFree(pCaseSchedule);
			pCaseSchedule=temp_pCaseSchedule;
			CaseScheduleNum=temp_CaseScheduleNum;
			NowCaseSchedule=temp_NowCaseSchedule;
			CaseTypeSize=temp_CaseTypeSize;
			SetError(22,"Select",cp);
			return;
		}
		if(basbuf[i]==1&&basbuf[i+1]==ESC_SELECTCASE){
			for(i2=0;;i++){
				if(basbuf[i]==1&&basbuf[i+1]==ESC_SELECTCASE) i2++;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_ENDSELECT){
					i2--;
					if(i2==0) break;
				}
			}
			continue;
		}
		if(basbuf[i]==1&&basbuf[i+1]==ESC_ENDSELECT){
			if(sw==0){
				//add esp,CaseTypeSize
				compiler.codeGenerator.op_add_esp(CaseTypeSize);
			}
			break;
		}
		if(basbuf[i]==1&&basbuf[i+1]==ESC_CASE){
			NowCaseCp=i;

			i++;
			while(1){
				for(i++,i2=0;;i++,i2++){
					if(basbuf[i]=='\"'){
						i3=GetStringInQuotation(temporary+i2,basbuf+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}
					if(basbuf[i]=='('){
						i3=GetStringInPare(temporary+i2,basbuf+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}
					if(basbuf[i]=='['){
						i3=GetStringInBracket(temporary+i2,basbuf+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}

					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					if(basbuf[i]==','){
						temporary[i2]=0;
						break;
					}

					temporary[i2]=basbuf[i];
				}

				//G[p
				i2=cp;
				cp=NowCaseCp;

				Type type2;
				if( !NumOpe(temporary,type1,type2) ){
					return;
				}

				cp=i2;

				if(type1.IsObject()){
					std::vector<const UserProc *> subs;
					type1.GetClass().GetMethods().Enum( CALC_EQUAL, subs );
					if( subs.size() == 0 ){
						return;
					}

					Parameters params;
					params.push_back( new Parameter( "", Type( type2 ) ) );

					//I[o[[h
					const UserProc *pUserProc = OverloadSolution("==",subs, params, NULL);

					delete params[0];

					if(!pUserProc){
						//G[
						return;
					}


					//pop edx
					compiler.codeGenerator.op_pop(REG_EDX);

					//mov ecx,dword ptr[esp]
					compiler.codeGenerator.op_mov_RM(sizeof(long),REG_ECX,REG_ESP,0,MOD_BASE);

					//push edx
					compiler.codeGenerator.op_push(REG_EDX);

					//push ecx
					compiler.codeGenerator.op_push(REG_ECX);

					//call operator_proc	 ==Zq
					compiler.codeGenerator.op_call(pUserProc);

					//test eax,eax
					compiler.codeGenerator.op_test(REG_EAX,REG_EAX);

					//jne ...
					OpBuffer[obp++]=(char)0x0F;
					OpBuffer[obp++]=(char)0x85;
					AddCaseSchedule();
					obp+=sizeof(long);
				}
				else if(type1.IsDouble()){
					ChangeTypeToDouble(type2.GetBasicType());

					//fld qword ptr[esp]
					compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

					//add esp,CaseTypeSize
					compiler.codeGenerator.op_add_esp(CaseTypeSize);

					//fld qword ptr[esp]
					compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

					//fcompp
					compiler.codeGenerator.op_fcompp();

					//fnstsw ax
					compiler.codeGenerator.op_fnstsw_ax();

					//test ah,40
					compiler.codeGenerator.op_test_ah( (char)0x40 );

					//jne ...
					OpBuffer[obp++]=(char)0x0F;
					OpBuffer[obp++]=(char)0x85;
					AddCaseSchedule();
					obp+=sizeof(long);
				}
				else if(type1.IsSingle()){
					ChangeTypeToSingle(type2.GetBasicType());

					//fld dword ptr[esp]
					compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

					//add esp,CaseTypeSize
					compiler.codeGenerator.op_add_esp(CaseTypeSize);

					//fld dword ptr[esp]
					compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

					//fcompp
					compiler.codeGenerator.op_fcompp();

					//fnstsw ax
					compiler.codeGenerator.op_fnstsw_ax();

					//test ah,40
					compiler.codeGenerator.op_test_ah( (char)0x40 );

					//jne ...
					OpBuffer[obp++]=(char)0x0F;
					OpBuffer[obp++]=(char)0x85;
					AddCaseSchedule();
					obp+=sizeof(long);
				}
				else{
					//̑^

					//pop ebx
					compiler.codeGenerator.op_pop(REG_EBX);

					//mov eax,dword ptr[esp]
					compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );

					//cmp eax,ebx
					compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

					//je ...
					OpBuffer[obp++]=(char)0x0F;
					OpBuffer[obp++]=(char)0x84;
					AddCaseSchedule();
					obp+=sizeof(long);
				}

				if(basbuf[i]!=',') break;
			}
		}
		if(basbuf[i]==1&&basbuf[i+1]==ESC_CASEELSE){
			sw=1;

			//jmp ...
			OpBuffer[obp++]=(char)0xE9;
			AddCaseSchedule();
			obp+=sizeof(long);
		}
	}

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_SELECT );

	//Select CaseRpC
	CompileBuffer(ESC_ENDSELECT,0);

	//jmp EndSelect
	OpBuffer[obp++]=(char)0xE9;
	AddCaseSchedule();
	obp+=sizeof(long);

	//ŏIXPW[
	for(i=NowCaseSchedule;i<CaseScheduleNum;i++){
		*(long *)(OpBuffer+pCaseSchedule[i])=obp-(pCaseSchedule[i]+sizeof(long));
	}
	HeapDefaultFree(pCaseSchedule);

	//LVJXR[vx_E
	GetLexicalScopes().End();

	pCaseSchedule=temp_pCaseSchedule;
	CaseScheduleNum=temp_CaseScheduleNum;
	NowCaseSchedule=temp_NowCaseSchedule;
	CaseTypeSize=temp_CaseTypeSize;
}
void OpcodeCase(char *Parameter){
	extern DWORD *pCaseSchedule;
	extern int NowCaseSchedule;
	extern int CaseTypeSize;
	int i;

	if(!pCaseSchedule){
		SetError(30,"Case",cp);
		return;
	}

	//jmp EndSelect
	OpBuffer[obp++]=(char)0xE9;
	AddCaseSchedule();
	obp+=sizeof(long);

	i=0;
	while(1){
		//CaseXPW[
		*(long *)(OpBuffer+pCaseSchedule[NowCaseSchedule])=obp-(pCaseSchedule[NowCaseSchedule]+sizeof(long));
		NowCaseSchedule++;

		i=JumpOneParameter(Parameter,i);
		if(Parameter[i]=='\0') break;
	}

	//add esp,CaseTypeSize
	compiler.codeGenerator.op_add_esp(CaseTypeSize);
}

void OpcodeGosub(char *Parameter){
	extern HANDLE hHeap;
	extern GOTOLABELSCHEDULE *pGotoLabelSchedule;
	extern int GotoLabelScheduleNum;
	int i,LineNum;

	if(Parameter[0]=='*'){
		i=GetLabelAddress(Parameter+1,0);

		//call ...
		OpBuffer[obp++]=(char)0xE8;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=(char *)HeapAlloc(hHeap,0,lstrlen(Parameter+1)+1);
			lstrcpy(pGotoLabelSchedule[GotoLabelScheduleNum].pName,Parameter+1);
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}
	else{
		LineNum=atoi(Parameter);
		i=GetLabelAddress(0,LineNum);

		//call ...
		OpBuffer[obp++]=(char)0xE8;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=0;
			pGotoLabelSchedule[GotoLabelScheduleNum].line=LineNum;
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}
}
void OpcodeReturn(char *Parameter){
	if( UserProc::IsGlobalAreaCompiling() ){
		//Gosub`ReturnƂĈ

		//ret
		compiler.codeGenerator.op_ret();
	}
	else{
		//߂lZbg
		if(Parameter[0]){
			const UserProc &proc = UserProc::CompilingUserProc();

			const char *temp = "_System_ReturnValue";
			if(proc.GetName()[0]==1&&proc.GetName()[1]==ESC_OPERATOR)
			{
			}
			else{
				temp=proc.GetName().c_str();
			}

			char temporary[VN_SIZE];
			sprintf(temporary,"%s=%s",temp,Parameter);
			OpcodeCalc(temporary);
		}

		//vV[W𔲂oiCreturnƓl̏sj
		OpcodeExitSub();
	}
}


////////////
// |C^

void OpcodeSetPtrData(char *Parameter,int type){
	int i;
	char temporary[VN_SIZE];

	if(Parameter[0]=='('){
		i=JumpStringInPare(Parameter,1);
		if(Parameter[i+1]=='\0'){
			for(i=0;;i++){
				Parameter[i]=Parameter[i+1];
				if(Parameter[i]=='\0') break;
			}
			Parameter[i-1]=0;
		}
	}

	//Pp[^擾
	i=GetOneParameter(Parameter,0,temporary);
	if(!Parameter[i]){
		SetError(1,NULL,cp);
		return;
	}

	Type resultType;
	if( !NumOpe(temporary,Type(),resultType) ){
		return;
	}
	if(!resultType.IsWhole()){
		SetError(11,Parameter,cp);
		return;
	}

	ChangeTypeToLong( resultType.GetBasicType() );

	//Qp[^擾
	i=GetOneParameter(Parameter,i,temporary);
	if(Parameter[i]){
		SetError(1,NULL,cp);
		return;
	}

	if( !NumOpe(temporary,Type(),resultType) ){
		return;
	}

	if(type==DEF_DOUBLE){
		ChangeTypeToDouble_ToFpuReg( resultType.GetBasicType() );

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//fstp qword ptr[eax]
		compiler.codeGenerator.PutOld(
			(char)0xDD,
			(char)0x18
		);
	}
	else if(type==DEF_SINGLE){
		ChangeTypeToSingle( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov dword ptr[eax],ebx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
	else if(type==DEF_QWORD){
		ChangeTypeToInt64( resultType.GetBasicType() );

		//pop ecx
		compiler.codeGenerator.op_pop(REG_ECX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov dword ptr[eax],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_EAX, 0, MOD_BASE );

		//mov dword ptr[eax+sizeof(long)],ebx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EBX, REG_EAX, 0x04, MOD_BASE_DISP8 );
	}
	else if(type==DEF_DWORD){
		ChangeTypeToLong( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov dword ptr[eax],ebx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
	else if(type==DEF_WORD){
		ChangeTypeToLong( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov word ptr[eax],bx
		compiler.codeGenerator.op_mov_MR( sizeof(short), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
	else if(type==DEF_BYTE){
		ChangeTypeToLong( resultType.GetBasicType() );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//mov byte ptr[eax],bl
		compiler.codeGenerator.op_mov_MR( sizeof(char), REG_EBX, REG_EAX, 0, MOD_BASE );
	}
}
