#pragma once

#include <vector>

#include <jenga/include/common/Exception.h>

#include <BoostSerializationSupport.h>

void AddLocalVarAddrSchedule();
void ObpPlus( int step = 1 );

class Schedule
{
public:
	enum Type
	{
		None = 10000,
		GlobalVar,		// O[oϐXPW[
		LocalVar,		// [JϐXPW[
		DataTable,		// f[^e[u XPW[
		Relocation,		// P[VXPW[
	};

private:
	Type type;
	int offset;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( offset );
	}

public:
	Schedule()
	{
	}
	Schedule( Type type, int offset )
		: type( type )
		, offset( offset )
	{
	}
	~Schedule()
	{
	}
};
typedef std::vector<Schedule> Schedules;

class NativeCode
{
	int allocateSize;
	char *codeBuffer;
	int size;

	Schedules schedules;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		std::string code;
		ar & BOOST_SERIALIZATION_NVP( code );
		ar & BOOST_SERIALIZATION_NVP( size );
		ar & BOOST_SERIALIZATION_NVP( schedules );

		// ǂݍ݌̏
		Realloc( size );
		for( int i=0; i<size; i++ )
		{
			char c;
			sscanf( code.c_str() + i*3, "%02x,", &c );
			codeBuffer[i] = c;
		}
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		// ۑ
		char *tempCode = (char *)malloc( (size+1) * 3 );
		for( int i=0; i<size; i++ )
		{
			char temp[32];
			sprintf( temp, "%02x,", codeBuffer[i] );
			tempCode[i*3] = temp[0];
			tempCode[i*3+1] = temp[1];
			tempCode[i*3+2] = temp[2];
		}

		std::string code = tempCode;
		free( tempCode );

		ar & BOOST_SERIALIZATION_NVP( code );
		ar & BOOST_SERIALIZATION_NVP( size );
		ar & BOOST_SERIALIZATION_NVP( schedules );
	}


	void Realloc( int additionSize = 0 )
	{
		if( allocateSize < size + 8192 + additionSize )
		{
			while( allocateSize < size + 8192 + additionSize )
			{
				allocateSize += 8192;
			}
			codeBuffer = (char *)realloc( codeBuffer, allocateSize );
		}
	}

public:
	NativeCode()
		: allocateSize( 8192 )
		, codeBuffer( (char *)malloc( allocateSize ) )
		, size( 0 )
	{
	}
	~NativeCode()
	{
		free( codeBuffer );
	}
	void Clear()
	{
		size = 0;
	}

	int GetSize() const
	{
		return size;
	}

	void Overwrite( int codePos, char c )
	{
		codeBuffer[codePos] = c;
	}
	void OverwriteOld( int _obpOld, char c )
	{
		// 
		extern char *OpBuffer;
		OpBuffer[_obpOld] = c;
	}
	void Overwrite( int codePos, long newLongValue )
	{
		*(long *)(this->codeBuffer+codePos) = newLongValue;
	}
	void OverwriteOld( int _obpOld, long newLongValue )
	{
		// 
		extern char *OpBuffer;
		*(long *)(OpBuffer+_obpOld) = newLongValue;
	}

	void Put( const char *codeBuffer, int size )
	{
		Realloc( size );

		memcpy( this->codeBuffer + this->size, codeBuffer, size );
		this->size += size;

		// 
		extern char *OpBuffer;
		extern int obp;
		memcpy( OpBuffer + obp, codeBuffer, size );
		ObpPlus( size );
	}
	void Put( const NativeCode &nativeCode )
	{
		Put( nativeCode.codeBuffer, nativeCode.size );
	}
	void Put( _int64 i64data )
	{
		Put( (const char *)(&i64data), sizeof(_int64) );
	}
	void Put( long l, Schedule::Type scheduleType = Schedule::None )
	{
		if( scheduleType != Schedule::None )
		{
			schedules.push_back( Schedule( scheduleType, size ) );
		}

		*((long *)(codeBuffer+size))=l;
		size += sizeof(long);



		// 
		switch( scheduleType )
		{
		case Schedule::None:
			break;
		case Schedule::GlobalVar:
			extern CSchedule *pobj_GlobalVarSchedule;
			pobj_GlobalVarSchedule->add();
			break;
		case Schedule::LocalVar:
			AddLocalVarAddrSchedule();
			break;
		case Schedule::DataTable:
			extern CSchedule *pobj_DataTableSchedule;
			pobj_DataTableSchedule->add();
			break;
		case Schedule::Relocation:
			break;
		default:
			Jenga::Throw( "scheduleTypeȒlێĂ" );
			break;
		}
		extern char *OpBuffer;
		extern int obp;
		*((long *)(OpBuffer+obp))=l;
		ObpPlus( sizeof(long) );
	}
	void Put( short s )
	{
		Put( (const char *)(&s), sizeof(short) );
	}
	void Put( char c )
	{
		codeBuffer[size++] = c;
		Realloc();



		// 
		extern char *OpBuffer;
		extern int obp;
		OpBuffer[obp]=c;
		ObpPlus();
	}
};
