#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void AutoExtendToBigType( int *type_stack,int sp, int reg1, int reg2 ){
	/*
	int bigSize = GetTypeSize( type_stack[sp-1], -1 );
	if( bigSize != GetTypeSize( type_stack[sp-2], -1 ) ){
		int extReg = reg2;
		int oldType = type_stack[sp-2];
		if( bigSize < GetTypeSize( type_stack[sp-2], -1 ) ){
			bigSize = GetTypeSize( type_stack[sp-2], -1 );
			extReg = reg1;
			oldType = type_stack[sp-1];
		}
		if( bigSize == 2 ){
			ExtendTypeTo16( oldType, extReg );
		}
		else if( bigSize == 4 ){
			ExtendTypeTo32( oldType, extReg );
		}
		else{
			SetError();
		}
	}*/
}


BOOL Calc_Relation_PE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]<=value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//////////////
		// Z
		//////////////

		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//test ah,41h
		compiler.codeGenerator.op_test_ah( (char)0x41 );

		//jne 5
		compiler.codeGenerator.PutOld(
			(char)0x75,
			(char)0x02
		);

		//xor ecx,ecxiecx0ɂj
		compiler.codeGenerator.op_zero_reg(REG_ECX);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////

		// 1 <= 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		compiler.codeGenerator.op_cmp_RR( REG_EDX, REG_ECX );

		CodeGenerator::PertialSchedule *pFalsePertialSchedule1;
		if(IsSignedType(type_stack[sp-2])==0&&IsSignedType(type_stack[sp-1])==0){
			//ȂZ

			//ja FalseSchedule1iUփWvj
			pFalsePertialSchedule1 = compiler.codeGenerator.op_ja( 0, sizeof(char), true );
		}
		else{
			//艉Z

			//jg FalseSchedule1iUփWvj
			pFalsePertialSchedule1 = compiler.codeGenerator.op_jg( 0, sizeof(char), true );
		}

		CodeGenerator::PertialSchedule *pTruePertialSchedule;
		if(IsSignedType(type_stack[sp-2])==0&&IsSignedType(type_stack[sp-1])==0){
			//ȂZ

			//jb TrueSchedulei^փWvj
			pTruePertialSchedule = compiler.codeGenerator.op_jb( 0, sizeof(char), true );
		}
		else{
			//艉Z

			//jl TrueSchedulei^փWvj
			pTruePertialSchedule = compiler.codeGenerator.op_jl( 0, sizeof(char), true );
		}

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		//ja FalseSchedule2iUփWvj
		CodeGenerator::PertialSchedule *pFalsePertialSchedule2 = compiler.codeGenerator.op_ja( 0, sizeof(char), true );

		//TrueSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//jmp 2iZIʒuփWvj
		compiler.codeGenerator.op_jmp( 2 );

		//FalseSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule2 );

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		if(IsSignedType(type_stack[sp-2])==0&&IsSignedType(type_stack[sp-1])==0){
			//ȂZ

			//jbe 2ixorщzj
			compiler.codeGenerator.op_jbe( 2 );
		}
		else{
			//艉Z

			//jle 2ixorщzj
			compiler.codeGenerator.op_jle( 2 );
		}

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_QE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]>=value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//_Z
		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//test ah,1
		compiler.codeGenerator.op_test_ah( (char)0x01 );

		//je 2ixorщzj
		compiler.codeGenerator.op_je( 2 );

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////

		// 1 >= 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		compiler.codeGenerator.op_cmp_RR( REG_EDX, REG_ECX );

		CodeGenerator::PertialSchedule *pFalsePertialSchedule1;
		if(IsSignedType(AnswerType)){
			//艉Z

			//jl FalseSchedule1iUփWvj
			pFalsePertialSchedule1 = compiler.codeGenerator.op_jl( 0, sizeof(char), true );
		}
		else{
			//ȂZ

			//jb FalseSchedule1iUփWvj
			pFalsePertialSchedule1 = compiler.codeGenerator.op_jb( 0, sizeof(char), true );
		}

		CodeGenerator::PertialSchedule *pTruePertialSchedule;
		if(IsSignedType(AnswerType)){
			//艉Z

			//jg TrueSchedulei^փWvj
			pTruePertialSchedule = compiler.codeGenerator.op_jg( 0, sizeof(char), true );
		}
		else{
			//ȂZ

			//ja TrueSchedulei^փWvj
			pTruePertialSchedule = compiler.codeGenerator.op_ja( 0, sizeof(char), true );
		}

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		//jb FalseSchedule2iUփWvj
		CodeGenerator::PertialSchedule *pFalsePertialSchedule2 = compiler.codeGenerator.op_jb( 0, sizeof(char), true );

		//TrueSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//jmp 2iZIʒuփWvj
		compiler.codeGenerator.op_jmp( 2 );

		//FalseSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule2 );

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		if(IsSignedType(AnswerType)){
			//艉Z

			//jge 2ixorщzjL
			compiler.codeGenerator.op_jge( 2 );
		}
		else{
			//ȂZ

			//jae 2ixorщzj
			compiler.codeGenerator.op_jae( 2 );
		}

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_P(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]<value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//////////////
		// Z
		//////////////

		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//test ah,01h
		compiler.codeGenerator.op_test_ah( (char)0x01 );

		//jne 2
		compiler.codeGenerator.op_jne( 2 );

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////

		// 1 < 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		compiler.codeGenerator.op_cmp_RR( REG_EDX, REG_ECX );

		CodeGenerator::PertialSchedule *pTruePertialSchedule1;
		if(IsSignedType(AnswerType)){
			//艉Z

			//jl TrueSchedule1i^փWvj
			pTruePertialSchedule1 = compiler.codeGenerator.op_jl( 0, sizeof(char), true );
		}
		else{
			//ȂZ

			//jb TrueSchedule1i^փWvj
			pTruePertialSchedule1 = compiler.codeGenerator.op_jb( 0, sizeof(char), true );
		}

		CodeGenerator::PertialSchedule *pFalsePertialSchedule;
		if(IsSignedType(AnswerType)){
			//艉Z

			//jg FalseScheduleiUփWvj
			pFalsePertialSchedule = compiler.codeGenerator.op_jg( 0, sizeof(char), true );
		}
		else{
			//ȂZ

			//ja FalseScheduleiUփWvj
			pFalsePertialSchedule = compiler.codeGenerator.op_ja( 0, sizeof(char), true );
		}

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		//jb TrueSchedule2i^փWvj
		CodeGenerator::PertialSchedule *pTruePertialSchedule2 = compiler.codeGenerator.op_jb( 0, sizeof(char), true );

		//FalseSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule );

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//jmp 5iZIʒuփWvj
		compiler.codeGenerator.op_jmp( 5 );

		//TrueSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule2 );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		///////////////////
		//32rbgZ
		///////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		if(IsSignedType(AnswerType)){
			//艉Z

			//jl 2ixorщzj
			compiler.codeGenerator.op_jl( 2 );
		}
		else{
			//ȂZ

			//jb 2ixorщzj
			compiler.codeGenerator.op_jb( 2 );
		}

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_Q(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]>value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//////////////
		// Z
		//////////////

		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//test ah,41
		compiler.codeGenerator.op_test_ah( (char)0x41 );

		//je 2ixorщzj
		compiler.codeGenerator.op_je( 2 );

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////

		// 1 > 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		compiler.codeGenerator.op_cmp_RR( REG_EDX, REG_ECX );

		CodeGenerator::PertialSchedule *pTruePertialSchedule1;
		if(IsSignedType(AnswerType)){
			//L

			//jg TrueSchedule1i^փWvj
			pTruePertialSchedule1 = compiler.codeGenerator.op_jg( 0, sizeof(char), true );
		}
		else{
			//

			//ja TrueSchedule1i^փWvj
			pTruePertialSchedule1 = compiler.codeGenerator.op_ja( 0, sizeof(char), true );
		}

		CodeGenerator::PertialSchedule *pFalsePertialSchedule;
		if(IsSignedType(AnswerType)){
			//L

			//jl FalseScheduleiUփWvj
			pFalsePertialSchedule = compiler.codeGenerator.op_jl( 0, sizeof(char), true );
		}
		else{
			//

			//jb FalseScheduleiUփWvj
			pFalsePertialSchedule = compiler.codeGenerator.op_jb( 0, sizeof(char), true );
		}

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		//ja TrueSchedule2i^փWvj
		CodeGenerator::PertialSchedule *pTruePertialSchedule2 = compiler.codeGenerator.op_ja( 0, sizeof(char), true );

		//FalseSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule );

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//jmp 5iZIʒuփWvj
		compiler.codeGenerator.op_jmp( 5 );

		//TrueSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule2 );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		if(IsSignedType(AnswerType)){
			//jg 2ixorщzj
			compiler.codeGenerator.op_jg( 2 );
		}
		else{
			//ja 2ixorщzj
			compiler.codeGenerator.op_ja( 2 );
		}

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_NotEqual(int *type,int *pStackPointer){
	//value[sp-2]<>value[sp-1]

	int sp;
	sp=*pStackPointer;

	if(type[sp-2]==DEF_DOUBLE||type[sp-2]==DEF_SINGLE||
		type[sp-1]==DEF_DOUBLE||type[sp-1]==DEF_SINGLE){
		//////////////
		// Z
		//////////////

		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//test ah,40
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//je 2
		compiler.codeGenerator.op_je( 2 );

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD||
		type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////

		// 1 <> 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type,sp);

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		//jne TrueSchedule1i^փWvj
		CodeGenerator::PertialSchedule *pTruePertialSchedule1 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//cmp edx,ecx
		compiler.codeGenerator.op_cmp_RR( REG_EDX, REG_ECX );

		//jne TrueSchedule2i^փWvj
		CodeGenerator::PertialSchedule *pTruePertialSchedule2 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//jmp 5iZIʒuփWvj
		compiler.codeGenerator.op_jmp( 5 );

		//TrueSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pTruePertialSchedule2 );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//xor eax,ebx
		compiler.codeGenerator.op_xor_RR( REG_EAX, REG_EBX );

		//je 5imovщzj
		compiler.codeGenerator.op_je( 5 );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_Equal(int *type,int *pStackPointer){
	//value[sp-2]=value[sp-1]

	int sp;
	sp=*pStackPointer;

	if(type[sp-2]==DEF_DOUBLE||type[sp-2]==DEF_SINGLE||
		type[sp-1]==DEF_DOUBLE||type[sp-1]==DEF_SINGLE){
		//////////////
		// Z
		//////////////

		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//test ah,40
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//jne 2ixorщzj
		compiler.codeGenerator.op_jne( 2 );

		//xor ecx,ecx
		compiler.codeGenerator.op_xor_RR( REG_ECX );

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD||
		type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////

		// 1 == 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type,sp);

		//cmp eax,ebx
		compiler.codeGenerator.op_cmp_RR( REG_EAX, REG_EBX );

		//jne FalseSchedule1iUփWvj
		CodeGenerator::PertialSchedule *pFalsePertialSchedule1 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//cmp edx,ecx
		compiler.codeGenerator.op_cmp_RR( REG_EDX, REG_ECX );

		//jne FalseSchedule2iUփWvj
		CodeGenerator::PertialSchedule *pFalsePertialSchedule2 = compiler.codeGenerator.op_jne( 0, sizeof(char), true );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//jmp 2iZIʒuփWvj
		compiler.codeGenerator.op_jmp( 2 );

		//FalseSchedulẽWv̐ݒ
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule1 );
		compiler.codeGenerator.opfix_JmpPertialSchedule( pFalsePertialSchedule2 );

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//xor eax,ebx
		compiler.codeGenerator.op_xor_RR( REG_EAX, REG_EBX );

		//je 4ixorjmpщzj
		compiler.codeGenerator.op_je( 4 );

		//xor eax,eax
		compiler.codeGenerator.op_xor_RR( REG_EAX );

		//jmp 5
		compiler.codeGenerator.op_jmp( 5 );

		//mov eax,1
		compiler.codeGenerator.op_mov_RV( REG_EAX, 1 );

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}
