#include "common.h"


void GetDefaultEditFont(LOGFONT *pLogFont){
#if defined(JPN)
	//{
	pLogFont->lfHeight=-13;
	pLogFont->lfWidth=0;
	pLogFont->lfEscapement=0;
	pLogFont->lfOrientation=0;
	pLogFont->lfWeight=400;
	pLogFont->lfItalic=NULL;
	pLogFont->lfUnderline=NULL;
	pLogFont->lfStrikeOut=NULL;
	pLogFont->lfCharSet=SHIFTJIS_CHARSET;
	pLogFont->lfOutPrecision=OUT_STRING_PRECIS;
	pLogFont->lfClipPrecision=CLIP_STROKE_PRECIS;
	pLogFont->lfQuality=DRAFT_QUALITY;
	pLogFont->lfPitchAndFamily=FIXED_PITCH;
	sprintf(pLogFont->lfFaceName,"lr SVbN");
#else
	//p
	pLogFont->lfHeight=-15;
	pLogFont->lfWidth=0;
	pLogFont->lfEscapement=0;
	pLogFont->lfOrientation=0;
	pLogFont->lfWeight=400;
	pLogFont->lfItalic=NULL;
	pLogFont->lfUnderline=NULL;
	pLogFont->lfStrikeOut=NULL;
	pLogFont->lfCharSet=ANSI_CHARSET;
	pLogFont->lfOutPrecision=OUT_STRING_PRECIS;
	pLogFont->lfClipPrecision=CLIP_STROKE_PRECIS;
	pLogFont->lfQuality=DRAFT_QUALITY;
	pLogFont->lfPitchAndFamily=FIXED_PITCH;
	sprintf(pLogFont->lfFaceName,"Courier New");
#endif
}
void GetDefaultHintFont(LOGFONT *pLogFont){
#if defined(JPN)
	//{
	pLogFont->lfHeight=-12;
	pLogFont->lfWidth=0;
	pLogFont->lfEscapement=0;
	pLogFont->lfOrientation=0;
	pLogFont->lfWeight=FW_THIN;
	pLogFont->lfItalic=NULL;
	pLogFont->lfUnderline=NULL;
	pLogFont->lfStrikeOut=NULL;
	pLogFont->lfCharSet=ANSI_CHARSET;
	pLogFont->lfOutPrecision=OUT_STRING_PRECIS;
	pLogFont->lfClipPrecision=CLIP_STROKE_PRECIS;
	pLogFont->lfQuality=DRAFT_QUALITY;
	pLogFont->lfPitchAndFamily=VARIABLE_PITCH;
	sprintf(pLogFont->lfFaceName,"lr oSVbN");
#else
	//p
	pLogFont->lfHeight=-12;
	pLogFont->lfWidth=0;
	pLogFont->lfEscapement=0;
	pLogFont->lfOrientation=0;
	pLogFont->lfWeight=FW_THIN;
	pLogFont->lfItalic=NULL;
	pLogFont->lfUnderline=NULL;
	pLogFont->lfStrikeOut=NULL;
	pLogFont->lfCharSet=ANSI_CHARSET;
	pLogFont->lfOutPrecision=OUT_STRING_PRECIS;
	pLogFont->lfClipPrecision=CLIP_STROKE_PRECIS;
	pLogFont->lfQuality=DRAFT_QUALITY;
	pLogFont->lfPitchAndFamily=VARIABLE_PITCH;
	sprintf(pLogFont->lfFaceName,"Arial");
#endif
}
void GetDefaultPrintFont(LOGFONT *pLogFont){
	pLogFont->lfHeight=0;	//iPrintFontPointSizeƃfoCXɂ茈܂
	pLogFont->lfWidth=0;
	pLogFont->lfEscapement=0;
	pLogFont->lfOrientation=0;
	pLogFont->lfWeight=FW_NORMAL;
	pLogFont->lfItalic=NULL;
	pLogFont->lfUnderline=NULL;
	pLogFont->lfStrikeOut=NULL;
	pLogFont->lfCharSet=SHIFTJIS_CHARSET;
	pLogFont->lfOutPrecision=OUT_STRING_PRECIS;
	pLogFont->lfClipPrecision=CLIP_STROKE_PRECIS;
	pLogFont->lfQuality=DRAFT_QUALITY;
	pLogFont->lfPitchAndFamily=FIXED_PITCH;
	lstrcpy(pLogFont->lfFaceName,"lr SVbN");
}


///////////////////////////
// s̃f[^Ǘ
///////////////////////////

CNonVolatile::CNonVolatile(){
	memset(this,0,sizeof(CNonVolatile));

	//gqǗIuWFNg𐶐
	pobj_ExtLink=new CExtLink();

	//WebphCǗIuWFNg𐶐
	pobj_DBDomain=new CDBDomain();

	//uŋߎgt@CvIuWFNg𐶐
	pobj_History=new CHistory(100);

	//uŋߎgvWFNgvIuWFNg𐶐
	pobj_ProjectHistory=new CHistory(200);
}
CNonVolatile::~CNonVolatile(){
	//gqǗIuWFNgj
	delete pobj_ExtLink;
	pobj_ExtLink=0;

	//WebphCǗIuWFNgj
	delete pobj_DBDomain;
	pobj_DBDomain=0;

	//uŋߎgt@CvIuWFNgj
	delete pobj_History;
	pobj_History=0;

	//uŋߎgvWFNgvIuWFNgj
	delete pobj_ProjectHistory;
	pobj_ProjectHistory=0;
}

BOOL CSettingFile::GetDataLine(char *name,char *parms){
	int i,i2,length;
	length=lstrlen(name);
	for(i=0;;i++){
		if(buffer[i]=='\0') break;
		if(i==0||buffer[i]=='\r'&&buffer[i+1]=='\n'){
			if(buffer[i]=='\r'&&buffer[i+1]=='\n') i+=2;
			if(memcmp(buffer+i,name,length)==0&&buffer[i+length]=='='){
				i+=length+1;
				for(i2=0;;i++,i2++){
					if(buffer[i]=='\r'&&buffer[i+1]=='\n'||buffer[i]=='\0'){
						parms[i2]=0;
						break;
					}
					parms[i2]=buffer[i];
				}
				return 1;
			}
		}
	}
	return 0;
}

BOOL CSettingFile::GetWholeValue(char *name,int *pi32data){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	*pi32data=atoi(temporary);
	return 1;
}
BOOL CSettingFile::Get3WholeValue(char *name,int *pd1,int *pd2,int *pd3){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%d,%d,%d",pd1,pd2,pd3);
	return 1;
}
BOOL CSettingFile::GetRGBValue(char *name,COLORREF *prgb){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%x",prgb);
	return 1;
}
BOOL CSettingFile::GetStringValue(char *name,char *str){
	if(!GetDataLine(name,str)) return 0;
	return 1;
}
BOOL CSettingFile::GetRectValue(char *name,RECT *prc){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%d,%d,%d,%d",&prc->left,&prc->top,&prc->right,&prc->bottom);
	return 1;
}
BOOL CSettingFile::GetLogFont(char *name,LOGFONT *plf){
	char temporary[8192];
	if(!GetDataLine(name,temporary)) return 0;
	sscanf(temporary,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",
		&plf->lfHeight,
		&plf->lfWidth,
		&plf->lfEscapement,
		&plf->lfOrientation,
		&plf->lfWeight,
		&plf->lfItalic,
		&plf->lfUnderline,
		&plf->lfStrikeOut,
		&plf->lfCharSet,
		&plf->lfOutPrecision,
		&plf->lfClipPrecision,
		&plf->lfQuality,
		&plf->lfPitchAndFamily);

	int i;
	for(i=lstrlen(temporary)-1;i>=0;i--){
		if(temporary[i]==','){
			i++;
			break;
		}
	}
	lstrcpy(plf->lfFaceName,temporary+i);
	return 1;
}
BOOL CSettingFile::GetRebarBand(SAVEREBAR *psr,int num){
	char name[32];
	char temporary[8192];

	sprintf(name,"RebarBand%d",num);
	if(!GetDataLine(name,temporary)) return 0;

	sscanf(temporary,"%d,%d,%d",&psr->RebarID,&psr->RebarLength,&psr->IsBandBreak);
	return 1;
}

void CNonVolatile::load(){
	extern METHODCHECKINFO MethodCheckInfo;

	int i;
	char temporary[MAX_PATH];


	///////////////////////////////////
	// ֘Atp̊gqIuWFNg
	///////////////////////////////////
	sprintf(temporary,"%sUserSetting\\extlink.ini",pj_editor_Dir);
	pobj_ExtLink->load(temporary);


	//////////////////////////////////////
	// WebphCǗIuWFNg
	//////////////////////////////////////
	pobj_DBDomain->load();


	///////////////////////////////////////
	// uŋߎgt@CvIuWFNg
	///////////////////////////////////////
	sprintf(temporary,"%sUserSetting\\history.ini",pj_editor_Dir);
	pobj_History->load(temporary);


	////////////////////////////////////////////
	// uŋߎgvWFNgvIuWFNg
	////////////////////////////////////////////
	sprintf(temporary,"%sUserSetting\\pj_history.ini",pj_editor_Dir);
	pobj_ProjectHistory->load(temporary);



	//J
	sprintf(temporary,"%sUserSetting\\editor.ini",pj_editor_Dir);
	buffer=ReadBuffer_NonErrMsg(temporary);
	if(!buffer){

		//ftHg̏ݒ
		InitToDefaultData();
		return;
	}

	//֘Atsǂi̊֐̍ŌɌĂяoj
	if(!GetStringValue("LinkFile",temporary)){
		ExtensionLink(NULL);
	}

	//EBhETCYۑ邩Ȃ
	if(!GetRectValue("WindowRect",&StartupWindowRect)){
		StartupWindowRect.left=(int)((double)ScreenX*0.1);
		StartupWindowRect.top=(int)((double)ScreenX*0.1);
		StartupWindowRect.right=(int)((double)ScreenX*0.8);
		StartupWindowRect.bottom=(int)((double)ScreenY*0.8);
	}

	//EBhEő剻邩
	if(!GetWholeValue("IsWindowMax",&bWindowMax)) bWindowMax=0;

	//s̃vWFNg̕ۑmF̗L
	if(!GetWholeValue("Project_SaveCheck",&bSaveCheckProject)) bSaveCheckProject=0;

	//CAWX^
	if(!GetWholeValue("Rad_LineAdjust",&bLineAdjust)) bLineAdjust=1;

	//ProjectViewʒu
	if(!GetRectValue("ProjectViewRect",&rectProjectView)){
		rectProjectView.left=StartupWindowRect.right-270;
		rectProjectView.right=StartupWindowRect.right-5;
		rectProjectView.top=StartupWindowRect.top+60;
		rectProjectView.bottom=StartupWindowRect.top+380;
	}
	if(rectProjectView.right<=0||
		rectProjectView.left>=ScreenX||
		rectProjectView.bottom<=0||
		rectProjectView.top>=ScreenY||
		rectProjectView.right-rectProjectView.left<10||
		rectProjectView.bottom-rectProjectView.top<10){
		//sȃf[^͕
		rectProjectView.left=StartupWindowRect.right-270;
		rectProjectView.right=StartupWindowRect.right-5;
		rectProjectView.top=StartupWindowRect.top+60;
		rectProjectView.bottom=StartupWindowRect.top+380;
	}

	//ProjectViewNbv
	if(!GetWholeValue("IsClipProjectView",&bClipProjectView)) bClipProjectView=1;
	if(!GetWholeValue("width_ClipProjectView",&width_ClipProjectView)) width_ClipProjectView=200;

	//fobKr[ Nbv
	if(!GetWholeValue("height_ClipDebuggerView",&height_ClipDebuggerView)) height_ClipDebuggerView=180;

	//RpCr[ Nbv
	if(!GetWholeValue("height_ClipCompileView",&height_ClipCompileView)) height_ClipCompileView=130;

	//WebNbv
	if(!GetWholeValue("width_WebSearchView",&width_WebSearchView)) width_WebSearchView=230;


	//Rebaroh
	for(i=0;i<MAX_REBARBANDS;i++){
		if(!GetRebarBand(&SaveRebar[i],i)){
			ResetRebarData();
			break;
		}
	}

	//RebarohŒ肷邩
	if(!GetWholeValue("IsNoGripper",&bNoGripper)) bNoGripper=0;


	//hLgۑƂɃ^u擪ɍĔzu邩ǂ
	if(!GetWholeValue("IsSaveTabToHead",&bSaveTabToHead)){
		bSaveTabToHead=0;
	}

	//tHg
	if(!GetLogFont("EditorFont",&lf)){
		//ǂݍ߂ȂƂ́AftHg̃GfB^tHgZbg
		GetDefaultEditFont(&lf);
	}

	//^uTCY
	if(!GetWholeValue("TabSize",&TabSize)) TabSize=4;

	//GfB^̍sԍ\邩ǂ
	if(!GetWholeValue("IsShowLineNumber",&bEditor_LineNumber)) bEditor_LineNumber=1;

	//GfB^̃[[\邩ǂ
	if(!GetWholeValue("IsShowRuler",&bEditor_Ruler)) bEditor_Ruler=1;

	//J[\s\邩ǂ
	if(!GetWholeValue("IsCaretLine_BackGround",&bEditor_CaretLine_BackGround)) bEditor_CaretLine_BackGround=1;

	//܂Ԃ̈s̕
	if(!GetWholeValue("MaxOneLineTextLength",&iMaxOneLineTextLength)) iMaxOneLineTextLength=75;

	//R[h⊮@\Lɂ邩ǂ
	if(!GetWholeValue("IsShowComplementWnd",&bShowComplementWnd)) bShowComplementWnd=1;

	//yAXe[gg⊮Lɂ邩ǂ
	if(!GetWholeValue("BackNum_PairStatementComplement",&BackNum_PairStatementComplement)) BackNum_PairStatementComplement=100;

	//p[^qg
	if(!GetWholeValue("ParameterHint",(int *)&dwParameterHint)) dwParameterHint=1;

	//p[^ qg tHg
	extern METHODCHECKINFO MethodCheckInfo;
	if(!GetLogFont("HintFont",&MethodCheckInfo.LogFont)){
		//ǂݍ߂ȂƂ́AftHg̃qgtHgZbg
		GetDefaultHintFont(&MethodCheckInfo.LogFont);
	}

	//Cfg
	if(!GetWholeValue("IsAutoIndent",&bAutoIndent)) bAutoIndent=1;

	//\t̃Cfg
	if(!GetWholeValue("IsPasteIndent",&bPasteIndent)) bPasteIndent=0;

	//Euۑ邩ǂ
	if(!GetWholeValue("IsSaveFindStr",&bSaveFindStr)) bSaveFindStr=1;

	//܂Ԃ邩ǂ
	if(!GetWholeValue("IsRightTurn",&bRightTurn)) bRightTurn=0;

	//CtrlL[ɂnCp[N
	if(!GetWholeValue("IsCtrlKeyHyperLink",&bCtrlKeyHyperLink)) bCtrlKeyHyperLink=1;

	//Webۑ邩ǂ
	if(!GetWholeValue("IsSaveWebFindStr",&bSaveWebFindStr)) bSaveWebFindStr=1;

	//MDIEBhEő剻\邩
	if(!GetWholeValue("IsMDIZoomed",&bMDIZoomed)) bMDIZoomed=0;

	//WۑfBNg
	if(!GetStringValue("DefSaveDir",DefSaveDir)) lstrcpy(DefSaveDir,pj_editor_Dir);

	//vWFNgۑfBNg
	if(!GetStringValue("ProjectSaveDir",ProjectSaveDir)) sprintf(ProjectSaveDir,"%sMyProjects",pj_editor_Dir);

	//ɁA啶ʂ邩
	if(!GetWholeValue("IsFindStrBigSmall",&bFindStrBigSmall)) bFindStrBigSmall=0;

	//ɁAK\𗘗p邩ǂ
	if(!GetWholeValue("IsRegExp",&bRegExp)) bRegExp=0;

	//ANeBu fUC e[}
	if(!GetStringValue("ActiveTheme",szActiveTheme)) lstrcpy(szActiveTheme,THEMENAME_CLASSIC);

	//ptHg
	if(!GetLogFont("PrintFont",&lfPrint)){
		//ǂݍ߂ȂƂ́AftHg̃GfB^tHgZbg
		GetDefaultPrintFont(&lfPrint);
	}

	//ptHg̃|CgTCY
	if(!GetWholeValue("PrintFontPointSize",&iPrintFontPointSize)){
		//ǂݍ߂ȂƂ́AftHg̃|CgTCYZbg
		iPrintFontPointSize=72;
	}

	//y[Wԍ\邩ǂ
	if(!GetWholeValue("IsShowPageNum",&bShowPageNum)) bShowPageNum=1;

	//y[Wԍ
	if(!GetStringValue("PageStr",szPageStr)) lstrcpy(szPageStr,"y[W &n");

	//CN[hfBNg
	if(!GetStringValue("IncludeDir",szIncludeDir)) lstrcpy(szIncludeDir,".\\Include\\");

	HeapDefaultFree(buffer);


	/////////////////
	// 
	/////////////////
	int i2,i3;

	sprintf(temporary,"%sUserSetting\\findstr.ini",pj_editor_Dir);
	buffer=ReadBuffer_NonErrMsg(temporary);
	if(buffer){
		i2=0;
		for(i=0;i<MAX_FINDLIST;i++){
			for(i3=0;i3<MAX_PATH;i2++,i3++){
				if(buffer[i2]=='\r'&&buffer[i2+1]=='\n'||buffer[i2]=='\0'){
					FindStr[i][i3]=0;
					break;
				}
				FindStr[i][i3]=buffer[i2];
			}
			if(buffer[i2]=='\r'&&buffer[i2+1]=='\n') i2+=2;
		}

		HeapDefaultFree(buffer);
	}


	/////////////////
	// u
	/////////////////
	sprintf(temporary,"%sUserSetting\\permustr.ini",pj_editor_Dir);
	buffer=ReadBuffer_NonErrMsg(temporary);
	if(buffer){
		i2=0;
		for(i=0;i<MAX_FINDLIST;i++){
			for(i3=0;i3<MAX_PATH;i2++,i3++){
				if(buffer[i2]=='\r'&&buffer[i2+1]=='\n'||buffer[i2]=='\0'){
					PermutationStr[i][i3]=0;
					break;
				}
				PermutationStr[i][i3]=buffer[i2];
			}
			if(buffer[i2]=='\r'&&buffer[i2+1]=='\n') i2+=2;
		}

		HeapDefaultFree(buffer);
	}


	/////////////////
	// Web
	/////////////////
	sprintf(temporary,"%sUserSetting\\webstr.ini",pj_editor_Dir);
	buffer=ReadBuffer_NonErrMsg(temporary);
	if(buffer){
		i2=0;
		for(i=0;i<MAX_FINDLIST;i++){
			for(i3=0;i3<MAX_PATH;i2++,i3++){
				if(buffer[i2]=='\r'&&buffer[i2+1]=='\n'||buffer[i2]=='\0'){
					WebStr[i][i3]=0;
					break;
				}
				WebStr[i][i3]=buffer[i2];
			}
			if(buffer[i2]=='\r'&&buffer[i2+1]=='\n') i2+=2;
		}

		HeapDefaultFree(buffer);
	}
}

void CNonVolatile::InitToDefaultData(){
	///////////////////////////////////
	// ftHg̏ݒ
	///////////////////////////////////

	//Euۑ邩ǂ
	bSaveFindStr=1;

	//܂Ԃ邩ǂ
	bRightTurn=0;

	//CtrlL[ɂnCp[N
	bCtrlKeyHyperLink=1;

	//Webۑ邩ǂ
	bSaveWebFindStr=1;

	//ANeBu fUC e[}
	lstrcpy(szActiveTheme,THEMENAME_CLASSIC);

	//ptHg
	GetDefaultPrintFont(&lfPrint);

	//ptHg̃|CgTCY
	iPrintFontPointSize=72;

	//y[Wԍ\邩ǂ
	bShowPageNum=1;

	//y[Wԍ
	lstrcpy(szPageStr,"y[W &n");

	//CN[hfBNg
	lstrcpy(szIncludeDir,".\\Include\\");

	//EBhEʒuATCY
	StartupWindowRect.left=(int)((double)ScreenX*0.1);
	StartupWindowRect.top=(int)((double)ScreenX*0.1);
	StartupWindowRect.right=(int)((double)ScreenX*0.8);
	StartupWindowRect.bottom=(int)((double)ScreenY*0.8);

	//EBhEő剻邩
	bWindowMax=1;

	//śAvWFNg̕ۑmF̗L
	bSaveCheckProject=0;

	//RADc[̃C AWX^
	bLineAdjust=1;

	//ProjectViewʒu
	rectProjectView.left=StartupWindowRect.right-270;
	rectProjectView.right=StartupWindowRect.right-5;
	rectProjectView.top=StartupWindowRect.top+60;
	rectProjectView.bottom=StartupWindowRect.top+380;

	//Rebar
	ResetRebarData();

	//GfB^ tHg
	GetDefaultEditFont(&lf);

	//p[^ qg tHg
	extern METHODCHECKINFO MethodCheckInfo;
	GetDefaultHintFont(&MethodCheckInfo.LogFont);

	//^uTCY
	TabSize=4;

	//sԍ\邩ǂ
	bEditor_LineNumber=1;

	//[[\邩ǂ
	bEditor_Ruler=1;

	//J[\s\邩ǂ
	bEditor_CaretLine_BackGround=1;

	//܂Ԃ̕
	iMaxOneLineTextLength=75;

	//p[^qg
	dwParameterHint=1;

	//Cfg
	bAutoIndent=1;

	//\t̃Cfg
	bPasteIndent=0;

	//MDIEBhEő剻\邩
	bMDIZoomed=1;

	//WۑfBNg
	lstrcpy(DefSaveDir,pj_editor_Dir);

	//vWFNgۑfBNg
	sprintf(ProjectSaveDir,"%sMyProjects",pj_editor_Dir);

	bClipProjectView=1;
	width_ClipProjectView=200;
	height_ClipDebuggerView=180;
	height_ClipCompileView=130;
	width_WebSearchView=230;
	bSaveTabToHead=0;

	BackNum_PairStatementComplement=100;

	//t@C̊֘At
	ExtensionLink(NULL);
}

void CSettingFile::SetWholeValue(char *name,long i32data){
	sprintf(buffer+lstrlen(buffer),"%s=%d\r\n",name,i32data);
}
void CSettingFile::Set3WholeValue(char *name,long d1,long d2,long d3){
	sprintf(buffer+lstrlen(buffer),"%s=%d,%d,%d\r\n",name,d1,d2,d3);
}
void CSettingFile::SetRGBValue(char *name,COLORREF rgb){
	rgb=RGB(
		LOBYTE(LOWORD(rgb)),
		HIBYTE(LOWORD(rgb)),
		LOBYTE(HIWORD(rgb))
		);
	sprintf(buffer+lstrlen(buffer),"%s=%x\r\n",name,rgb);
}
void CSettingFile::SetStringValue(char *name,char *str){
	sprintf(buffer+lstrlen(buffer),"%s=%s\r\n",name,str);
}
void CSettingFile::SetRectValue(char *name,RECT *prc){
	sprintf(buffer+lstrlen(buffer),"%s=%d,%d,%d,%d\r\n",name,prc->left,prc->top,prc->right,prc->bottom);
}
void CSettingFile::SetLogFont(char *name,LOGFONT *plf){
	sprintf(buffer+lstrlen(buffer),"%s=%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%s\r\n",name,
		plf->lfHeight,
		plf->lfWidth,
		plf->lfEscapement,
		plf->lfOrientation,
		plf->lfWeight,
		plf->lfItalic,
		plf->lfUnderline,
		plf->lfStrikeOut,
		plf->lfCharSet,
		plf->lfOutPrecision,
		plf->lfClipPrecision,
		plf->lfQuality,
		plf->lfPitchAndFamily,
		plf->lfFaceName);
}
void CSettingFile::SetRebarBand(SAVEREBAR *psr,int num){
	char name[32];

	sprintf(name,"RebarBand%d",num);
	sprintf(buffer+lstrlen(buffer),"%s=%d,%d,%d\r\n",name,psr->RebarID,psr->RebarLength,psr->IsBandBreak);
}

void CNonVolatile::save(){
	int i;
	char temporary[MAX_PATH];

	sprintf(temporary,"%sUserSetting",pj_editor_Dir);

	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	hFind=FindFirstFile(temporary,&wfd);
	if(hFind==INVALID_HANDLE_VALUE){
		//UserSettingfBNg쐬
		if(!CreateDirectory(temporary,NULL)){
			MessageBox(hOwner,"UserSettingfBNg̍쐬Ɏs",APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	buffer=(char *)HeapAlloc(hHeap,0,65536);
	buffer[0]=0;


	//EBhETCYۑ邩Ȃ
	SetRectValue("WindowRect",&StartupWindowRect);

	//EBhEő剻邩
	SetWholeValue("IsWindowMax",bWindowMax);

	//s̃vWFNg̕ۑmF̗L
	SetWholeValue("Project_SaveCheck",bSaveCheckProject);

	//CAWX^
	SetWholeValue("Rad_LineAdjust",bLineAdjust);

	//ProjectViewʒu
	SetRectValue("ProjectViewRect",&rectProjectView);

	//ProjectViewNbv
	SetWholeValue("IsClipProjectView",bClipProjectView);
	SetWholeValue("width_ClipProjectView",width_ClipProjectView);

	//fobKr[ Nbv
	SetWholeValue("height_ClipDebuggerView",height_ClipDebuggerView);

	//RpCr[ Nbv
	SetWholeValue("height_ClipCompileView",height_ClipCompileView);

	//WebNbv
	SetWholeValue("width_WebSearchView",width_WebSearchView);


	//Rebar
	for(i=0;i<MAX_REBARBANDS;i++){
		SetRebarBand(&SaveRebar[i],i);
	}

	//RebarohŒ肷邩
	SetWholeValue("IsNoGripper",bNoGripper);


	//hLgۑƂɃ^u擪ɍĔzu邩ǂ
	SetWholeValue("IsSaveTabToHead",bSaveTabToHead);

	//tHg
	SetLogFont("EditorFont",&lf);

	//^uTCY
	SetWholeValue("TabSize",TabSize);

	//GfB^̍sԍ\邩ǂ
	SetWholeValue("IsShowLineNumber",bEditor_LineNumber);

	//[[\邩ǂ
	SetWholeValue("IsShowRuler",bEditor_Ruler);

	//J[\s\邩ǂ
	SetWholeValue("IsCaretLine_BackGround",bEditor_CaretLine_BackGround);

	//܂Ԃ̈s̕
	SetWholeValue("MaxOneLineTextLength",iMaxOneLineTextLength);

	//R[h⊮@\Lɂ邩ǂ
	SetWholeValue("IsShowComplementWnd",bShowComplementWnd);

	//yAXe[gg⊮Lɂ邩ǂ
	SetWholeValue("BackNum_PairStatementComplement",BackNum_PairStatementComplement);

	//p[^qg
	SetWholeValue("ParameterHint",dwParameterHint);

	//p[^ qg tHg
	extern METHODCHECKINFO MethodCheckInfo;
	SetLogFont("HintFont",&MethodCheckInfo.LogFont);

	//Euۑ邩ǂ
	SetWholeValue("IsSaveFindStr",bSaveFindStr);

	//Cfg
	SetWholeValue("IsAutoIndent",bAutoIndent);

	//\t̃Cfg
	SetWholeValue("IsPasteIndent",bPasteIndent);

	//܂Ԃ邩ǂ
	SetWholeValue("IsRightTurn",bRightTurn);

	//CtrlL[ɂnCp[N
	SetWholeValue("IsCtrlKeyHyperLink",bCtrlKeyHyperLink);

	//Webۑ邩ǂ
	SetWholeValue("IsSaveWebFindStr",bSaveWebFindStr);

	//MDIEBhEő剻\邩
	SetWholeValue("IsMDIZoomed",bMDIZoomed);

	//WۑfBNg
	SetStringValue("DefSaveDir",DefSaveDir);

	//vWFNgۑfBNg
	SetStringValue("ProjectSaveDir",ProjectSaveDir);

	//ɁA啶ʂ邩
	SetWholeValue("IsFindStrBigSmall",bFindStrBigSmall);

	//ɁAK\𗘗p邩
	SetWholeValue("IsRegExp",bRegExp);

	//NɊ֘At_CAO\Ȃ悤ɂ
	SetStringValue("LinkFile","ok");

	//ANeBu fUC e[}
	SetStringValue("ActiveTheme",szActiveTheme);

	//ptHg
	SetLogFont("PrintFont",&lfPrint);

	//ptHg̃|CgTCY
	SetWholeValue("PrintFontPointSize",iPrintFontPointSize);

	//y[Wԍ\邩ǂ
	SetWholeValue("IsShowPageNum",bShowPageNum);

	//y[Wԍ
	SetStringValue("PageStr",szPageStr);

	//CN[hfBNg
	SetStringValue("IncludeDir",szIncludeDir);


	//ۑ
	sprintf(temporary,"%sUserSetting\\editor.ini",pj_editor_Dir);
	WriteBuffer(temporary,buffer,lstrlen(buffer));



	/////////////////
	// 
	/////////////////
	buffer[0]=0;
	if(pobj_nv->bSaveFindStr){
		for(i=0;i<MAX_FINDLIST;i++){
			lstrcat(buffer,FindStr[i]);
			lstrcat(buffer,"\r\n");
		}
	}

	//ۑ
	sprintf(temporary,"%sUserSetting\\findstr.ini",pj_editor_Dir);
	WriteBuffer(temporary,buffer,lstrlen(buffer));



	/////////////////
	// u
	/////////////////
	buffer[0]=0;
	if(pobj_nv->bSaveFindStr){
		for(i=0;i<MAX_FINDLIST;i++){
			lstrcat(buffer,PermutationStr[i]);
			lstrcat(buffer,"\r\n");
		}
	}

	//ۑ
	sprintf(temporary,"%sUserSetting\\permustr.ini",pj_editor_Dir);
	WriteBuffer(temporary,buffer,lstrlen(buffer));



	/////////////////
	// Web
	/////////////////
	buffer[0]=0;
	if(pobj_nv->bSaveWebFindStr){
		for(i=0;i<MAX_FINDLIST;i++){
			lstrcat(buffer,WebStr[i]);
			lstrcat(buffer,"\r\n");
		}
	}

	//ۑ
	sprintf(temporary,"%sUserSetting\\webstr.ini",pj_editor_Dir);
	WriteBuffer(temporary,buffer,lstrlen(buffer));

	HeapDefaultFree(buffer);



	///////////////////////////////////
	// ֘Atp̊gqIuWFNg
	///////////////////////////////////
	sprintf(temporary,"%sUserSetting\\extlink.ini",pj_editor_Dir);
	pobj_ExtLink->save(temporary);


	//////////////////////////////////////
	// WebphCǗIuWFNg
	//////////////////////////////////////
	pobj_DBDomain->save();


	///////////////////////////////////////
	// uŋߎgt@CvIuWFNg
	///////////////////////////////////////
	sprintf(temporary,"%sUserSetting\\history.ini",pj_editor_Dir);
	pobj_History->save(temporary);

	
	///////////////////////////////////////
	// uŋߎgt@CvIuWFNg
	///////////////////////////////////////
	sprintf(temporary,"%sUserSetting\\pj_history.ini",pj_editor_Dir);
	pobj_ProjectHistory->save(temporary);
}
