#include "common.h"
#include "CIEsink.h"


#define ID_TIMER_POPUP_ANIMATION 100
#define ID_TIMER_IDLE 200

extern FWINLAYER SetLayeredWindowAttributes;


LRESULT CALLBACK ResultListProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	CResultList *pobj_ResultList;
	POINT pos;
	RECT rc;
	int iItem;

	switch(message){
		case WM_TIMER:
			if(wParam==ID_TIMER_POPUP_ANIMATION){
				pobj_ResultList=(CResultList *)GetWindowLong(hwnd,GWL_USERDATA);

				SetLayeredWindowAttributes(hwnd, 0,(int)((double)255/(double)100*(double)(pobj_ResultList->iAnimeCount*10)), LWA_ALPHA);

				GetWindowRect(hwnd,&rc);
				rc.top++;
				SetWindowPos(hwnd,0,rc.left,rc.top,0,0,SWP_NOSIZE);

				pobj_ResultList->iAnimeCount+=1;
				if(pobj_ResultList->iAnimeCount>10){
					KillTimer(hwnd,ID_TIMER_POPUP_ANIMATION);

					SetTimer(hwnd,ID_TIMER_IDLE,100,NULL);
				}
			}
			else if(wParam==ID_TIMER_IDLE){
				InvalidateRect(hwnd,NULL,0);
			}
			return 0;
		case WM_PAINT:
			pobj_ResultList=(CResultList *)GetWindowLong(hwnd,GWL_USERDATA);

			RECT ClientRect;
			GetClientRect(hwnd,&ClientRect);

			//`Jn
			HDC hdc;
			PAINTSTRUCT ps;
			hdc=BeginPaint(hwnd,&ps);

			//foCXReLXg𐶐
			HDC memdc;
			HBITMAP hMemBmp;
			memdc=CreateCompatibleDC(hdc);
			hMemBmp=CreateCompatibleBitmap(hdc,ClientRect.right,ClientRect.bottom);
			SelectObject(memdc,hMemBmp);

			//tHgZbg
			extern HFONT hStatusFont;
			HFONT hOldFont;
			hOldFont=(HFONT)SelectObject(memdc,hStatusFont);

			//EBhETCY擾iACeW擾j
			GetCursorPos(&pos);
			GetWindowRect(hwnd,&rc);
			rc.bottom=rc.top+LINK_ITEM_HEIGHT;

			//NCAg ACe W擾
			ClientRect.left+=10;
			ClientRect.bottom=ClientRect.top+LINK_ITEM_HEIGHT;

			//uV𐶐
			HBRUSH hFaceBrush,hShadowBrush,hOldBrush;
			hFaceBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE));
			hShadowBrush=CreateSolidBrush(GetSysColor(COLOR_3DSHADOW));

			for(iItem=0;iItem<10;iItem++){
				if(rc.left<pos.x && pos.x<rc.right && rc.top<pos.y && pos.y<rc.bottom){

					SetBkColor(memdc,GetSysColor(COLOR_3DSHADOW));

					hOldBrush=(HBRUSH)SelectObject(memdc,hShadowBrush);
				}
				else{
					extern HFONT hStatusFont;
					hOldFont=(HFONT)SelectObject(memdc,hStatusFont);

					SetBkColor(memdc,GetSysColor(COLOR_3DFACE));

					hOldBrush=(HBRUSH)SelectObject(memdc,hFaceBrush);
				}
				SetTextColor(memdc,RGB(0,0,255));

				PatBlt(memdc,ClientRect.left-10,ClientRect.top,ClientRect.right,ClientRect.bottom,PATCOPY);
				SelectObject(memdc,hOldBrush);

				DrawText(memdc,pobj_ResultList->pobj_OneTab->lpszTitle[iItem],-1,&ClientRect,DT_LEFT|DT_VCENTER|DT_SINGLELINE);

				rc.top+=LINK_ITEM_HEIGHT;
				rc.bottom=rc.top+LINK_ITEM_HEIGHT;

				ClientRect.top+=LINK_ITEM_HEIGHT;
				ClientRect.bottom=ClientRect.top+LINK_ITEM_HEIGHT;
			}

			SelectObject(memdc,hOldFont);

			GetClientRect(hwnd,&ClientRect);
			BitBlt(hdc,0,0,ClientRect.right,ClientRect.bottom,memdc,0,0,SRCCOPY);

			EndPaint(hwnd,&ps);

			DeleteObject(hFaceBrush);
			DeleteObject(hShadowBrush);

			DeleteDC(memdc);
			DeleteObject(hMemBmp);
			break;

		case WM_LBUTTONDOWN:
			pobj_ResultList=(CResultList *)GetWindowLong(hwnd,GWL_USERDATA);

			GetCursorPos(&pos);
			GetWindowRect(hwnd,&rc);
			rc.bottom=rc.top+LINK_ITEM_HEIGHT;

			for(iItem=0;iItem<10;iItem++){
				if(rc.left<pos.x && pos.x<rc.right && rc.top<pos.y && pos.y<rc.bottom){
					ShellExecute(hwnd,"open",pobj_ResultList->pobj_OneTab->lpszUrl[iItem],NULL,NULL,SW_SHOWNORMAL);
					break;
				}

				rc.top+=LINK_ITEM_HEIGHT;
				rc.bottom=rc.top+LINK_ITEM_HEIGHT;
			}
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

CResultList::CResultList(COneTab *pot){
	pobj_OneTab=pot;
	iAnimeCount=0;

	hwnd=CreateWindowEx(0,"ResultList","ResultList",
		WS_POPUP|WS_CLIPCHILDREN|WS_VISIBLE|WS_BORDER,
		0,0,0,0,
		hOwner,0,hInst,0);

	//EBhE𔼓ɂ
	int lStyle;
	lStyle=GetWindowLong(hwnd,GWL_EXSTYLE) | WS_EX_LAYERED;
	SetWindowLong(hwnd,GWL_EXSTYLE,lStyle);
	SetLayeredWindowAttributes(hwnd, 0, 0, LWA_ALPHA);

	SetWindowLong(hwnd,GWL_USERDATA,(long)this);
	SetTimer(hwnd,ID_TIMER_POPUP_ANIMATION,10,NULL);
	BringWindowToTop(hwnd);

	RECT rc;
	GetWindowRect(pobj_OneTab->hTabWnd,&rc);

	HDC hdc;
	hdc=GetDC(hwnd);

	extern HFONT hStatusFont;
	HFONT hOldFont;
	hOldFont=(HFONT)SelectObject(hdc,hStatusFont);


	//ACe擾
	int iItem,iMaxWidth=0;
	for(iItem=0;iItem<10;iItem++){
		if(pobj_OneTab->lpszTitle[iItem]==0){
			break;
		}

		SIZE size;
		GetTextExtentPoint32(hdc,pobj_OneTab->lpszTitle[iItem],lstrlen(pobj_OneTab->lpszTitle[iItem]),&size);

		if(iMaxWidth<size.cx){
			//ő啝擾
			iMaxWidth=size.cx;
		}
	}

	SelectObject(hdc,hOldFont);
	ReleaseDC(hwnd,hdc);

	MoveWindow(hwnd,rc.left,rc.top-iItem*LINK_ITEM_HEIGHT-10,iMaxWidth+20,iItem*LINK_ITEM_HEIGHT,1);
}
CResultList::~CResultList(){
	DestroyWindow(hwnd);
}



LRESULT CALLBACK OneTabProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	COneTab *pobj_OneTab;
	RECT rc;
	POINT pos;

	switch(message){
		case WM_CREATE:
			SetTimer(hwnd,0,100,NULL);
			return 0;
		case WM_TIMER:
			InvalidateRect(hwnd,NULL,0);
			return 0;
		case WM_PAINT:
			pobj_OneTab=(COneTab *)GetWindowLong(hwnd,GWL_USERDATA);

			HBRUSH hBrush,hOldBrush;

			HDC hdc;
			PAINTSTRUCT ps;
			hdc=BeginPaint(hwnd,&ps);

			GetCursorPos(&pos);
			GetWindowRect(hwnd,&rc);
			HFONT hOldFont;
			if(rc.left<=pos.x && pos.x<=rc.right && rc.top<=pos.y && pos.y<=rc.bottom){
				extern HFONT hStatusFont;
				hOldFont=(HFONT)SelectObject(hdc,hStatusFont);

				SetBkColor(hdc,GetSysColor(COLOR_3DSHADOW));

				hBrush=CreateSolidBrush(GetSysColor(COLOR_3DSHADOW));

				//Xg\
				if(pobj_OneTab->pobj_ResultList==0){
					pobj_OneTab->pobj_ResultList=new CResultList(pobj_OneTab);
				}
			}
			else{
				extern HFONT hStatusFont;
				hOldFont=(HFONT)SelectObject(hdc,hStatusFont);

				SetBkColor(hdc,GetSysColor(COLOR_3DFACE));

				hBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE));

				//Xgj
				if(pobj_OneTab->pobj_ResultList){
					GetWindowRect(pobj_OneTab->pobj_ResultList->hwnd,&rc);
					if(!(rc.left<=pos.x && pos.x<=rc.right && rc.top<=pos.y && pos.y<=rc.bottom)){
						delete pobj_OneTab->pobj_ResultList;
						pobj_OneTab->pobj_ResultList=0;
					}
				}
			}
			SetTextColor(hdc,RGB(0,0,255));

			GetClientRect(hwnd,&rc);

			hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
			PatBlt(hdc,0,0,rc.right,rc.bottom,PATCOPY);
			SelectObject(hdc,hOldBrush);

			rc.left++;
			DrawText(hdc,pobj_OneTab->lpszString,-1,&rc,DT_CENTER|DT_VCENTER|DT_SINGLELINE);

			SelectObject(hdc,hOldFont);

			//[̋E
			HPEN hPen,hOldPen;
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DSHADOW));
			hOldPen=(HPEN)SelectObject(hdc,hPen);
			MoveToEx(hdc,0,0,NULL);
			LineTo(hdc,0,rc.bottom-rc.top);
			SelectObject(hdc,hOldPen);
			DeleteObject(hPen);

			EndPaint(hwnd,&ps);

			DeleteObject(hBrush);
			return 0;
		case WM_LBUTTONDOWN:
			pobj_OneTab=(COneTab *)GetWindowLong(hwnd,GWL_USERDATA);

			ShellExecute(hwnd,"open",pobj_OneTab->lpszUrl[0],NULL,NULL,SW_SHOWNORMAL);
			return 0;

		case WM_COMMAND:
			break;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

COneTab::COneTab(int WndNum,char *str){
	//0ŏ
	memset(this,0,sizeof(COneTab));

	m_WndNum=WndNum;

	lpszString=(char *)malloc(lstrlen(str)+1);
	lstrcpy(lpszString,str);


	//Web
	WebSearch();



	/////////////////////////////////
	// eLXgACe̕擾
	/////////////////////////////////

	HDC hdc;
	SIZE size;
	hdc=GetDC(hOwner);

	extern HFONT hStatusFont;
	HFONT hOldFont;
	hOldFont=(HFONT)SelectObject(hdc,hStatusFont);

	GetTextExtentPoint32(hdc,lpszString,lstrlen(lpszString),&size);

	SelectObject(hdc,hOldFont);

	ReleaseDC(hOwner,hdc);
	iWindowWidth=size.cx+20;

	if(MdiInfo[WndNum].pMdiTextEdit==0) return;
	hTabWnd=(HWND)SendMessage(MdiInfo[WndNum].pMdiTextEdit->hEdit,WM_SEARCH_TAB_CREATE,(WPARAM)WndNum,(LPARAM)this);
}
COneTab::~COneTab(){
	free(lpszString);

	int i;
	for(i=0;i<10;i++){
		if(lpszTitle[i]) free(lpszTitle[i]);
		if(lpszUrl[i]) free(lpszUrl[i]);
	}

	if(MdiInfo[m_WndNum].pMdiTextEdit)
		SendMessage(MdiInfo[m_WndNum].pMdiTextEdit->hEdit,WM_SEARCH_TAB_CLOSE,0,(LPARAM)hTabWnd);
}

void COneTab::WebSearch(){
	//URLGR[h
	char *temporary;
	temporary=(char *)malloc(lstrlen(lpszString)*3+1024);
	wsprintf(temporary," %s",lpszString);
	URLEncode(temporary);

	char *lpszTempUrl;
	lpszTempUrl=(char *)malloc(lstrlen(temporary)+1024);
	sprintf(lpszTempUrl,"http://www.activebasic.com/application_web_search/search.php?query=%s&type=web&utf_sw=1&start=1",temporary);

	free(temporary);


	HINTERNET hInternet;
	HINTERNET hNetFile;
	hInternet = InternetOpen("Agent", 0, NULL, NULL, 0);
	if(hInternet==0){
		return;
	}
	hNetFile = InternetOpenUrl(hInternet, lpszTempUrl, NULL, 0, 0, 0);
	if(hNetFile==0){
		InternetCloseHandle(hInternet);
		return;
	}

	/* I[vURLf[^(1000oCg)ǂݍ */
	DWORD dwReadSize;
	BOOL bResult;
	char *buffer;
	buffer=(char *)malloc(8192);
	buffer[0]=0;

	while(1){
		char temp3[1024];
		bResult = InternetReadFile(
			hNetFile,
			temp3,
			1000,
			&dwReadSize);

		/* Sēǂݍ񂾂烋[v𔲂 */
		if(bResult && (dwReadSize == 0)) break;

		temp3[dwReadSize]=0;
		lstrcat(buffer,temp3);
	}


	//UTF-8Shift-JISɕϊ
	char *temp2;
	temp2=(char *)malloc(8192);
	nkf.pSetNkfOption("-sx");	//Shift-JISɕϊix͔pJ^JiSpɕϊȂIvVj
	nkf.pNkfConvert(temp2,buffer);
	free(buffer);


	InternetCloseHandle(hNetFile);
	InternetCloseHandle(hInternet);


	//^CgEURL擾
	int iItem;
	int i=0,i2;
	for(iItem=0;iItem<10;iItem++){
		lpszTitle[iItem]=(char *)malloc(lstrlen(temp2)+1);
		lpszUrl[iItem]=(char *)malloc(lstrlen(temp2)+1);
		for(i2=0;;i++,i2++){
			//^Cg
			if(temp2[i]=='\n'||temp2[i]=='\0'){
				lpszTitle[iItem][i2]=0;
				break;
			}
			lpszTitle[iItem][i2]=temp2[i];
		}
		if(temp2[i]){
			//URL
			for(i++,i2=0;;i++,i2++){
				if(temp2[i]=='\n'||temp2[i]=='\0'){
					lpszUrl[iItem][i2]=0;
					break;
				}
				lpszUrl[iItem][i2]=temp2[i];
			}
		}
		if(temp2[i]){
			//T}[
			for(i++,i2=0;;i++,i2++){
				if(temp2[i]=='\n'||temp2[i]=='\0'){
					break;
				}
			}
		}

		if(temp2[i]=='\0') break;
		i++;
	}


	free(temp2);


	free(lpszTempUrl);
}






LRESULT CALLBACK WebResultWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_COMMAND:
			break;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

CWebResult::CWebResult(HWND hParent){
	ppobj_OneTab=(COneTab **)malloc(1);
	iTabNum=0;

	hwnd=CreateWindowEx(0,"WebResult","WebResult",
		WS_CHILD|WS_CLIPCHILDREN|WS_VISIBLE,
		0,0,0,0,
		hParent,0,hInst,0);
}
CWebResult::~CWebResult(){
	int i;
	for(i=0;i<iTabNum;i++){
		delete ppobj_OneTab[i];
	}

	free(ppobj_OneTab);
	ppobj_OneTab=0;

	DestroyWindow(hwnd);
}

void CWebResult::resize(int x,int y,int cx,int cy){
	MoveWindow(hwnd,x,y,cx,cy,1);
}

void CWebResult::add(int WndNum,char *lpszSearchText){
	COneTab *pobj_temp_OneTab;
	pobj_temp_OneTab=new COneTab(WndNum,lpszSearchText);
	if(MdiInfo[WndNum].pMdiTextEdit==0){
		delete pobj_temp_OneTab;
		return;
	}

	if(pobj_temp_OneTab->lpszTitle[0]){
		if(pobj_temp_OneTab->lpszTitle[0][0]=='\0'){
			delete pobj_temp_OneTab;
			return;
		}
	}
	else{
		delete pobj_temp_OneTab;
		return;
	}


	ppobj_OneTab=(COneTab **)realloc(ppobj_OneTab,(iTabNum+1)*sizeof(COneTab));

	//[e[V
	int i;
	for(i=iTabNum-1;i>=0;i--){
		ppobj_OneTab[i+1]=ppobj_OneTab[i];
	}

	ppobj_OneTab[0]=pobj_temp_OneTab;
	iTabNum++;

	if(iTabNum==10){
		//ÂACej
		delete ppobj_OneTab[iTabNum-1];
		iTabNum--;
	}

	int offset=0;
	for(i=0;i<iTabNum;i++){
		offset+=ppobj_OneTab[i]->iWindowWidth;
	}
	for(i=iTabNum-1;i>=0;i--){
		offset-=ppobj_OneTab[i]->iWindowWidth;
		MoveWindow(ppobj_OneTab[i]->hTabWnd,
			offset,
			0,
			ppobj_OneTab[i]->iWindowWidth,
			20,
			1);
	}
}
BOOL CWebResult::DuplicateCheck(char *str){
	int i;
	for(i=0;i<iTabNum;i++){
		if(lstrcmpi(ppobj_OneTab[i]->lpszString,str)==0){
			return 1;
		}
	}
	return 0;
}



BOOL bSearchingWeb;
char *lpszRetrySearchStr;
void WebSearchThread(void *temp_str){
	char *str;
	str=(char *)malloc(lstrlen((char *)temp_str)+1);
	lstrcpy(str,(char *)temp_str);
	HeapDefaultFree(temp_str);

	int WndNum;
	WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));
	if(bSearchingWeb){
		if(lpszRetrySearchStr) free(lpszRetrySearchStr);
		lpszRetrySearchStr=str;

		_endthread();
		return;
	}
	bSearchingWeb=1;


wait_repeat:
	Sleep(500);
	if(lpszRetrySearchStr){
		free(str);

		str=lpszRetrySearchStr;
		lpszRetrySearchStr=0;
		goto wait_repeat;
	}


	if(WndNum==-1){
		goto exit;
	}
	if(MdiInfo[WndNum].pMdiTextEdit==0){
		goto exit;
	}

	//d`FbN
	if(MdiInfo[WndNum].pMdiTextEdit->pobj_WebResult->DuplicateCheck(str)){
		goto exit;
	}



	extern MDIINFO MdiInfo[MAX_WNDNUM];
	MdiInfo[WndNum].pMdiTextEdit->pobj_WebResult->add(WndNum,str);

exit:
	bSearchingWeb=0;

	free(str);


	if(lpszRetrySearchStr){
		str=lpszRetrySearchStr;
		lpszRetrySearchStr=0;
		goto wait_repeat;
	}


	_endthread();
}




////////////////////////////
// ȉASideWeb
////////////////////////////

CComModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
END_OBJECT_MAP()

HWND hNowIEWnd;
LRESULT CALLBACK SideWebProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	CComQIPtr<IWebBrowser2>	pWB2 ;

	switch (iMsg)
	{
		case WM_CREATE :
		{
			AtlAxWinInit();
			hNowIEWnd = CreateWindow("AtlAxWin", "Shell.Explorer.2", WS_CHILD|WS_VISIBLE, 0,0,0,0, 
						hwnd, (HMENU)0, hInst, NULL);
			if(!hNowIEWnd){
				MessageBox(hOwner,"IER|[lg̐Ɏs܂","lockey_browser",MB_OK|MB_ICONEXCLAMATION);
				PostQuitMessage(0);
				return 0;
			}

			// ActiveXRg[̃C^[tF[Xv
			CComPtr<IUnknown>	 punkIE;
			if (AtlAxGetControl(hNowIEWnd, &punkIE) == S_OK)
			{
				// IUnknown|C^IWebBrowser2|C^փLXg
				pWB2 = punkIE;

				if(pWB2)
				{
					// VNIuWFNg̍쐬
					CComObject<CIESink>* sink;
					CComObject<CIESink>::CreateInstance(&sink);

					// CxgDispatch悤AIERg[ɂ肢
					HRESULT hr = sink->AdviseToIE(punkIE);
					if(SUCCEEDED(hr))
					{
						//
						return 0;
					}
				}

				MessageBox(hOwner,"IER|[lg̐Ɏs܂","ProjectEditor",MB_OK|MB_ICONEXCLAMATION);
				PostQuitMessage(0);
				return 0;
			}

			return 0 ;
		}

		case WM_SIZE :
			MoveWindow(GetWindow(hwnd,GW_CHILD), 0, 0, LOWORD(lParam), HIWORD(lParam), 1) ;
			return 0 ;

		case WM_KEYDOWN:
		{
			// ActiveXRg[̃C^[tF[Xv
			CComPtr<IUnknown>	 punkIE;
			if (AtlAxGetControl(hNowIEWnd, &punkIE) == S_OK)
			{
				// IUnknown|C^IWebBrowser2|C^փLXg
				pWB2 = punkIE;

				CComQIPtr<IOleInPlaceActiveObject, &IID_IOleInPlaceActiveObject> pIOIPAO(pWB2) ;

				if(pIOIPAO)
				{
					MSG msg;
					msg.message = iMsg;
					msg.wParam = wParam;
					msg.lParam = lParam;

					pIOIPAO->TranslateAccelerator(&msg);
				}
 
				return 0 ;
			}
		}

		case WM_BROWS_GO:

			{
				// ActiveXRg[̃C^[tF[Xv
				CComPtr<IUnknown>	 punkIE;
				if (AtlAxGetControl(hNowIEWnd, &punkIE) == S_OK)
				{
					// IUnknown|C^IWebBrowser2|C^փLXg
					pWB2 = punkIE;

					// URLֈړ
					CComVariant vempty, vUrl((char *)lParam);
					pWB2->Navigate2 (&vUrl, &vempty, &vempty, &vempty, &vempty );
				}
			}

			return 0;

		case WM_BROWS_DESTROY:
			DestroyWindow(hwnd);
			return 0;

		case WM_DESTROY :
			{
				// ActiveXRg[̃C^[tF[Xv
				CComPtr<IUnknown>	 punkIE;
				if (AtlAxGetControl(hNowIEWnd, &punkIE) == S_OK)
				{
					// IUnknown|C^IWebBrowser2|C^փLXg
					pWB2 = punkIE;

					pWB2.Release();
				}

			}
			return 0 ;
	}

	return DefWindowProc (hwnd, iMsg, wParam, lParam) ;
}

CChildSideWeb::CChildSideWeb(HWND hParent,HWND hTab,char *title,char *site){
	hwnd=CreateWindowEx(WS_EX_CLIENTEDGE,"SideWeb","SideWeb",
		WS_CHILD|WS_CLIPCHILDREN,
		0,0,0,0,
		hParent,0,hInst,0);
	hIEWnd=hNowIEWnd;

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;

	tcItem.pszText=title;
	TabCtrl_InsertItem(hTab,SendMessage(hTab,TCM_GETITEMCOUNT,0,0),&tcItem);

	//^Cg
	lpszTitle=(char *)malloc(lstrlen(title)+1);
	lstrcpy(lpszTitle,title);

	//TCg
	lpszSite=(char *)malloc(lstrlen(site)+1);
	lstrcpy(lpszSite,site);
}
CChildSideWeb::~CChildSideWeb(){
	free(lpszTitle);
	free(lpszSite);
	DestroyWindow(hwnd);
}


CSideWeb *pobj_SideWeb=0;

CSideWeb::CSideWeb(HWND hParent){
	lpszNowUrl=0;
	bShow=0;

	_Module.Init(ObjectMap, hInst);

	//^u𐶐
	extern HFONT hStatusFont;
	hTab=CreateWindowEx(0,WC_TABCONTROL,NULL,
		WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS|WS_VISIBLE,
		0,0,0,0,
		hParent,0,hInst,0);
	SendMessage(hTab,WM_SETFONT,(long)hStatusFont,0);

	//{^𐶐
	hRightButton=CreateWindow("BUTTON","",WS_CHILD|WS_VISIBLE,
		0,0,20,13,
		hParent,(HMENU)IDC_CLIP,hInst,0);
	SendMessage(hRightButton,WM_SETFONT,(long)hStatusFont,0);


	iChildSideWebNum=pobj_nv->pobj_DBDomain->iDomainNum+1;
	ppobj_ChildSideWeb=(CChildSideWeb **)malloc(iChildSideWebNum*sizeof(CChildSideWeb *));
	ppobj_ChildSideWeb[0]=new CChildSideWeb(hParent,hTab,"S","");
	int i;
	for(i=0;i<pobj_nv->pobj_DBDomain->iDomainNum;i++){
		ppobj_ChildSideWeb[i+1]=new CChildSideWeb(hParent,hTab,
			pobj_nv->pobj_DBDomain->ppobj_Domain[i]->lpszName,
			pobj_nv->pobj_DBDomain->ppobj_Domain[i]->lpszDomain);
	}


	TabCtrl_SetCurSel(hTab,0);
	ShowWindow(ppobj_ChildSideWeb[0]->hwnd,SW_SHOW);
	hNowIEWnd=ppobj_ChildSideWeb[0]->hIEWnd;
}
CSideWeb::~CSideWeb(){
	int i;
	for(i=0;i<iChildSideWebNum;i++){
		delete ppobj_ChildSideWeb[i];
	}
	free(ppobj_ChildSideWeb);
	ppobj_ChildSideWeb=0;

	if(lpszNowUrl) free(lpszNowUrl);

	DestroyWindow(hTab);
	DestroyWindow(hRightButton);
}
void CSideWeb::resize(int x,int y,int cx,int cy){
	int iTabHeight=25;

	MoveWindow(hTab,x,y,cx-30,iTabHeight,1);

	SetWindowPos(hRightButton,NULL,x+cx-25,y+7,0,0,SWP_NOSIZE);

	int i;
	for(i=0;i<iChildSideWebNum;i++){
		MoveWindow(ppobj_ChildSideWeb[i]->hwnd,x,y+iTabHeight,cx,cy-iTabHeight,1);
	}

	m_Rect.left=x;
	m_Rect.top=y;
	m_Rect.right=x+cx;
	m_Rect.bottom=y+cy;
}

void CSideWeb::GoPage(char *lpszUrl){
	char *pTemp;
	pTemp=(char *)malloc(lstrlen(lpszUrl)+1);
	lstrcpy(pTemp,lpszUrl);

	if(lpszNowUrl) free(lpszNowUrl);
	lpszNowUrl=pTemp;

	int iTabPos;
	iTabPos=SendMessage(hTab,TCM_GETCURSEL,0,0);


	pTemp=(char *)malloc(lstrlen(lpszNowUrl)+1024);
	if(ppobj_ChildSideWeb[iTabPos]->lpszSite[0])
		sprintf(pTemp,"%s&site=%s",lpszNowUrl,ppobj_ChildSideWeb[iTabPos]->lpszSite);
	else lstrcpy(pTemp,lpszNowUrl);

	SendMessage(ppobj_ChildSideWeb[iTabPos]->hwnd,WM_BROWS_GO,0,(LPARAM)pTemp);

	free(pTemp);

	bShow=1;
	ResizeOwnerWnd();	
}

void CSideWeb::SelChangeEvent(){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	char temporary[MAX_PATH];

	int i;
	i=TabCtrl_GetCurSel(hTab);

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;
	tcItem.pszText=temporary;
	tcItem.cchTextMax=MAX_PATH;
	TabCtrl_GetItem(hTab,i,&tcItem);

	for(i=0;i<iChildSideWebNum;i++){
		ShowWindow(ppobj_ChildSideWeb[i]->hwnd,SW_HIDE);
	}

	for(i=0;i<iChildSideWebNum;i++){
		if(lstrcmpi(temporary,ppobj_ChildSideWeb[i]->lpszTitle)==0){
			ShowWindow(ppobj_ChildSideWeb[i]->hwnd,SW_SHOW);
			hNowIEWnd=ppobj_ChildSideWeb[i]->hIEWnd;
			GoPage(lpszNowUrl);
			break;
		}
	}
}

void CSideWeb::GetRect(RECT *prc){
	*prc=m_Rect;
}





CWebStrings obj_WebStrings;

CWebStrings::CWebStrings(){
	buffer=(char *)malloc(1);
	buffer[0]=0;

	ppStr=(char **)malloc(1);
	iStrNum=0;
}
CWebStrings::~CWebStrings(){
	free(buffer);

	int i;
	for(i=0;i<iStrNum;i++){
		free(ppStr[i]);
	}
	free(ppStr);
}

void CWebStrings::add(char *query){
	//d`FbN
	int i;
	for(i=0;i<iStrNum;i++){
		if(lstrcmpi(ppStr[i],query)==0){
			return;
		}
	}

	ppStr=(char **)realloc(ppStr,(iStrNum+1)*sizeof(char *));
	ppStr[iStrNum]=(char *)malloc(lstrlen(query)+1);
	lstrcpy(ppStr[iStrNum],query);
	iStrNum++;
}

void CWebStrings::clear(){
	buffer[0]=0;

	int i;
	for(i=0;i<iStrNum;i++){
		free(ppStr[i]);
	}
	iStrNum=0;
}

char *CWebStrings::GetBuffer(){
	buffer[0]=0;
	int i;
	for(i=0;i<iStrNum;i++){
		buffer=(char *)realloc(buffer,lstrlen(buffer)+lstrlen(ppStr[i])+2);
		if(i) lstrcat(buffer," ");
		lstrcat(buffer,ppStr[i]);
	}
	return buffer;
}



//////////////////////////
// WebphCǗ
//////////////////////////

CDomain::CDomain(char *name,char *domain){
	//\
	lpszName=(char *)HeapAlloc(hHeap,0,lstrlen(name)+1);
	lstrcpy(lpszName,name);

	//hC
	lpszDomain=(char *)HeapAlloc(hHeap,0,lstrlen(domain)+1);
	lstrcpy(lpszDomain,domain);
}
CDomain::~CDomain(){
	HeapDefaultFree(lpszName);
	HeapDefaultFree(lpszDomain);
}


void CDBDomain::init(){
	int i;
	for(i=0;i<iDomainNum;i++){
		delete ppobj_Domain[i];
	}
	iDomainNum=0;
}
CDBDomain::CDBDomain(){
	ppobj_Domain=(CDomain **)HeapAlloc(hHeap,0,1);
	iDomainNum=0;

	m_hListView=0;
}
CDBDomain::~CDBDomain(){
	init();
	HeapDefaultFree(ppobj_Domain);
}

void CDBDomain::load(){
	char temporary[MAX_PATH],temp2[MAX_PATH];
	sprintf(temporary,"%sUserSetting\\domain.ini",pj_editor_Dir);

	char *buffer;
	buffer=ReadBuffer_NonErrMsg(temporary);
	if(buffer){
		int i;
		i=0;
		while(buffer[i]){
			//\
			i=GetOneParameter(buffer,i,temporary);
			if(temporary[0]=='\0') break;

			//hC
			i=GetOneParameter(buffer,i,temp2);
			if(temp2[0]=='\0') break;

			if(buffer[i]=='\r'&&buffer[i+1]=='\n'){
				i+=2;
			}

			add(temporary,temp2);
		}
		HeapDefaultFree(buffer);
	}
	else{
		add("","ja.wikipedia.org");
		add("MSDN","msdn.microsoft.com");
	}
}
void CDBDomain::save(){
	char temporary[MAX_PATH];
	sprintf(temporary,"%sUserSetting\\domain.ini",pj_editor_Dir);

	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,iDomainNum*MAX_PATH*2+1);
	buffer[0]=0;

	int i;
	for(i=0;i<iDomainNum;i++){
		sprintf(buffer+lstrlen(buffer),"%s,%s\r\n",ppobj_Domain[i]->lpszName,ppobj_Domain[i]->lpszDomain);
	}

	WriteBuffer(temporary,buffer,lstrlen(buffer));

	HeapDefaultFree(buffer);
}

void CDBDomain::copy_get(CDBDomain *pobj_DBDomain){
	init();

	int i;
	for(i=0;i<pobj_DBDomain->iDomainNum;i++){
		add(pobj_DBDomain->ppobj_Domain[i]->lpszName,pobj_DBDomain->ppobj_Domain[i]->lpszDomain);
	}
}

void CDBDomain::SetListView(HWND hListView){
	m_hListView=hListView;

	int i;
	for(i=0;i<iDomainNum;i++){
		LV_ITEM item;

		item.mask=LVIF_TEXT;
		item.pszText=ppobj_Domain[i]->lpszName;
		item.iItem=i;
		item.iSubItem=0;
		ListView_InsertItem(m_hListView,&item);

		item.pszText=ppobj_Domain[i]->lpszDomain;
		item.iItem=i;
		item.iSubItem++;
		ListView_SetItem(m_hListView,&item);
	}
}

void CDBDomain::add(char *name,char *domain){
	ppobj_Domain=(CDomain **)HeapReAlloc(hHeap,0,ppobj_Domain,(iDomainNum+1)*sizeof(CDomain *));
	ppobj_Domain[iDomainNum]=new CDomain(name,domain);
	iDomainNum++;


	if(m_hListView){
		int i;
		i=ListView_GetItemCount(m_hListView);

		//Xgr[ɒǉ
		LV_ITEM item;
		item.mask=LVIF_TEXT;
		item.pszText=name;
		item.iItem=i;
		item.iSubItem=0;
		ListView_InsertItem(m_hListView,&item);

		item.pszText=domain;
		item.iItem=i;
		item.iSubItem++;
		ListView_SetItem(m_hListView,&item);
	}
}
void CDBDomain::del(char *name){
	int i;
	for(i=0;i<iDomainNum;i++){
		if(lstrcmp(ppobj_Domain[i]->lpszName,name)==0) break;
	}
	if(i==iDomainNum) return;

	if(m_hListView){
		//Xgr[폜
		ListView_DeleteItem(m_hListView,i);
	}

	delete ppobj_Domain[i];
	iDomainNum--;
	for(;i<iDomainNum;i++){
		ppobj_Domain[i]=ppobj_Domain[i+1];
	}
}
void CDBDomain::change(char *szBeforeName,char *name,char *domain){
	int i;
	for(i=0;i<iDomainNum;i++){
		if(lstrcmp(ppobj_Domain[i]->lpszName,szBeforeName)==0) break;
	}
	if(i==iDomainNum) return;

	ppobj_Domain[i]->lpszName=(char *)HeapReAlloc(hHeap,0,ppobj_Domain[i]->lpszName,lstrlen(name)+1);
	lstrcpy(ppobj_Domain[i]->lpszName,name);

	ppobj_Domain[i]->lpszDomain=(char *)HeapReAlloc(hHeap,0,ppobj_Domain[i]->lpszDomain,lstrlen(domain)+1);
	lstrcpy(ppobj_Domain[i]->lpszDomain,domain);


	if(m_hListView){
		//Xgr[̐ݒ
		ListView_SetItemText(m_hListView,i,0,name);
		ListView_SetItemText(m_hListView,i,1,domain);
	}
}
