#include "common.h"

LRESULT CALLBACK RulerProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_PAINT:
			CRuler *pobj_Ruler;
			pobj_Ruler=(CRuler *)GetWindowLong(hwnd,GWL_USERDATA);

			HDC hdc;
			PAINTSTRUCT ps;
			hdc=BeginPaint(hwnd,&ps);

			pobj_Ruler->draw(hdc);

			EndPaint(hwnd,&ps);
			break;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

CRuler::CRuler(HWND hParent,int WndNum){
	m_WndNum=WndNum;

	hRulerWnd=CreateWindowEx(0,"Ruler","Ruler",
		WS_CHILD|WS_CLIPCHILDREN|WS_VISIBLE,
		0,0,0,0,
		hParent,0,hInst,0);
	SetWindowLong(hRulerWnd,GWL_USERDATA,(long)this);

	HDC hdc;
	hdc=GetDC(hRulerWnd);

	memdc=CreateCompatibleDC(hdc);
	hMemBmp=CreateCompatibleBitmap(hdc,ScreenX,HEIGHT_RULER);
	SelectObject(memdc,hMemBmp);

	ReleaseDC(hRulerWnd,hdc);
}
CRuler::~CRuler(){
	DeleteDC(memdc);
	DeleteObject(hMemBmp);

	DestroyWindow(hRulerWnd);
}

void CRuler::resize(int x,int y,int cx,int cy){
	MoveWindow(hRulerWnd,x,y,cx,cy,1);
}
void CRuler::draw(HDC hdc){
	int i;

	//XN[o[ɂx[X|WV擾
	int BaseX,BaseY;
	BaseX=0;
	BaseY=0;
	GetScrollBaseCaretPos(m_WndNum,&BaseX,&BaseY);

	int iControlTabSpace;
	iControlTabSpace=MdiInfo[m_WndNum].pMdiTextEdit->iWidth_ControlTabSpace;

	HBRUSH hBrush,hOldBrush;
	hBrush=CreateSolidBrush(RGB(230,230,230));

	HPEN hPen,hOldPen;
	hPen=CreatePen(PS_SOLID,0,RGB(60,60,60));

	//wiFhԂ
	hOldBrush=(HBRUSH)SelectObject(memdc,hBrush);
	PatBlt(memdc,0,0,ScreenX,HEIGHT_RULER,PATCOPY);
	SelectObject(memdc,hOldBrush);


	extern HFONT hRulerFont;
	HFONT hOldFont;
	hOldFont=(HFONT)SelectObject(memdc,hRulerFont);

	hOldPen=(HPEN)SelectObject(memdc,hPen);

	//C`
	extern int font_width;
	int x;
	for(x=iControlTabSpace,i=-BaseX;x<ScreenX;x+=font_width,i++){
		if(i%10==0){
			MoveToEx(memdc,x,0,NULL);
			LineTo(memdc,x,HEIGHT_RULER);
		}
		else if(i%5==0){
			MoveToEx(memdc,x,HEIGHT_RULER/2,NULL);
			LineTo(memdc,x,HEIGHT_RULER);
		}
		else{
			MoveToEx(memdc,x,HEIGHT_RULER-3,NULL);
			LineTo(memdc,x,HEIGHT_RULER);
		}
	}

	//ԍ`
	char temporary[32];
	SetBkColor(memdc,RGB(230,230,230));
	SetTextColor(memdc,RGB(60,60,60));
	for(x=iControlTabSpace,i=-BaseX;x<ScreenX;x+=font_width,i++){
		if(i%10==0){
			sprintf(temporary,"%d",i);
			TextOut(memdc,x+2,0,temporary,lstrlen(temporary));
		}
	}

	SelectObject(memdc,hOldPen);
	SelectObject(memdc,hOldFont);


	//ʂɕ`
	BitBlt(hdc,0,0,ScreenX,HEIGHT_RULER,memdc,0,0,SRCCOPY);

	DeleteObject(hBrush);
	DeleteObject(hPen);
}
