#include "Common.h"

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif


CClassTreeView *pobj_ClassTreeView;

BOOL bSearchingClasses,bRetrySearchingClasses;


int CClassTreeView::hash_default(LONG_PTR lpdata){
	return lpdata%MAX_HASH;
}
void CClassTreeView::AddValidItem(HTREEITEM hItem,int iFileNum){
	//nbVl擾
	int key;
	key=hash_default((LONG_PTR)hItem);

	//i[ʒu擾
	TREEHASH *pth;
	pth=&tree_data[key];
	while(pth->hItem){
		if(pth->hItem==hItem){
			//ɑ݂Ƃ͔o
			return;
		}
		if(pth->pNextData==0){
			pth->pNextData=(TREEHASH *)HeapAlloc(hHeap,0,sizeof(TREEHASH));
			pth=pth->pNextData;
			break;
		}
		pth=pth->pNextData;
	}

	pth->hItem=hItem;
	pth->iFileNum=iFileNum;
	pth->pNextData=0;
}

BOOL CClassTreeView::delete_check(HTREEITEM hItem){
	//nbVl擾
	int key;
	key=hash_default((LONG_PTR)hItem);

	TREEHASH *pth;
	pth=&tree_data[key];
	while(pth->hItem){
		if(pth->hItem==hItem) return 1;

		if(pth->pNextData==0) break;
		pth=pth->pNextData;
	}
	return 0;
}

void CClassTreeView::DeleteInvalidItems(HTREEITEM hItem){
	HTREEITEM hChildItem;
	while(hItem){
		if(!delete_check(hItem)){
			HTREEITEM hTemp;
			hTemp=hItem;

			hItem=TreeView_GetNextSibling(hTreeWnd,hItem);

			TreeView_DeleteItem(hTreeWnd,hTemp);
			continue;
		}

		hChildItem=TreeView_GetChild(hTreeWnd,hItem);
		if(hChildItem){
			DeleteInvalidItems(hChildItem);
		}

		hItem=TreeView_GetNextSibling(hTreeWnd,hItem);
	}
}

void CClassTreeView::DeleteTreeHash(TREEHASH *pth){
	if(pth->hItem && (iNowFile==-1 || iNowFile==pth->iFileNum)){
		if(pth->pNextData){
			DeleteTreeHash(pth->pNextData);
			HeapDefaultFree(pth->pNextData);
			pth->pNextData=0;
		}
		pth->hItem=0;
	}
}


HTREEITEM CClassTreeView::insert(HTREEITEM hParentItem,int flag,char *lpszName,int iFileNum){
	char temporary[255];

	TVITEM tvItem;
	tvItem.pszText=temporary;
	tvItem.cchTextMax=255;
	HTREEITEM hNextItem;
	hNextItem=TreeView_GetChild(hTreeWnd,hParentItem);
	while(hNextItem){
		tvItem.mask=TVIF_HANDLE|TVIF_TEXT;
		tvItem.hItem=hNextItem;
		TreeView_GetItem(hTreeWnd,&tvItem);
		if(lstrcmp(lpszName,tvItem.pszText)==0){
			//ɑ}ς݂̏ꍇ
			AddValidItem(hNextItem,iFileNum);
			return hNextItem;
		}

		hNextItem=TreeView_GetNextSibling(hTreeWnd,hNextItem);
	}


	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE|TVIS_EXPANDED ;
	tv.hParent=hParentItem;
	tv.item.pszText=lpszName;

	if(flag==CTV_ROOT){
		tv.item.iImage=3;
		tv.item.iSelectedImage=3;
	}
	if(flag==CTV_FOLDER){
		tv.item.iImage=0;
		tv.item.iSelectedImage=0;
	}
	else if(flag==CTV_GLOBAL_PROC){
		tv.item.iImage=5;
		tv.item.iSelectedImage=5;
	}
	else if(flag==CTV_CLASS){
		tv.item.iImage=2;
		tv.item.iSelectedImage=2;
	}
	else if(flag==CTV_PUBLIC_MEMBER){
		tv.item.iImage=4;
		tv.item.iSelectedImage=4;
	}
	else if(flag==CTV_PUBLIC_METHOD){
		tv.item.iImage=5;
		tv.item.iSelectedImage=5;
	}
	else if(flag==CTV_PRIVATE_MEMBER){
		tv.item.iImage=6;
		tv.item.iSelectedImage=6;
	}
	else if(flag==CTV_PRIVATE_METHOD){
		tv.item.iImage=7;
		tv.item.iSelectedImage=7;
	}

	hNextItem=TreeView_InsertItem(hTreeWnd,&tv);
	AddValidItem(hNextItem,iFileNum);
	return hNextItem;
}



CClassTreeView::CClassTreeView(){
	memset(this,0,sizeof(CClassTreeView));
}
CClassTreeView::~CClassTreeView(){
	while(bSearchingClasses) Sleep(10);

	iNowFile=-1;

	int i;
	for(i=0;i<MAX_HASH;i++){
		DeleteTreeHash(&tree_data[i]);
	}

	if(pobj_ClassTreeView->pProcInfo){
		//vV[W̃
		for(i=0;i<pobj_ClassTreeView->NumberOfProcedures;i++){
			HeapDefaultFree(pobj_ClassTreeView->pProcInfo[i].name);
		}
		HeapDefaultFree(pobj_ClassTreeView->pProcInfo);
		pobj_ClassTreeView->pProcInfo=0;
	}
}
void CClassTreeView::init(HWND hwnd,int iFileNum){
	hTreeWnd=hwnd;

	iNowFile=iFileNum;

	int i;
	for(i=0;i<MAX_HASH;i++){
		DeleteTreeHash(&tree_data[i]);
	}
}

void CClassTreeView::InsertRootFolder(void){
	extern PROJECTINFO ProjectInfo;
	char temporary[VN_SIZE];
	sprintf(temporary,"%s NX",ProjectInfo.name);
	hRootFolder=insert(
		TVI_ROOT,
		CTV_ROOT,
		temporary,-1);
}
void CClassTreeView::InsertGlobalProcedureFolder(void){
	hGlobalProcedureFolder=insert(
		hRootFolder,
		CTV_FOLDER,
		"O[o֐",-1);
}

HTREEITEM CClassTreeView::InsertGlobalProcedure(int flag,char *lpszName,int iFileNum){
	return pobj_ClassTreeView->insert(
		hGlobalProcedureFolder,
		CTV_GLOBAL_PROC,
		lpszName,
		iFileNum);
}

HTREEITEM CClassTreeView::insert_code_item(HTREEITEM hParentItem,int flag,char *lpszName,int iFileNum,char *pBuf,int p){
	int i4;
	i4=NumberOfProcedures;
	pProcInfo=(PROCINFO *)HeapReAlloc(hHeap,0,pProcInfo,sizeof(PROCINFO)*(i4+1));
	pProcInfo[i4].name=(char *)HeapAlloc(hHeap,0,lstrlen(lpszName)+1);
	lstrcpy(pProcInfo[i4].name,lpszName);
	pProcInfo[i4].FileNum=iFileNum;

	//R[hʒu
	pProcInfo[i4].code_pos=p;

	//c[ACe}
	HTREEITEM hTempItem;
	hTempItem=insert(
		hParentItem,
		flag,
		lpszName,
		iFileNum);

	pProcInfo[i4].hTreeItem=hTempItem;

	NumberOfProcedures++;

	return hTempItem;
}

void CClassTreeView::InsertClassFolder(char *lpszName,int iFileNum,char *pBuf,int p){
	hNowClassFolder=insert_code_item(hRootFolder,CTV_CLASS,lpszName,iFileNum,pBuf,p);
}
void CClassTreeView::InsertClassMember(int flag,char *lpszName,int iFileNum,char *pBuf,int p){
	insert_code_item(hNowClassFolder,flag,lpszName,iFileNum,pBuf,p);
}

void CClassTreeView::finish(){
	DeleteInvalidItems(TreeView_GetRoot(hTreeWnd));
}


void AnalysisClass(char *pBuf,int *p,int iFileNum){
	int i2;
	i2=*p;


	CClassInfo *pobj_ClassInfo;
	pobj_ClassInfo=new CClassInfo();

	pobj_ClassInfo->Analyze(pBuf,p);


	//NXtH_}
	pobj_ClassTreeView->InsertClassFolder(
		pobj_ClassInfo->ClassName,
		iFileNum,
		pBuf,
		i2);



	///////////////////////////////
	// oyу\bh}
	///////////////////////////////

	int i;
	for(i=0;i<pobj_ClassInfo->MemberNum;i++){
		int flag;
		if(pobj_ClassInfo->pMemberInfo[i].dwProc==0){
			//oϐ
			if(pobj_ClassInfo->pMemberInfo[i].dwAccess==ACCESS_PUBLIC){
				//J
				flag=CTV_PUBLIC_MEMBER;
			}
			else{
				//J
				flag=CTV_PRIVATE_MEMBER;
			}
		}
		else{
			//\bh
			if(pobj_ClassInfo->pMemberInfo[i].dwAccess==ACCESS_PUBLIC){
				//J
				flag=CTV_PUBLIC_METHOD;
			}
			else{
				//J
				flag=CTV_PRIVATE_METHOD;
			}
		}
		pobj_ClassTreeView->InsertClassMember(flag,pobj_ClassInfo->pMemberInfo[i].pName,iFileNum,pBuf,pobj_ClassInfo->pMemberInfo[i].code_pos);
	}


	delete pobj_ClassInfo;
	pobj_ClassInfo=0;
}



void SetClassTreeFromOneFile(char *lpszFilePath,int iFileNum){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i2,i3,i4,WndNum;
	char *pBuf;
	HWND hChild;
	char temporary[GENERAL_SIZE];

	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		WndNum=GetWndNum(hChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
			if(lstrcmpi(MdiInfo[WndNum].path,lpszFilePath)==0) break;
		}
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
	}

	if(hChild){
		//łɎw肳ꂽt@CJĂꍇ
		pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;
	}
	else{
		//JĂȂꍇ
		pBuf=ReadBuffer(lpszFilePath);
		if(!pBuf) pBuf=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
	}
	for(i2=0;;i2++){
		if(pBuf[i2]=='\0') break;
		while(pBuf[i2]=='\r'&&pBuf[i2+1]=='\n'&&pBuf[i2+2]=='\r'&&pBuf[i2+3]=='\n') i2+=2;
		if(i2==0||(pBuf[i2]=='\r'&&pBuf[i2+1]=='\n')){
			if(pBuf[i2]=='\r'&&pBuf[i2+1]=='\n') i2+=2;
			while(pBuf[i2]>='0'&&pBuf[i2]<='9') i2++;
			while(pBuf[i2]==' '||pBuf[i2]=='\t') i2++;

			i4=i2;
			for(i3=0;;i2++,i3++){
				if(!IsVariableChar(pBuf[i2])){
					temporary[i3]=0;
					break;
				}
				temporary[i3]=pBuf[i2];
			}
			if(pBuf[i2]=='\0') break;

			if(lstrcmpi(temporary,"Class")==0||
				lstrcmpi(temporary,"Type")==0||
				lstrcmpi(temporary,"Interface")==0){

				/////////////////////////////
				// NX̉
				/////////////////////////////
				AnalysisClass(pBuf,&i4,iFileNum);

				i2=i4-1;
				continue;
			}

			int sw;
			if(lstrcmpi(temporary,"Sub")==0) sw=1;
			else if(lstrcmpi(temporary,"Function")==0) sw=2;
			else sw=0;

			if(sw){
				//Sub/Function
				while(pBuf[i2]==' '||pBuf[i2]=='\t') i2++;
				for(i3=0;;i2++,i3++){
					if(!IsVariableChar(pBuf[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=pBuf[i2];
				}

				if(lstrcmpi(temporary,"Export")==0){
					//ExportCq͂Ƃ΂
					while(pBuf[i2]==' '||pBuf[i2]=='\t') i2++;

					for(i3=0;;i2++,i3++){
						if(!IsVariableChar(pBuf[i2])){
							temporary[i3]=0;
							break;
						}
						temporary[i3]=pBuf[i2];
					}
				}

				i4=pobj_ClassTreeView->NumberOfProcedures;
				pobj_ClassTreeView->pProcInfo=(PROCINFO *)HeapReAlloc(hHeap,0,pobj_ClassTreeView->pProcInfo,sizeof(PROCINFO)*(i4+1));
				pobj_ClassTreeView->pProcInfo[i4].name=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
				lstrcpy(pobj_ClassTreeView->pProcInfo[i4].name,temporary);
				pobj_ClassTreeView->pProcInfo[i4].FileNum=iFileNum;

				//`s̑I͈
				pobj_ClassTreeView->pProcInfo[i4].code_pos=i2;

				//p[^
				while(pBuf[i2]==' '||pBuf[i2]=='\t') i2++;
				if(pBuf[i2]=='('){
					int IsStr,PareNum;
					for(i2++,i3=0,IsStr=0,PareNum=0;;i2++,i3++){
						if(pBuf[i2]=='\"') IsStr^=1;
						if(pBuf[i2]=='('&&IsStr==0) PareNum++;
						if(pBuf[i2]==')'&&IsStr==0){
							PareNum--;
							if(PareNum<0){
								temporary[i3]=0;
								break;
							}
						}
						if(pBuf[i2]=='\0') break;
						temporary[i3]=pBuf[i2];
					}
					//temporary̓p[^̓ei[邪Asv
				}

				for(;;i2++){
					if(IsCommandDelimitation(pBuf,i2)){
						break;
					}
					if((pBuf[i2]=='a'||pBuf[i2]=='A')&&(pBuf[i2+1]=='s'||pBuf[i2+1]=='S')&&(pBuf[i2+2]==' '||pBuf[i2+2]=='\t')){
						i2+=3;
						while(pBuf[i2]==' '||pBuf[i2]=='\t') i2++;
						for(i3=0;;i2++,i3++){
							if(!IsVariableChar(pBuf[i2])){
								temporary[i3]=0;
								break;
							}
							temporary[i3]=pBuf[i2];
						}
						//temporaryɂ͌^񂪊i[邪Asv
						break;
					}
				}

				//c[ACe}
				HTREEITEM hTempItem;
				hTempItem=pobj_ClassTreeView->InsertGlobalProcedure(
					CTV_GLOBAL_PROC,
					pobj_ClassTreeView->pProcInfo[i4].name,
					iFileNum);
				pobj_ClassTreeView->pProcInfo[i4].hTreeItem=hTempItem;

				pobj_ClassTreeView->NumberOfProcedures++;

				i2--;
			}
		}
	}

	if(!hChild) HeapDefaultFree(pBuf);
}

void SetProcedureTreeData(void *temp_iFileNum){
	extern PROJECTINFO ProjectInfo;
	int i;
	char temporary[MAX_PATH];
	BOOL bExpand;
	TVITEM tvItem;
	SCROLLINFO si;

	int iFileNum;
	iFileNum=(int)temp_iFileNum;

	if(bSearchingClasses){
		bRetrySearchingClasses=1;
		_endthread();
		return;
	}
	bSearchingClasses=1;

	if(pobj_ClassTreeView->pProcInfo){
wait_repeat:
		Sleep(700);
		if(bRetrySearchingClasses){
			bRetrySearchingClasses=0;
			goto wait_repeat;
		}

		PROCINFO *pNewProcInfo;
		pNewProcInfo=(PROCINFO *)HeapAlloc(hHeap,0,pobj_ClassTreeView->NumberOfProcedures*sizeof(PROCINFO));
		int NewProcNum;
		NewProcNum=0;

		//vV[W̃
		for(i=0;i<pobj_ClassTreeView->NumberOfProcedures;i++){
			if(iFileNum==-1 || iFileNum==pobj_ClassTreeView->pProcInfo[i].FileNum){
				HeapDefaultFree(pobj_ClassTreeView->pProcInfo[i].name);
			}
			else{
				pNewProcInfo[NewProcNum]=pobj_ClassTreeView->pProcInfo[i];
				NewProcNum++;
			}
		}
		HeapDefaultFree(pobj_ClassTreeView->pProcInfo);

		pobj_ClassTreeView->pProcInfo=pNewProcInfo;
		pobj_ClassTreeView->NumberOfProcedures=NewProcNum;
	}
	else{
		pobj_ClassTreeView->pProcInfo=(PROCINFO *)HeapAlloc(hHeap,0,1);
		pobj_ClassTreeView->NumberOfProcedures=0;
	}

	extern HWND hProcedureTreeView;
	tvItem.hItem=TreeView_GetRoot(hProcedureTreeView);
	if(tvItem.hItem){
		TreeView_GetItem(hProcedureTreeView,&tvItem);
		if(tvItem.state&TVIS_EXPANDED){
			bExpand=1;

			si.cbSize=sizeof(SCROLLINFO);
			si.fMask=SIF_POS;
			GetScrollInfo(hProcedureTreeView,SB_VERT,&si);
		}
		else bExpand=0;
	}
	else bExpand=1;


	pobj_ClassTreeView->init(hProcedureTreeView,iFileNum);

	//[gtH_
	pobj_ClassTreeView->InsertRootFolder();

	//O[o֐tH_
	pobj_ClassTreeView->InsertGlobalProcedureFolder();


	//`bN
	LockWindowUpdate(hProcedureTreeView);

	if(iFileNum==-1){
		//vWFNĝׂẴt@C
		for(i=0;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){
			ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);

			SetClassTreeFromOneFile(temporary,i);
		}

		//svɂȂACe
		pobj_ClassTreeView->finish();
	}
	else{
		/////////////////////////////////
		// ҏW̃t@Ĉ݂
		/////////////////////////////////

		ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[iFileNum]->GetFullPath(temporary);

		SetClassTreeFromOneFile(temporary,iFileNum);
	}

	//svɂȂACe
	pobj_ClassTreeView->finish();

	//`惍bN
	LockWindowUpdate(0);


	if(bExpand){
		TreeView_Expand(hProcedureTreeView,pobj_ClassTreeView->hRootFolder,TVE_EXPAND);

		SetScrollInfo(hProcedureTreeView,SB_VERT,&si,1);
	}


	bSearchingClasses=0;
	if(bRetrySearchingClasses){
		bRetrySearchingClasses=0;
		ResetClassTree(iFileNum);
	}

	if(pobj_ClassTreeView->bCloseSwitch){
		//R[h͒ɏI{^ꂽƂ
		PostMessage(hOwner,WM_CLOSE,0,0);
	}
	if(pobj_ClassTreeView->bShowSwitch){
		//R[h͒ɃNXr[_uNbNꂽƂ
		extern HWND hProjectViewTab;
		PostMessage(hProjectViewTab,WM_COMMAND,IDM_PROCEDURETREE_SHOW,0);
		pobj_ClassTreeView->bShowSwitch=0;
	}

	_endthread();
}
void ResetClassTree(int iFileNum){
	_beginthread(SetProcedureTreeData,0,(void *)iFileNum);
}
