#include "stdafx.h"

#include <CodeGenerator.h>


void CodeGenerator::CheckUnresolveSchedule()
{
	if( pertialSchedules.size() > 0 )
	{
		SetError();
	}
}


// ֘A
void CodeGenerator::opfix_JmpPertialSchedule( const PertialSchedule *pPertialSchedule )
{
	bool isSuccessful = false;

	CodeGenerator::PertialSchedules::iterator it = pertialSchedules.begin();
	while( it != pertialSchedules.end() )
	{
		if( (*it) == pPertialSchedule )
		{
			if( pPertialSchedule->GetTypeSize() == sizeof(char) )
			{
				pNativeCode->Overwrite( pPertialSchedule->GetCodePos(), (char)( pNativeCode->GetSize() - (pPertialSchedule->GetCodePos()+1) ) );

				// TODO: ipȂj
				extern int obp;
				pNativeCode->OverwriteOld( pPertialSchedule->GetObpOld(), (char)( obp - (pPertialSchedule->GetObpOld()+1) ) );
			}
			else
			{
				SetError();
			}

			pertialSchedules.erase( it );
			delete pPertialSchedule;

			isSuccessful = true;
		}
		else
		{
			it++;
		}
	}

	if( isSuccessful == false )
	{
		SetError();
	}
}
CodeGenerator::PertialSchedule *CodeGenerator::__jmp_op_format( char opcode, long offset, int op_size, bool isPertialSchedule )
{
	pNativeCode->Put( opcode );

	PertialSchedule *pPertialSchedule = NULL;
	if( isPertialSchedule )
	{
		pertialSchedules.push_back( new PertialSchedule( pNativeCode->GetSize(), op_size ) );
		pPertialSchedule = pertialSchedules[pertialSchedules.size()-1];
	}

	if( op_size == sizeof(char) )
	{
		pNativeCode->Put( (char)offset );
	}
	else if( op_size == sizeof(long) )
	{
		SetError();
		pNativeCode->Put( offset );
	}
	else
	{
		SetError();
	}

	return pPertialSchedule;
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jle( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x7E, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jbe( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x76, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jge( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x7D, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jae( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x73, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jl( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x7C, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jb( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x72, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jg( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x7F, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_ja( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x77, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jne( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x75, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_je( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0x74, offset, op_size, isPertialSchedule );
}
CodeGenerator::PertialSchedule *CodeGenerator::op_jmp( long offset, int op_size, bool isPertialSchedule )
{
	return __jmp_op_format( (char)0xEB, offset, op_size, isPertialSchedule );
}
