#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>
#include <Class.h>
#include <Variable.h>

#include "../BasicCompiler_Common/common.h"
#include "../BasicCompiler_Common/DebugSection.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

#define MDLFILE_VER	0x70000003


void SetLpIndex_DebugFile(char *buffer,int *p,const Type &type){
	if(NATURAL_TYPE(type.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(type.GetBasicType())==DEF_STRUCT){
		lstrcpy(buffer+(*p),type.GetClass().GetName().c_str());
		(*p)+=lstrlen(buffer+(*p))+1;
	}
	else{
		*(LONG_PTR *)(buffer+(*p))=type.GetIndex();
		(*p)+=sizeof(LONG_PTR);
	}
}


void GetLpIndex_DebugFile(char *buffer,int *p,Type &type){
	if(NATURAL_TYPE(type.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(type.GetBasicType())==DEF_STRUCT){
		char szClassName[VN_SIZE];
		lstrcpy(szClassName,buffer+(*p));
		(*p)+=lstrlen(buffer+(*p))+1;

		type.SetClassPtr( compiler.GetMeta().GetClasses().Find(szClassName) );
	}
	else{
		type.SetIndex( *(LONG_PTR *)(buffer+(*p)) );
		(*p)+=sizeof(LONG_PTR);
	}
}



CDebugSection::~CDebugSection(){
	if(pobj_DBClass) DeleteDebugInfo();
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}
}
void CDebugSection::make(void){
	extern INCLUDEFILEINFO IncludeFileInfo;
	int i2,i3,BufferSize;

	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}

	i2=0;

	extern char *basbuf;
	BufferSize=lstrlen(basbuf)+65535;
	buffer=(char *)HeapAlloc(hHeap,0,BufferSize);

	//fobOpt@C̃o[W
	*(long *)(buffer+i2)=MDLFILE_VER;
	i2+=sizeof(long);

	//vbgtH[̃rbg
	*(long *)(buffer+i2)=PLATFORM;
	i2+=sizeof(long);

	//CN[h
	*(long *)(buffer+i2)=IncludeFileInfo.FilesNum;
	i2+=sizeof(long);
	for(i3=0;i3<IncludeFileInfo.FilesNum;i3++){
		lstrcpy(buffer+i2,IncludeFileInfo.ppFileNames[i3]);
		i2+=lstrlen(buffer+i2)+1;
	}
	buffer[i2++]=0;
	for(i3=0;;i3++){
		buffer[i2++]=(char)IncludeFileInfo.LineOfFile[i3];
		if(IncludeFileInfo.LineOfFile[i3]==-1) break;
	}

	//\[XR[h
	lstrcpy(buffer+i2,basbuf);
	i2+=lstrlen(buffer+i2)+1;


	////////////////////////
	// R[hƍsԍ̊֌W
	////////////////////////
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;

	//obt@Ȃꍇ͍Ċm
	if(MaxLineInfoNum*sizeof(LINEINFO)<32768) i3=32768;
	else i3=MaxLineInfoNum*sizeof(LINEINFO)+32768;
	if(BufferSize<i2+i3){
		BufferSize+=i3;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
	}

	*(long *)(buffer+i2)=MaxLineInfoNum;
	i2+=sizeof(long);
	memcpy(buffer+i2,pLineInfo,MaxLineInfoNum*sizeof(LINEINFO));
	i2+=MaxLineInfoNum*sizeof(LINEINFO);



	////////////////////////////////////////////
	// NXiÔ݁Bڍׂ͌ŕۑj
	////////////////////////////////////////////

	//Ce[^Zbg
	compiler.GetMeta().GetClasses().Iterator_Reset();

	//
	*(long *)(buffer+i2)=compiler.GetMeta().GetClasses().Iterator_GetMaxCount();
	i2+=sizeof(long);

	while(compiler.GetMeta().GetClasses().Iterator_HasNext()){
		CClass *pobj_c;
		pobj_c=compiler.GetMeta().GetClasses().Iterator_GetNext();

		//NX
		lstrcpy(buffer+i2,pobj_c->GetName().c_str());
		i2+=lstrlen(buffer+i2)+1;
	}



	//////////////////
	// TypeDef
	//////////////////
	*(long *)(buffer+i2)=(int)compiler.GetMeta().GetTypeDefs().size();
	i2+=sizeof(long);
	for(i3=0;i3<(int)compiler.GetMeta().GetTypeDefs().size();i3++){
		lstrcpy(buffer+i2,compiler.GetMeta().GetTypeDefs()[i3].GetName().c_str() );
		i2+=lstrlen(buffer+i2)+1;

		lstrcpy(buffer+i2,compiler.GetMeta().GetTypeDefs()[i3].GetBaseName().c_str() );
		i2+=lstrlen(buffer+i2)+1;

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}


	//O[oϐ
	*(long *)(buffer+i2)=(int)compiler.GetMeta().GetGlobalVars().size();
	i2+=sizeof(long);
	BOOST_FOREACH( Variable *pVar, compiler.GetMeta().GetGlobalVars() ){
		//ϐ
		lstrcpy(buffer+i2,pVar->GetName().c_str());
		i2+=lstrlen(buffer+i2)+1;

		//^
		*(long *)(buffer+i2)=pVar->GetType().GetBasicType();
		i2+=sizeof(long);

		//^̊g
		SetLpIndex_DebugFile(buffer,&i2,pVar->GetType());

		buffer[i2++] = pVar->IsRef() ? 1 : 0;

		buffer[i2++] = pVar->IsArray() ? 1 : 0;

		if(pVar->IsArray()){
			*(long *)(buffer+i2)=(int)pVar->GetSubscripts().size();
			i2+=sizeof(long);
			BOOST_FOREACH( int indexMax, pVar->GetSubscripts() )
			{
				*(long *)(buffer+i2)=indexMax;
				i2+=sizeof(long);
			}
		}

		//LVJXR[v
		*(long *)(buffer+i2)=pVar->GetScopeStartAddress();
		i2+=sizeof(long);
		*(long *)(buffer+i2)=pVar->GetScopeEndAddress();
		i2+=sizeof(long);
		*(long *)(buffer+i2)=pVar->GetScopeLevel();
		i2+=sizeof(long);

		//ʒu
		*(long *)(buffer+i2)=pVar->GetOffsetAddress();
		i2+=sizeof(long);

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	*(long *)(buffer+i2)=GlobalOpBufferSize;
	i2+=sizeof(long);

	//vV[W
	*(long *)(buffer+i2) = compiler.GetMeta().GetUserProcs().Iterator_GetMaxCount();
	i2+=sizeof(long);
	compiler.GetMeta().GetUserProcs().Iterator_Reset();
	while( compiler.GetMeta().GetUserProcs().Iterator_HasNext() )
	{
		UserProc *pUserProc = compiler.GetMeta().GetUserProcs().Iterator_GetNext();

		if(pUserProc->GetParentClassPtr()){
			lstrcpy(buffer+i2,pUserProc->GetParentClassPtr()->GetName().c_str());
			i2+=lstrlen(buffer+i2)+1;
		}
		else{
			lstrcpy(buffer+i2,"");
			i2+=lstrlen(buffer+i2)+1;
		}

		//ID
		*(long *)(buffer+i2)=pUserProc->GetId();
		i2+=sizeof(long);

		//֐
		lstrcpy(buffer+i2,pUserProc->GetName().c_str());
		i2+=lstrlen(buffer+i2)+1;

		*(long *)(buffer+i2)=pUserProc->GetBeginOpAddress();
		i2+=sizeof(long);
		*(long *)(buffer+i2)=pUserProc->GetEndOpAddress();
		i2+=sizeof(long);

		//[Jϐ
		*(long *)(buffer+i2)=(int)pUserProc->GetLocalVars().size();
		i2+=sizeof(long);

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}

		BOOST_FOREACH( Variable *pVar, pUserProc->GetLocalVars() ){
			lstrcpy(buffer+i2,pVar->GetName().c_str());
			i2+=lstrlen(buffer+i2)+1;

			//^
			*(long *)(buffer+i2)=pVar->GetType().GetBasicType();
			i2+=sizeof(long);

			//^̊g
			SetLpIndex_DebugFile(buffer,&i2,pVar->GetType());

			//Qƌ^p[^ǂ
			buffer[i2++] = pVar->IsRef() ? 1 : 0;

			//z񂩂ǂ
			buffer[i2++] = pVar->IsArray() ? 1 : 0;

			//zvf
			if(pVar->IsArray()){
				*(long *)(buffer+i2)=(int)pVar->GetSubscripts().size();
				i2+=sizeof(long);
				BOOST_FOREACH( int indexMax, pVar->GetSubscripts() )
				{
					*(long *)(buffer+i2)=indexMax;
					i2+=sizeof(long);
				}
			}

			//LVJXR[v
			*(long *)(buffer+i2)=pVar->GetScopeStartAddress();
			i2+=sizeof(long);
			*(long *)(buffer+i2)=pVar->GetScopeEndAddress();
			i2+=sizeof(long);
			*(long *)(buffer+i2)=pVar->GetScopeLevel();
			i2+=sizeof(long);

			//ʒu
			*(long *)(buffer+i2)=pVar->GetOffsetAddress();
			i2+=sizeof(long);




			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}
		}
	}



	///////////////////
	// NX
	///////////////////

	//Ce[^Zbg
	compiler.GetMeta().GetClasses().Iterator_Reset();

	while(compiler.GetMeta().GetClasses().Iterator_HasNext()){
		CClass *pobj_c;
		pobj_c=compiler.GetMeta().GetClasses().Iterator_GetNext();


		//NX
		lstrcpy(buffer+i2,pobj_c->GetName().c_str());
		i2+=lstrlen(buffer+i2)+1;

		//z֐̐
		*(long *)(buffer+i2)=pobj_c->GetVtblNum();
		i2+=sizeof(long);

		//ACg
		*(long *)(buffer+i2)=pobj_c->GetFixedAlignment();
		i2+=sizeof(long);

		// Io
		*(long *)(buffer+i2)=(int)pobj_c->GetDynamicMembers().size();
		i2+=sizeof(long);
		BOOST_FOREACH( CMember *member, pobj_c->GetDynamicMembers() ){
			// O
			lstrcpy(buffer+i2,member->GetName().c_str());
			i2+=lstrlen(buffer+i2)+1;

			// ^
			*(long *)(buffer+i2)=member->GetType().GetBasicType();
			i2+=sizeof(long);

			// ^̊g
			SetLpIndex_DebugFile(buffer,&i2,member->GetType());

			// ANZVreB
			*(Prototype::Accessibility *)(buffer+i2)=member->GetAccessibility();
			i2+=sizeof(Prototype::Accessibility);

			*(long *)(buffer+i2)=(int)member->GetSubscripts().size();
			i2+=sizeof(long);
			BOOST_FOREACH( int indexMax, member->GetSubscripts() )
			{
				*(long *)(buffer+i2)=indexMax;
				i2+=sizeof(long);
			}

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}
		}

		// I\bh
		*(long *)(buffer+i2)=(long)pobj_c->GetMethods().size();
		i2+=sizeof(long);
		BOOST_FOREACH( const CMethod *pMethod, pobj_c->GetMethods() ){
			*(Prototype::Accessibility *)(buffer+i2)=pMethod->GetAccessibility();
			i2+=sizeof(Prototype::Accessibility);
			if( pMethod->GetInheritsClassPtr() ){
				lstrcpy(buffer+i2,pMethod->GetInheritsClassPtr()->GetName().c_str());
				i2+=lstrlen(buffer+i2)+1;
			}
			else{
				lstrcpy(buffer+i2,"");
				i2+=lstrlen(buffer+i2)+1;
			}
			lstrcpy(buffer+i2,pMethod->GetUserProc().GetName().c_str());
			i2+=lstrlen(buffer+i2)+1;
		}

		//ÓIo
		*(long *)(buffer+i2)=(long)pobj_c->GetStaticMembers().size();
		i2+=sizeof(long);
		BOOST_FOREACH( CMember *member, pobj_c->GetStaticMembers() ){
			// O
			lstrcpy(buffer+i2,member->GetName().c_str());
			i2+=lstrlen(buffer+i2)+1;

			// ^
			*(long *)(buffer+i2)=member->GetType().GetBasicType();
			i2+=sizeof(long);

			// ^̊g
			SetLpIndex_DebugFile(buffer,&i2,member->GetType());

			// ANZVreB
			*(Prototype::Accessibility *)(buffer+i2)=member->GetAccessibility();
			i2+=sizeof(Prototype::Accessibility);

			// z
			*(long *)(buffer+i2)=(int)member->GetSubscripts().size();
			i2+=sizeof(long);
			BOOST_FOREACH( int indexMax, member->GetSubscripts() )
			{
				*(long *)(buffer+i2)=indexMax;
				i2+=sizeof(long);
			}

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}
		}

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	length=i2;
}

char *CDebugSection::MakeSingleStepCode(void){
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);

	memcpy(buffer,OpBuffer,SizeOf_CodeSection);

	int i2;
	for(i2=0;i2<MaxLineInfoNum;i2++){
		if(!(
			pLineInfo[i2].dwCodeType&CODETYPE_SYSTEMPROC||
			pLineInfo[i2].dwCodeType&CODETYPE_DEBUGPROC
			)){
			//int 3
			buffer[pLineInfo[i2].TopObp]=(char)0xCC;
		}
	}

	return buffer;
}
BOOL CDebugSection::__load(void){
	int i2,i3,i4,num;
	char temp2[MAX_PATH],*temp5;

	compiler.pCompilingClass = NULL;

	i2=0;

	//fobOpt@C̃o[W`FbN
	if(*(long *)(buffer+i2)<MDLFILE_VER){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	//vbgtH[̃rbg`FbN
	if(*(long *)(buffer+i2)!=PLATFORM){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	//CN[h
	IncludeFileInfo.FilesNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	IncludeFileInfo.ppFileNames=(char **)malloc(IncludeFileInfo.FilesNum*sizeof(char *));
	for(i3=0;i3<IncludeFileInfo.FilesNum;i3++){
		if(buffer[i2]=='\0') break;
		IncludeFileInfo.ppFileNames[i3]=(char *)malloc(lstrlen(buffer+i2)+1);
		lstrcpy(IncludeFileInfo.ppFileNames[i3],buffer+i2);
		i2+=lstrlen(buffer+i2)+1;
	}
	for(i2++,i3=0;;i2++,i3++){
		IncludeFileInfo.LineOfFile[i3]=(long)buffer[i2];
		if(IncludeFileInfo.LineOfFile[i3]==-1) break;
	}

	//\[XR[h
	i2++;
	source.SetBuffer( buffer + i2 );
	i2+=lstrlen(buffer+i2)+1;

	//R[hƍsԍ̊֌W
	MaxLineInfoNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	pLineInfo=(LINEINFO *)HeapAlloc(hHeap,0,MaxLineInfoNum*sizeof(LINEINFO)+1);
	memcpy(pLineInfo,buffer+i2,MaxLineInfoNum*sizeof(LINEINFO));
	i2+=MaxLineInfoNum*sizeof(LINEINFO);


	///////////////////////////////////////////
	// NXiÔ݁Bڍׂ͌Ŏ擾j
	///////////////////////////////////////////

	this->pobj_DBClass=new Classes();

	int iMaxClassCount;
	iMaxClassCount=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<iMaxClassCount;i3++){
		//NX
		// TODO: OԂ
		this->pobj_DBClass->Add(NamespaceScopes(),NamespaceScopesCollection(),buffer+i2,0);
		i2+=lstrlen(buffer+i2)+1;
	}

	compiler.GetMeta().SetClasses( this->pobj_DBClass );


	//////////////////
	// TypeDef
	//////////////////

	//
	compiler.GetMeta().GetTypeDefs().clear();

	//擾
	num=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<num;i3++){
		temp5=buffer+i2;
		i2+=lstrlen(buffer+i2)+1;

		// OԂɖΉ
		compiler.GetMeta().GetTypeDefs().push_back( TypeDef( NamespaceScopes(), temp5, buffer+i2, -1 ) );

		i2+=lstrlen(buffer+i2)+1;
	}

	//萔擾
	GetConstInfo();
	this->globalConsts = compiler.GetMeta().GetGlobalConsts();
	this->globalConstMacros = compiler.GetMeta().GetGlobalConstMacros();

	//O[oϐ
	compiler.GetMeta().GetGlobalVars().clear();
	int maxGlobalVars=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<maxGlobalVars;i3++){

		//ϐ
		char *name = buffer+i2;
		i2+=lstrlen(buffer+i2)+1;

		int basicType = *(long *)(buffer+i2);
		i2+=sizeof(long);

		Type type( basicType );
		GetLpIndex_DebugFile(buffer,&i2,type);

		bool isRef = (buffer[i2++]) ? true:false;

		bool isArray = (buffer[i2++]) ? true:false;

		Variable *pVar = new Variable( name, type, false, isRef, "" );

		if(isArray){
			Subscripts subscripts;
			int nSubScriptsNum = *(long *)(buffer+i2);
			i2+=sizeof(long);
			for( int i=0; i<nSubScriptsNum; i++ )
			{
				subscripts.push_back( *(long *)(buffer+i2) );
				i2+=sizeof(long);
			}

			pVar->SetArray( subscripts );
		}

		//LVJXR[v
		pVar->SetScopeStartAddress( *(long *)(buffer+i2) );
		i2+=sizeof(long);
		pVar->SetScopeEndAddress( *(long *)(buffer+i2) );
		i2+=sizeof(long);
		pVar->SetScopeLevel( *(long *)(buffer+i2) );
		i2+=sizeof(long);

		//ʒu
		pVar->SetOffsetAddress( *(long *)(buffer+i2) );
		i2+=sizeof(long);

		//ϐǉ
		compiler.GetMeta().GetGlobalVars().push_back( pVar );
	}

	//O[os̈̃TCY
	GlobalOpBufferSize=*(long *)(buffer+i2);
	i2+=sizeof(long);

	//vV[W
	userProcs.Clear();
	int subNum = *(long *)(buffer+i2);
	i2+=sizeof(long);
	for(int i6=0;i6<subNum;i6++){
		char szParentClassName[VN_SIZE];
		lstrcpy(szParentClassName,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		const CClass *pClass = NULL;
		if(szParentClassName[0]){
			pClass=compiler.GetMeta().GetClasses().Find(szParentClassName);
		}

		//ID
		int id=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//O
		char *name = buffer+i2;
		i2+=lstrlen(buffer+i2)+1;

		// IuWFNg𐶐
		// TODO: OԂ
		UserProc *pUserProc = new UserProc( NamespaceScopes(), NamespaceScopesCollection(), name, Procedure::Function, false, false, false, id );
		pUserProc->SetParentClass( pClass );

		pUserProc->SetBeginOpAddress( *(long *)(buffer+i2) );
		i2+=sizeof(long);
		pUserProc->SetEndOpAddress( *(long *)(buffer+i2) );
		i2+=sizeof(long);

		pUserProc->CompleteCompile();

		//[Jϐ
		pUserProc->GetLocalVars().clear();
		int maxLocalVar=*(long *)(buffer+i2);
		i2+=sizeof(long);
		for(i3=0;i3<maxLocalVar;i3++){
			//ϐ
			char *name = buffer+i2;
			i2+=lstrlen(buffer+i2)+1;

			int basicType = *(long *)(buffer+i2);
			i2+=sizeof(long);

			Type type( basicType );
			GetLpIndex_DebugFile(buffer,&i2,type);

			bool isRef = (buffer[i2++]) ? true:false;

			bool isArray = (buffer[i2++]) ? true:false;

			Variable *pVar = new Variable( name, type, false, isRef, "" );

			if(isArray){
				Subscripts subscripts;
				int nSubScriptsNum = *(long *)(buffer+i2);
				i2+=sizeof(long);
				for( int i=0; i<nSubScriptsNum; i++ )
				{
					subscripts.push_back( *(long *)(buffer+i2) );
					i2+=sizeof(long);
				}

				pVar->SetArray( subscripts );
			}

			//LVJXR[v
			pVar->SetScopeStartAddress( *(long *)(buffer+i2) );
			i2+=sizeof(long);
			pVar->SetScopeEndAddress( *(long *)(buffer+i2) );
			i2+=sizeof(long);
			pVar->SetScopeLevel( *(long *)(buffer+i2) );
			i2+=sizeof(long);

			//ʒu
			pVar->SetOffsetAddress( *(long *)(buffer+i2) );
			i2+=sizeof(long);

			//ϐǉ
			pUserProc->GetLocalVars().push_back( pVar );
		}


		/////////////////////////////////
		// i[ʒuvZpUserProcZbg
		/////////////////////////////////

		// nbVɒǉ
		if( !userProcs.Insert( pUserProc, -1 ) )
		{
			//return NULL;
		}
	}
	userProcs.Iterator_Init();

	//NX
	CClass *pobj_c;
	for(i3=0;i3<iMaxClassCount;i3++){
		//NX
		char szClassName[VN_SIZE];
		lstrcpy(szClassName,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		pobj_c =  const_cast<CClass *>( compiler.GetMeta().GetClasses().Find(szClassName) );

		//z֐̐
		pobj_c->SetVtblNum( *(long *)(buffer+i2) );
		i2+=sizeof(long);

		//ACg
		pobj_c->SetFixedAlignment( *(long *)(buffer+i2) );
		i2+=sizeof(long);

		// Io
		int nDynamicMember = *(long *)(buffer+i2);
		i2+=sizeof(long);
		for( i4=0; i4<nDynamicMember; i4++ ){
			// O
			string name = (char *)(buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			// ^
			Type type( *(long *)(buffer+i2) );
			i2+=sizeof(long);

			// ^̊g
			GetLpIndex_DebugFile(buffer,&i2,type);

			// ANZVreB
			Prototype::Accessibility accessibility = *(Prototype::Accessibility *)(buffer+i2);
			i2+=sizeof(Prototype::Accessibility);

			Subscripts subscripts;
			int nSubScriptsNum = *(long *)(buffer+i2);
			i2+=sizeof(long);
			for( int i=0; i<nSubScriptsNum; i++ )
			{
				subscripts.push_back( *(long *)(buffer+i2) );
				i2+=sizeof(long);
			}

			CMember *member=new CMember( accessibility, name, type, false, subscripts, "", "" );

			pobj_c->GetDynamicMembers().push_back( member );
		}

		// I\bh
		int nMethod = *(long *)(buffer+i2);
		i2+=sizeof(long);
		for( i4=0; i4<nMethod; i4++ ){

			Prototype::Accessibility accessibility=*(Prototype::Accessibility *)(buffer+i2);
			i2+=sizeof(Prototype::Accessibility);

			char szInherits[VN_SIZE];
			lstrcpy(szInherits,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			const CClass *pobj_InheritsClass = NULL;
			if(szInherits[0]){
				pobj_InheritsClass=compiler.GetMeta().GetClasses().Find(szInherits);
			}

			lstrcpy(temp2,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			const CClass *pobj_temp_c;
			pobj_temp_c=pobj_InheritsClass;
			if(pobj_temp_c==0) pobj_temp_c=pobj_c;

			UserProc *pUserProc = compiler.GetMeta().GetUserProcs().GetHashArrayElement( temp2 );
			while(pUserProc){
				if( pUserProc->GetName() == temp2 &&pUserProc->GetParentClassPtr()==pobj_temp_c)
				{
					break;
				}

				pUserProc=pUserProc->GetChainNext();
			}

			CMethod *pMethod = new DynamicMethod( pUserProc, accessibility, 0,0,false, pobj_InheritsClass);

			pobj_c->GetMethods().push_back( pMethod );
		}

		//ÓIo
		int nStaticMember = *(long *)(buffer+i2);
		i2+=sizeof(long);
		for( i4=0; i4<nStaticMember; i4++ ){
			// O
			string name = (char *)(buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			// ^
			Type type( *(long *)(buffer+i2) );
			i2+=sizeof(long);

			// ^̊g
			GetLpIndex_DebugFile(buffer,&i2,type);

			// ANZVreB
			Prototype::Accessibility accessibility = *(Prototype::Accessibility *)(buffer+i2);
			i2+=sizeof(Prototype::Accessibility);

			// z
			Subscripts subscripts;
			int nSubScriptsNum = *(long *)(buffer+i2);
			i2+=sizeof(long);
			for( int i=0; i<nSubScriptsNum; i++ )
			{
				subscripts.push_back( *(long *)(buffer+i2) );
				i2+=sizeof(long);
			}

			CMember *member=new CMember( accessibility, name, type, false, subscripts, "", "" );

			pobj_c->GetStaticMembers().push_back( member );
		}
	}

	HeapDefaultFree(buffer);
	buffer=0;




	compiler.GetMeta().GetUserProcs() = userProcs;
	pSub_DebugSys_EndProc=GetSubHash("_DebugSys_EndProc");


	SingleStepCodeBuffer=MakeSingleStepCode();


	/////////////////////////////
	// u[N|CgKp
	/////////////////////////////

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->IncludeFileInfo;

	//R[hƍsԍ̊֌W
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;
	MaxLineInfoNum=this->MaxLineInfoNum;
	pLineInfo=this->pLineInfo;

	BreakStepCodeBuffer=pobj_DBBreakPoint->update(OpBuffer,SizeOf_CodeSection);

	//vZXɃRs[
	extern HANDLE hDebugProcess;
	SIZE_T accessBytes;
	WriteProcessMemory(hDebugProcess,(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),
		BreakStepCodeBuffer,
		SizeOf_CodeSection,&accessBytes);


	return 1;
}

BOOL CDebugSection::load(HMODULE hModule){
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}


	extern HANDLE hDebugProcess;
	SIZE_T accessBytes;
	IMAGE_DOS_HEADER ImageDosHeader;
	ReadProcessMemory(hDebugProcess,hModule,&ImageDosHeader,sizeof(IMAGE_DOS_HEADER),&accessBytes);

	int pe_size;
#ifdef _AMD64_
	IMAGE_NT_HEADERS64 pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS64);
#else
	IMAGE_NT_HEADERS pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS);
#endif
	ReadProcessMemory(hDebugProcess,(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew),&pe_hdr,pe_size,&accessBytes);

	IMAGE_SECTION_HEADER *pSectionHdr;
	pSectionHdr=(IMAGE_SECTION_HEADER *)HeapAlloc(hHeap,0,pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER));
	ReadProcessMemory(hDebugProcess,
		(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew+pe_size),
		pSectionHdr,
		pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER),
		&accessBytes);

	int i;
	for(i=0;i<pe_hdr.FileHeader.NumberOfSections;i++){

		//C^uZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".data")==0){
			dwRVA_RWSection=pSectionHdr[i].VirtualAddress;
		}

		//R[hZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".text")==0){
			dwRVA_CodeSection=pSectionHdr[i].VirtualAddress;
			SizeOf_CodeSection=pSectionHdr[i].SizeOfRawData;
		}

		//fobOZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".debug")==0){
			length=pSectionHdr[i].Misc.VirtualSize;
			buffer=(char *)HeapAlloc(hHeap,0,length+1);

			ReadProcessMemory(hDebugProcess,
				(void *)(((ULONG_PTR)hModule)+pSectionHdr[i].VirtualAddress),
				buffer,
				length,
				&accessBytes);
			buffer[length]=0;
		}

	}
	HeapDefaultFree(pSectionHdr);

	if(!buffer) return 0;


	dwImageBase=(DWORD)(ULONG_PTR)hModule;



	if(OpBuffer) free(OpBuffer);
	OpBuffer=(char *)malloc(SizeOf_CodeSection);

	ReadProcessMemory(hDebugProcess,
		(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),OpBuffer,
		SizeOf_CodeSection,&accessBytes);


	return __load();
}

void CDebugSection::choice(void){
	//C[Wx[X
	extern DWORD ImageBase;
	ImageBase=this->dwImageBase;

	//C^uZNVRVA
	extern int MemPos_RWSection;
	MemPos_RWSection=this->dwRVA_RWSection;

	//R[hZNVRVAƃTCY
	extern int MemPos_CodeSection;
	extern int FileSize_CodeSection;
	MemPos_CodeSection=this->dwRVA_CodeSection;
	FileSize_CodeSection=this->SizeOf_CodeSection;

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->IncludeFileInfo;

	//\[XR[h
	Smoothie::Lexical::source = source;

	//R[hƍsԍ̊֌W
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;
	MaxLineInfoNum=this->MaxLineInfoNum;
	pLineInfo=this->pLineInfo;

	// NX
	compiler.GetMeta().SetClasses( this->pobj_DBClass );

	//萔擾
	compiler.GetMeta().GetGlobalConsts() = this->globalConsts;
	compiler.GetMeta().GetGlobalConstMacros() = this->globalConstMacros;

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	GlobalOpBufferSize=this->GlobalOpBufferSize;

	//vV[W
	compiler.GetMeta().GetUserProcs() = userProcs;

	extern const UserProc *pSub_DebugSys_EndProc;
	pSub_DebugSys_EndProc=this->pSub_DebugSys_EndProc;

	//lCeBuR[hobt@
	extern char *OpBuffer;
	OpBuffer=this->OpBuffer;
}

void CDebugSection::DeleteDebugInfo(void){
	int i2;

	//CN[h
	for(i2=0;i2<IncludeFileInfo.FilesNum;i2++)
	{
		free(IncludeFileInfo.ppFileNames[i2]);
	}
	free(IncludeFileInfo.ppFileNames);

	//NXɊւ郁
	delete this->pobj_DBClass;
	this->pobj_DBClass=0;

	//R[hƍsԍ̊֌W
	HeapDefaultFree(pLineInfo);

	//R[hobt@
	free(OpBuffer);
	OpBuffer=0;

	HeapDefaultFree(SingleStepCodeBuffer);
	SingleStepCodeBuffer=0;

	HeapDefaultFree(BreakStepCodeBuffer);
	BreakStepCodeBuffer=0;
}



CDBDebugSection::CDBDebugSection(){
	ppobj_ds=(CDebugSection **)HeapAlloc(hHeap,0,1);
	num=0;
}
CDBDebugSection::~CDBDebugSection(){
	int i;
	for(i=0;i<num;i++){
		delete ppobj_ds[i];
	}
	HeapDefaultFree(ppobj_ds);
}

BOOL CDBDebugSection::add(HMODULE hModule){
	CDebugSection *pobj_d;
	pobj_d=new CDebugSection();
	if(!pobj_d->load(hModule)){
		//fobO񂪑݂ȂƂ
		delete pobj_d;
		return 0;
	}

	ppobj_ds=(CDebugSection **)HeapReAlloc(hHeap,0,ppobj_ds,(num+1)*sizeof(CDebugSection *));
	ppobj_ds[num]=pobj_d;
	num++;

	return 1;
}

void CDBDebugSection::del(HMODULE hModule){
	int i;
	for(i=0;i<num;i++){
		if((HMODULE)(ULONG_PTR)ppobj_ds[i]->dwImageBase==hModule){
			delete ppobj_ds[i];

			num--;
			for(;i<num;i++){
				ppobj_ds[i]=ppobj_ds[i+1];
			}
			break;
		}
	}
}

void CDBDebugSection::choice(int index){
	pobj_now=ppobj_ds[index];
	pobj_now->choice();
}



CDBDebugSection *pobj_DBDebugSection;
