#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"


/////////////////////////
// X^bNt[Ǘ
/////////////////////////

CStackFrame::CStackFrame(){
	lowest_sp=0;
	now_sp=0;
	max_parm_size=0;
}
CStackFrame::~CStackFrame(){
	//IuWFNgjɕsȂ`FbNioOj
	error_check();
}
int CStackFrame::GetFrameSize( int localParamSize ){
	int answer_sp;

	answer_sp=lowest_sp-max_parm_size;

	if((localParamSize%0x10)){
		if((answer_sp%0x10)==0){
			//֐̃Gg|Cg128rbgECɍ킹邽
			return -(answer_sp-0x08);
		}
		return -(answer_sp-0x10);
	}

	if((answer_sp%0x10)==0){
		//֐̃Gg|Cg128rbgECɍ킹邽
		return -(answer_sp-0x10);
	}
	return -(answer_sp-0x08);
}
int CStackFrame::GetNowSp(){
	return now_sp;
}
void CStackFrame::mov_sp( int reg ){
	//mov reg,rsp
	compiler.codeGenerator.op_mov_RR( reg, REG_RSP );

	//add reg,now_sp
	compiler.codeGenerator.op_add_RV( reg, now_sp );

	//XPW[Zbg
	obp-=sizeof(long);
	add();
	obp+=sizeof(long);
}
int CStackFrame::push(int reg){
	now_sp-=sizeof(_int64);
	if(lowest_sp>now_sp) lowest_sp=now_sp;

	if(reg==REG_NON) return now_sp;

	//mov qword ptr[rsp+offset],reg
	compiler.codeGenerator.op_mov_MR(sizeof(_int64),reg,REG_RSP,now_sp,MOD_BASE_DISP32);

	//XPW[Zbg
	obp-=sizeof(long);
	add();
	obp+=sizeof(long);

	return now_sp;
}
void CStackFrame::push(int xmm_reg,int varSize){
	now_sp-=sizeof(_int64);
	if(lowest_sp>now_sp) lowest_sp=now_sp;

	if(varSize==sizeof(double)){
		//movlpd qword ptr[rsp+offset],xmm_reg
		compiler.codeGenerator.op_movlpd_MR(xmm_reg,REG_RSP,now_sp,MOD_BASE_DISP32);
	}
	if(varSize==sizeof(float)){
		//movss dword ptr[rsp+offset],xmm_reg
		compiler.codeGenerator.op_movss_MR( xmm_reg, REG_RSP, now_sp, MOD_BASE_DISP32 );
	}

	//XPW[Zbg
	obp-=sizeof(long);
	add();
	obp+=sizeof(long);
}
void CStackFrame::ref_offset_data( int reg, int sp_offset ){
	//mov reg,qword ptr[rsp+offset]     X^bNt[𗘗p
	compiler.codeGenerator.op_mov_RM(sizeof(_int64),reg,REG_RSP,sp_offset,MOD_BASE_DISP32);

	//XPW[Zbg
	obp-=sizeof(long);
	add();
	obp+=sizeof(long);
}
void CStackFrame::ref(int reg){
	ref_offset_data( reg, now_sp );
}
void CStackFrame::ref(int xmm_reg,int varSize){
	if(varSize==sizeof(double)){
		//movlpd xmm_reg,qword ptr[rsp+offset]
		compiler.codeGenerator.op_movlpd_RM(xmm_reg,REG_RSP,now_sp,MOD_BASE_DISP32);
	}
	if(varSize==sizeof(float)){
		//movss xmm_reg,dword ptr[rsp+offset]
		compiler.codeGenerator.op_movss_MR( xmm_reg, REG_RSP, now_sp, MOD_BASE_DISP32 );
	}

	//XPW[Zbg
	obp-=sizeof(long);
	add();
	obp+=sizeof(long);
}
void CStackFrame::pop(int reg){
	if(reg!=REG_NON) ref(reg);

	now_sp+=sizeof(_int64);
}
void CStackFrame::pop(int xmm_reg,int varSize){
	ref(xmm_reg,varSize);

	now_sp+=sizeof(_int64);
}
void CStackFrame::parameter_allocate(int size){
	if(max_parm_size<size) max_parm_size=size;
}
void CStackFrame::RunningSchedule( int stackFrameSize ){
	for(int i=0;i<num;i++){
		*((long *)(OpBuffer+pObpValues[i])) += stackFrameSize;
	}
}

void CStackFrame::error_check(){
	if(now_sp){
		SetError(300,NULL,cp);
	}
}

//X^bNt[ǗpIuWFNg|C^
CStackFrame *pobj_sf;
