#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"


void SetXmmReg_DoubleVariable(RELATIVE_VAR *pRelativeVar,int xmm_reg){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//movlpd xmm_reg,qword ptr[r11+offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x41;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x12;
			OpBuffer[obp++]=(char)(0x83 | REGISTER_OPERAND(xmm_reg)<<3);
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//movlpd xmm_reg,qword ptr[offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x12;
			OpBuffer[obp++]=(char)(0x04 | REGISTER_OPERAND(xmm_reg)<<3);
			OpBuffer[obp++]=(char)0x25;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		SetError(300,NULL,cp);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//movlpd xmm_reg,qword ptr[rsp+r11+offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x42;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x12;
			OpBuffer[obp++]=(char)(0x84 | REGISTER_OPERAND(xmm_reg)<<3);
			OpBuffer[obp++]=(char)0x1C;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//movlpd xmm_reg,qword ptr[rsp+offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x12;
			OpBuffer[obp++]=(char)(0x84 | REGISTER_OPERAND(xmm_reg)<<3);
			OpBuffer[obp++]=(char)0x24;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			OpBuffer[obp++]=(char)0x4C;
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x9C;
			OpBuffer[obp++]=(char)0x24;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//movlpd xmm_reg,qword ptr[r11]
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0x12;
		OpBuffer[obp++]=(char)(0x03 | REGISTER_OPERAND(xmm_reg)<<3);
	}
}
void SetXmmReg_SingleVariable(RELATIVE_VAR *pRelativeVar,int xmm_reg){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//movss xmm_reg,dword ptr[r11+offset]
			OpBuffer[obp++]=(char)0xF3;
			OpBuffer[obp++]=(char)0x41;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x10;
			OpBuffer[obp++]=(char)(0x83 | REGISTER_OPERAND(xmm_reg)<<3);
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//movss xmm_reg,dword ptr[offset]
			OpBuffer[obp++]=(char)0xF3;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x10;
			OpBuffer[obp++]=(char)(0x04 | REGISTER_OPERAND(xmm_reg)<<3);
			OpBuffer[obp++]=(char)0x25;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		SetError(300,NULL,cp);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//movss xmm_reg,dword ptr[rsp+r11+offset]
			OpBuffer[obp++]=(char)0xF3;
			OpBuffer[obp++]=(char)0x42;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x10;
			OpBuffer[obp++]=(char)(0x84 | REGISTER_OPERAND(xmm_reg)<<3);
			OpBuffer[obp++]=(char)0x1C;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//movss xmm_reg,dword ptr[rsp+offset]
			OpBuffer[obp++]=(char)0xF3;
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0x10;
			OpBuffer[obp++]=(char)(0x84 | REGISTER_OPERAND(xmm_reg)<<3);
			OpBuffer[obp++]=(char)0x24;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			OpBuffer[obp++]=(char)0x4C;
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x9C;
			OpBuffer[obp++]=(char)0x24;
			*((long *)(OpBuffer+obp))=(int)pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//movss xmm_reg,dword ptr[r11]
		OpBuffer[obp++]=(char)0xF3;
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0x10;
		OpBuffer[obp++]=(char)(0x03 | REGISTER_OPERAND(xmm_reg)<<3);
	}
}


void SetReg_WholeVariable(int type,RELATIVE_VAR *pRelativeVar,int reg){
	int varSize;

	varSize=GetTypeSize(type,-1);

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[r11+offset]
			compiler.codeGenerator.op_mov_RM(varSize,reg,REG_R11,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::GlobalVar );
		}
		else{
			//mov reg, ptr[offset]
			compiler.codeGenerator.op_mov_RM(varSize,reg,0,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[offset]
			compiler.codeGenerator.op_add_RM(sizeof(_int64),REG_R11,REG_NON,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}
		else{
			//mov r11,qword ptr[offset]
			compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_NON,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[rsp+r11+offset]
			compiler.codeGenerator.op_mov_RM_ex(varSize,reg,REG_RSP,REG_R11,(int)pRelativeVar->offset,USE_OFFSET, Schedule::LocalVar );
		}
		else{
			//mov reg, ptr[rsp+offset]
			compiler.codeGenerator.op_mov_RM(varSize,reg,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::LocalVar );
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			compiler.codeGenerator.op_add_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::LocalVar );
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::LocalVar );
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//mov reg, ptr[r11]
		compiler.codeGenerator.op_mov_RM(varSize,reg,REG_R11,0,MOD_BASE);
	}
}
