#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void AutoExtendToBigType( int *type_stack,int sp, int reg1, int reg2 ){
	/*
	int bigSize = GetTypeSize( type_stack[sp-1], -1 );
	if( bigSize != GetTypeSize( type_stack[sp-2], -1 ) ){
		int extReg = reg2;
		int oldType = type_stack[sp-2];
		if( bigSize < GetTypeSize( type_stack[sp-2], -1 ) ){
			bigSize = GetTypeSize( type_stack[sp-2], -1 );
			extReg = reg1;
			oldType = type_stack[sp-1];
		}
		if( bigSize == 2 ){
			ExtendTypeTo16( oldType, extReg );
		}
		else if( bigSize == 4 ){
			ExtendTypeTo32( oldType, extReg );
		}
		else{
			SetError();
		}
	}*/
}


BOOL Calc_Relation_PE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]<=value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//////////////
		// Z
		//////////////

		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		compiler.codeGenerator.op_mov_RV( REG_ECX, 1 );

		//test ah,41h
		compiler.codeGenerator.op_test_ah( (char)0x41 );

		//jne 5
		compiler.codeGenerator.PutOld(
			(char)0x75,
			(char)0x02
		);

		//xor ecx,ecxiecx0ɂj
		compiler.codeGenerator.op_zero_reg(REG_ECX);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////
		int TrueSchedule,
			FalseSchedule1,
			FalseSchedule2;

		// 1 <= 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		compiler.codeGenerator.op_cmp_RR( REG_EDX, REG_ECX );

		if(IsSignedType(type_stack[sp-2])==0&&IsSignedType(type_stack[sp-1])==0){
			//ȂZ

			//ja FalseSchedule1iUփWvj
			OpBuffer[obp++]=(char)0x77;
		}
		else{
			//艉Z

			//jg FalseSchedule1iUփWvj
			OpBuffer[obp++]=(char)0x7F;
		}
		FalseSchedule1=obp;
		obp++;

		if(IsSignedType(type_stack[sp-2])==0&&IsSignedType(type_stack[sp-1])==0){
			//ȂZ

			//jb TrueSchedulei^փWvj
			OpBuffer[obp++]=(char)0x72;
		}
		else{
			//艉Z

			//jl TrueSchedulei^փWvj
			OpBuffer[obp++]=(char)0x7C;
		}
		TrueSchedule=obp;
		obp++;

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		//ja FalseSchedule2iUփWvj
		OpBuffer[obp++]=(char)0x77;
		FalseSchedule2=obp;
		obp++;

		//TrueSchedulẽWv̐ݒ
		OpBuffer[TrueSchedule]=obp-(TrueSchedule+1);

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//jmp 2iZIʒuփWvj
		OpBuffer[obp++]=(char)0xEB;
		OpBuffer[obp++]=(char)0x02;

		//FalseSchedulẽWv̐ݒ
		OpBuffer[FalseSchedule1]=obp-(FalseSchedule1+1);
		OpBuffer[FalseSchedule2]=obp-(FalseSchedule2+1);

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		if(IsSignedType(type_stack[sp-2])==0&&IsSignedType(type_stack[sp-1])==0){
			//ȂZ

			//jbe 5imovщzj
			OpBuffer[obp++]=(char)0x76;
			OpBuffer[obp++]=(char)0x05;
		}
		else{
			//艉Z

			//jle 5imovщzj
			OpBuffer[obp++]=(char)0x7E;
			OpBuffer[obp++]=(char)0x05;
		}

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_QE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]>=value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//_Z
		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		OpBuffer[obp++]=(char)0xDE;
		OpBuffer[obp++]=(char)0xD9;

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//test ah,1
		compiler.codeGenerator.op_test_ah( (char)0x01 );

		//je 5
		OpBuffer[obp++]=(char)0x74;
		OpBuffer[obp++]=(char)0x05;

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////
		int TrueSchedule,
			FalseSchedule1,
			FalseSchedule2;

		// 1 >= 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xD1;

		if(IsSignedType(AnswerType)){
			//艉Z

			//jl FalseSchedule1iUփWvj
			OpBuffer[obp++]=(char)0x7C;
		}
		else{
			//ȂZ

			//jb FalseSchedule1iUփWvj
			OpBuffer[obp++]=(char)0x72;
		}
		FalseSchedule1=obp;
		obp++;

		if(IsSignedType(AnswerType)){
			//艉Z

			//jg TrueSchedulei^փWvj
			OpBuffer[obp++]=(char)0x7F;
		}
		else{
			//ȂZ

			//ja TrueSchedulei^փWvj
			OpBuffer[obp++]=(char)0x77;
		}
		TrueSchedule=obp;
		obp++;

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		//jb FalseSchedule2iUփWvj
		OpBuffer[obp++]=(char)0x72;
		FalseSchedule2=obp;
		obp++;

		//TrueSchedulẽWv̐ݒ
		OpBuffer[TrueSchedule]=obp-(TrueSchedule+1);

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//jmp 2iZIʒuփWvj
		OpBuffer[obp++]=(char)0xEB;
		OpBuffer[obp++]=(char)0x02;

		//FalseSchedulẽWv̐ݒ
		OpBuffer[FalseSchedule1]=obp-(FalseSchedule1+1);
		OpBuffer[FalseSchedule2]=obp-(FalseSchedule2+1);

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		if(IsSignedType(AnswerType)){
			//艉Z

			//jge 5imovщzjL
			OpBuffer[obp++]=(char)0x7D;
			OpBuffer[obp++]=(char)0x05;
		}
		else{
			//ȂZ

			//jae 5imovщzj
			OpBuffer[obp++]=(char)0x73;
			OpBuffer[obp++]=(char)0x05;
		}

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_P(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]<value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//////////////
		// Z
		//////////////

		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//test ah,01h
		compiler.codeGenerator.op_test_ah( (char)0x41 );

		//jne 5
		OpBuffer[obp++]=(char)0x75;
		OpBuffer[obp++]=(char)0x05;

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////
		int TrueSchedule1,
			TrueSchedule2,
			FalseSchedule;

		// 1 < 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xD1;

		if(IsSignedType(AnswerType)){
			//艉Z

			//jl TrueSchedule1i^փWvj
			OpBuffer[obp++]=(char)0x7C;
		}
		else{
			//ȂZ

			//jb TrueSchedule1i^փWvj
			OpBuffer[obp++]=(char)0x72;
		}
		TrueSchedule1=obp;
		obp++;

		if(IsSignedType(AnswerType)){
			//艉Z

			//jg FalseScheduleiUփWvj
			OpBuffer[obp++]=(char)0x7F;
		}
		else{
			//ȂZ

			//ja FalseScheduleiUփWvj
			OpBuffer[obp++]=(char)0x77;
		}
		FalseSchedule=obp;
		obp++;

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		//jb TrueSchedule2i^փWvj
		OpBuffer[obp++]=(char)0x72;
		TrueSchedule2=obp;
		obp++;

		//FalseSchedulẽWv̐ݒ
		OpBuffer[FalseSchedule]=obp-(FalseSchedule+1);

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//jmp 5iZIʒuփWvj
		OpBuffer[obp++]=(char)0xEB;
		OpBuffer[obp++]=(char)0x05;

		//TrueSchedulẽWv̐ݒ
		OpBuffer[TrueSchedule1]=obp-(TrueSchedule1+1);
		OpBuffer[TrueSchedule2]=obp-(TrueSchedule2+1);

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		///////////////////
		//32rbgZ
		///////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		if(IsSignedType(AnswerType)){
			//艉Z

			//jl 5imovщzj
			OpBuffer[obp++]=(char)0x7C;
			OpBuffer[obp++]=(char)0x05;
		}
		else{
			//ȂZ

			//jb 5imovщzj
			OpBuffer[obp++]=(char)0x72;
			OpBuffer[obp++]=(char)0x05;
		}

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_Q(int *type_stack,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]>value[sp-1]

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		//////////////
		// Z
		//////////////

		if(type_stack[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type_stack[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-1]==DEF_INT64||type_stack[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type_stack[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type_stack[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type_stack[sp-2]==DEF_INT64||type_stack[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//test ah,41
		compiler.codeGenerator.op_test_ah( (char)0x41 );

		//je 5
		OpBuffer[obp++]=(char)0x74;
		OpBuffer[obp++]=(char)0x05;

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(Is64Type(AnswerType)){
		////////////////////
		// 64rbgZ
		////////////////////
		int FalseSchedule,
			TrueSchedule1,
			TrueSchedule2;

		// 1 > 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type_stack,sp);

		//cmp edx,ecx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xD1;

		if(IsSignedType(AnswerType)){
			//L

			//jg TrueSchedule1i^փWvj
			OpBuffer[obp++]=(char)0x7F;
		}
		else{
			//

			//ja TrueSchedule1i^փWvj
			OpBuffer[obp++]=(char)0x77;
		}
		TrueSchedule1=obp;
		obp++;

		if(IsSignedType(AnswerType)){
			//L

			//jl FalseScheduleiUփWvj
			OpBuffer[obp++]=(char)0x7C;
		}
		else{
			//

			//jb FalseScheduleiUփWvj
			OpBuffer[obp++]=(char)0x72;
		}
		FalseSchedule=obp;
		obp++;

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		//ja TrueSchedule2i^փWvj
		OpBuffer[obp++]=(char)0x77;
		TrueSchedule2=obp;
		obp++;

		//FalseSchedulẽWv̐ݒ
		OpBuffer[FalseSchedule]=obp-(FalseSchedule+1);

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//jmp 5iZIʒuփWvj
		OpBuffer[obp++]=(char)0xEB;
		OpBuffer[obp++]=(char)0x05;

		//TrueSchedulẽWv̐ݒ
		OpBuffer[TrueSchedule1]=obp-(TrueSchedule1+1);
		OpBuffer[TrueSchedule2]=obp-(TrueSchedule2+1);

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type_stack, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		if(IsSignedType(AnswerType)){
			//jg 5imovщzj
			OpBuffer[obp++]=(char)0x7F;
			OpBuffer[obp++]=(char)0x05;
		}
		else{
			//ja 5imovщzj
			OpBuffer[obp++]=(char)0x77;
			OpBuffer[obp++]=(char)0x05;
		}

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type_stack[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_NotEqual(int *type,int *pStackPointer){
	//value[sp-2]<>value[sp-1]

	int sp;
	sp=*pStackPointer;

	if(type[sp-2]==DEF_DOUBLE||type[sp-2]==DEF_SINGLE||
		type[sp-1]==DEF_DOUBLE||type[sp-1]==DEF_SINGLE){
		//////////////
		// Z
		//////////////

		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//test ah,40
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//je 5
		OpBuffer[obp++]=(char)0x74;
		OpBuffer[obp++]=(char)0x05;

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD||
		type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////
		int TrueSchedule1,
			TrueSchedule2;

		// 1 <> 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type,sp);

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		//jnz TrueSchedule1i^փWvj
		OpBuffer[obp++]=(char)0x75;
		TrueSchedule1=obp;
		obp++;

		//cmp edx,ecx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xD1;

		//jnz TrueSchedule2i^փWvj
		OpBuffer[obp++]=(char)0x75;
		TrueSchedule2=obp;
		obp++;

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//jmp 5iZIʒuփWvj
		OpBuffer[obp++]=(char)0xEB;
		OpBuffer[obp++]=(char)0x05;

		//TrueSchedulẽWv̐ݒ
		OpBuffer[TrueSchedule1]=obp-(TrueSchedule1+1);
		OpBuffer[TrueSchedule2]=obp-(TrueSchedule2+1);

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//xor eax,ebx
		OpBuffer[obp++]=(char)0x33;
		OpBuffer[obp++]=(char)0xC3;

		//jz 5imovщzj
		OpBuffer[obp++]=(char)0x74;
		OpBuffer[obp++]=(char)0x05;

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Relation_Equal(int *type,int *pStackPointer){
	//value[sp-2]=value[sp-1]

	int sp;
	sp=*pStackPointer;

	if(type[sp-2]==DEF_DOUBLE||type[sp-2]==DEF_SINGLE||
		type[sp-1]==DEF_DOUBLE||type[sp-1]==DEF_SINGLE){
		//////////////
		// Z
		//////////////

		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{	//LongADWord
			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		//fcompp
		compiler.codeGenerator.op_fcompp();

		//fnstsw ax
		compiler.codeGenerator.op_fnstsw_ax();

		//mov ecx,1
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//test ah,40
		compiler.codeGenerator.op_test_ah( (char)0x40 );

		//jne 5
		OpBuffer[obp++]=(char)0x75;
		OpBuffer[obp++]=(char)0x05;

		//mov ecx,0
		OpBuffer[obp++]=(char)0xB9;
		*((long *)(OpBuffer+obp))=0;
		obp+=sizeof(long);

		//mov dword ptr[esp],ecx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_ECX, REG_ESP, 0, MOD_BASE );
	}
	else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD||
		type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////
		int FalseSchedule1,
			FalseSchedule2;

		// 1 == 2

		//1 edx:eax
		//2 ecx:ebx
		GetStackData_ToRegister(type,sp);

		//cmp eax,ebx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xC3;

		//jnz FalseSchedule1iUփWvj
		OpBuffer[obp++]=(char)0x75;
		FalseSchedule1=obp;
		obp++;

		//cmp edx,ecx
		OpBuffer[obp++]=(char)0x3B;
		OpBuffer[obp++]=(char)0xD1;

		//jnz FalseSchedule2iUփWvj
		OpBuffer[obp++]=(char)0x75;
		FalseSchedule2=obp;
		obp++;

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//jmp 2iZIʒuփWvj
		OpBuffer[obp++]=(char)0xEB;
		OpBuffer[obp++]=(char)0x02;

		//FalseSchedulẽWv̐ݒ
		OpBuffer[FalseSchedule1]=obp-(FalseSchedule1+1);
		OpBuffer[FalseSchedule2]=obp-(FalseSchedule2+1);

		//xor eax,eaxieax0ɂj
		compiler.codeGenerator.op_zero_reg(REG_EAX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		// ǂ炩̃TCYȂꍇ͎g
		AutoExtendToBigType( type, sp, REG_EAX, REG_EBX );

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//xor eax,ebx
		OpBuffer[obp++]=(char)0x33;
		OpBuffer[obp++]=(char)0xC3;

		//jz 4ixorjmpщzj
		OpBuffer[obp++]=(char)0x74;
		OpBuffer[obp++]=(char)0x04;

		//xor eax,eax
		OpBuffer[obp++]=(char)0x33;
		OpBuffer[obp++]=(char)0xC0;

		//jmp 5
		OpBuffer[obp++]=(char)0xEB;
		OpBuffer[obp++]=(char)0x05;

		//mov eax,1
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=1;
		obp+=sizeof(long);

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type[sp-1]=DEF_BOOLEAN;

	*pStackPointer=sp;
	return 1;
}
