#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void ExtendStackTo32(int type);
void ExtendStackTo64(int type){
	if(Is64Type(type)) return;

	//32rbgɊg
	ExtendStackTo32(type);

	//64rbgɊg
	if(IsSignedType(type)){
		//

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//cdq
		compiler.codeGenerator.op_cdq();

		//push edx
		compiler.codeGenerator.op_push(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else{
		//Ȃ

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}
void ExtendStackTo32(int type){
	if(GetTypeSize(type,-1)==sizeof(long)) return;

	if(Is64Type(type)){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if(type==DEF_INTEGER || (Smoothie::IsUnicode()&&type==DEF_CHAR)){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//movsx eax,ax
		compiler.codeGenerator.op_movsx_R32R16( REG_EAX );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if(type==DEF_WORD){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//and eax,0000FFFFh
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=0x0000FFFF;
		obp+=sizeof(long);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if(type==DEF_SBYTE || (Smoothie::IsUnicode()==false&&type==DEF_CHAR)){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//movsx eax,al
		compiler.codeGenerator.op_movsx_R32R8( REG_EAX );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if(type==DEF_BYTE||type==DEF_BOOLEAN){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//and eax,000000FFh
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=0x000000FF;
		obp+=sizeof(long);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}
void ExtendStackTo16(int type){
	if(type==DEF_SBYTE || (Smoothie::IsUnicode()==false&&type==DEF_CHAR)){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//movsx eax,al
		compiler.codeGenerator.op_movsx_R32R8( REG_EAX );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
	else if(type==DEF_BYTE){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//and eax,000000FFh
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=0x000000FF;
		obp+=sizeof(long);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}
void ExtendStackTo8(int type){
	if(Is64Type(type)){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);
	}
}


void ChangeTypeToWhole(int OldType,int NewType){
	if(OldType==DEF_DOUBLE){
		if(Is64Type(NewType)){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );
		}
		else{
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
	}
	else if(OldType==DEF_SINGLE){
		if(Is64Type(NewType)){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//sub esp,4
			compiler.codeGenerator.op_sub_esp(4);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );
		}
		else{
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
	}
	else{
		//琮֕ϊ

		if(Is64Type(NewType)){
			ExtendStackTo64(OldType);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(long)){
			ExtendStackTo32(OldType);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(short)){
			ExtendStackTo16(OldType);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(char)){
			ExtendStackTo8(OldType);
		}
	}
}
