#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void GetStackData_ToRegister(int *type,int sp){
	/*NumOpe|[h̃X^bN~ςɂ鉉Zei2̃f[^j
		WX^edx:eaxAecx:ebxɎ擾*/

	if(type[sp-1]==DEF_DOUBLE){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//fistp qword ptr[esp]
		compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop ecx
		compiler.codeGenerator.op_pop(REG_ECX);
	}
	else if(type[sp-1]==DEF_SINGLE){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//fistp qword ptr[esp]
		compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop ecx
		compiler.codeGenerator.op_pop(REG_ECX);
	}
	else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop ecx
		compiler.codeGenerator.op_pop(REG_ECX);
	}
	else{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		if(IsSignedType(type[sp-1])){
			//g
			//edx:eax  eax
				
			//cdq
			compiler.codeGenerator.op_cdq();
		}
		else{
			//rbgg
			//edx:eax  eax

			//xor edx,edx
			compiler.codeGenerator.op_zero_reg(REG_EDX);
		}

		//mov ebx,eax
		compiler.codeGenerator.op_mov_RR( REG_EBX, REG_EAX );

		//mov ecx,edx
		compiler.codeGenerator.op_mov_RR( REG_ECX, REG_EDX );
	}

	//164rbgɑΉ
	if(type[sp-2]==DEF_DOUBLE){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//fistp qword ptr[esp]
		compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);
	}
	else if(type[sp-2]==DEF_SINGLE){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//fistp qword ptr[esp]
		compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);
	}
	else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);
	}
	else{
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		if(IsSignedType(type[sp-2])){
			//g
			//edx:eax  eax
				
			//cdq
			compiler.codeGenerator.op_cdq();
		}
		else{
			//rbgg
			//edx:eax  eax

			//xor edx,edx
			compiler.codeGenerator.op_zero_reg(REG_EDX);
		}
	}
}

void FormatStackData_To64bit(int *type,int sp){
	//NumOpe|[h̃X^bN~ςɂ鉉Zei2̃f[^j64rbg^ɂ

	GetStackData_ToRegister(type,sp);

	//push ecx
	compiler.codeGenerator.op_push(REG_ECX);

	//push ebx
	compiler.codeGenerator.op_push(REG_EBX);

	//push edx
	compiler.codeGenerator.op_push(REG_EDX);

	//push eax
	compiler.codeGenerator.op_push(REG_EAX);
}

BOOL CalcTwoTerm_Arithmetic(int idCalc,int *type,LONG_PTR *index_stack,int *pStackPointer){
	/*	value[sp-2] = value[sp-2] + value[sp-1]
		value[sp-2] = value[sp-2] - value[sp-1]
		value[sp-2] = value[sp-2] * value[sp-1]		*/

	int sp;
	sp=*pStackPointer;

	int AnswerType;
	AnswerType=NeutralizationType(type[sp-2],index_stack[sp-2],type[sp-1],index_stack[sp-1]);

	if(type[sp-2]==DEF_DOUBLE||type[sp-2]==DEF_SINGLE||
		type[sp-1]==DEF_DOUBLE||type[sp-1]==DEF_SINGLE){
		/////////////
		// Z
		/////////////

		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//64rbgl

			//fild qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

			//add esp,8
			compiler.codeGenerator.op_add_esp(8);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
		}
		else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//64rbgl
			compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);
		}
		else{
			//̑^

			//fild dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
		}

		if(GetTypeSize(type[sp-2],-1)==sizeof(_int64)){
			if(AnswerType==DEF_SINGLE){
				//add esp,4
				compiler.codeGenerator.op_add_esp(4);
			}
		}
		else{
			if(AnswerType==DEF_DOUBLE){
				//sub esp,4
				compiler.codeGenerator.op_sub_esp(4);
			}
		}

		if(idCalc==CALC_ADDITION){
			//faddp st(1),st
			compiler.codeGenerator.PutOld(
				(char)0xDE,
				(char)0xC1
			);
		}
		else if(idCalc==CALC_SUBTRACTION){
			//fsubrp st(1),st
			compiler.codeGenerator.PutOld(
				(char)0xDE,
				(char)0xE1
			);
		}
		else if(idCalc==CALC_PRODUCT){
			//fmulp st(1),st
			compiler.codeGenerator.PutOld(
				(char)0xDE,
				(char)0xC9
			);
		}

		if(AnswerType==DEF_DOUBLE){
			//fstp qword ptr[esp]
			compiler.codeGenerator.op_fstp_basereg( DEF_DOUBLE, REG_ESP );
		}
		else{
			//fstp dword ptr[esp]
			compiler.codeGenerator.op_fstp_basereg( DEF_SINGLE, REG_ESP );
		}
	}
	else if(Is64Type(type[sp-2])||Is64Type(type[sp-1])){
		//////////////////////
		// 64rbgZ
		//////////////////////

		if(idCalc==CALC_PRODUCT){
			if(!((type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD)&&
				(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD))){
				//2̍̂ǂ炩64rbgłȂƂ
				FormatStackData_To64bit(type,sp);
			}

			//call _allmul
			extern const UserProc *pSub_allmul;
			compiler.codeGenerator.op_call(pSub_allmul);

			//push edx
			compiler.codeGenerator.op_push(REG_EDX);

			//push eax
			compiler.codeGenerator.op_push(REG_EAX);
		}
		else{
			if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
				//264rbgl̂Ƃ

				//pop ebx
				compiler.codeGenerator.op_pop(REG_EBX);

				//pop ecx
				compiler.codeGenerator.op_pop(REG_ECX);
			}
			else{
				//2̑l̂Ƃ

				//pop eax
				compiler.codeGenerator.op_pop(REG_EAX);

				if(IsSignedType(type[sp-1])){
					//g
					//edx:eax  eax
					
					//cdq
					compiler.codeGenerator.op_cdq();
				}
				else{
					//rbgg
					//edx:eax  eax

					//xor edx,edx
					compiler.codeGenerator.op_zero_reg(REG_EDX);
				}

				//mov ebx,eax
				compiler.codeGenerator.op_mov_RR( REG_EBX, REG_EAX );

				//mov ecx,edx
				compiler.codeGenerator.op_mov_RR( REG_ECX, REG_EDX );
			}

			if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
				//164rbgl̂Ƃ

				if(idCalc==CALC_ADDITION){
					//add dword ptr[esp],ebx
					compiler.codeGenerator.PutOld(
						(char)0x01,
						(char)0x1C,
						(char)0x24
					);

					//adc dword ptr[esp+sizeof(long)],ecx
					compiler.codeGenerator.PutOld(
						(char)0x11,
						(char)0x4C,
						(char)0x24,
						(char)0x04
					);
				}
				else if(idCalc==CALC_SUBTRACTION){
					//sub dword ptr[esp],ebx
					compiler.codeGenerator.PutOld(
						(char)0x29,
						(char)0x1C,
						(char)0x24
					);

					//sbb dword ptr[esp+sizeof(long)],ecx
					compiler.codeGenerator.PutOld(
						(char)0x19,
						(char)0x4C,
						(char)0x24,
						(char)0x04
					);
				}
			}
			else{
				//1̑l̂Ƃ

				//pop eax
				compiler.codeGenerator.op_pop(REG_EAX);

				if(IsSignedType(type[sp-2])){
					//g
					//edx:eax  eax

					//cdq
					compiler.codeGenerator.op_cdq();
				}
				else{
					//rbgg
					//edx:eax  eax

					//xor edx,edx
					compiler.codeGenerator.op_zero_reg(REG_EDX);
				}

				if(idCalc==CALC_ADDITION){
					//add ebx,eax
					compiler.codeGenerator.op_add_RR( REG_EBX, REG_EAX );

					//adc ecx,edx
					compiler.codeGenerator.op_adc_RR( REG_ECX, REG_EDX );
				}
				else if(idCalc==CALC_SUBTRACTION){
					//sub ebx,eax
					compiler.codeGenerator.op_sub_RR( REG_EBX, REG_EAX );

					//sbb ecx,edx
					compiler.codeGenerator.op_sub_RR( REG_ECX, REG_EDX );
				}

				//push ecx
				compiler.codeGenerator.op_push(REG_ECX);

				//push ebx
				compiler.codeGenerator.op_push(REG_EBX);
			}
		}
	}
	else{
		//////////////////////////
		//32rbgȉ̐Z
		//////////////////////////

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		if(idCalc==CALC_ADDITION){
			//add eax,ebx
			compiler.codeGenerator.op_add_RR( REG_EAX, REG_EBX );
		}
		else if(idCalc==CALC_SUBTRACTION){
			//sub eax,ebx
			compiler.codeGenerator.op_sub_RR( REG_EAX, REG_EBX );
		}
		else if(idCalc==CALC_PRODUCT){
			//imul eax,ebxi64rbgZł͂Ȃ̂ŁAlȂj
			compiler.codeGenerator.op_imul_RR( REG_EAX, REG_EBX );
		}

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );
	}

	sp--;
	type[sp-1]=AnswerType;

	*pStackPointer=sp;

	return 1;
}

BOOL Calc_Mod(int *type,int *pStackPointer){
	//value[sp-2]%=value[sp-1]
	//]Z

	int sp;
	sp=*pStackPointer;

	if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD||
		type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
		////////////////
		// 64rbgZ
		////////////////

		//264rbgɑΉ
		FormatStackData_To64bit(type,sp);

		if(IsSignedType(type[sp-2])==0&&IsSignedType(type[sp-1])==0){
			//ȂZ

			//call _aullrem
			extern const UserProc *pSub_aullrem;
			compiler.codeGenerator.op_call(pSub_aullrem);
		}
		else{
			//艉Z

			//call _allrem
			extern const UserProc *pSub_allrem;
			compiler.codeGenerator.op_call(pSub_allrem);
		}

		//push edx
		compiler.codeGenerator.op_push(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		sp--;
		if(type[sp-1]==DEF_QWORD&&type[sp]==DEF_QWORD) type[sp-1]=DEF_QWORD;
		else type[sp-1]=DEF_INT64;
	}
	else{
		////////////////
		// 32rbgZ
		////////////////

		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		if(type[sp-2]==DEF_DWORD&&type[sp-1]==DEF_DWORD){
			//xor edx,edx
			compiler.codeGenerator.op_zero_reg(REG_EDX);

			//div ebx (eax=eax/ebx...edx)
			compiler.codeGenerator.op_div_R( REG_EBX );
		}
		else{
			//cdq
			compiler.codeGenerator.op_cdq();

			//idiv ebx (eax=eax/ebx...edx)
			compiler.codeGenerator.op_idiv_R( REG_EBX );
		}

		//mov dword ptr[esp],edx
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EDX, REG_ESP, 0, MOD_BASE );

		sp--;
		type[sp-1]=DEF_LONG;
	}

	*pStackPointer=sp;

	return 1;
}

BOOL Calc_Divide(int *type,int *pStackPointer,int BaseType){
	//value[sp-2]/=value[sp-1];
	//Z

	int sp;
	sp=*pStackPointer;

	///////////////////////
	// _Ẑ
	///////////////////////

	int AnswerType;
	if(type[sp-2]==DEF_DOUBLE||type[sp-1]==DEF_DOUBLE||BaseType==DEF_DOUBLE) AnswerType=DEF_DOUBLE;
	else AnswerType=DEF_SINGLE;

	if(type[sp-1]==DEF_DOUBLE){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//add esp,8
		compiler.codeGenerator.op_add_esp(8);
	}
	else if(type[sp-1]==DEF_SINGLE){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);
	}
	else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		//64rbgl

		//fild qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

		//add esp,8
		compiler.codeGenerator.op_add_esp(8);
	}
	else if(type[sp-1]==DEF_DWORD){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		//fild qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

		//add esp,8
		compiler.codeGenerator.op_add_esp(8);
	}
	else{
		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);
	}

	if(type[sp-2]==DEF_DOUBLE){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);
	}
	else if(type[sp-2]==DEF_SINGLE){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);
	}
	else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
		//64rbgl

		//fild qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);
	}
	else if(type[sp-2]==DEF_DWORD){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//push 0
		compiler.codeGenerator.op_push_V(0);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		//fild qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);
	}
	else{	//Long
		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);
	}
                                                            //ODWord
	if(GetTypeSize(type[sp-2],-1)==sizeof(_int64)||type[sp-2]==DEF_DWORD){
		if(AnswerType==DEF_SINGLE){
			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
	}
	else{
		if(AnswerType==DEF_DOUBLE){
			//sub esp,4
			compiler.codeGenerator.op_sub_esp(4);
		}
	}

	//fdivrp st(1),st
	compiler.codeGenerator.PutOld(
		(char)0xDE,
		(char)0xF1
	);

	sp--;
	if(AnswerType==DEF_DOUBLE){
		//fstp qword ptr[esp]
		compiler.codeGenerator.op_fstp_basereg( DEF_DOUBLE, REG_ESP );

		type[sp-1]=DEF_DOUBLE;
	}
	else{
		//fstp dword ptr[esp]
		compiler.codeGenerator.op_fstp_basereg( DEF_SINGLE, REG_ESP );

		type[sp-1]=DEF_SINGLE;
	}

	*pStackPointer=sp;

	return 1;
}

BOOL Calc_IntDivide(int *type,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2]/=value[sp-1]
	//Zij

	int sp;
	sp=*pStackPointer;

	if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD||
		type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
		////////////////
		// 64rbgZ
		////////////////

		//2̍64rbgɑΉ
		FormatStackData_To64bit(type,sp);

		if(IsSignedType(type[sp-2])==0&&IsSignedType(type[sp-1])==0){
			//ȂZ

			//call _aulldiv
			extern const UserProc *pSub_aulldiv;
			compiler.codeGenerator.op_call(pSub_aulldiv);
		}
		else{
			//艉Z

			//call _alldiv
			extern const UserProc *pSub_alldiv;
			compiler.codeGenerator.op_call(pSub_alldiv);
		}

		//push edx
		compiler.codeGenerator.op_push(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		sp--;
		if(type[sp-1]==DEF_QWORD&&type[sp]==DEF_QWORD) type[sp-1]=DEF_QWORD;
		else type[sp-1]=DEF_INT64;
	}
	else{
		////////////////
		// 32rbgZ
		////////////////

		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}

		//pop ebx
		compiler.codeGenerator.op_pop(REG_EBX);

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		if((type[sp-2]==DEF_DWORD&&type[sp-1]==DEF_DWORD)||
			(IS_POSITIVE_LITERAL(index_stack[sp-2])&&type[sp-1]==DEF_DWORD)||
			(type[sp-2]==DEF_DWORD&&IS_POSITIVE_LITERAL(index_stack[sp-1]))){
			//xor edx,edx
			compiler.codeGenerator.op_zero_reg(REG_EDX);

			//div ebx (eax=eax/ebx...edx)
			compiler.codeGenerator.op_div_R( REG_EBX );
		}
		else{
			//cdq
			compiler.codeGenerator.op_cdq();

			//idiv ebx (eax=eax/ebx...edx)
			compiler.codeGenerator.op_idiv_R( REG_EBX );
		}

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );

		sp--;

		//ȊǑ^ƂLong^ɂ
		if(!IsWholeNumberType(type[sp-1])) type[sp-1]=DEF_LONG;
	}

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_MinusMark(int *type,int sp){
	//value[sp-1]=-value[sp-1]
	//]

	if(type[sp-1]==DEF_DOUBLE){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//push -1
		compiler.codeGenerator.op_push_V(-1);

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);

		//fmulp st(1),st
		compiler.codeGenerator.PutOld(
			(char)0xDE,
			(char)0xC9
		);

		//fstp qword ptr[esp]
		compiler.codeGenerator.op_fstp_basereg( DEF_DOUBLE, REG_ESP );
	}
	else if(type[sp-1]==DEF_SINGLE){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//push -1
		compiler.codeGenerator.op_push_V(-1);

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);

		//fmulp st(1),st
		compiler.codeGenerator.PutOld(
			(char)0xDE,
			(char)0xC9
		);

		//fstp dword ptr[esp]
		compiler.codeGenerator.op_fstp_basereg( DEF_SINGLE, REG_ESP );
	}
	else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//neg eax
		compiler.codeGenerator.op_neg( REG_EAX );

		//pop edx
		compiler.codeGenerator.op_pop(REG_EDX);

		//adc edx,0
		compiler.codeGenerator.op_adc_RV8(REG_EDX,0);

		//neg edx
		compiler.codeGenerator.op_neg( REG_EDX );

		//push edx
		compiler.codeGenerator.op_push(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		type[sp-1]=DEF_INT64;	//QWordInt64
	}
	else if(IsWholeNumberType(type[sp-1])){
		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//imul eax,-1
		compiler.codeGenerator.op_imul_RV8( REG_EAX, -1 );

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		type[sp-1]=GetSignedType(type[sp-1]);
	}

	return 1;
}

BOOL Calc_Power(int *type,int *pStackPointer){
	//ׂiẐ݁j

	int sp;
	sp=*pStackPointer;

	if(type[sp-1]==DEF_DOUBLE){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

		//add esp,8
		compiler.codeGenerator.op_add_esp(8);
	}
	else if(type[sp-1]==DEF_SINGLE){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);
	}
	else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		//64rbgl

		//fild qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);

		//add esp,8
		compiler.codeGenerator.op_add_esp(8);
	}
	else{
		//32rbgl

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//add esp,4
		compiler.codeGenerator.op_add_esp(4);
	}

	if(type[sp-2]==DEF_DOUBLE){
		//fld qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);
	}
	else if(type[sp-2]==DEF_SINGLE){
		//fld dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);
	}
	else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
		//64rbgl

		//fild qword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_INT64);
	}
	else{
		//32rbgl

		//fild dword ptr[esp]
		compiler.codeGenerator.op_fld_ptr_esp(DEF_LONG);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);
	}

	//sub esp,8
	compiler.codeGenerator.op_sub_esp(8);

	//fstp qword ptr[esp]
	compiler.codeGenerator.op_fstp_basereg( DEF_DOUBLE, REG_ESP );

	//fstp qword ptr[esp+8]
	compiler.codeGenerator.op_fstp_base_offset(DEF_DOUBLE,REG_ESP,8);

	//call pow
	extern const UserProc *pSub_pow;
	compiler.codeGenerator.op_call(pSub_pow);

	//sub esp,8
	compiler.codeGenerator.op_sub_esp(8);

	//fstp qword ptr[esp]
	compiler.codeGenerator.op_fstp_basereg( DEF_DOUBLE, REG_ESP );

	sp--;
	type[sp-1]=DEF_DOUBLE;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Cast(int *type,LONG_PTR *index_stack,int *pStackPointer){
	//LXg

	int sp;
	sp=*pStackPointer;

	int CastType;
	CastType=type[sp-1];
	if((CastType&FLAG_CAST)==0){
		SetError(47,NULL,cp);
		return 0;
	}
	CastType=CastType&(~FLAG_CAST);

	if(IsPtrType(CastType)){
		ChangeTypeToLong(type[sp-2]);
	}
	else if(IsRealNumberType(CastType)){
		if(CastType==DEF_DOUBLE) ChangeTypeToDouble(type[sp-2]);
		else if(CastType==DEF_SINGLE) ChangeTypeToSingle(type[sp-2]);
	}
	else ChangeTypeToWhole(type[sp-2],CastType);

	type[sp-2]=CastType;
	index_stack[sp-2]=index_stack[sp-1];

	sp--;

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_SHL(int *type,int *pStackPointer){
	//rbgVtg
	//value[sp-2]=value[sp-2]<<value[sp-1]

	int sp;
	sp=*pStackPointer;

	if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
		////////////////
		// 64rbgZ
		////////////////

		//2ڂ32rbgƂėp
		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}

		//164rbgɑΉ
		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop edx
			compiler.codeGenerator.op_pop(REG_EDX);
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//sub esp,4
			compiler.codeGenerator.op_sub_esp(4);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop edx
			compiler.codeGenerator.op_pop(REG_EDX);
		}
		else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop edx
			compiler.codeGenerator.op_pop(REG_EDX);
		}
		else{
			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			if(IsSignedType(type[sp-2])){
				//g
				//edx:eax  eax
					
				//cdq
				compiler.codeGenerator.op_cdq();
			}
			else{
				//rbgg
				//edx:eax  eax

				//xor edx,edx
				compiler.codeGenerator.op_zero_reg(REG_EDX);
			}
		}

		//call _allshl
		extern const UserProc *pSub_allshl;
		compiler.codeGenerator.op_call(pSub_allshl);

		//push edx
		compiler.codeGenerator.op_push(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		sp--;
	}
	else{
		////////////////
		// 32rbgZ
		////////////////

		//2ڂ32rbgƂėp
		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		//shl eax,cl
		compiler.codeGenerator.PutOld(
			(char)0xD3,
			(char)0xE0
		);

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );

		sp--;

		//32rbg^ɂ
		if(IsSignedType(type[sp-1])) type[sp-1]=DEF_LONG;
		else type[sp-1]=DEF_DWORD;
	}

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_SHR(int *type,int *pStackPointer){
	//ErbgVtg
	//value[sp-2]=value[sp-2]>>value[sp-1]

	int sp;
	sp=*pStackPointer;

	if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
		////////////////
		// 64rbgZ
		////////////////

		//2ڂ32rbgƂėp
		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}

		//164rbgɑΉ
		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop edx
			compiler.codeGenerator.op_pop(REG_EDX);
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//sub esp,4
			compiler.codeGenerator.op_sub_esp(4);

			//fistp qword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(_int64) );

			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop edx
			compiler.codeGenerator.op_pop(REG_EDX);
		}
		else if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			//pop edx
			compiler.codeGenerator.op_pop(REG_EDX);
		}
		else{
			//pop eax
			compiler.codeGenerator.op_pop(REG_EAX);

			if(IsSignedType(type[sp-2])){
				//g
				//edx:eax  eax

				//cdq
				compiler.codeGenerator.op_cdq();
			}
			else{
				//rbgg
				//edx:eax  eax

				//xor edx,edx
				compiler.codeGenerator.op_zero_reg(REG_EDX);
			}
		}

		if(type[sp-2]==DEF_QWORD){
			//ȂZ

			//call _aullshr
			extern const UserProc *pSub_aullshr;
			compiler.codeGenerator.op_call(pSub_aullshr);
		}
		else{
			//艉Z

			//call _allshr
			extern const UserProc *pSub_allshr;
			compiler.codeGenerator.op_call(pSub_allshr);
		}

		//push edx
		compiler.codeGenerator.op_push(REG_EDX);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		sp--;
	}
	else{
		////////////////
		// 32rbgZ
		////////////////

		//2ڂ32rbgƂėp
		if(type[sp-1]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );

			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}
		else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);
		}
		else{
			//pop ecx
			compiler.codeGenerator.op_pop(REG_ECX);
		}

		if(type[sp-2]==DEF_DOUBLE){
			//fld qword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			compiler.codeGenerator.op_add_esp(4);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}
		else if(type[sp-2]==DEF_SINGLE){
			//fld dword ptr[esp]
			compiler.codeGenerator.op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			compiler.codeGenerator.op_fistp_ptr_esp( sizeof(long) );
		}

		//pop eax
		compiler.codeGenerator.op_pop(REG_EAX);

		//sub esp,4
		compiler.codeGenerator.op_sub_esp(4);

		if(type[sp-2]==DEF_DWORD){
			//shr eax,cl
			compiler.codeGenerator.PutOld(
				(char)0xD3,
				(char)0xE8
			);
		}
		else{
			//sar eax,cl
			compiler.codeGenerator.PutOld(
				(char)0xD3,
				(char)0xF8
			);
		}

		//mov dword ptr[esp],eax
		compiler.codeGenerator.op_mov_MR( sizeof(long), REG_EAX, REG_ESP, 0, MOD_BASE );

		sp--;

		//ȊǑ^ƂLong^ɂ
		if(!IsWholeNumberType(type[sp-1])) type[sp-1]=DEF_LONG;
	}

	*pStackPointer=sp;
	return 1;
}
