#pragma once

#include <vector>
#include <string>

#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <BoostSerializationSupport.h>
#include <Namespace.h>

using namespace std;

class Symbol
{
	NamespaceScopes namespaceScopes;
	string name;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		//trace_for_serialize( "serializing(load) - Symbol" );

		ar & BOOST_SERIALIZATION_NVP( namespaceScopes );

		std::string _name;
		ar & BOOST_SERIALIZATION_NVP( _name );
		this->name = Operator_NaturalStringToCalcMarkString( _name );
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		//trace_for_serialize( "serializing(save) - Symbol" );

		ar & BOOST_SERIALIZATION_NVP( namespaceScopes );

		std::string _name = Operator_CalcMarkStringToNaturalString( name );
		ar & BOOST_SERIALIZATION_NVP( _name );
	}

public:
	Symbol( const NamespaceScopes &namespaceScopes, const string &name )
		: namespaceScopes( namespaceScopes )
		, name( name )
	{
	}
	Symbol( const char *fullName );
	Symbol( const string &fullName );
	Symbol( const Symbol &symbol )
		: namespaceScopes( symbol.namespaceScopes )
		, name( symbol.name )
	{
	}
	Symbol()
	{
	}

	virtual const NamespaceScopes &GetNamespaceScopes() const
	{
		return namespaceScopes;
	}
	const string &GetName() const
	{
		return name;
	}

	// V{r
	bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;
	bool IsEqualSymbol( const Symbol &symbol ) const;
	bool IsEqualSymbol( const char *fullName ) const;
	bool IsEqualSymbol( const string &fullName ) const
	{
		return IsEqualSymbol( fullName.c_str() );
	}
};
