#pragma once

#include <vector>
#include <string>
#include <fstream>
#include <sstream>

#include <boost/serialization/serialization.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/serialization/export.hpp>

namespace Jenga{
namespace Common{

using namespace std;

template<class T_xml_schema> class BoostSerializationSupport{
	virtual const char *RootTagName() const = 0;

	void echo( const char *msg ) const;

public:
	bool ReadXml( istream& ifs, bool isShowExceptionMessage = true );
	bool WriteXml( ostream& ofs, bool isShowExceptionMessage = true ) const;
	bool ReadXml( const string &xmlFilePath, bool isShowExceptionMessage = true );
	bool WriteXml( const string &xmlFilePath, bool isShowExceptionMessage = true ) const;

	bool ReadBinaly( const string &filePath, bool isShowExceptionMessage = true );
	bool WriteBinaly( const string &filePath, bool isShowExceptionMessage = true ) const;

	bool ReadText( const string &filePath, bool isShowExceptionMessage = true );
	bool WriteText( const string &filePath, bool isShowExceptionMessage = true ) const;

	bool ReadXmlFromString( const string &xmlBuffer );
};


}}
