#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

int hash_default(const char *name){
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_HASH;
	}

	return key;
}

DllProc *GetDeclareHash(const char *fullName){
	char namespaceStr[VN_SIZE];		//IuWFNgϐ
	char simpleName[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( fullName, namespaceStr, simpleName );

	///////////////////////////
	// O[o֐
	///////////////////////////

	// nbVl擾
	DllProc *pDllProc = compiler.GetMeta().GetDllProcs().GetHashArrayElement( simpleName );
	while(pDllProc){
		if( pDllProc->IsEqualSymbol( fullName ) ){
			return pDllProc;
		}

		pDllProc=pDllProc->GetChainNext();
	}

	return NULL;
}

void GetOverloadSubHash( const char *lpszName, std::vector<const UserProc *> &subs ){
	char name[VN_SIZE];

	if(lpszName[0]=='.'){
		GetWithName(name);
		lstrcat(name,lpszName);
	}
	else lstrcpy(name,lpszName);

	char ObjName[VN_SIZE];		//IuWFNgϐ
	char NestMember[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( name, ObjName, NestMember );

	if(isObjectMember){
		//IuWFNg̃o֐̏ꍇ

		bool isStatic = false;
		const CClass *pobj_c = NULL;
		if(lstrcmpi(ObjName,"Super")==0){
			//NXo֐NX̌Ăяo
			pobj_c=compiler.pCompilingClass;
		}
		else{
			//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
			Type type;
			if( GetVarType(ObjName,type,0) ){
				pobj_c = &type.GetClass();
			}
			else{
				pobj_c=compiler.GetMeta().GetClasses().Find(ObjName);
				if( pobj_c ){
					isStatic = true;
				}
			}
		}

		if( pobj_c && pobj_c != (CClass *)-1 ){
			if( isStatic ){
				// ÓI\bh
				pobj_c->GetStaticMethods().Enum( NestMember, subs );
			}
			else{
				//I\bh
				pobj_c->GetMethods().Enum( NestMember, subs );
			}
			return;
		}
	}


	if(compiler.pCompilingClass){
		//g̃IuWFNg̃o֐

		// ÓI\bh
		compiler.pCompilingClass->GetStaticMethods().Enum( name, subs );

		// I\bh
		compiler.pCompilingClass->GetMethods().Enum( name, subs );
	}


	// O[o֐
	compiler.GetMeta().GetUserProcs().EnumGlobalProcs( NestMember, name, subs );
}

//I[o[[hĂȂ֐擾î̃RpC\[XR[hƂ̌݊ێj
const UserProc *GetSubHash(const char *lpszName,BOOL bError){
	std::vector<const UserProc *> subs;
	GetOverloadSubHash(lpszName,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		if(bError){
			SetError(3,lpszName,cp);
		}
		return 0;
	}

	//ȏ̊֐݂Ƃ͓G[ifobOpj
	if(subs.size() > 1){
		if(bError) SetError(300,NULL,cp);
	}

	const UserProc *pUserProc = subs[0];

	return pUserProc;
}
const UserProc *GetMethodHash(const char *ObjectName,const char *MethodName,const char *Parameter,BOOL bError){
	char temporary[VN_SIZE];
	sprintf(temporary,"%s.%s",ObjectName,MethodName);

	std::vector<const UserProc *> subs;
	GetOverloadSubHash(temporary,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		return 0;
	}

	//I[o[[h
	const UserProc *pUserProc = OverloadSolutionWithStrParam(temporary,subs,Parameter,ObjectName);

	return pUserProc;
}

const UserProc *GetClassMethod( const char *className, const char *methodName ){
	const CClass *pClass = compiler.GetMeta().GetClasses().Find( className );
	if( pClass ){
		vector<const UserProc *> userProcs;
		pClass->GetMethods().Enum( methodName, userProcs );
		if( userProcs.size() == 1 ){
			return userProcs[0];
		}
	}

	char temporary[VN_SIZE];
	sprintf( temporary, "%s.%s", className, methodName );
	SetError(3, temporary, -1 );

	return NULL;
}
