#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Compiler.h>
#include <Procedure.h>
#include <NamespaceSupporter.h>

#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

int GetCallProcName(char *buffer,char *name){
	int i2,i3,IsStr=0;

	for(i2=0;;i2++){
		if(buffer[i2]=='\"') IsStr^=1;
		if(IsDBCSLeadByte(buffer[i2])){
			name[i2]=buffer[i2];
			i2++;
			name[i2]=buffer[i2];
			continue;
		}
		if(buffer[i2]=='['&&IsStr==0){
			i3=GetStringInBracket(name+i2,buffer+i2);
			i2+=i3-1;
			continue;
		}
		if(buffer[i2]=='('&&IsStr==0){
			name[i2]=0;
			break;
		}
		if(buffer[i2]=='='&&IsStr==0){
			name[i2]=0;
			break;
		}

		name[i2]=buffer[i2];
		if(buffer[i2]=='\0') break;
	}
	return i2;
}

int GetProc(char *name,void **ppInfo){

	//[U[`֐
	*ppInfo=(void *)GetSubHash(name);
	if(*ppInfo) return PROC_DEFAULT;

	//DLL֐
	*ppInfo=(void *)GetDeclareHash(name);
	if(*ppInfo) return PROC_DLL;

	//RpCߍ݌^
	*ppInfo=(void *)(_int64)GetFunctionFromName(name);
	if(*ppInfo) return PROC_BUILTIN;

	//֐|C^
	Type type;
	if( !GetVarType( name, type, false ) ){
		return 0;
	}
	if( type.IsProcPtr() ){
		return PROC_PTR;
	}

	return 0;
}

void SplitObjectName(const char *name,char *ObjectName,int *pRefType){
	int i4;
	for(i4=lstrlen(name)-1;i4>=0;i4--){
		if(name[i4]=='.'||(name[i4]==1&&name[i4+1]==ESC_PSMEM))
			break;
	}
	if(i4==-1) ObjectName[0]=0;
	else{
		//Qƃ^Cv𔻕
		if(name[i4]=='.') *pRefType=DEF_OBJECT;
		else *pRefType=DEF_PTR_OBJECT;

		if(i4==0) GetWithName(ObjectName);
		else{
			memcpy(ObjectName,name,i4);
			ObjectName[i4]=0;
		}
	}
}

bool CallProc( int kind, const void *pProc, const char *fullCallName, const char *lpszParms, Type &resultType, bool isCallOn ){

	//GetSubHashŃG[񎦂sꂽꍇ
	if(pProc==(Procedure *)-1){
		return false;
	}

	if(kind==PROC_DEFAULT){
		/////////////////////
		// [U[`֐
		/////////////////////

		const UserProc *pUserProc = (const UserProc *)pProc;

		//IuWFNg擾
		char ObjectName[VN_SIZE];
		int RefType;
		SplitObjectName(fullCallName,ObjectName,&RefType);


		////////////////////////
		// I[o[[h
		////////////////////////

		std::vector<const UserProc *> subs;
		GetOverloadSubHash(fullCallName,subs);
		if(subs.size()){
			//I[o[[h
			pUserProc=OverloadSolutionWithStrParam(fullCallName,subs,lpszParms,ObjectName);

			if(!pUserProc){
				return false;
			}
		}

		resultType = pUserProc->ReturnType();

		if( isCallOn ){
			if( !Opcode_CallProc(lpszParms,pUserProc,0,ObjectName,RefType) ){
				return false;
			}
		}
	}
	else if(kind==PROC_DLL){
		/////////////////////////
		// DLL֐
		/////////////////////////
		DllProc *pDllProc = (DllProc *)pProc;

		resultType = pDllProc->ReturnType();

		if( isCallOn ){
			if( !Opcode_CallDllProc(lpszParms,pDllProc) ){
				return false;
			}
		}
	}
	else if(kind==PROC_BUILTIN){
		/////////////////////////
		// gݍ݊֐
		/////////////////////////
		int FuncId = (int)(_int64)pProc;

		if( !Opcode_CallFunc( lpszParms, FuncId, resultType, isCallOn ) ){
			return false;
		}
	}
	else if(kind==PROC_PTR){
		/////////////////
		// ֐|C^
		/////////////////

		Type type;
		GetVarType(fullCallName,type,false);

		ProcPointer *pProcPtr = compiler.GetMeta().GetProcPointers()[type.GetIndex()];
		resultType = pProcPtr->ReturnType();

		if( isCallOn ){
			if( !Opcode_CallProcPtr(fullCallName,lpszParms,pProcPtr) ){
				return false;
			}
		}
	}
	else{
		return false;
	}

	return true;
}
bool CallPropertyMethod( const char *variable, const char *rightSide, Type &resultType){
	//vpeBp̃\bhĂяo

	//zvf擾
	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(variable,VarName,ArrayElements);

	//IuWFNg擾
	char ObjectName[VN_SIZE];
	int RefType;
	SplitObjectName(VarName,ObjectName,&RefType);

	//I[o[[hp̊֐Xg쐬
	std::vector<const UserProc *> subs;
	GetOverloadSubHash(VarName,subs);
	if(subs.size()==0){
		return false;
	}

	//p[^𐮔
	char *Parameter;
	Parameter=(char *)HeapAlloc(hHeap,0,lstrlen(ArrayElements)+lstrlen(rightSide)+32);
	lstrcpy(Parameter,ArrayElements);
	if(rightSide){
		if(Parameter[0]&&rightSide[0]) lstrcat(Parameter,",");
		lstrcat(Parameter,rightSide);
	}

	//I[o[[h
	const UserProc *pUserProc = OverloadSolutionWithStrParam(VarName,subs,Parameter,ObjectName);

	if(pUserProc){
		//Ăяo
		Opcode_CallProc(Parameter,pUserProc,0,ObjectName,RefType);

		resultType = pUserProc->ReturnType();
	}

	HeapDefaultFree(Parameter);

	return true;
}

bool GetReturnTypeOfPropertyMethod( const char *variable, const char *rightSide, Type &resultType ){
	//vpeBp̃\bhĂяo

	//zvf擾
	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(variable,VarName,ArrayElements);

	//IuWFNg擾
	char ObjectName[VN_SIZE];
	int RefType;
	SplitObjectName(VarName,ObjectName,&RefType);

	//I[o[[hp̊֐Xg쐬
	std::vector<const UserProc *> subs;
	GetOverloadSubHash(VarName,subs);
	if(subs.size()==0){
		return 0;
	}

	//p[^𐮔
	char *Parameter;
	Parameter=(char *)HeapAlloc(hHeap,0,lstrlen(ArrayElements)+lstrlen(rightSide)+32);
	lstrcpy(Parameter,ArrayElements);
	if(rightSide){
		if(Parameter[0]&&rightSide[0]) lstrcat(Parameter,",");
		lstrcat(Parameter,rightSide);
	}

	//I[o[[h
	const UserProc *pUserProc = OverloadSolutionWithStrParam(VarName,subs,Parameter,ObjectName);

	if(pUserProc){
		resultType = pUserProc->ReturnType();
	}

	return 1;
}

//CfNTigetterj̖߂l擾
bool GetReturnTypeOfIndexerGetterProc( const CClass &objClass, Type &resultType ){
	vector<const UserProc *> subs;
	objClass.GetMethods().Enum( CALC_ARRAY_GET, subs );
	if( subs.size() == 0 ){
		return false;
	}

	resultType = subs[0]->ReturnType();

	return true;
}

void CollectProcedures( const BasicSource &source, UserProcs &userProcs, DllProcs &dllProcs )
{
	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[8192];

	//Tu[`i[U[`j
	userProcs.Clear();

	//DeclareiDLL֐j
	dllProcs.Clear();

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection &importedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	importedNamespaces.clear();

	i=-1;
	while(1){
		i++;

		if(source[i]==1&&(source[i+1]==ESC_CLASS||source[i+1]==ESC_INTERFACE)){
			/*	Class ` End Class
				Interface ` End Interface
				щz			*/
			i3=GetEndXXXCommand(source[i+1]);
			for(i+=2,i2=0;;i++,i2++){
				if(source[i]=='\0') break;
				if(source[i]==1&&source[i+1]==(char)i3){
					i++;
					break;
				}
			}
			if(source[i]=='\0') break;
			continue;
		}

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				SetError(64,temporary,cp );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			importedNamespaces.clear();
			continue;
		}

		if(source[i]==1&&source[i+1]==ESC_DECLARE){
			for(i+=2,i2=0;;i2++,i++){
				if(source[i]=='\n'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
				if(source[i]=='\0') break;
			}
			dllProcs.Add(namespaceScopes,temporary,i);

			continue;
		}
		if(source[i]==1&&(source[i+1]==ESC_SUB||source[i+1]==ESC_FUNCTION||source[i+1]==ESC_MACRO)){
			char statementChar = source[i+1];

			for(i2=0;;i2++,i++){
				if(IsCommandDelimitation(source[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
				if(source[i]=='\0') break;
			}
			userProcs.Add(namespaceScopes, importedNamespaces, temporary,i,false,NULL,false);

			/*	Sub ` End Sub
				Function ` End Function
				Macro ` End Macro
				щz			*/
			char endStatementChar = GetEndXXXCommand( statementChar );
			for(i2=0;;i++,i2++){
				if( source[i] == '\0' ) break;
				if( source[i] == 1 && source[i+1] == endStatementChar ){
					i++;
					break;
				}
			}
			if(source[i]=='\0') break;
			continue;
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(source[i])) break;
		}
		if(source[i]=='\0') break;
	}

	////////////
	// ֐
	////////////
	namespaceScopes.clear();
	importedNamespaces.clear();

	sprintf(temporary,"%c%c_allrem()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_aullrem()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_allmul()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_alldiv()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_aulldiv()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_allshl()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_allshr()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_aullshr()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);

	sprintf(temporary,"%c%c_System_InitStaticLocalVariables()",1,ESC_SUB);
	userProcs.Add( namespaceScopes, importedNamespaces, temporary,0,false,NULL,false);
}
void Delete_di(DllProc *pDllProc){
	if(pDllProc->pNextData) Delete_di(pDllProc->pNextData);

	delete pDllProc;
}

bool IsNeedProcCompile(){
	compiler.GetMeta().GetUserProcs().Iterator_Reset();
	while( compiler.GetMeta().GetUserProcs().Iterator_HasNext() )
	{
		UserProc *pUserProc = compiler.GetMeta().GetUserProcs().Iterator_GetNext();
		if( pUserProc->IsUsing() && pUserProc->IsCompiled() == false ){
			return true;
		}
	}
	return false;
}
