#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void PushReturnValue(int type){
	//֐̖߂lX^bNփvbV
	//̏ł́AesiAedi͎gps

	if(type==DEF_OBJECT || type==DEF_STRUCT){
		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_DOUBLE){
		//sub esp,8
		op_sub_esp(8);

		//fstp qword ptr[esp]
		OpBuffer[obp++]=(char)0xDD;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_SINGLE){
		//sub esp,4
		op_sub_esp(4);

		//fstp dword ptr[esp]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//push edx
		op_push(REG_EDX);

		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_LONG){
		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_INTEGER || (Smoothie::IsUnicode()&&type==DEF_CHAR)){
		//movsx ebx,ax
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBF;
		OpBuffer[obp++]=(char)0xD8;

		//push ebx
		op_push(REG_EBX);
	}
	else if(type==DEF_SBYTE || (Smoothie::IsUnicode()==false&&type==DEF_CHAR)){
		//movsx ebx,al
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBE;
		OpBuffer[obp++]=(char)0xD8;

		//push ebx
		op_push(REG_EBX);
	}
	else if(type==DEF_DWORD||type==DEF_WORD||type==DEF_BYTE||type==DEF_BOOLEAN||
		IsPtrType(type)){
		//push eax
		op_push(REG_EAX);
	}
	else{
		SetError();
	}
}

void NewStringObject( const char *str ){
	///////////////////////////////////////////////////////
	// lpszTextStringIuWFNg𐶐A
	// IuWFNg|C^regɊi[
	///////////////////////////////////////////////////////

	char *parameter = (char *)malloc( lstrlen( str ) + 32 );
	sprintf( parameter, "\"%s\"%c%c*Char", str, 1, ESC_AS );
	SetStringQuotes( parameter );

	Operator_New( *compiler.GetMeta().GetClasses().GetStringClassPtr(), "", parameter, Type( DEF_OBJECT, *compiler.GetMeta().GetClasses().GetStringClassPtr() ) );

	free( parameter );
}

void ExtendRegToBigType( int reg, int bigBasicType, int baseBasicType ){
	if( reg != REG_EAX ){
		SetError();
	}
	switch( Type::GetBasicSize( bigBasicType ) ){
		case sizeof(_int64):
			ExtendTypeTo64(baseBasicType);
			break;
		case sizeof(long):
			ExtendTypeTo32(baseBasicType,reg);
			break;
		case sizeof(short):
			ExtendTypeTo16(baseBasicType,reg);
			break;
	}
}



bool VarToReg( RELATIVE_VAR &relativeVar, const Type &baseType, Type &resultType ){
	const int useReg = REG_EAX;

	//傫Ȍ^ւ̈Öق̕ϊ
	int bigType = AutoBigCast(baseType.GetBasicType(),resultType.GetBasicType());

	if(resultType.GetBasicType()&FLAG_PTR){
		//z|C^
		resultType.SetBasicType( GetPtrType(resultType.GetBasicType()^FLAG_PTR) );

		SetVarPtrToReg(useReg, &relativeVar);
	}
	else if( resultType.IsStruct() ){
		//\̃|C^eax֊i[i\̂͒l^j
		SetVarPtrToReg(useReg, &relativeVar);
	}
	else if( resultType.IsReal() ){
		// 
		SetReg_RealVariable( resultType.GetBasicType(), &relativeVar );
	}
	else if( resultType.IsWhole() || resultType.IsObject()){
		//^
		SetReg_WholeVariable(resultType.GetBasicType(),&relativeVar,useReg);
	}
	else if( resultType.IsStruct() ){
		//\̃|C^UseReg֊i[i\̂͒l^j
		SetVarPtrToReg(useReg,&relativeVar);
	}
	else{
		return false;
	}

	if( resultType.GetBasicType() != bigType ){
		// 傫Ȍ^֕ϊꂽꍇ
		// WX^̒lLXg
		ExtendRegToBigType( useReg, bigType, resultType.GetBasicType() );

		resultType.SetBasicType( bigType );
	}

	return true;
}
bool TermMemberOpe( const CClass &objClass, const Type &baseType, Type &resultType, const char *termFull, const char *termLeft, const char *member ){
	const int useReg = REG_EAX;

	if( GetMemberType( objClass, member, resultType, 0, false ) ){
		// oƂ

		//IuWFNg|C^ecxɃRs[
		op_mov_RR( REG_ECX, useReg );

		RELATIVE_VAR relativeVar;
		relativeVar.dwKind=VAR_DIRECTMEM;

		if( !_member_offset(
			true,	//G[\
			false,	//ǂݍݐp
			objClass,
			member,&relativeVar,resultType,0)){
				return false;
		}

		if( !VarToReg( relativeVar, baseType, resultType ) ){
			SetError(11,termFull,cp);
		}

		return true;
	}


	///////////////////////////////////////////////////////////////////
	// I\bh
	///////////////////////////////////////////////////////////////////
	vector<const UserProc *> userProcs;

	char methodName[VN_SIZE], lpPtrOffset[VN_SIZE], parameter[VN_SIZE], dummy[1];
	ReferenceKind refType;
	lstrcpy( methodName, member );
	GetVarFormatString(methodName,parameter,lpPtrOffset,dummy,refType);

	objClass.GetMethods().Enum( methodName, userProcs );
	if(userProcs.size()){
		//I[o[[h
		const UserProc *pUserProc = OverloadSolutionWithStrParam(termFull,userProcs,parameter,termLeft);

		if( pUserProc ){

			resultType = pUserProc->ReturnType();

			{
				//IuWFNg|C^X^bNɓĂ
				//push reg
				op_push( useReg );

				if( !Opcode_CallProc(parameter,pUserProc,PROCFLAG_NEW,termLeft,0 ) ){

					return false;
				}

				op_pop();

				/////////////////////
				// ߂l̏
				/////////////////////

				//傫Ȍ^ւ̈Öق̕ϊ
				int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

				if( resultType.GetBasicType() != bigType ){
					// 傫Ȍ^֕ϊꂽꍇ
					// WX^̒lLXg
					ExtendRegToBigType( REG_EAX, bigType, resultType.GetBasicType() );

					resultType.SetBasicType( bigType );
				}

				//SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);
			}
			
			return true;
		}
	}

	return false;
}
bool TermOpe( const char *term, const Type &baseType, Type &resultType, bool &isLiteral, BOOL *pbUseHeap, bool isWantObject, bool *pIsClassName, bool isProcedureCallOnly ){
	char parameter[VN_SIZE];

	// With
	char termFull[VN_SIZE];
	if(term[0]=='.'){
		GetWithName(termFull);
		lstrcat(termFull,term);
	}
	else lstrcpy(termFull,term);

	char termLeft[VN_SIZE];
	lstrcpy(termLeft,termFull);

	// p[X
	char member[VN_SIZE];
	ReferenceKind refType;
	if( SplitMemberName( termFull, termLeft, member, refType ) ){
		///////////////////////////////////////////////////////////////////
		// IuWFNgƃoɕłƂ
		// termLeft.member
		///////////////////////////////////////////////////////////////////

		isLiteral = false;

		// IuWFNǧ^擾
		bool isClassName = false;
		Type leftType;
		if( GetTermType( termLeft, leftType, isLiteral, &isClassName ) ){
			if( isClassName == false && compiler.GetMeta().GetBlittableTypes().IsExist( leftType ) ){
				// ̃IuWFNgBlittable^̂Ƃ

				char temporary[VN_SIZE];
				lstrcpy( temporary, termLeft );
				sprintf( termLeft, "%s(%s)",
					compiler.GetMeta().GetBlittableTypes().Find( leftType ).GetCreateStaticMethodFullName().c_str(),
					temporary );
			}
		}

		if( !TermOpe( termLeft, baseType, leftType, isLiteral, pbUseHeap, true, &isClassName ) ){
			goto globalArea;
		}

		if( isClassName ){
			// ÓIo/\bh̏ꍇ
			goto globalArea;
		}

		if( !leftType.HasMember() ){
			// oȂ^̏ꍇ
			return false;
		}

		return TermMemberOpe( leftType.GetClass(), baseType, resultType, termFull, termLeft, member );
	}
globalArea:


	//////////////////////////////////////////////
	// NXǂ`FbNiÓIopj
	//////////////////////////////////////////////

	if( pIsClassName ){
		if( compiler.GetMeta().GetClasses().Find( termFull ) ){
			*pIsClassName = true;
			return true;
		}
	}


	/////////////////////////////////////////////////////////////////
	// O[oGA
	/////////////////////////////////////////////////////////////////

	const int useReg = REG_EAX;


	if(lstrcmpi(termFull,"This")==0 && isProcedureCallOnly == false ){
		//ThisIuWFNg
		resultType.SetType( DEF_OBJECT, compiler.pCompilingClass );

		SetThisPtrToReg( useReg );

		isLiteral = false;

		return true;
	}


	//////////////////////////////////////
	// ֐iDLLA[U[`Agݍ݁j
	//////////////////////////////////////
	char procName[VN_SIZE];
	char temporary[8192];

	int i2=GetCallProcName(termFull,procName);
	if(termFull[i2]=='('){
		int i4=GetStringInPare_RemovePare(parameter,termFull+i2+1);

		void *pInfo;
		int idProc=GetProc(procName,(void **)&pInfo);

		if(idProc){
			//JbR")"ɑNULLłȂƂ
			if(termFull[i2+1+i4+1]!='\0'){
				SetError(42,NULL,cp);
			}


			{
				////////////////
				// Ăяo
				////////////////

				CallProc(idProc,pInfo,procName,parameter,resultType);


				/////////////////////
				// ߂l̏
				/////////////////////

				//傫Ȍ^ւ̈Öق̕ϊ
				int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

				/*
				NumOpeŃvbV
				//X^bNփvbV
				PushReturnValue( resultType.GetBasicType() );
				*/

				if( resultType.GetBasicType() != bigType ){
					// 傫Ȍ^֕ϊꂽꍇ
					// WX^̒lLXg
					ExtendRegToBigType( useReg, bigType, resultType.GetBasicType() );

					resultType.SetBasicType( bigType );
				}

				//SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);
			}


			if(resultType.IsStruct()){
				//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
				//freeKv
				// TODO: GCɔC
				*pbUseHeap = 1;
			}

			isLiteral = false;

			return true;
		}

		ConstMacro *pConstMacro = compiler.GetMeta().GetGlobalConstMacros().Find( procName );
		if( pConstMacro )
		{
			if( pConstMacro->GetCalcBuffer( parameter, temporary ) )
			{
				/////////////////////////
				// }N֐
				/////////////////////////

				//JbR")"ɑNULLłȂƂ̓G[ɂ
				if(termFull[i2+1+i4+1]!='\0') SetError(42,NULL,cp);

				//}N֐̏ꍇ
				NumOpe(useReg, temporary,Type(),resultType);

				if(!IS_LITERAL(resultType.GetIndex())){
					//elł͂ȂƂ
					isLiteral = false;
				}

				return true;
			}
		}
	}
	else if( isProcedureCallOnly ){
		// ֐ĂяoȊO͎󂯕tȂ
		return false;
	}


	////////////////////////////////
	// CfNTigetANZTj
	////////////////////////////////

	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(termFull,VarName,ArrayElements);
	if(ArrayElements[0]){
		GetVarType(VarName,resultType,false);
		if( resultType.IsObject() ){
			CallIndexerGetterProc(/*UseReg,*/&resultType.GetClass(),VarName,ArrayElements,resultType);

			isLiteral = false;

			return true;
		}
	}


	////////////////////////////////
	// ϐ
	////////////////////////////////

	RELATIVE_VAR relativeVar;
	if(GetVarOffset(
		false,	//G[\Ȃ
		false,	//ǂݍݐp
		termFull,
		&relativeVar,resultType)){
		//////////
		// ϐ
		//////////

		if( !VarToReg( relativeVar, baseType, resultType ) ){
			SetError(11,termFull,cp);
		}

		isLiteral = false;

		return true;
	}


	/////////////////////////////////
	// vpeBp̃\bh
	/////////////////////////////////

	//zvfr
	GetArrayElement(termFull,VarName,ArrayElements);

	if(GetSubHash(VarName,0)){

		{
			CallPropertyMethod(termFull,NULL,resultType);

			//傫Ȍ^ւ̈Öق̕ϊ
			int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

			if( resultType.GetBasicType() != bigType ){
				// 傫Ȍ^֕ϊꂽꍇ
				// WX^̒lLXg
				ExtendRegToBigType( REG_EAX, bigType, resultType.GetBasicType() );

				resultType.SetBasicType( bigType );
			}

			//SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);
		}


		if(resultType.IsStruct()){
			//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
			//freeKv
			// TODO: GCɔC
			*pbUseHeap = 1;
		}

		isLiteral = false;

		return true;
	}


	return false;
}


bool NumOpe( int reg,
			const char *expression,
			const Type &baseType,
			Type &resultType,
			BOOL *pbUseHeap ){

	if( !NumOpe( expression, baseType, resultType, pbUseHeap ) ){
		return false;
	}

	if( reg != REG_EAX ){
		// TODO: 
		SetError();
	}

	if( resultType.IsReal() ){
		//fld ptr[esp]
		op_fld_ptr_esp( resultType.GetBasicType() );

		//add esp,size
		op_add_esp( resultType.GetBasicSize() );
	}
	else{
		//pop eax
		op_pop(REG_EAX);

		if( resultType.Is64() ){
			//pop edx
			op_pop(REG_EDX);
		}
	}
	return true;
}
bool NumOpe( const char *expression,
			const Type &baseType,
			Type &resultType,
			BOOL *pbUseHeap ){

	int i,i2,i3;
	char temporary[1024],temp2[1024];

	if(expression[0]=='\0'){
		SetError(1,NULL,cp);
		return false;
	}

	if(expression[0]==1&& expression[1]==ESC_NEW ){
		//NewZqiIuWFNgj

		if( !Operator_New( expression+2, baseType, resultType ) ){
			return false;
		}

		return true;
	}

	if( !baseType.IsNull() && expression[0] == '[' ){
		// ez̏ꍇ

		if( !baseType.IsPointer() ){
			SetError(1,NULL,cp);
			return false;
		}
		Type tempBaseType( baseType );
		tempBaseType.PtrLevelDown();

		char *buffer = (char *)malloc( lstrlen( expression ) + 1 );
		lstrcpy( buffer, expression );
		RemoveStringBracket( buffer );

		void *binary = malloc( 1 );
		int num = 0;

		i = 0;
		while( buffer[i] ){
			i = GetOneParameter( buffer, i, temporary );
			if( buffer[i] == ',' ){
				i++;
			}

			Type resultType;
			_int64 i64data;
			if( !StaticCalculation( true, temporary, tempBaseType.GetBasicType(), &i64data, resultType ) ){
				return false;
			}
			if( !resultType.IsWhole() ){
				// TODO: ɖΉ
				SetError();
				return false;
			}

			binary = realloc( binary, ( num + 1 ) * tempBaseType.GetSize() );
			memcpy( (char *)binary + (num * tempBaseType.GetSize()), &i64data, tempBaseType.GetSize() );
			num++;
		}

		i2 = compiler.GetNativeCode().GetDataTable().AddBinary( binary, num * tempBaseType.GetSize() );

		//mov eax,i2
		op_mov_RV(REG_EAX,i2);
		obp-=sizeof(long);
		pobj_DataTableSchedule->add();
		obp+=sizeof(long);

		free( buffer );

		resultType = baseType;

		//push eax
		op_push( REG_EAX );

		return true;
	}


	/////////////////////////////////
	// vft|[hŎ擾
	/////////////////////////////////

	char *values[255];
	long calc[255];
	long stack[255];
	int pnum;
	if(!GetNumOpeElements(expression,&pnum,values,calc,stack)){
		for(i=0;i<pnum;i++){
			if(values[i]) HeapDefaultFree(values[i]);
		}
		return false;
	}


	BOOL bError;
	bError=0;

	//el݂̂̌vZǂ𔻕ʂ邽߂̃tO
	BOOL bLiteralCalculation=1;

	//eZ̏ꍇlZÕobt@ʒu
	int BeforeObp;
	BeforeObp=obp;

	//eZ̏ꍇlZÕvV[WXPW[ʒu
	//64rbg̊|ZAZȂǂœ֐Ă΂邽
	int Before_ProcAddrScheduleNum;
	Before_ProcAddrScheduleNum=pobj_SubAddrSchedule->num;

	//eZ̏ꍇlZÕf[^e[uXPW[ʒu
	int Before_DataTableScheduleNum;
	Before_DataTableScheduleNum=pobj_DataTableSchedule->num;

	//eZ̏ꍇlZO̍ĔzuXPW[
	CReloc *pobj_BackReloc;
	pobj_BackReloc=new CReloc();
	pobj_BackReloc->copy(pobj_Reloc);

	double dbl;
	int sp;
	int type_stack[255];
	bool isNothing_stack[255];
	LONG_PTR index_stack[255];
	BOOL bUseHeap[255];
	_int64 i64data;
	for(i=0,sp=0;i<pnum;i++){
		int idCalc;
		idCalc=calc[i]%100;

		if(idCalc){
			if(type_stack[sp-2]==DEF_OBJECT){
				if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& index_stack[sp-1] == index_stack[sp-2]
					|| isNothing_stack[sp-2] ){
						// ̌^A܂Nothingɑ΂AsAsZqĂяoȂ
				}
				else if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& ( ((CClass *)index_stack[sp-1])->IsEqualsOrSubClass( (CClass *)index_stack[sp-2] ) || ((CClass *)index_stack[sp-2])->IsEqualsOrSubClass( (CClass *)index_stack[sp-1] )
					)){
						// _ELXg
				}
				else{
					//I[o[[hꂽIy[^Ăяo
					i2=CallOperatorProc(idCalc,baseType,type_stack,index_stack,bUseHeap,sp);
					if(i2==0){
						if(idCalc==CALC_EQUAL) lstrcpy(temp2,"==");
						else GetCalcName(idCalc,temp2);
						sprintf(temporary,"Operator %s",temp2);
						SetError(27,temporary,cp);
						goto error;
					}
					else if(i2==-1) goto error;

					continue;
				}
			}

			if(!CheckCalcType(idCalc,type_stack,sp)) goto error;
		}

		switch(idCalc){
			//l
			case 0:
				index_stack[sp]=-1;
				isNothing_stack[sp] = false;
				bUseHeap[sp]=0;

				char *term;
				term=values[i];

				if( calc[i+1]%100 == CALC_AS ){
					// AsZq̉EӒl
					//^
					if( Compiler::StringToType( term, resultType ) ){
						resultType.SetBasicType( resultType.GetBasicType() | FLAG_CAST );
					}
					else{
						SetError(3, term, cp );
						goto error;
					}

					type_stack[sp] = resultType.GetBasicType();
					index_stack[sp] = resultType.GetIndex();
					sp++;

					break;
				}

				if(term[0]=='\"'){
					//e
					if(!RemoveStringQuotes(term)){
						SetError(43,NULL,cp);
						goto error;
					}
					i3=lstrlen(term);
StrLiteral:

					if( baseType.IsObject() || baseType.IsNull() ){
						//v^CvIuWFNgA܂͖̂Ƃ

						//String^IuWFNg𐶐
						NewStringObject(term);

						type_stack[sp]=DEF_OBJECT;
						index_stack[sp]=(LONG_PTR)compiler.GetMeta().GetClasses().GetStringClassPtr();
						bLiteralCalculation=0;

						sp++;
						break;
					}


					type_stack[sp]=typeOfPtrChar;
					bLiteralCalculation=0;

					i2=compiler.GetNativeCode().GetDataTable().AddString(term,i3);

					//push DataSize
					OpBuffer[obp++]=(char)0x68;
					*((long *)(OpBuffer+obp))=i2;
					pobj_DataTableSchedule->add();
					obp+=sizeof(long);
				}
				else if((term[0]=='e'||term[0]=='E')&&
					(term[1]=='x'||term[1]=='X')&&
					term[2]=='\"'){
					//gŃeiGXP[vV[PX\j
					if(!RemoveStringQuotes(term+2)){
						SetError(43,NULL,cp);
						goto error;
					}
					i3=FormatString_EscapeSequence(term+2);
					term+=2;

					goto StrLiteral;
				}
				else if(IsVariableTopChar(term[0])||
					term[0]=='*'||
					(term[0]=='.'&&IsVariableTopChar(term[1]))){
					//////////////////
					// 炩̎ʎq

					bool isLiteral;
					if( TermOpe( term, baseType, resultType, isLiteral, &bUseHeap[sp] ) ){
						if(resultType.IsNull()){
							//߂l݂ȂƂ
							for(i2=0;;i2++){
								if(term[i2]=='('||term[i2]=='\0'){
									term[i2]=0;
									break;
								}
							}
							SetError(38,term,cp);

							goto error;
						}

						type_stack[sp] = resultType.GetBasicType();
						index_stack[sp] = resultType.GetIndex();

						if( !isLiteral ){
							bLiteralCalculation=0;
						}

						if( resultType.GetBasicType() & FLAG_CAST ){
							// ^̂
							SetError();
						}
						else{
							if( resultType.IsReal() ){
								//sub esp,size
								//fstp ptr[esp]
								op_fstp_push( resultType );
							}
							else{
								if( resultType.Is64() ){
									//push edx
									op_push( REG_EDX );
								}
								else{
									ExtendTypeTo32( resultType.GetBasicType(), REG_EAX );
								}

								//push eax
								op_push( REG_EAX );
							}
						}

						sp++;
						break;
					}


					// Nothing
					if( lstrcmp( term, "Nothing" ) == 0 ){
						isNothing_stack[sp] = true;

						type_stack[sp] = DEF_OBJECT;
						if( baseType.IsObject() ){
							index_stack[sp] = baseType.GetIndex();
						}
						else{
							index_stack[sp] = (LONG_PTR)compiler.GetMeta().GetClasses().GetObjectClassPtr();
						}

						bLiteralCalculation = 0;

						//push 0
						op_push_V( 0 );

						sp++;
						break;
					}


					//////////////
					// 萔̏ꍇ
					//////////////

					i3 = compiler.GetMeta().GetGlobalConsts().GetBasicType(term);
					if(i3){
						if( compiler.GetMeta().GetGlobalConsts().IsStringPtr( term ) ){
							//e

							double dbl = compiler.GetMeta().GetGlobalConsts().GetDoubleData(term);
							memcpy(&i64data,&dbl,sizeof(double));

							//oCg
							i3=lstrlen((char *)i64data);

							memcpy(term,(char *)i64data,i3);
							term[i3]=0;
							goto StrLiteral;
						}

						type_stack[sp]=i3;
						if(IsRealNumberType(i3)){
							//
							double dbl = compiler.GetMeta().GetGlobalConsts().GetDoubleData(term);
							memcpy(&i64data,&dbl,sizeof(double));
							goto Literal;
						}
						else if(IsWholeNumberType(i3)){
							//
							i64data = compiler.GetMeta().GetGlobalConsts().GetWholeData(term);
							goto Literal;
						}
						else{
							SetError(300,NULL,cp);
							goto error;
						}
					}


					//Y鎯ʎqȂƂ̓G[ɂ
					bError=1;
					SetError(3,term,cp);
					type_stack[sp]=DEF_DOUBLE;
				}
				else{
					//el
					type_stack[sp]=GetLiteralValue(term,&i64data,baseType.GetBasicType());
Literal:
					if(type_stack[sp]==DEF_INT64||
						type_stack[sp]==DEF_QWORD||
						type_stack[sp]==DEF_DOUBLE){
						//64rbgiL萮/j

						//push HILONG(dbl)
						op_push_V((long)*(long *)(((char *)(&i64data))+4));

						//push LOLONG(dbl)
						op_push_V(*(long *)(&i64data));
					}
					else if(type_stack[sp]==DEF_SINGLE){
						//single

						float flt;
						memcpy(&dbl,&i64data,sizeof(double));
						flt=(float)dbl;
						memcpy(&i3,&flt,sizeof(long));

						//push term
						op_push_V(i3);
					}
					else{
						//̑

						//push term
						op_push_V((long)i64data);

						if((long)i64data==0) index_stack[sp]=LITERAL_NULL;
					}


					//el̎
					if(Is64Type(type_stack[sp])==0&&IsRealNumberType(type_stack[sp])==0){
						//iL/j

						index_stack[sp]=GetLiteralIndex(i64data);
					}
				}
				sp++;
				break;

			//_Zq
			case CALC_XOR:
				//value[sp-2] xor= value[sp-1]
				//xorZ
				if(!Calc_Xor(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_OR:
				//value[sp-2] or= value[sp-1]
				//orZ
				if(!Calc_Or(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_AND:
				//value[sp-2] and= value[sp-1]
				//andZ
				if(!Calc_And(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_NOT:
				//value[sp-1]=Not value[sp-1]
				//NOTZq
				if(!Calc_Not(type_stack,sp)) goto error;
				break;

			//rZq
			case CALC_PE:
				//value[sp-2]<=value[sp-1]
				if(!Calc_Relation_PE(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_QE:
				//value[sp-2]>=value[sp-1]
				if(!Calc_Relation_QE(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_P:
				//value[sp-2]<value[sp-1]
				if(!Calc_Relation_P(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_Q:
				//value[sp-2]>value[sp-1]
				if(!Calc_Relation_Q(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_NOTEQUAL:
				//value[sp-2]<>value[sp-1]
				if(!Calc_Relation_NotEqual(type_stack,&sp)) goto error;
				break;
			case CALC_EQUAL:
				//value[sp-2]=value[sp-1]
				if(!Calc_Relation_Equal(type_stack,&sp)) goto error;
				break;

			//rbgVtg
			case CALC_SHL:
				//value[sp-2]=value[sp-2]<<value[sp-1]
				if(!Calc_SHL(type_stack,&sp)) goto error;
				break;
			case CALC_SHR:
				//value[sp-2]=value[sp-2]>>value[sp-1]
				if(!Calc_SHR(type_stack,&sp)) goto error;
				break;

			//ZpZ
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_PRODUCT:
				if(!CalcTwoTerm_Arithmetic(idCalc,type_stack,index_stack,&sp)) goto error;
				break;

			case CALC_MOD:
				//value[sp-2]%=value[sp-1]
				//]Z
				if(!Calc_Mod(type_stack,&sp)) goto error;
				break;
			case CALC_QUOTIENT:
				//value[sp-2]/=value[sp-1];
				//Z
				if(!Calc_Divide(type_stack,&sp,baseType.GetBasicType())) goto error;
				break;
			case CALC_INTQUOTIENT:
				//value[sp-2]/=value[sp-1]
				//Z
				if(!Calc_IntDivide(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_MINUSMARK:
				//value[sp-1]=-value[sp-1]
				//]
				if(!Calc_MinusMark(type_stack,sp)) goto error;
				index_stack[sp-1]=-1;
				break;
			case CALC_POWER:
				//ׂ扉Zi_Ẑ݁j
				if(!Calc_Power(type_stack,&sp)) goto error;
				break;
			case CALC_AS:
				//LXg
				if(!Calc_Cast(type_stack,index_stack,&sp)) goto error;
				break;

			case CALC_BYVAL:
				//|C^^Qƌ^
				if( PTR_LEVEL( type_stack[sp-1] ) <= 0 ){
					//|C^^ł͂ȂƂ
					SetError( 3, NULL, cp );
					goto error;
				}

				type_stack[sp-1] = PTR_LEVEL_DOWN( type_stack[sp-1] );

				break;

			default:
				SetError(300,NULL,cp);
				goto error;
		}
	}

	if(bError) goto error;

	if(sp!=1){
		SetError(1,NULL,cp);
		goto error;
	}

	if(bLiteralCalculation){
		//EӒll̒萔̏ꍇ
		Type resultType;
		StaticCalculation(true, expression,baseType.GetBasicType(),&i64data,resultType);

		obp=BeforeObp;
		pobj_SubAddrSchedule->num=Before_ProcAddrScheduleNum;
		pobj_DataTableSchedule->num=Before_DataTableScheduleNum;
		pobj_Reloc->copy(pobj_BackReloc);

		if( resultType.GetBasicSize() == sizeof(_int64) ){
			//64rbgiL萮/j

			//push HILONG(i64data)
			op_push_V((long)*(long *)(((char *)(&i64data))+4));

			//push LOLONG(i64data)
			op_push_V(*(long *)(&i64data));
		}
		else if( resultType.IsSingle() ){
			//single

			memcpy(&dbl,&i64data,sizeof(_int64));

			float flt;
			flt=(float)dbl;
			memcpy(&i3,&flt,sizeof(long));

			//push flt
			op_push_V(i3);
		}
		else{
			//iL/j

			i3=(long)i64data;

			if(resultType.GetBasicSize()==sizeof(char)) i3=i3&0x000000FF;
			if(resultType.GetBasicSize()==sizeof(short)) i3=i3&0x0000FFFF;

			//push term
			op_push_V(i3);
		}

		type_stack[0]=resultType.GetBasicType();
		index_stack[0]=resultType.GetIndex();
	}
	else{
		//EӒll̒萔ł͂ȂƂ
		if(IS_LITERAL(index_stack[0])) index_stack[0]=-1;
	}

	if(pbUseHeap) *pbUseHeap=bUseHeap[0];

	resultType.SetType( type_stack[0], index_stack[0] );

	bool isSuccessful = true;
	goto finish;


error:
	isSuccessful = false;
	goto finish;


finish:

	for(i=0;i<pnum;i++){
		if(values[i]) HeapDefaultFree(values[i]);
	}

	//ĔzuXPW[obNAbv
	delete pobj_BackReloc;

	return isSuccessful;
}
