#include "stdafx.h"

#include <jenga/include/smoothie/BasicFixed.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Compiler.h>
#include <Symbol.h>

Symbol::Symbol( const char *fullName )
{
	char areaName[VN_SIZE] = "";		//IuWFNgϐ
	char nestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName, areaName, nestName );

	namespaceScopes = NamespaceScopes( areaName );
	name = nestName;
}
Symbol::Symbol( const string &fullName )
{
	char areaName[VN_SIZE] = "";		//IuWFNgϐ
	char nestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), areaName, nestName );

	namespaceScopes = NamespaceScopes( areaName );
	name = nestName;
}

bool Symbol::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}

	return compiler.GetNamespaceSupporter().IsSameAreaNamespace( GetNamespaceScopes(), namespaceScopes );
}
bool Symbol::IsEqualSymbol( const Symbol &symbol ) const
{
	if( IsEqualSymbol( symbol.GetNamespaceScopes(), symbol.GetName() ) )
	{
		return true;
	}

	if( symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( namespaceScopes, name );
	}
	return false;
}
bool Symbol::IsEqualSymbol( const char *fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName, AreaName, NestName );

	if( IsEqualSymbol( NamespaceScopes( AreaName ), NestName ) ){
		return true;
	}

	return false;
}
