#pragma once

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalScoping.h>

class ScopeImpl : public CScope
{
public:
	ScopeImpl( int level, int addr, SCOPE_TYPE TypeOfStatement )
		: CScope( level, addr, TypeOfStatement )
	{
	}
	~ScopeImpl();

	virtual void Break();
	virtual void RunScheduleOfBreak();
};

class LexicalScopesImpl : public CLexicalScopes
{
	virtual CScope *CreateScope( int level, int addr, SCOPE_TYPE TypeOfStatement )
	{
		return new ScopeImpl( level, addr, TypeOfStatement );
	}

public:

	virtual void End();

	//XR[vĨfXgN^Ăяo
	virtual void CallDestructorsOfScopeEnd();

	//ReturnXe[ggp̃fXgN^Ăяo
	virtual void CallDestructorsOfReturn( int BaseLevel = 0 );
};

LexicalScopesImpl &GetLexicalScopes();
