#include "stdafx.h"

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void SetReg_RealVariable(int type,RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//fld ptr[ecx+offset]
			op_fld_base_offset(type,REG_ECX,(int)pRelativeVar->offset);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,offset
			op_mov_RV(REG_ECX,(int)pRelativeVar->offset);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//fld ptr[ecx]
			op_fld_basereg(type,REG_ECX);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		SetError(300,NULL,cp);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//fld ptr[ebp+ecx+offset]
			op_fld_base_offset_ex(type,REG_EBP,REG_ECX,(int)pRelativeVar->offset,USE_OFFSET);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//fld ptr[ebp+offset]
			op_fld_base_offset(type,REG_EBP,(int)pRelativeVar->offset);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[ebp+offset]
			op_add_RM(sizeof(long),REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,qword ptr[ebp+offset]
			op_mov_RM(sizeof(long),REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//fld ptr[ecx]
		op_fld_basereg(type,REG_ECX);
	}
}
void SetReg_WholeVariable(int type,RELATIVE_VAR *pRelativeVar,int reg, bool is64Head){
	int varSize;

	varSize=GetTypeSize(type,-1);

	if(varSize==sizeof(_int64)){
		//64rbg̏ꍇedx:eaxɃ[h
		if(reg!=REG_EAX){
			SetError(300,NULL,cp);
			return;
		}

		//32rbgeaxɃ[h
		SetReg_WholeVariable(DEF_LONG,pRelativeVar,REG_EAX);

		//32rbgedxɃ[h
		SetReg_WholeVariable(DEF_LONG,pRelativeVar,REG_EDX, true);

		return;
	}

	int offsetOf64Head = 0;
	if( is64Head ){
		offsetOf64Head = sizeof(long);
	}

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[ecx+offset]
			op_mov_RM(varSize,reg,REG_ECX,(int)pRelativeVar->offset + offsetOf64Head,MOD_BASE_DISP32);
		}
		else{
			//mov reg, ptr[offset]
			op_mov_RM(varSize,reg,0,(int)pRelativeVar->offset + offsetOf64Head,MOD_DISP32);
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[offset]
			op_add_RM(varSize,REG_ECX,REG_NON,(int)pRelativeVar->offset,MOD_DISP32);
		}
		else{
			//mov ecx,qword ptr[offset]
			op_mov_RM(varSize,REG_ECX,REG_NON,(int)pRelativeVar->offset,MOD_DISP32);
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//mov reg, ptr[ebp+ecx+offset]
			op_mov_RM_ex(varSize,reg,REG_EBP,REG_ECX,(int)pRelativeVar->offset + offsetOf64Head,USE_OFFSET);
		}
		else{
			//mov reg, ptr[ebp+offset]
			op_mov_RM(varSize,reg,REG_EBP,(int)pRelativeVar->offset + offsetOf64Head,MOD_BASE_DISP32);
		}
		obp-=sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[ebp+offset]
			op_add_RM(varSize,REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
		}
		else{
			//mov ecx,qword ptr[ebp+offset]
			op_mov_RM(varSize,REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
		}
		obp-=sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		if( is64Head ){
			//mov reg, ptr[ecx]
			op_mov_RM(varSize,reg,REG_ECX,offsetOf64Head,MOD_BASE_DISP8);
		}
		else{
			//mov reg, ptr[ecx]
			op_mov_RM(varSize,reg,REG_ECX,0,MOD_BASE);
		}
	}
}





void PushDoubleVariable(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//push dword ptr[ecx+offset+sizeof(long)]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0xB1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//push dword ptr[ecx+offset]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0xB1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//push dword ptr[offset+sizeof(long)]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x35;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//push dword ptr[offset]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x35;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		SetError(300,NULL,cp);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset+sizeof(long)
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset+sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//push dword ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x74;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;

			//sub ecx,sizeof(long)
			OpBuffer[obp++]=(char)0x83;
			OpBuffer[obp++]=(char)0xE9;
			OpBuffer[obp++]=(char)0x04;

			//push dword ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x74;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//push dword ptr[ebp+offset+sizeof(long)]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0xB5;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset+sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//push dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0xB5;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		//mov eax,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=pRelativeVar->offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add eax,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xC1;
		}

		//push dword ptr[eax+sizeof(long)]
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0x70;
		OpBuffer[obp++]=(char)0x04;

		//push dword ptr[eax]
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0x30;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//push dword ptr[ecx+sizeof(long)]
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0xB1;
		*((long *)(OpBuffer+obp))=sizeof(long);
		obp+=sizeof(long);

		//push dword ptr[ecx]
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0x31;
	}
}
void PushLongVariable(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//push dword ptr[ecx+offset]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0xB1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//push dword ptr[offset]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x35;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		//mov eax,dword ptr[offset]
		op_mov_RM( sizeof(long), REG_EAX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add eax,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xC1;
		}

		//push dword ptr[eax]
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0x30;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//push dword ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x74;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//push dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0xB5;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		//mov eax,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=pRelativeVar->offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add eax,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xC1;
		}

		//push dword ptr[eax]
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0x30;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//push dword ptr[ecx]
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0x31;
	}
}
void PushIntegerVariable(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//movsx eax,word ptr[ecx+offset]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBF;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//movsx eax,word ptr[offset]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBF;
			OpBuffer[obp++]=(char)0x05;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		//mov ebx,dword ptr[offset]
		op_mov_RM( sizeof(long), REG_EBX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//movsx eax,word ptr[ebx]
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBF;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//movsx eax,word ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBF;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//movsx eax,word ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBF;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=pRelativeVar->offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//movsx eax,word ptr[ebx]
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBF;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//movsx eax,word ptr[ecx]
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBF;
		OpBuffer[obp++]=(char)0x01;
	}

	//push eax
	op_push(REG_EAX);
}
void PushWordVariable(RELATIVE_VAR *pRelativeVar){
	//xor eax,eaxieax0ɏj
	op_zero_reg(REG_EAX);

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//mov ax,word ptr[ecx+offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov ax,word ptr[offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0xA1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		//mov ebx,dword ptr[offset]
		op_mov_RM( sizeof(long), REG_EBX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov ax,word ptr[ebx]
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov ax,word ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov ax,word ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=pRelativeVar->offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov ax,word ptr[ebx]
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//mov ax,word ptr[ecx]
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x01;
	}

	//push eax
	op_push(REG_EAX);
}
void PushCharVariable(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//movsx eax,byte ptr[ecx+offset]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBE;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//movsx eax,byte ptr[offset]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBE;
			OpBuffer[obp++]=(char)0x05;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		//mov ebx,dword ptr[offset]
		op_mov_RM( sizeof(long), REG_EBX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//movsx eax,byte ptr[ebx]
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBE;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//movsx eax,byte ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBE;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//movsx eax,byte ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x0F;
			OpBuffer[obp++]=(char)0xBE;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=pRelativeVar->offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//movsx eax,byte ptr[ebx]
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBE;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//movsx eax,byte ptr[ecx]
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBE;
		OpBuffer[obp++]=(char)0x01;
	}

	//push eax
	op_push(REG_EAX);
}
void PushByteVariable(RELATIVE_VAR *pRelativeVar){
	//xor eax,eaxieax0ɏj
	op_zero_reg(REG_EAX);

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//mov al,byte ptr[ecx+offset]
			OpBuffer[obp++]=(char)0x8A;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov al,byte ptr[offset]
			OpBuffer[obp++]=(char)0xA0;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		//mov ebx,dword ptr[offset]
		op_mov_RM( sizeof(long), REG_EBX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov al,byte ptr[ebx]
		OpBuffer[obp++]=(char)0x8A;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov al,byte ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0x8A;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov al,byte ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8A;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=pRelativeVar->offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(pRelativeVar->bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov al,byte ptr[ebx]
		OpBuffer[obp++]=(char)0x8A;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//mov al,byte ptr[ecx]
		OpBuffer[obp++]=(char)0x8A;
		OpBuffer[obp++]=(char)0x01;
	}

	//push eax
	op_push(REG_EAX);
}
