#pragma once

#include <vector>
#include <string>
#include <fstream>
#include <sstream>

#include <boost/archive/xml_oarchive.hpp>
#include <boost/archive/xml_iarchive.hpp>
#include <boost/serialization/serialization.hpp>
#include <boost/serialization/string.hpp>
#include <boost/serialization/access.hpp>
#include <boost/serialization/export.hpp>
#include <boost/serialization/level.hpp>
#include <boost/serialization/vector.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/serialization/version.hpp>
#include <boost/serialization/is_abstract.hpp>

#include <windows.h>

namespace Jenga{
namespace Common{

using namespace std;

template<class T_xml_schema> class BoostXmlSupport{
	virtual const char *RootTagName() const = 0;

	void echo( const char *msg ) const
	{
		MessageBox( NULL, msg, "XMLVACY̗O", MB_OK );
	}

public:
	bool Read( istream& ifs, bool isShowExceptionMessage = true )
	{
		bool isSuccessful = false;

		try{
			boost::archive::xml_iarchive ia(ifs);

			// t@CǍ
			ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			isSuccessful = true;
		}
		catch( boost::archive::archive_exception e )
		{
			if( isShowExceptionMessage )
			{
				echo( e.what() );
			}
		}
		catch(...){
			if( isShowExceptionMessage )
			{
				echo( "archive_exceptionȊO̕sȗO" );
			}
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}

	bool Write( ostream& ofs, bool isShowExceptionMessage = true ) const
	{
		bool isSuccessful = false;

		try{
			boost::archive::xml_oarchive oa(ofs);

			// t@Cɏo
			oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			isSuccessful = true;
		}
		catch( boost::archive::archive_exception e )
		{
			if( isShowExceptionMessage )
			{
				echo( e.what() );
			}
		}
		catch(...){
			if( isShowExceptionMessage )
			{
				echo( "archive_exceptionȊO̕sȗO" );
			}
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}

	bool Read( const string &xmlFilePath, bool isShowExceptionMessage = true )
	{
		bool isSuccessful = false;

		// ̓A[JCu̍쐬
		std::ifstream ifs( xmlFilePath.c_str() );
		
		bool result = Read(ifs,isShowExceptionMessage);

		// ͂
		ifs.close();

		return result;
	}

	bool Write( const string &xmlFilePath, bool isShowExceptionMessage = true ) const
	{
		// o̓A[JCu̍쐬
		std::ofstream ofs( xmlFilePath.c_str() );

		bool result = Write(ofs,isShowExceptionMessage);

		// o͂
		ofs.close();

		return result;
	}

	bool ReadFromString( const string &xmlBuffer )
	{
		bool isSuccessful = false;

		// ̓A[JCu̍쐬
		std::istringstream iss( xmlBuffer );

		try{
			boost::archive::xml_iarchive ia(iss);

			// Xg[Ǎ
			ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			isSuccessful = true;
		}
		catch(...){
			// s
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}
	bool ToWString( wstring &xmlBuffer ) const
	{
		bool isSuccessful = false;

		// ̓A[JCu̍쐬
		std::ostringstream oss;

		try{
			boost::archive::xml_oarchive oa(oss);

			// Xg[֏o
			oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			xmlBuffer = oss.str();

			isSuccessful = true;
		}
		catch(...){
			// s
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}
};


}}
