#pragma once

#include "Parameter.h"
#include "Variable.h"

class CClass;
class CMethod;

class Procedure{
public:
	// 
	enum Kind{
		Sub,
		Function,
	};

private:
	string name;						// vV[W

	Kind kind;

	bool isCdecl;
	bool isUsing;

protected:

	// p[^
	Parameters params;

	// ߂ľ^
	Type returnType;

	// \[XR[ḧʒu
	int codePos;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( name );
		ar & BOOST_SERIALIZATION_NVP( kind );
		ar & BOOST_SERIALIZATION_NVP( isCdecl );
		ar & BOOST_SERIALIZATION_NVP( isUsing );
		ar & BOOST_SERIALIZATION_NVP( params );
		ar & BOOST_SERIALIZATION_NVP( returnType );
		ar & BOOST_SERIALIZATION_NVP( codePos );
	}

public:
	Procedure( const string &name, Kind kind, bool isCdecl ):
	  name( name ),
	  kind( kind ),
	  isCdecl( isCdecl ),
	  isUsing( false ),
	  codePos( -1 )
	{}
	~Procedure(){
		BOOST_FOREACH( Parameter *pParam, params ){
			delete pParam;
		}
	}

	const string &GetName() const
	{
		return name;
	}

	bool IsSub() const
	{
		return ( kind == Sub );
	}
	bool IsFunction() const
	{
		return ( kind == Function );
	}

	bool IsCdecl() const
	{
		return isCdecl;
	}
	void Using(){
		isUsing = true;
	}
	bool IsUsing() const
	{
		return isUsing;
	}

	int GetCodePos() const
	{
		return codePos;
	}

	const Parameters &Params() const
	{
		return params;
	}
	const Type &ReturnType() const
	{
		return returnType;
	}
};

class UserProc : public Procedure
{
public:
	string _paramStr;

protected:
	bool isMacro;

	// p[^̒ǉ
	int secondParmNum;
	Parameters realParams;
	int realSecondParmNum;

	// eNXƑΉ郁\bh
	const CClass *pParentClass;
	CMethod *pMethod;

	// etO
	bool isExport;
	bool isSystem;
	bool isAutoGeneration;
	bool isCompiled;

	// XMLVACYp
	// TODO: xmlipublicȃNXcĂj
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
		ar & BOOST_SERIALIZATION_NVP( _paramStr );
		ar & BOOST_SERIALIZATION_NVP( secondParmNum );
		ar & BOOST_SERIALIZATION_NVP( realParams );
		ar & BOOST_SERIALIZATION_NVP( realSecondParmNum );
		ar & BOOST_SERIALIZATION_NVP( pParentClass );
		ar & BOOST_SERIALIZATION_NVP( pMethod );
		ar & BOOST_SERIALIZATION_NVP( isExport );
		ar & BOOST_SERIALIZATION_NVP( isSystem );
		ar & BOOST_SERIALIZATION_NVP( isAutoGeneration );
		ar & BOOST_SERIALIZATION_NVP( isCompiled );
	}

public:

	UserProc( const string &name, Kind kind, bool isMacro, bool isCdecl, bool isExport ):
	  Procedure( name, kind, isCdecl ),
	  isMacro( isMacro ),
	  pParentClass( NULL ),
	  pMethod( NULL ),
	  isExport( isExport ),
	  isSystem( false ),
	  isAutoGeneration( false ),
	  isCompiled( false ),
	  beginOpAddress( 0 ),
	  endOpAddress( 0 )
	{
	}
	~UserProc()
	{
		BOOST_FOREACH( Parameter *pParam, realParams ){
			delete pParam;
		}
	}

	string GetFullName() const;

	bool IsMacro() const
	{
		return isMacro;
	}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine, bool isStatic ) = 0;

	int GetSecondParmNum() const
	{
		return secondParmNum;
	}
	const Parameters &RealParams() const
	{
		return realParams;
	}
	int GetRealSecondParmNum() const
	{
		return realSecondParmNum;
	}

	void SetParentClass( const CClass *pParentClass ){
		this->pParentClass = pParentClass;
	}
	const CClass *GetParentClassPtr() const
	{
		return pParentClass;
	}
	const CClass &GetParentClass() const
	{
		return *pParentClass;
	}
	bool HasParentClass() const
	{
		return ( pParentClass != NULL );
	}
	void SetMethod( CMethod *pMethod ){
		this->pMethod = pMethod;
	}

	void ExportOff(){
		isExport = false;
	}
	bool IsExport() const
	{
		return isExport;
	}
	void ThisIsSystemProc(){
		isSystem = true;
	}
	bool IsSystem() const
	{
		return isSystem;
	}
	void ThisIsAutoGenerationProc(){
		isAutoGeneration = true;
	}
	bool IsAutoGeneration(){
		return isAutoGeneration;
	}
	void CompleteCompile(){
		isCompiled = true;
	}
	void KillCompileStatus(){
		isCompiled = false;
	}
	bool IsCompiled() const
	{
		return isCompiled;
	}
	bool IsDestructor() const
	{
		return ( GetName()[0] == '~' );
	}
	bool IsVirtual() const;

	// oCiR[ḧʒu
	DWORD beginOpAddress;
	DWORD endOpAddress;
	int GetCodeSize() const
	{
		return endOpAddress - beginOpAddress;
	}

	virtual const NamespaceScopes &GetNamespaceScopes() const;
	virtual const NamespaceScopesCollection &GetImportedNamespaces() const;
	virtual bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;

	// [Jϐ
	Variables localVars;

	// TODO: K؂ȃR[h֒
	long id;


	/////////////////////////////////////////////////////////////////
	// RpC̊֐Ǘ
	/////////////////////////////////////////////////////////////////
private:
	static UserProc *pCompilingUserProc;
public:
	static void CompileStartForGlobalArea(){
		pCompilingUserProc = NULL;
	}
	static void CompileStartForUserProc( UserProc *pUserProc ){
		pCompilingUserProc = pUserProc;
	}
	static bool IsGlobalAreaCompiling(){
		return ( pCompilingUserProc == NULL );
	}
	static bool IsLocalAreaCompiling(){
		return ( pCompilingUserProc != NULL );
	}
	static UserProc &CompilingUserProc(){
		return *pCompilingUserProc;
	}
};

class DllProc : public Procedure
{
	NamespaceScopes namespaceScopes;

	string dllFileName;
	string alias;
	int lookupAddress;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
		ar & BOOST_SERIALIZATION_NVP( namespaceScopes );
		ar & BOOST_SERIALIZATION_NVP( dllFileName );
		ar & BOOST_SERIALIZATION_NVP( alias );
		ar & BOOST_SERIALIZATION_NVP( lookupAddress );
	}

public:
	// nbVXgp
	DllProc *pNextData;

	DllProc( const NamespaceScopes &namespaceScopes, const string &name, Kind kind, bool isCdecl, const string &dllFileName, const string &alias ):
	  Procedure( name, kind, isCdecl ),
	  namespaceScopes( namespaceScopes ),
	  dllFileName( dllFileName ),
	  alias( alias ),
	  lookupAddress( 0 ),
	  pNextData( NULL )
	{
	}
	~DllProc(){}

	virtual bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const = 0;
	bool IsEqualSymbol( const string &name ) const;

	const NamespaceScopes &GetNamespaceScopes() const
	{
		return namespaceScopes;
	}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine ) = 0;

	const string &GetDllFileName() const
	{
		return dllFileName;
	}
	const string &GetAlias() const
	{
		return alias;
	}

	void SetLookupAddress( int lookupAddress ){
		this->lookupAddress = lookupAddress;
	}
	int GetLookupAddress() const
	{
		return lookupAddress;
	}

};

class ProcPointer : public Procedure
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
	}

public:
	ProcPointer( Kind kind ):
	  Procedure( "", kind, false )
	{
	}
	~ProcPointer(){}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine ) = 0;
};
class ProcPointers : public vector<ProcPointer *>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & boost::serialization::make_nvp("vector_ProcPointer", boost::serialization::base_object<vector<ProcPointer *>>(*this));
	}

public:
	ProcPointers()
	{
	}
	~ProcPointers()
	{
	}

	virtual int Add( const string &typeExpression ) = 0;
};
