#pragma once

#include <jenga/include/common/BoostXmlSupport.h>

#include "Prototype.h"
#include "Member.h"
#include "Method.h"
#include "LexicalAnalysis.h"

class InheritedInterface
{
	CClass *pInterfaceClass;
	int vtblOffset;
public:
	InheritedInterface( CClass *pInterfaceClass, int vtblOffset )
		: pInterfaceClass( pInterfaceClass )
		, vtblOffset( vtblOffset )
	{
	}

	CClass &GetInterfaceClass() const{
		return *pInterfaceClass;
	}
	int GetVtblOffset() const
	{
		return vtblOffset;
	}
};
typedef vector<InheritedInterface> Interfaces;

class CClass : public Prototype
{
public:
	// o̎Qƕ@
	enum RefType{
		Non = 0,		// no reference member
		Dot,			// obj.member
		Pointer,		// obj->member
	};

	// ^̎
	enum ClassType{
		Class,
		Interface,
		Enum,
		Delegate,
		Structure,
	};

protected:
	ClassType classType;

	// importĂ閼O
	NamespaceScopesCollection importedNamespaces;

	// C^[tFCX
	Interfaces interfaces;
	
	// pNX
	const CClass *pSuperClass;

	// Blittable^
	Type blittableType;

	// Io
	Members dynamicMembers;

	// ÓIo
	Members staticMembers;

	// I\bh
	Methods methods;
	int ConstructorMemberSubIndex;
	int DestructorMemberSubIndex;
	int vtblNum;					// z֐̐

	// ÓI\bh
	Methods staticMethods;


	// XMLVACYp
	// TODO: xml
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Prototype );
		ar & BOOST_SERIALIZATION_NVP( classType );
		ar & BOOST_SERIALIZATION_NVP( importedNamespaces );
		//ar & BOOST_SERIALIZATION_NVP( interfaces );
		ar & boost::serialization::make_nvp( "pSuperClass", const_cast<CClass *&>(pSuperClass) );
		ar & BOOST_SERIALIZATION_NVP( blittableType );
		//ar & BOOST_SERIALIZATION_NVP( dynamicMembers );
		//ar & BOOST_SERIALIZATION_NVP( staticMembers );
		//ar & BOOST_SERIALIZATION_NVP( methods );
		ar & BOOST_SERIALIZATION_NVP( ConstructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( DestructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( vtblNum );
		//ar & BOOST_SERIALIZATION_NVP( staticMethods );
	}


	bool isReady;

public:

	//ACgl
	int iAlign;

	CClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name )
		: isReady( false )
		, Prototype( namespaceScopes, name )
		, importedNamespaces( importedNamespaces )
		, ConstructorMemberSubIndex( -1 )
		, DestructorMemberSubIndex( -1 )
		, classType( Class )
		, pSuperClass( NULL )
		, vtblNum( 0 )
		, iAlign( 0 )
		, vtbl_offset( -1 )
		, isCompilingConstructor( false )
		, isCompilingDestructor( false )
		, pobj_NextClass( NULL )
	{
	}
	CClass()
		: isReady( false )
		, Prototype()
		, importedNamespaces()
		, ConstructorMemberSubIndex( -1 )
		, DestructorMemberSubIndex( -1 )
		, classType()
		, pSuperClass( NULL )
		, vtblNum( 0 )
		, iAlign( 0 )
		, vtbl_offset( -1 )
		, isCompilingConstructor( false )
		, isCompilingDestructor( false )
		, pobj_NextClass( NULL )
	{
	}
	~CClass();

	void Readed(){
		isReady = true;
	}
	bool IsReady() const{
		return isReady;
	}

	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	// C^[tFCX
	bool HasInterfaces() const
	{
		return ( interfaces.size() != 0 );
	}
	bool IsInheritsInterface( const CClass *pInterfaceClass ) const;

	// pNX
	bool HasSuperClass() const
	{
		return ( pSuperClass != NULL );
	}
	const CClass &GetSuperClass() const
	{
		return *pSuperClass;
	}
	void SetSuperClass( const CClass *pSuperClass )
	{
		this->pSuperClass = pSuperClass;
	}

	// Blittable^
	bool IsBlittableType() const
	{
		return !blittableType.IsNull();
	}
	const Type &GetBlittableType() const
	{
		return blittableType;
	}
	void SetBlittableType( const Type &type ){
		blittableType = type;
	}

	bool IsClass() const;
	bool IsInterface() const;
	bool IsEnum() const;
	bool IsDelegate() const;
	bool IsStructure() const;
	void SetClassType( ClassType classType )
	{
		this->classType = classType;
	}

	// p
	virtual bool Inherits( const char *inheritNames, int nowLine ) = 0;
	virtual bool InheritsClass( const CClass &inheritsClass, int nowLine ) = 0;
	virtual bool InheritsInterface( const CClass &inheritsClass, int nowLine ) = 0;

	virtual void AddMember( Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer, int nowLine ) = 0;
	virtual void AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ) = 0;

	virtual void AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
		bool isVirtual, bool isOverride, char *buffer, int nowLine) = 0;

	//d`FbN
	BOOL DupliCheckAll(const char *name);
	BOOL DupliCheckMember(const char *name);

	const Members &GetDynamicMembers() const
	{
		return dynamicMembers;
	}
	const Members &GetStaticMembers() const
	{
		return staticMembers;
	}
	Members &GetDynamicMembers()
	{
		return dynamicMembers;
	}
	Members &GetStaticMembers()
	{
		return staticMembers;
	}

	const Methods &GetMethods() const
	{
		return methods;
	}
	const Methods &GetStaticMethods() const
	{
		return staticMethods;
	}
	Methods &GetMethods()
	{
		return methods;
	}
	Methods &GetStaticMethods()
	{
		return staticMethods;
	}

	//ftHg RXgN^
	const CMethod *GetConstructorMethod() const;
	void SetConstructorMemberSubIndex( int constructorMemberSubIndex )
	{
		this->ConstructorMemberSubIndex = constructorMemberSubIndex;
	}

	//fXgN^ \bh擾
	const CMethod *GetDestructorMethod() const;
	void SetDestructorMemberSubIndex( int destructorMemberSubIndex )
	{
		this->DestructorMemberSubIndex = destructorMemberSubIndex;
	}

	// vtblɑ݂鉼z֐̐
	int GetVtblNum() const
	{
		return vtblNum;
	}
	void SetVtblNum( int vtblNum )
	{
		this->vtblNum = vtblNum;
	}
	void AddVtblNum( int vtblNum )
	{
		this->vtblNum += vtblNum;
	}
	bool IsExistVirtualFunctions() const
	{
		return ( vtblNum > 0 );
	}

	// ȏTCY擾
	int GetSize() const;

	// õItZbg擾
	int GetMemberOffset( const char *memberName, int *pMemberNum = NULL ) const;

private:
	// ACgl擾
	int GetAlignment() const;


	//vtbl
protected:
	mutable long vtbl_offset;
public:
	int GetFuncNumInVtbl( const UserProc *pUserProc ) const;
	virtual LONG_PTR GetVtblGlobalOffset(void) const = 0;
	virtual void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection) = 0;
	bool IsAbstract() const;


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile() const;
	void NotifyFinishConstructorCompile() const;
	bool IsCompilingConstructor() const;

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile() const;
	void NotifyFinishDestructorCompile() const;
	bool IsCompilingDestructor() const;


	//g̔hNXǂmF
	bool IsSubClass( const CClass *pClass ) const;

	//gƓ܂͔hNXǂmF
	bool IsEqualsOrSubClass( const CClass *pClass ) const;

	// gƓ܂͔hNXANXǂmF
	bool IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const;


	//`Xgp
	CClass *pobj_NextClass;


public:
	static bool SplitName( const char *desc, char *object, char *member, CClass::RefType &refType ){
		int lastIndex = -1;
		for( int i=0; desc[i]; i++ ){
			if( desc[i] == '(' ){
				i=JumpStringInPare(desc,i+1);
				continue;
			}
			else if( desc[i] == '[' ){
				i=JumpStringInBracket(desc,i+1);
				continue;
			}
			else if(desc[i]=='.'||(desc[i]==1&&desc[i+1]==ESC_PSMEM)){
				lastIndex = i;
			}
		}
		if( lastIndex == -1 ){
			lstrcpy( member, desc );
			return false;
		}

		if(desc[lastIndex]=='.'){
			lstrcpy(member,desc+lastIndex+1);
			refType = CClass::Dot;
		}
		else{
			lstrcpy(member,desc+lastIndex+2);
			refType = CClass::Pointer;
		}

		if( object ){
			lstrcpy( object, desc );
			object[lastIndex]=0;
		}

		return true;
	}
	static bool SplitName( const char *desc, char *object, char *member ){
		CClass::RefType dummyRefType;
		return SplitName( desc, object, member, dummyRefType );
	}
};

#define MAX_CLASS_HASH 65535
class Classes
{
protected:
	int GetHashCode(const char *name) const;
	void DestroyClass(CClass *pobj_c);
public:
	CClass *pobj_ClassHash[MAX_CLASS_HASH];

	Classes();
	~Classes();
	void Clear();

	const CClass *Find( const string &fullName ) const;
	virtual const CClass *Find( const NamespaceScopes &namespaceScopes, const string &name ) const = 0;

	virtual CClass *Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name) = 0;
	bool Insert( CClass *pClass );
	CClass *Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine);

	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);

public:

	// ̎W
	virtual void CollectClassesForNameOnly( const BasicSource &source ) = 0;
	virtual void GetClass_recur(const char *lpszInheritsClass) = 0;
	virtual void GetAllClassInfo() = 0;
	virtual void Compile_System_InitializeUserTypes() = 0;
	virtual void InitStaticMember() = 0;


	/////////////////////////////
	// NX
	/////////////////////////////
	CClass *pStringClass;
	CClass *pObjectClass;
	CClass *GetStringClassPtr() const;
	CClass *GetObjectClassPtr() const;


	/////////////////////////////
	// ݃RpC̏
	/////////////////////////////
private:
	const CClass *pCompilingClass;
	const CMethod *pCompilingMethod;
public:
	//RpCJn̒ʒm󂯎郁\bh
	void StartCompile( UserProc *pUserProc );

	//݃RpC̃\bh擾
	const CClass *GetNowCompilingClass() const;
	const CMethod *GetNowCompilingMethodInfo();


	/////////////////////
	// Ce[^
	/////////////////////
private:
	mutable CClass **ppobj_IteClass;
	mutable int iIteMaxNum;
	mutable int iIteNextNum;
public:
	void Iterator_Init() const;
	void Iterator_Reset() const;
	BOOL Iterator_HasNext() const;
	CClass *Iterator_GetNext() const;
	int Iterator_GetMaxCount() const;
};
