#pragma once

#include <string>
#include <vector>

#include <jenga/include/common/BoostXmlSupport.h>

#include "Symbol.h"

using namespace std;

class CMethod;
class UserProc;

class Prototype : public Symbol
{
public:
	enum Accessibility{
		None,
		Private,
		Protected,
		Public,
	};

private:
	mutable bool isUsing;


	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
	}


public:

	Prototype( const NamespaceScopes &namespaceScopes, const string &name )
		: Symbol( namespaceScopes, name )
		, isUsing( false )
	{
	}
	Prototype()
		: Symbol()
	{
	}
	~Prototype()
	{
	}

	//gƓǂmF
	bool IsEquals( const Prototype *prototype ) const
	{
		if( this == prototype ){
			return true;
		}
		return false;
	}

	// V{r
	virtual bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const = 0;
	bool IsEqualSymbol( const Prototype &prototype ) const;
	bool IsEqualSymbol( const string &name ) const;

	// p
	bool IsUsing() const
	{
		return isUsing;
	}
	void Using() const
	{
		isUsing = true;
	}
};

class MemberPrototype
{
	Prototype::Accessibility accessibility;
public:
	MemberPrototype( Prototype::Accessibility accessibility )
		: accessibility( accessibility )
	{
	}

	Prototype::Accessibility GetAccessibility() const
	{
		return accessibility;
	}
	void SetAccessibility( Prototype::Accessibility accessibility ){
		this->accessibility = accessibility;
	}

	bool IsNoneAccess() const
	{
		return ( accessibility == Prototype::None );
	}
	bool IsPrivate() const
	{
		return ( accessibility == Prototype::Private );
	}
	bool IsProtected() const
	{
		return ( accessibility == Prototype::Protected );
	}
	bool IsPublic() const
	{
		return ( accessibility == Prototype::Public );
	}
};
