#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

//[JϐAhXXPW[
DWORD *pLocalVarAddrSchedule;
int LocalVarAddrScheduleNum;

void Call_DebugSys_SaveContext(){
	//call _System_GetEip
	extern SUBINFO *pSub_System_GetEip;
	op_call(pSub_System_GetEip);

	//push eax
	op_push(REG_EAX);

	//push ebp
	op_push(REG_EBP);

	//call _DebugSys_SaveContext
	extern SUBINFO *pSub_DebugSys_SaveContext;
	op_call(pSub_DebugSys_SaveContext);
}

void AddLocalVarAddrSchedule(){
	extern HANDLE hHeap;

	//[JϐAhXXPW[ɒǉ
	pLocalVarAddrSchedule=(DWORD *)HeapReAlloc(hHeap,0,pLocalVarAddrSchedule,(LocalVarAddrScheduleNum+1)*sizeof(DWORD));
	pLocalVarAddrSchedule[LocalVarAddrScheduleNum]=obp;
	LocalVarAddrScheduleNum++;
}
int CallProc(int idProc,void *pInfo,char *name,char *Parameter,LONG_PTR *plpRetIndex){
	int ret_type;

	if(idProc==PROC_DEFAULT){
		/////////////////////
		// [U[`֐
		/////////////////////

		SUBINFO *psi;
		psi=(SUBINFO *)pInfo;

		//GetSubHashŃG[񎦂sꂽꍇ
		if(psi==(SUBINFO *)-1) return -1;


		//IuWFNg擾
		char ObjectName[VN_SIZE];
		int RefType;
		GetObjectName(name,ObjectName,&RefType);


		////////////////////////
		// I[o[[h
		////////////////////////

		SUBINFO **ppsi;
		int num;
		ppsi=GetOverloadSubHash(name,&num);
		if(num){
			//I[o[[h
			psi=OverloadSolutionWithStrParam(name,ppsi,num,Parameter,ObjectName,NULL);
			HeapDefaultFree(ppsi);

			if(!psi) return 0;
		}


		ret_type=Opcode_CallProc(Parameter,psi,plpRetIndex,0,ObjectName,RefType);
	}
	else if(idProc==PROC_DLL){
		/////////////////////////
		// DLL֐
		/////////////////////////
		DECLAREINFO *pdi;
		pdi=(DECLAREINFO *)pInfo;

		ret_type=Opcode_CallDllProc(Parameter,pdi,plpRetIndex);
	}
	else if(idProc==PROC_BUILTIN){
		/////////////////////////
		// gݍ݊֐
		/////////////////////////
		int FuncId;
		FuncId=(int)(_int64)pInfo;

		ret_type=Opcode_CallFunc(Parameter,FuncId);
	}
	else if(idProc==PROC_PTR){
		/////////////////
		// ֐|C^
		/////////////////

		LONG_PTR lpIndex;
		GetVarType(name,&lpIndex,0);

		extern PROCPTRINFO *pProcPtrInfo;
		ret_type=Opcode_CallProcPtr(name,Parameter,&pProcPtrInfo[lpIndex],plpRetIndex);
	}

	return ret_type;
}

BOOL CallPropertyMethod(char *variable,char *RightSide,TYPEINFO *pRetTypeInfo){
	//vpeBp̃\bhĂяo

	//zvf擾
	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(variable,VarName,ArrayElements);

	//IuWFNg擾
	char ObjectName[VN_SIZE];
	int RefType;
	GetObjectName(VarName,ObjectName,&RefType);

	//I[o[[hp̊֐Xg쐬
	SUBINFO **ppsi;
	int num;
	ppsi=GetOverloadSubHash(VarName,&num);
	if(num==0){
		return 0;
	}

	//p[^𐮔
	char *Parameter;
	Parameter=(char *)HeapAlloc(hHeap,0,lstrlen(ArrayElements)+lstrlen(RightSide)+32);
	lstrcpy(Parameter,ArrayElements);
	if(RightSide){
		if(Parameter[0]&&RightSide[0]) lstrcat(Parameter,",");
		lstrcat(Parameter,RightSide);
	}

	//I[o[[h
	SUBINFO *psi;
	psi=OverloadSolutionWithStrParam(VarName,ppsi,num,Parameter,ObjectName,NULL);
	HeapDefaultFree(ppsi);

	if(psi){
		//Ăяo
		int type;
		LONG_PTR lpIndex;
		type=Opcode_CallProc(Parameter,psi,&lpIndex,0,ObjectName,RefType);

		if(pRetTypeInfo){
			pRetTypeInfo->type=type;
			pRetTypeInfo->u.lpIndex=lpIndex;
		}
	}

	HeapDefaultFree(Parameter);

	return 1;
}


int Opcode_CallProcPtr(char *variable,char *Parameter,PROCPTRINFO *pi,LONG_PTR *plpIndex){
	extern HANDLE hHeap;
	int i;


	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0)
		Call_DebugSys_SaveContext();


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	CParameter *pobj_parameter=0;
	pobj_parameter=new CParameter(Parameter);

	//G[`FbN
	pobj_parameter->ErrorCheck(variable,pi->pParmInfo,pi->ParmNum,pi->ParmNum);

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( variable,pi->pParmInfo,pi->ParmNum,pi->ParmNum );

	//WX^AX^bNt[ɃZbg
	pobj_parameter->SetParameter(variable,pi->pParmInfo,pi->ParmNum,pi->ParmNum);



	////////////////////////
	// call
	////////////////////////
	RELATIVE_VAR RelativeVar;
	LONG_PTR lp;
	GetVarOffsetReadOnly(variable,&i,&RelativeVar,&lp);
	SetVarPtrToEax(&RelativeVar);

	//mov eax,dword ptr[eax]
	OpBuffer[obp++]=(char)0x8B;
	OpBuffer[obp++]=(char)0x00;

	//call eax
	OpBuffer[obp++]=(char)0xFF;
	OpBuffer[obp++]=(char)0xD0;



	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	if(plpIndex) *plpIndex=pi->u.ReturnIndex;

	return pi->ReturnType;
}

int Opcode_CallProc(char *Parameter,SUBINFO *psi,LONG_PTR *plpIndex,DWORD dwFlags,char *ObjectName,int RefType){
	int i,i2;

	if(psi->dwType==SUBTYPE_MACRO){
		if(lstrcmpi(psi->name,"Print")==0){
			Opcode_Print(Parameter,0);
			return -1;
		}
		if(lstrcmpi(psi->name,"Input")==0){
			Opcode_Input(Parameter);
			return -1;
		}
		if(lstrcmpi(psi->name,"Write")==0){
			Opcode_Print(Parameter,1);
			return -1;
		}
	}

	psi->bUse=1;

	BOOL bStatic=0;
	CClass *pobj_c = NULL;
	CMethod *pMethod = NULL;
	if(psi->pobj_ParentClass){
		//NX̃o֐Ăяoꍇ̓ANZX`FbNs
		if(ObjectName[0]){
			if(lstrcmpi(ObjectName,"Super")==0){
				//NXo֐X[p[NX̌Ăяo
				pobj_c=pobj_CompilingClass;
			}
			else{
				pobj_c=pobj_DBClass->check(ObjectName);
				if(pobj_c){
					//ÓIo
					bStatic=1;
				}
				else{
					//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
					GetVarType(ObjectName,(LONG_PTR *)&pobj_c,1);
				}
			}
		}
		else{
			if(dwFlags&PROCFLAG_NEW){
				//NewZqɂRXgN^Ăяo
				pobj_c=psi->pobj_ParentClass;
			}
			else{
				//NXo֐瓯NX̃o֐̌Ăяo
				pobj_c=pobj_CompilingClass;
			}
		}


		/////////////////////////////////
		// \bh擾
		/////////////////////////////////
		pMethod = pobj_c->GetMethodInfo( psi );
		if( !pMethod ){
			//I\bh擾łȂƂ͐ÓI\bh𓖂
			pMethod = pobj_c->GetStaticMethodInfo( psi );
			if( !pMethod ){
				SetError(300,NULL,cp);
				return -1;
			}
		}


		//////////////////////////////
		// ANZXG[`FbN
		//////////////////////////////
		DWORD dwAccess = pMethod->dwAccess;

		if(ObjectName[0]){
			//ǑĂяo
			if(pobj_c==pobj_CompilingClass){
				//NXIuWFNg̏ꍇ̓vCx[gANZXeF
				if(dwAccess==ACCESS_NON){
					SetError(109,psi->name,cp);
					return -1;
				}
			}
			else{
				if(dwAccess==ACCESS_PRIVATE||
					dwAccess==ACCESS_NON){
					SetError(109,psi->name,cp);
					return -1;
				}
				if(dwAccess==ACCESS_PROTECTED){
					SetError(110,psi->name,cp);
					return -1;
				}
			}
		}
		else{
			//NX̌ĂяoipɂACCESS_NON݂̂G[Ƃj
			if(dwAccess==ACCESS_NON){
				SetError(109,psi->name,cp);
				return -1;
			}
		}
	}



	///////////////////////////////////////////////////////////////
	// _System_LocalThisA_System_ReturnObject̃_~[Zbg
	///////////////////////////////////////////////////////////////

	char temporary[VN_SIZE]={0};
	if(psi->pobj_ParentClass&&bStatic==0){
		//_System_LocalThisip[^j̃_~[쐬
		lstrcpy(temporary,"0,");
	}

	if(psi->ReturnType==DEF_OBJECT){
		//_System_ReturnObjecti܂͑p[^̃_~[쐬j
		sprintf(temporary+lstrlen(temporary),"%c%c0,",1,ESC_BYVAL);
	}

	if(Parameter[0]=='\0'&&temporary[0])
		temporary[lstrlen(temporary)-1]=0;
	else lstrcat(temporary,Parameter);



	////////////////////////
	// p[^Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	CParameter *pobj_parameter=0;
	pobj_parameter=new CParameter(temporary);

	//G[`FbN
	pobj_parameter->ErrorCheck(psi->name,psi->pRealParmInfo,psi->RealParmNum,psi->RealSecondParmNum);

	if(psi->dwType==SUBTYPE_MACRO){
		//}N֐̏ꍇ́Ap[^ȗl
		pobj_parameter->MacroParameterSupport(psi->pRealParmInfo);
	}

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( psi->name,psi->pRealParmInfo,psi->RealParmNum,psi->RealSecondParmNum );

	//WX^AX^bNt[ɃZbg
	int ParmSize;
	ParmSize=pobj_parameter->SetParameter(psi->name,psi->pRealParmInfo,psi->RealParmNum,psi->RealSecondParmNum);



	if(psi->ReturnType==DEF_OBJECT){
		//////////////////////////////////////////////////////
		// ߂lɃIuWFNg CX^Xꍇ
		// ByRef _System_ReturnObject p[^Zbg
		//////////////////////////////////////////////////////

		int object_size;
		object_size=GetSizeOfClass(psi->u.Return_pobj_c);

		//push object_size
		op_push_value(object_size);

		//call calloc
		extern SUBINFO *pSub_calloc;
		op_call(pSub_calloc);

		//push eax
		op_push(REG_EAX);
	}


	if(psi->pobj_ParentClass&&bStatic==0){
		//////////////////////////////////////////////////////
		// o֐̏ꍇ
		// _System_LocalThis p[^Zbg
		//////////////////////////////////////////////////////

		if(ObjectName[0]){
			if(lstrcmpi(ObjectName,"Super")==0) goto InClassMember;
			else{
				RELATIVE_VAR RelativeVar;
				if( pMethod->isConst ){
					//ConstANZX\ȃ\bh̏ꍇ
					if( !GetVarOffsetReadOnly( ObjectName, &i2, &RelativeVar, 0 ) ) return -1;
				}
				else{
					//ConstANZXs\ȃ\bh̏ꍇ
					if( !GetVarOffsetReadWrite( ObjectName, &i2, &RelativeVar, 0 ) ) return -1;
				}

				SetVarPtrToEax(&RelativeVar);

				//Qƃ^CvĂ邩`FbN
				if(i2!=RefType) SetError(104,ObjectName,cp);

				if(i2==DEF_PTR_OBJECT){
					//mov eax,dword ptr[eax]
					OpBuffer[obp++]=(char)0x8B;
					OpBuffer[obp++]=(char)0x00;
				}

				//mov ecx,eax
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0xC8;
			}
		}
		else{
InClassMember:
			if(dwFlags&PROCFLAG_NEW){
				//NewZqɂRXgN^Ăяȍꍇ
				//mov ecx,dword ptr[esp+ParmSize]
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0x8C;
				OpBuffer[obp++]=(char)0x24;
				*((long *)(OpBuffer+obp))=ParmSize;
				obp+=sizeof(long);
			}
			else{
				//This|C^ecxɃRs[
				SetThisPtrToReg(REG_ECX);
			}
		}

		//push ecx
		op_push(REG_ECX);
	}

	if(psi->bVirtual){
		//z֐iIuWFNg\bhjĂяo
		//pObj->func_table->func1
		//                ->func2
		//                ->func3

		//mov edx,dword ptr[ecx]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x11;

		for(i=0,i2=0;i<pobj_c->iMethodNum;i++){
			if(pobj_c->ppobj_Method[i]->psi==psi) break;
			if(pobj_c->ppobj_Method[i]->psi->bVirtual) i2++;
		}

		//call dword ptr[edx+func_index]
		if(i2*PTR_SIZE<=0x7F){
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x52;
			OpBuffer[obp++]=(char)(i2*PTR_SIZE);
		}
		else{
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x92;
			*((long *)(OpBuffer+obp))=i2*PTR_SIZE;
			obp+=sizeof(long);
		}
	}
	else{
		//ʏĂяo

		//call ProcAddr
		op_call(psi);
	}

	if(psi->bCdecl){
		//add esp,ParmSize
		op_add_esp(ParmSize);
	}

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	if(plpIndex) *plpIndex=psi->u.ReturnIndex;

	return psi->ReturnType;
}

int Opcode_CallDllProc(char *Parameter,DECLAREINFO *pdi,LONG_PTR *plpIndex){
	char *temporary;

	temporary=(char *)HeapAlloc(hHeap,0,lstrlen(Parameter)+1);

	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0&&lstrcmp(pdi->name,"DebugBreak")!=0)
		Call_DebugSys_SaveContext();

	pdi->bUse=1;


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	CParameter *pobj_parameter=0;
	pobj_parameter=new CParameter(Parameter);

	//G[`FbN
	pobj_parameter->ErrorCheck(pdi->name,pdi->pParmInfo,pdi->ParmNum,pdi->ParmNum);

	//WX^AX^bNt[ɃZbg
	int ParmSize;
	ParmSize=pobj_parameter->SetParameter(pdi->name,pdi->pParmInfo,pdi->ParmNum,pdi->ParmNum);

	//p[^IuWFNgj
	delete pobj_parameter;


	//INꂽvV[W̌Ăяo

	//call dword ptr[LookupTable]
	OpBuffer[obp++]=(char)0xFF;
	OpBuffer[obp++]=(char)0x15;
	pobj_ImportAddrSchedule->add(pdi);
	obp+=sizeof(long);

	if(pdi->bCdecl){
		//add esp,ParmSize
		op_add_esp(ParmSize);
	}

	if(plpIndex) *plpIndex=pdi->u.ReturnIndex;

	HeapDefaultFree(temporary);

	return pdi->ReturnType;
}
