#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

extern HANDLE hHeap;

int GetAlignment(CClass *pobj_c){
	int i;
	int alignment,member_size;

	if(pobj_c->vtbl_num) alignment=PTR_SIZE;
	else alignment=0;

	for(i=0;i<pobj_c->iMemberNum;i++){
		if(pobj_c->ppobj_Member[i]->TypeInfo.type==DEF_OBJECT){
			//oNX̃ACg擾
			member_size=GetAlignment(pobj_c->ppobj_Member[i]->TypeInfo.u.pobj_Class);
		}
		else{
			//oTCY擾
			member_size=GetTypeSize(pobj_c->ppobj_Member[i]->TypeInfo.type,pobj_c->ppobj_Member[i]->TypeInfo.u.lpIndex);
		}

		//ACgZbg
		if(alignment<member_size) alignment=member_size;
	}

	if(alignment==0) return 0;

	if(pobj_c->iAlign) alignment=pobj_c->iAlign;

	return alignment;
}
int GetSizeOfClassMember(CClass *pobj_c,char *pMemberName,int *pMemberNum){
	int i,i2,offset;

	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	if(pobj_c->vtbl_num) offset=PTR_SIZE;
	else offset=0;

	int alignment;
	if(pobj_c->iAlign) alignment=pobj_c->iAlign;
	else alignment=1;

	int iMaxAlign=0;
	for(i=0;i<pobj_c->iMemberNum;i++){
		//oϐ̌^TCY擾
		i2=GetTypeSize(pobj_c->ppobj_Member[i]->TypeInfo.type,pobj_c->ppobj_Member[i]->TypeInfo.u.lpIndex);
		if(i2==-1) return -1;

		//ACgZo
		int member_size;
		if(pobj_c->ppobj_Member[i]->TypeInfo.type==DEF_OBJECT){
			//oNX̃ACg擾
			member_size=GetAlignment(pobj_c->ppobj_Member[i]->TypeInfo.u.pobj_Class);
		}
		else{
			//oTCY擾
			member_size=i2;
		}
		if(iMaxAlign<member_size) iMaxAlign=member_size;

		//ACgl
		if(pobj_c->iAlign&&pobj_c->iAlign<member_size){
			if(offset%alignment) offset+=alignment-(offset%alignment);
		}
		else{
			if(alignment<member_size) alignment=member_size;

			if(member_size==0){
				//oȂNX
				//ȂiItZbǧvZȂj
			}
			else{
				if(offset%member_size) offset+=member_size-(offset%member_size);
			}
		}

		if(pMemberName){
			//ow肪ꍇ́AItZbgԂ
			if(lstrcmp(pobj_c->ppobj_Member[i]->name,pMemberName)==0){
				if(pMemberNum) *pMemberNum=i;
				return offset;
			}
		}

		//zloTCY擾
		member_size=i2 * JumpSubScripts(pobj_c->ppobj_Member[i]->SubScripts);

		//oTCYZ
		offset+= member_size;
	}

	if(iMaxAlign<alignment) alignment=iMaxAlign;

	//ACgl
	if(alignment){
		if(offset%alignment) offset+=alignment-(offset%alignment);
	}

	if(pMemberNum) *pMemberNum=i;
	return offset;
}
int GetSizeOfClass(CClass *pobj_c){
	return GetSizeOfClassMember(pobj_c,0,0);
}


void CallConstractor(char *ObjectName,int *SubScripts,TYPEINFO &TypeInfo,char *Parameter){
	if(TypeInfo.type!=DEF_OBJECT) return;

	/////////////////////////////////////
	// NXIuWFNg̏ꍇ
	// RXgN^̌Ăяo
	/////////////////////////////////////
	CClass *pobj_c;
	pobj_c=(CClass *)TypeInfo.u.lpIndex;

	SUBINFO *psi;
	psi=GetMethodHash(ObjectName,pobj_c->name,Parameter);
	if(!psi){
		if(Parameter[0]) SetError(113,pobj_c->name,cp);
		return;
	}


	char temporary[VN_SIZE];

	if(SubScripts[0]!=-1){
		int ss[MAX_ARRAYDIM];
		memset(ss,0,MAX_ARRAYDIM*sizeof(int));
		while(1){
			int i3;
			for(i3=0;;i3++){
				if(SubScripts[i3]==-1) break;

				if(ss[i3]>SubScripts[i3]){
					ss[i3]=0;
					ss[i3+1]++;
				}
				else break;
			}
			if(SubScripts[i3]==-1) break;
			sprintf(temporary,"%s[%d",ObjectName,ss[0]);
			for(i3=1;;i3++){
				if(SubScripts[i3]==-1) break;

				sprintf(temporary+lstrlen(temporary),",%d",ss[i3]);
			}
			lstrcat(temporary,"]");

			LONG_PTR lp;
			sprintf(temporary+lstrlen(temporary),".%s",pobj_c->name);
			CallProc(PROC_DEFAULT,
				psi,
				temporary,
				Parameter,
				&lp);

			ss[0]++;


			//lCeBuR[hobt@̍Ċm
			extern int obp_AllocSize;
			if(obp_AllocSize<obp+8192){
				obp_AllocSize+=8192;
				OpBuffer=(char *)HeapReAlloc(hHeap,0,OpBuffer,obp_AllocSize); //matea
			}
		}
	}
	else{
		LONG_PTR lp;
		sprintf(temporary,"%s.%s",ObjectName,pobj_c->name);
		CallProc(PROC_DEFAULT,
			psi,
			temporary,
			Parameter,
			&lp);
	}
}


void CallDestrouctorsOfScope(void){
	extern BOOL bCompilingGlobal;
	VARIABLE *pVar;
	int num;
	if(bCompilingGlobal){
		//O[oIuWFNg̉
		extern VARIABLE *GlobalVar;
		extern int MaxGlobalVarNum;
		pVar=GlobalVar;
		num=MaxGlobalVarNum;
	}
	else{
		//[JIuWFNg̉
		extern VARIABLE *LocalVar;
		extern int MaxLocalVarNum;
		pVar=LocalVar;
		num=MaxLocalVarNum;
	}


	int i3,i4,i5;
	int indexSystemGC=-1;
	for(i3=0;i3<num;i3++){

		if(bCompilingGlobal&&obj_LexScopes.GetNowLevel()==0){
			if(lstrcmp(pVar[i3].name,"_System_GC")==0){
				indexSystemGC=i3;
				continue;
			}
		}

		//ꃌx̃LVJXR[v݂̂m
		if(!pVar[i3].bLiving) continue;
		if(pVar[i3].ScopeLevel!=obj_LexScopes.GetNowLevel()) continue;

		if(pVar[i3].type==DEF_OBJECT&&pVar[i3].fRef&OBJECT_PARAMETER){
			//ԃIuWFNg̃p[^Ƃ

			//fXgN^Ăяo
			i5=pVar[i3].u.pobj_c->DestructorMemberSubIndex;
			if(i5!=-1)
				Opcode_CallProc("",pVar[i3].u.pobj_c->ppobj_Method[i5]->psi,0,0,pVar[i3].name,DEF_OBJECT);

			//

#ifdef _AMD64_
			//x64rbgR[h

			//mov rcx,qword ptr[rsp+offset]
			op_mov_RM(sizeof(_int64),REG_RCX,REG_RSP,
				-pVar[i3].offset,
				MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
#else
			//x86R[h

			//mov ecx,dword ptr[ebp+offset]
			op_mov_RM(sizeof(long),REG_ECX,REG_EBP,-pVar[i3].offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//push ecx
			op_push(REG_ECX);
#endif

			//call free
			extern SUBINFO *pSub_free;
			op_call(pSub_free);
		}
		else if(pVar[i3].type==DEF_OBJECT&&pVar[i3].fRef==0){
			//fXgN^̌Ăяo
			i5=pVar[i3].u.pobj_c->DestructorMemberSubIndex;
			if(i5!=-1){
				int ss[MAX_ARRAYDIM];
				memset(ss,0,MAX_ARRAYDIM*sizeof(int));
				if(pVar[i3].SubScripts[0]!=-1){
					while(1){
						for(i4=0;;i4++){
							if(pVar[i3].SubScripts[i4]==-1) break;

							if(ss[i4]>pVar[i3].SubScripts[i4]){
								ss[i4]=0;
								ss[i4+1]++;
							}
							else break;
						}
						if(pVar[i3].SubScripts[i4]==-1) break;
						char temporary[VN_SIZE];
						sprintf(temporary,"%s[%d",pVar[i3].name,ss[0]);
						for(i4=1;;i4++){
							if(pVar[i3].SubScripts[i4]==-1) break;

							sprintf(temporary+lstrlen(temporary),",%d",ss[i4]);
						}
						lstrcat(temporary,"]");
						Opcode_CallProc("",pVar[i3].u.pobj_c->ppobj_Method[i5]->psi,0,0,temporary,DEF_OBJECT);

						ss[0]++;


						//lCeBuR[hobt@̍Ċm
						extern int obp_AllocSize;
						if(obp_AllocSize<obp+8192){
							obp_AllocSize+=8192;
							OpBuffer=(char *)HeapReAlloc(hHeap,0,OpBuffer,obp_AllocSize); //matea
						}
					}
				}
				else{
					Opcode_CallProc("",pVar[i3].u.pobj_c->ppobj_Method[i5]->psi,0,0,pVar[i3].name,DEF_OBJECT);
				}
			}
		}
	}

	if(indexSystemGC!=-1){
		//_System_GCIuWFNg̃fXgN^̌Ăяo
		i3=pVar[indexSystemGC].u.pobj_c->DestructorMemberSubIndex;
		if(i3!=-1){
			Opcode_CallProc("",pVar[indexSystemGC].u.pobj_c->ppobj_Method[i3]->psi,0,0,pVar[indexSystemGC].name,DEF_OBJECT);
		}
	}
}

