#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Program.h>
#include <Compiler.h>
#include <LexicalScopingImpl.h>
#include <ClassImpl.h>
#include <VariableImpl.h>
#include <NamespaceSupporter.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"


void SystemProc( const UserProc &userProc ){
	if( userProc.GetName() == "_System_GetEip" ){
		//mov eax,dword ptr[esp]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;

		//ret
		op_ret();
	}
	else if( userProc.GetName() == "_System_InitDllGlobalVariables" ){
		////////////////////////////////////////
		// DLL̃O[öRpC
		////////////////////////////////////////

		extern BOOL bDll;
		if(!bDll){
			//ret
			op_ret();

			return;
		}

		UserProc *pBackUserProc;
		pBackUserProc = &UserProc::CompilingUserProc();
		UserProc::CompileStartForGlobalArea();

		int BackCp;
		BackCp=cp;
		cp=-1;

		extern BOOL bDebugCompile;
		if(bDebugCompile){
			//fobOp̕ϐ`
			DebugVariable();
		}

		//GCp̕ϐ`
		InitGCVariables();

		//_System_StartupProgram̌Ăяo
		extern UserProc *pSub_System_StartupProgram;
		op_call(pSub_System_StartupProgram);

		//NXɑÓIo`
		compiler.GetMeta().GetClasses().InitStaticMember();

		GetGlobalDataForDll();

		UserProc::CompileStartForUserProc( pBackUserProc );
		cp=BackCp;

		//ret
		op_ret();
	}
	else if( userProc.GetName() == "_System_InitStaticLocalVariables" ){
		//ÓI[JIuWFNg̃RXgN^Ăяo

		BOOST_FOREACH( Variable *pVar, globalVars ){
			if(memicmp(pVar->GetName().c_str(),"Static%",7)==0){
				//RXgN^Ăяo
				if( pVar->IsObject() ){

					//G[p
					cp=pVar->source_code_address;

					CallConstructor(
						pVar->GetName().c_str(),
						pVar->GetSubScriptsPtr(),
						*pVar,
						pVar->paramStrForConstructor.c_str());
				}
			}
		}

		//ret
		op_ret();
	}
	else if( userProc.GetName() == "_System_Call_Destructor_of_GlobalObject" ){

		UserProc *pBackUserProc;
		pBackUserProc = &UserProc::CompilingUserProc();
		UserProc::CompileStartForGlobalArea();

		GetLexicalScopes().CallDestructorsOfScopeEnd();

		UserProc::CompileStartForUserProc( pBackUserProc );


		//ret
		op_ret();
	}
	else if( userProc.GetName() == "_System_GetSp" ){
		//mov eax,esp
		op_mov_RR(REG_EAX,REG_ESP);

		//add eax,PTR_SIZE
		op_add_RV8(REG_EAX,PTR_SIZE);

		//ret
		op_ret();
	}
	else if( userProc.GetName() == "_allrem" ){
		//揜Zp̓֐i64rbgΉj
		BYTE Buffer_allrem[]={
			0x53,0x57,0x33,0xFF,0x8B,0x44,0x24,0x10,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x0C,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x10,0x89,0x54,0x24,0x0C,0x8B,0x44,0x24,0x18,0x0B,0xC0,0x7D,0x13,0x8B,0x54,0x24,0x14,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x18,0x89,0x54,0x24,0x14,0x0B,0xC0,0x75,0x1B,0x8B,0x4C,0x24,0x14,0x8B,0x44,0x24,0x10,0x33,0xD2,0xF7,0xF1,0x8B,0x44,0x24,0x0C,0xF7,0xF1,0x8B,0xC2,0x33,0xD2,0x4F,0x79,0x4E,0xEB,0x53,0x8B,0xD8,0x8B,0x4C,0x24,0x14,0x8B,0x54,0x24,0x10,0x8B,0x44,0x24,0x0C,0xD1,0xEB,0xD1,0xD9,0xD1,0xEA,0xD1,0xD8,0x0B,0xDB,0x75,0xF4,0xF7,0xF1,0x8B,0xC8,0xF7,0x64,0x24,0x18,0x91,0xF7,0x64,0x24,0x14,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x10,0x77,0x08,0x72,0x0E,0x3B,0x44,0x24,0x0C,0x76,0x08,0x2B,0x44,0x24,0x14,0x1B,0x54,0x24,0x18,0x2B,0x44,0x24,0x0C,0x1B,0x54,0x24,0x10,0x4F,0x79,0x07,0xF7,0xDA,0xF7,0xD8,0x83,0xDA,0x00,0x5F,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_allrem,178);
		obp+=178;
	}
	else if( userProc.GetName() == "_aullrem" ){
		//揜Zp̓֐i64rbgΉj
		BYTE Buffer_aullrem[]={
			0x53,0x8B,0x44,0x24,0x14,0x0B,0xC0,0x75,0x18,0x8B,0x4C,0x24,0x10,0x8B,
			0x44,0x24,0x0C,0x33,0xD2,0xF7,0xF1,0x8B,0x44,0x24,0x08,0xF7,0xF1,0x8B,
			0xC2,0x33,0xD2,0xEB,0x50,0x8B,0xC8,0x8B,0x5C,0x24,0x10,0x8B,0x54,0x24,
			0x0C,0x8B,0x44,0x24,0x08,0xD1,0xE9,0xD1,0xDB,0xD1,0xEA,0xD1,0xD8,0x0B,
			0xC9,0x75,0xF4,0xF7,0xF3,0x8B,0xC8,0xF7,0x64,0x24,0x14,0x91,0xF7,0x64,
			0x24,0x10,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x0C,0x77,0x08,0x72,0x0E,
			0x3B,0x44,0x24,0x08,0x76,0x08,0x2B,0x44,0x24,0x10,0x1B,0x54,0x24,0x14,
			0x2B,0x44,0x24,0x08,0x1B,0x54,0x24,0x0C,0xF7,0xDA,0xF7,0xD8,0x83,0xDA,
			0x00,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_aullrem,117);
		obp+=117;
	}
	else if( userProc.GetName() == "_allmul" ){
		//Zp̓֐i64rbgΉj
		BYTE Buffer_allmul[]={
			0x8B,0x44,0x24,0x08,0x8B,0x4C,0x24,0x10,0x0B,0xC8,0x8B,0x4C,0x24,0x0C,0x75,0x09,0x8B,0x44,0x24,0x04,0xF7,0xE1,0xC2,0x10,0x00,0x53,0xF7,0xE1,0x8B,0xD8,0x8B,0x44,0x24,0x08,0xF7,0x64,0x24,0x14,0x03,0xD8,0x8B,0x44,0x24,0x08,0xF7,0xE1,0x03,0xD3,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_allmul,52);
		obp+=52;
	}
	else if( userProc.GetName() == "_alldiv" ){
		//Zp̓֐i64rbgΉj
		BYTE Buffer_alldiv[]={
			0x57,0x56,0x53,0x33,0xFF,0x8B,0x44,0x24,0x14,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x10,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x14,0x89,0x54,0x24,0x10,0x8B,0x44,0x24,0x1C,0x0B,0xC0,0x7D,0x14,0x47,0x8B,0x54,0x24,0x18,0xF7,0xD8,0xF7,0xDA,0x83,0xD8,0x00,0x89,0x44,0x24,0x1C,0x89,0x54,0x24,0x18,0x0B,0xC0,0x75,0x18,0x8B,0x4C,0x24,0x18,0x8B,0x44,0x24,0x14,0x33,0xD2,0xF7,0xF1,0x8B,0xD8,0x8B,0x44,0x24,0x10,0xF7,0xF1,0x8B,0xD3,0xEB,0x41,0x8B,0xD8,0x8B,0x4C,0x24,0x18,0x8B,0x54,0x24,0x14,0x8B,0x44,0x24,0x10,0xD1,0xEB,0xD1,0xD9,0xD1,0xEA,0xD1,0xD8,0x0B,0xDB,0x75,0xF4,0xF7,0xF1,0x8B,0xF0,0xF7,0x64,0x24,0x1C,0x8B,0xC8,0x8B,0x44,0x24,0x18,0xF7,0xE6,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x14,0x77,0x08,0x72,0x07,0x3B,0x44,0x24,0x10,0x76,0x01,0x4E,0x33,0xD2,0x8B,0xC6,0x4F,0x75,0x07,0xF7,0xDA,0xF7,0xD8,0x83,0xDA,0x00,0x5B,0x5E,0x5F,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_alldiv,170);
		obp+=170;
	}
	else if( userProc.GetName() == "_aulldiv" ){
		//Zp̓֐i64rbgΉj
		BYTE Buffer_aulldiv[]={
			0x53,0x56,0x8B,0x44,0x24,0x18,0x0B,0xC0,0x75,0x18,0x8B,0x4C,0x24,0x14,
			0x8B,0x44,0x24,0x10,0x33,0xD2,0xF7,0xF1,0x8B,0xD8,0x8B,0x44,0x24,0x0C,
			0xF7,0xF1,0x8B,0xD3,0xEB,0x41,0x8B,0xC8,0x8B,0x5C,0x24,0x14,0x8B,0x54,
			0x24,0x10,0x8B,0x44,0x24,0x0C,0xD1,0xE9,0xD1,0xDB,0xD1,0xEA,0xD1,0xD8,
			0x0B,0xC9,0x75,0xF4,0xF7,0xF3,0x8B,0xF0,0xF7,0x64,0x24,0x18,0x8B,0xC8,
			0x8B,0x44,0x24,0x14,0xF7,0xE6,0x03,0xD1,0x72,0x0E,0x3B,0x54,0x24,0x10,
			0x77,0x08,0x72,0x07,0x3B,0x44,0x24,0x0C,0x76,0x01,0x4E,0x33,0xD2,0x8B,
			0xC6,0x5E,0x5B,0xC2,0x10,0x00
		};

		memcpy(OpBuffer+obp,Buffer_aulldiv,104);
		obp+=104;
	}
	else if( userProc.GetName() == "_allshl" ){
		//荶rbgVtgp̓֐i64rbgΉj
		BYTE Buffer_allshl[]={
			0x80,0xF9,0x40,0x73,0x15,0x80,0xF9,0x20,0x73,0x06,0x0F,0xA5,0xC2,0xD3,0xE0,0xC3,0x8B,0xD0,0x33,0xC0,0x80,0xE1,0x1F,0xD3,0xE2,0xC3,0x33,0xC0,0x33,0xD2,0xC3
		};

		memcpy(OpBuffer+obp,Buffer_allshl,31);
		obp+=31;
	}
	else if( userProc.GetName() == "_allshr" ){
		//ErbgVtgp̓֐i64rbgΉj
		BYTE Buffer_allshr[]={
			0x80,0xF9,0x40,0x73,0x16,0x80,0xF9,0x20,0x73,0x06,0x0F,0xAD,0xD0,0xD3,0xFA,0xC3,0x8B,0xC2,0xC1,0xFA,0x1F,0x80,0xE1,0x1F,0xD3,0xF8,0xC3,0xC1,0xFA,0x1F,0x8B,0xC2,0xC3
		};

		memcpy(OpBuffer+obp,Buffer_allshr,33);
		obp+=33;
	}
	else if( userProc.GetName() == "_aullshr" ){
		//ȂErbgVtgp̓֐i64rbgΉj
		BYTE Buffer_aullshr[]={
			0x80,0xF9,0x40,         //cmp         cl,40h
			0x73,0x15,              //jae         RETZERO (0040d71a)
			0x80,0xF9,0x20,         //cmp         cl,20h
			0x73,0x06,              //jae         MORE32 (0040d710)
			0x0F,0xAD,0xD0,         //shrd        eax,edx,cl
			0xD3,0xEA,              //shr         edx,cl
			0xC3,                   //ret
			//MORE32:
			0x8B,0xC2,              //mov         eax,edx
			0x33,0xD2,              //xor         edx,edx
			0x80,0xE1,0x1F,         //and         cl,1Fh
			0xD3,0xE8,              //shr         eax,cl
			0xC3,                   //ret
			//RETZERO:
			0x33,0xC0,              //xor         eax,eax
			0x33,0xD2,              //xor         edx,edx
			0xC3                    //ret
		};

		memcpy(OpBuffer+obp,Buffer_aullshr,31);
		obp+=31;
	}
	else{
		SetError();
	}
}
void AutoGeneration(UserProc &userProc){
	if( userProc.GetName() == "InitializeUserTypes"
		&& userProc.HasParentClass()
		&& userProc.GetParentClass().GetName() == "_System_TypeBase" ){

			compiler.GetMeta().GetClasses().Compile_System_InitializeUserTypes();
	}
	else if( userProc.GetName() == "RegisterGlobalRoots"
		&& userProc.HasParentClass()
		&& userProc.GetParentClass().GetName() == "_System_CGarbageCollection" ){

			Compile_AddGlobalRootsForGc();
	}
	else{
		SetError();
	}
}

void _compile_proc(UserProc *pUserProc){
	extern char *basbuf;
	extern HANDLE hHeap;
	extern GlobalProc **ppSubHash;
	extern BOOL bDebugCompile;
	int i3,i4,LocalVarSchedule,EspOffsetSchedule,BaseOffset;
	char temporary[VN_SIZE];

	if( pUserProc->IsUsing() == false || pUserProc->IsCompiled() ) return;

	if( pUserProc->localVars.size() ){
		SetError();
		return;
	}

	pUserProc->CompleteCompile();

	extern BOOL bSystemProc;
	if(memcmp(pUserProc->GetName().c_str(),"_System_",8)==0) bSystemProc=1;
	else bSystemProc=0;

	extern BOOL bDebugSupportProc;
	if(memcmp(pUserProc->GetName().c_str(),"_DebugSys_",10)==0){
		if(!bDebugCompile){
			return;
		}
		bDebugSupportProc=1;
	}
	else bDebugSupportProc=0;

	pUserProc->beginOpAddress=obp;

	//RpC̊֐NX
	Smoothie::Temp::pCompilingClass=pUserProc->GetParentClassPtr();

	//RpCX^[gNXǗNXɒǉ
	compiler.GetMeta().GetClasses().StartCompile( pUserProc );

	//RpC̊֐
	UserProc::CompileStartForUserProc( pUserProc );

	// RpC̊֐閼O
	compiler.GetNamespaceSupporter().SetLivingNamespaceScopes( pUserProc->GetNamespaceScopes() );

	// RpC̊֐ImportsĂ閼O
	compiler.GetNamespaceSupporter().SetImportedNamespaces( pUserProc->GetImportedNamespaces() );

	if(pUserProc->IsSystem()){
		////////////////////
		// ֐
		////////////////////

		extern int AllLocalVarSize;
		AllLocalVarSize=0;

		SystemProc(*pUserProc);

		pUserProc->endOpAddress=obp;
		return;
	}

	cp=pUserProc->GetCodePos();
	for(;;cp++){
		if(IsCommandDelimitation(basbuf[cp])) break;
	}
	cp--;

	//[JϐɊւ
	extern int AllLocalVarSize;
	AllLocalVarSize=0;

	//[JϐAhXXPW[
	extern DWORD *pLocalVarAddrSchedule;
	extern int LocalVarAddrScheduleNum;
	pLocalVarAddrSchedule=(DWORD *)HeapAlloc(hHeap,0,1);
	LocalVarAddrScheduleNum=0;

	//p[^p̕ϐf[^l
	for(i3=(int)pUserProc->RealParams().size()-1;i3>=0;i3--){
		Parameter &param = *pUserProc->RealParams()[i3];

		Variable *pVar = new VariableImpl( param.GetVarName(), param, false, param.IsRef() );

		if( param.IsArray() ){
			pVar->SetArray( param.GetSubScriptsPtr() );
		}

		int varSize;
		if( param.IsRef() == false && param.IsStruct() ){
			//\̂ByValp[^
			pVar->ThisIsParameter();
			varSize=PTR_SIZE;
		}
		else{
			if( param.IsArray() == false ){
				varSize = pVar->GetMemorySize();
			}
			else{
				varSize=PTR_SIZE;
			}
		}
		AllLocalVarSize+=varSize;
		pVar->offset=AllLocalVarSize;

		//LVJXR[v
		pVar->ScopeLevel=GetLexicalScopes().GetNowLevel();
		pVar->ScopeStartAddress=GetLexicalScopes().GetStartAddress();
		pVar->bLiving=TRUE;

		pUserProc->localVars.push_back( pVar );
	}

	//This|C^[JItZbglZbg
	extern int LocalVar_ThisPtrOffset;
	LocalVar_ThisPtrOffset=AllLocalVarSize;

	BaseOffset=AllLocalVarSize;

	//retp̃AhXl
	AllLocalVarSize+=sizeof(long);


	///////////////////////
	// R[h

	//sub esp,AllLocalVarSizeiXPW[j
	op_sub_esp(0xFFFFFFFF);
	LocalVarSchedule=obp-sizeof(long);

	//push ebp
	op_push(REG_EBP);

	//mov ebp,esp
	OpBuffer[obp++]=(char)0x8B;
	OpBuffer[obp++]=(char)0xEC;

	//push ebx
	op_push(REG_EBX);

	//push esi
	OpBuffer[obp++]=(char)0x56;

	//push edi
	OpBuffer[obp++]=(char)0x57;

	if( !pUserProc->ReturnType().IsNull() ){
		//߂l݂Ƃ

		const char *temp = pUserProc->GetName().c_str();
		if( temp[0]==1&&temp[1]==ESC_OPERATOR ){
			temp = "_System_ReturnValue";
		}

		if( pUserProc->ReturnType().IsStruct() ){
			//߂lp̍\́il^j̓p[^ňn
		}
		else{
			if( pUserProc->ReturnType().IsObject() ){
				sprintf(temporary,"%s=Nothing%c%c%s",temp,1,ESC_AS, Compiler::TypeToString( pUserProc->ReturnType() ).c_str() );
			}
			else{
				//߂lp̕ϐ̒`
				sprintf(temporary,"%s%c%c%s",temp,1,ESC_AS, Compiler::TypeToString( pUserProc->ReturnType() ).c_str() );
			}

			OpcodeDim(temporary,0);
		}
	}

	//vV[WoXPW[iExit Sub/Functionj
	extern DWORD *pExitSubSchedule;
	extern int ExitSubScheduleNum;
	pExitSubSchedule=(DWORD *)HeapAlloc(hHeap,0,1);
	ExitSubScheduleNum=0;

	//xp̃m
	extern LABEL *pLabelNames;
	extern int MaxLabelNum;
	pLabelNames=(LABEL *)HeapAlloc(hHeap,0,1);
	MaxLabelNum=0;

	//GotoxXPW[
	extern GOTOLABELSCHEDULE *pGotoLabelSchedule;
	extern int GotoLabelScheduleNum;
	pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapAlloc(hHeap,0,1);
	GotoLabelScheduleNum=0;

	//With̃m
	extern WITHINFO WithInfo;
	WithInfo.ppName=(char **)HeapAlloc(hHeap,0,1);
	WithInfo.pWithCp=(int *)HeapAlloc(hHeap,0,1);
	WithInfo.num=0;

	//dG[Ǘ̃m
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	//ContinueAhX
	extern DWORD dwContinueAddress;
	dwContinueAddress=-1;

	if(bDebugCompile&&bDebugSupportProc==0){
		//push dword ptr[ebp+(AllLocalVarSize-BaseOffset)]iXPW[j
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0xB5;
		EspOffsetSchedule=obp;
		obp+=sizeof(long);	

		//push dword ptr[ebp]iȑOebpj
		OpBuffer[obp++]=(char)0xFF;
		OpBuffer[obp++]=(char)0x75;
		OpBuffer[obp++]=(char)0x00;

		//call _DebugSys_StartProc
		extern UserProc *pSub_DebugSys_StartProc;
		op_call(pSub_DebugSys_StartProc);
	}

	if(Smoothie::Temp::pCompilingClass){
		if( pUserProc->GetName() == Smoothie::Temp::pCompilingClass->GetName() ){
			////////////////////////////////////
			// RXgN^RpCƂ
			////////////////////////////////////

			//RXgN^̃RpCJnʒm
			Smoothie::Temp::pCompilingClass->NotifyStartConstructorCompile();

			//NXǂ̎
			//ipC^[tFCX̏ꍇNXƌȂj
			BOOL bThisIsSuperClass;
			if(Smoothie::Temp::pCompilingClass->pobj_InheritsClass==0) bThisIsSuperClass=1;
			else if( Smoothie::Temp::pCompilingClass->pobj_InheritsClass->GetConstructorMethod() == NULL ){
				//C^[tFCXpƂ̓RXgN^Ȃ
				bThisIsSuperClass=1;
			}
			else bThisIsSuperClass=0;

			if(!bThisIsSuperClass){
				/* TuNXRXgN^RpCĂƂ́A
					NX̃RXgN^Ăяo */

				i3=cp+1;
				while(IsCommandDelimitation(basbuf[i3])) i3++;
				for(i4=0;;i3++,i4++){
					if(!IsVariableChar(basbuf[i3])){
						temporary[i4]=0;
						break;
					}
					temporary[i4]=basbuf[i3];
				}
				if( Smoothie::Temp::pCompilingClass->pobj_InheritsClass->GetName() == temporary ){
					//NX̃RXgN^Ăяo
					cp=i3;
					for(i4=0;;cp++,i4++){
						if(IsCommandDelimitation(basbuf[cp])){
							temporary[i4]=0;
							break;
						}
						temporary[i4]=basbuf[cp];
					}
					if(!(temporary[0]=='('&&temporary[lstrlen(temporary)-1]==')')){
						SetError(1,NULL,cp);
					}
					RemoveStringPare(temporary);

					Type dummyType;
					CallProc( PROC_DEFAULT
						, Smoothie::Temp::pCompilingClass->pobj_InheritsClass->GetConstructorMethod()->pUserProc
						, Smoothie::Temp::pCompilingClass->pobj_InheritsClass->GetConstructorMethod()->pUserProc->GetName().c_str()
						, temporary
						, dummyType );
				}
				else{
					//NX̃RXgN^ÖٓIɌĂяo
					Opcode_CallProc("",
						Smoothie::Temp::pCompilingClass->pobj_InheritsClass->GetConstructorMethod()->pUserProc,
						0,
						"",
						0);
				}
			}

			//z֐e[u
			if( Smoothie::Temp::pCompilingClass->IsExistVirtualFunctions()
				&& !Smoothie::Temp::pCompilingClass->IsAbstract() ){
					//֐e[uɒlZbg
					int offset = (int)Smoothie::Temp::pCompilingClass->GetVtblGlobalOffset();

					//mov eax,offset
					OpBuffer[obp++]=(char)0xB8;
					*((long *)(OpBuffer+obp))=offset;
					pobj_DataTableSchedule->add();
					obp+=sizeof(long);

					//This|C^ecxɃRs[
					SetThisPtrToReg(REG_ECX);

					//mov dword ptr[ecx],eax
					OpBuffer[obp++]=(char)0x89;
					OpBuffer[obp++]=(char)0x01;
			}
		}
		else if( pUserProc->IsDestructor() ){
			//fXgN^RpCƂ

			//fXgN^̃RpCJnʒm
			Smoothie::Temp::pCompilingClass->NotifyStartDestructorCompile();
		}
	}

	//////////////////////////////////////////
	//////////////////////////////////////////
	////// vV[WRpC ////////
	if( pUserProc->IsAutoGeneration() ){
		AutoGeneration( *pUserProc );
	}
	else{
		if(pUserProc->IsMacro()){
			CompileBuffer(ESC_ENDMACRO,0);
		}
		else{
			if(pUserProc->IsSub()){
				CompileBuffer(ESC_ENDSUB,0);
			}
			else if(pUserProc->IsFunction()){
				CompileBuffer(ESC_ENDFUNCTION,0);
			}
		}
	}
	//////////////////////////////////////////
	//////////////////////////////////////////

	if( Smoothie::Temp::pCompilingClass ){

		if( Smoothie::Temp::pCompilingClass->IsCompilingConstructor() ){
			// RXgN^RpCĂƂ

			// RXgN^̃RpCƂʒm
			Smoothie::Temp::pCompilingClass->NotifyFinishConstructorCompile();
		}
		else if( pUserProc->IsDestructor() ){
			////////////////////////////////////
			//fXgN^RpCƂ
			////////////////////////////////////

			// fXgN^̃RpCƂʒm
			Smoothie::Temp::pCompilingClass->NotifyFinishDestructorCompile();

			if(Smoothie::Temp::pCompilingClass->pobj_InheritsClass){
				/* TuNX̃fXgN^RpCĂƂ́A
					NX̃fXgN^Ăяo */

				const CMethod *method = Smoothie::Temp::pCompilingClass->pobj_InheritsClass->GetDestructorMethod();
				if( method ){
					Opcode_CallProc("",
						method->pUserProc,
						0,
						"",
						0);
				}
			}
		}
	}

	//xp̃
	for(i3=0;i3<MaxLabelNum;i3++){
		if(pLabelNames[i3].pName) HeapDefaultFree(pLabelNames[i3].pName);
	}
	HeapDefaultFree(pLabelNames);

	//GotomxXPW[
	for(i3=0;i3<GotoLabelScheduleNum;i3++){
		if(pGotoLabelSchedule[i3].pName){
			SetError(6,pGotoLabelSchedule[i3].pName,pGotoLabelSchedule[i3].now_cp);
			HeapDefaultFree(pGotoLabelSchedule[i3].pName);
		}
		else{
			sprintf(temporary,"%d",pGotoLabelSchedule[i3].line);
			SetError(6,temporary,pGotoLabelSchedule[i3].now_cp);
		}
	}
	HeapDefaultFree(pGotoLabelSchedule);

	//With̃
	for(i3=0;i3<WithInfo.num;i3++){
		SetError(22,"With",WithInfo.pWithCp[i3]);
		HeapDefaultFree(WithInfo.ppName[i3]);
	}
	HeapDefaultFree(WithInfo.ppName);
	HeapDefaultFree(WithInfo.pWithCp);

	//push ebp
	AllLocalVarSize+=sizeof(long);

	//[JIuWFNg̉
	GetLexicalScopes().CallDestructorsOfScopeEnd();

	//vV[WoXPW[iExit Sub/Functionj
	for(i3=0;i3<ExitSubScheduleNum;i3++){
		*((long *)(OpBuffer+pExitSubSchedule[i3]))=obp-(pExitSubSchedule[i3]+sizeof(long));
	}
	HeapDefaultFree(pExitSubSchedule);

	if(bDebugCompile&&bDebugSupportProc==0){
		*((long *)(OpBuffer+EspOffsetSchedule))=AllLocalVarSize-BaseOffset-sizeof(long);

		//call _DebugSys_EndProc
		extern UserProc *pSub_DebugSys_EndProc;
		op_call(pSub_DebugSys_EndProc);
	}

	if( !pUserProc->ReturnType().IsNull() ){
		//߂leaxAedxɐݒ
		RELATIVE_VAR RelativeVar;

		const char *temp = pUserProc->GetName().c_str();
		if( temp[0]==1 && temp[1]==ESC_OPERATOR ){
			temp="_System_ReturnValue";
		}
		GetVarOffsetReadWrite(temp,&RelativeVar,Type());

		i3=pUserProc->ReturnType().GetBasicType();

		if(i3==DEF_OBJECT || i3==DEF_STRUCT){
			SetVarPtrToEax(&RelativeVar);
			if( i3==DEF_OBJECT ){
				//mov eax,dword ptr[eax]
				op_mov_RM( sizeof(long), REG_EAX, REG_EAX, 0, MOD_BASE );
			}
		}
		else if(i3==DEF_DOUBLE){
			//fld qword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0xDD;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=RelativeVar.offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else if(i3==DEF_SINGLE){
			//fld dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=RelativeVar.offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else if(i3==DEF_INT64||i3==DEF_QWORD){
			//mov eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=RelativeVar.offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov edx,dword ptr[ebp+offset+sizeof(long)]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x95;
			*((long *)(OpBuffer+obp))=RelativeVar.offset+sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else if(i3==DEF_LONG||i3==DEF_DWORD||
			IsPtrType(i3)){
			//mov eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=RelativeVar.offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else if(i3==DEF_INTEGER||i3==DEF_WORD || (Smoothie::IsUnicode()&&i3==DEF_CHAR)){
			//xor eax,eaxieax0ɏj
			op_zero_reg(REG_EAX);

			//mov ax,word ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=RelativeVar.offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else if(i3==DEF_SBYTE||i3==DEF_BYTE||i3==DEF_BOOLEAN || (Smoothie::IsUnicode()==false&&i3==DEF_CHAR)){
			//xor eax,eaxieax0ɏj
			op_zero_reg(REG_EAX);

			//mov al,byte ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8A;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=RelativeVar.offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}

	//[JϐAhXXPW[
	for(i3=0;i3<LocalVarAddrScheduleNum;i3++){
		*((long *)(OpBuffer+pLocalVarAddrSchedule[i3]))+=AllLocalVarSize;
	}
	HeapDefaultFree(pLocalVarAddrSchedule);
	BOOST_FOREACH( Variable *pVar, pUserProc->localVars ){
		//ɃfobOŗp
		pVar->offset = AllLocalVarSize - pVar->offset;
	}

	//push ebpAretp̃AhXl
	AllLocalVarSize-=sizeof(long)*2;

	//[Jϐpmۂ邽߂̃XPW[isubR}hj
	*((long *)(OpBuffer+LocalVarSchedule))=AllLocalVarSize-BaseOffset;

	//pop edi
	OpBuffer[obp++]=(char)0x5F;

	//pop esi
	OpBuffer[obp++]=(char)0x5E;

	//pop ebx
	op_pop(REG_EBX);

	if(bDebugCompile){
		//cmp esp,ebp
		op_cmp_RR( REG_ESP, REG_EBP );

		//jz 6icallbreakpointщzj
		OpBuffer[obp++]=(char)0x74;
		OpBuffer[obp++]=(char)0x06;

		//call _esp_error
		extern UserProc *pSub_esp_error;
		op_call( pSub_esp_error );

		breakpoint;
	}

	//mov esp,ebp
	OpBuffer[obp++]=(char)0x8B;
	OpBuffer[obp++]=(char)0xE5;

	//pop ebp
	op_pop(REG_EBP);

	//add esp AllLocalVarSize
	op_add_esp(AllLocalVarSize-BaseOffset);

	if( BaseOffset==0 || pUserProc->IsCdecl() ){
		//ret
		op_ret();
	}
	else{
		//ret BaseOffsetip[^̃X^bN̈j
		OpBuffer[obp++]=(char)0xC2;
		*((_int16 *)(OpBuffer+obp))=(_int16)BaseOffset;
		obp+=sizeof(_int16);
	}


	pUserProc->endOpAddress=obp;


	//dG[Ǘ̃
	for(i3=0;i3<SynonymErrorNum;i3++) HeapDefaultFree(SynonymErrorWords[i3]);
	HeapDefaultFree(SynonymErrorWords);
	SynonymErrorWords=0;


	//[Jϐ̃l[͌ɉ
}

void CompileBufferInProcedure( UserProc &userProc ){
	if( userProc.IsUsing() == false || userProc.IsCompiled() ) return;

	_compile_proc( &userProc );
/*
	// O𗚂
	char temporary[8192];
	temporary[0]=0;
	lstrcat( temporary, "------------------------------------------------------------------\n" );
	sprintf( temporary + lstrlen(temporary), "y %s ̃R[hz\n", userProc.GetFullName().c_str() );
	sprintf( temporary + lstrlen(temporary), "code size: %d bytes\n", userProc.GetCodeSize() );
	lstrcat( temporary, "------------------------------------------------------------------\n" );
	lstrcat( temporary, "\n" );
	Smoothie::Logger::Put( temporary );*/
}
void CompileLocal(){
	extern GlobalProc **ppSubHash;
	int i2;

	extern BOOL bDll;
	if(bDll){
		//DLL̏ꍇ̓O[oϐ邽߂̊֐ԏ߂ɃRpC
		UserProc *pUserProc=GetSubHash("_System_InitDllGlobalVariables");
		if(pUserProc){
			CompileBufferInProcedure( *pUserProc );
		}
		else SetError(300,NULL,cp);
	}

	//_System_TypeBase_InitializeUserTypes͈ԍŌɃRpC
	extern UserProc *pSubStaticMethod_System_TypeBase_InitializeUserTypes;
	pSubStaticMethod_System_TypeBase_InitializeUserTypes->CompleteCompile();

	//_System_InitStaticLocalVariables͈ԍŌɃRpC
	//ʊ֐̐ÓIϐIuWFNgׂĎWȂ΂ȂȂ
	extern UserProc *pSub_System_InitStaticLocalVariables;
	pSub_System_InitStaticLocalVariables->CompleteCompile();

	//_System_Call_Destructor_of_GlobalObject͈ԍŌɃRpC
	extern UserProc *pSub_System_Call_Destructor_of_GlobalObject;
	pSub_System_Call_Destructor_of_GlobalObject->CompleteCompile();

repeat:
	GlobalProc *pGlobalProc;
	for(i2=0;i2<MAX_HASH;i2++){
		pGlobalProc=ppSubHash[i2];
		while(pGlobalProc){
			CompileBufferInProcedure( *pGlobalProc );
			pGlobalProc=pGlobalProc->pNextData;
		}
	}

	if( IsNeedProcCompile() ){
		//vV[WRpCɂāAvV[WRpCKvɂȂꍇ
		goto repeat;
	}

	//_System_TypeBase_InitializeUserTypes͍Ō̂قŃRpC
	pSubStaticMethod_System_TypeBase_InitializeUserTypes->KillCompileStatus();
	CompileBufferInProcedure( *pSubStaticMethod_System_TypeBase_InitializeUserTypes );

	if( IsNeedProcCompile() ){
		//vV[WRpCɂāAvV[WRpCKvɂȂꍇ
		for(i2=0;i2<MAX_HASH;i2++){
			pGlobalProc=ppSubHash[i2];
			while(pGlobalProc){
				CompileBufferInProcedure( *pGlobalProc );
				pGlobalProc=pGlobalProc->pNextData;
			}
		}
	}

	//_System_InitStaticLocalVariables͈ԍŌɃRpC
	pSub_System_InitStaticLocalVariables->KillCompileStatus();
	CompileBufferInProcedure( *pSub_System_InitStaticLocalVariables );

	//_System_Call_Destructor_of_GlobalObject͈ԍŌɃRpC
	pSub_System_Call_Destructor_of_GlobalObject->KillCompileStatus();
	CompileBufferInProcedure( *pSub_System_Call_Destructor_of_GlobalObject );
}
