#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <LexicalScopingImpl.h>
#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void OpcodeOthers(const char *Command){
	int i,i2;
	UserProc *pUserProc;

	char leftTerm[8192];
	int lastParePos = 0;
	for(i=0;;i++){
		if(Command[i]=='\"'){
			//_uNH[g͕sȂ̂ŃG[
			leftTerm[i]=0;
			SetError(3,leftTerm,cp);
			return;
		}

		if(Command[i]=='('){
			lastParePos = i;
			i2=GetStringInPare(leftTerm+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='['){
			i2=GetStringInBracket(leftTerm+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='\0'){
			leftTerm[i] = 0;
			break;
		}

		if( IsNumCalcMark( Command, i ) ){
			leftTerm[i] = 0;
			break;
		}

		leftTerm[i]=Command[i];
	}
	if(!(
		IsVariableTopChar(leftTerm[0])||
		leftTerm[0]=='.'||
		(leftTerm[0]==1&&leftTerm[1]==ESC_PSMEM)
		)){
		SetError(1,NULL,cp);
		return;
	}


	if(Command[i]=='\0' && lastParePos == 0){
		//////////////////////////////
		// p[^̃}N
		//////////////////////////////

		pUserProc=GetSubHash(Command);

		//GetSubHashŃG[񎦂sꂽꍇ
		if(pUserProc==(UserProc *)-1) return;

		if(pUserProc==0){
			char temporary[VN_SIZE];
			lstrcpy(temporary,Command);

			CharUpper(temporary);
			pUserProc=GetSubHash(temporary);

			//GetSubHashŃG[񎦂sꂽꍇ
			if(pUserProc==(UserProc *)-1) return;
		}

		if(pUserProc){
			if( !pUserProc->IsMacro() ){
				SetError(10,Command,cp);
			}

			Opcode_CallProc("",pUserProc,0,"",0);

			return;
		}
	}
	else if(IsNumCalcMark(Command,i)){
		//Z
		OpcodeCalc(Command);
		return;
	}

	if( pobj_reg ){
		SetError();
	}
	pobj_reg=new CRegister(REG_RAX);

	Type resultType;
	bool isLiteral;
	BOOL bUseHeap;
	bool result = TermOpe( leftTerm, Type(), resultType, isLiteral, &bUseHeap, false, NULL, true );

	delete pobj_reg;
	pobj_reg = NULL;

	if( result ){

		/////////////////////
		// ߂l̏
		/////////////////////

		if( resultType.IsStruct() ){
			//mov r14,rax
			op_mov_RR(REG_R14,REG_RAX);

			FreeTempObject(REG_R14,&resultType.GetClass());
		}

		//
		return;
	}

	// s
	SetError(1, NULL,cp);
}

void Judgment(char *buffer){
	int reg=REG_RAX;
	Type resultType;
	if( !NumOpe(&reg,buffer,Type(),resultType) ){
		return;
	}

	int offset;

	if(resultType.IsDouble()){
		double dbl=0;
		offset=compiler.GetNativeCode().GetDataTable().Add( dbl );

		//comisd xmm0,qword ptr[data table offset]
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0x2F;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=offset;
		pobj_DataTableSchedule->add();
		obp+=sizeof(long);
	}
	else if(resultType.IsSingle()){
		float flt=0;
		offset=compiler.GetNativeCode().GetDataTable().Add( flt );

		//comiss xmm0,dword ptr[data table offset]
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0x2F;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=offset;
		pobj_DataTableSchedule->add();
		obp+=sizeof(long);
	}
	else{
		//^

		//cmp rax,0
		op_cmp_value(resultType.GetSize(),REG_RAX,0);
	}
}

void OpcodeIf(char *Parameter){
	int i,i2,i3;

	for(i=0;;i++){
		if(Parameter[i]=='\0'){
			SetError(21,NULL,cp);
			return;
		}
		if(Parameter[i]==1&&Parameter[i+1]==ESC_THEN){
			Parameter[i]=0;
			break;
		}
	}

	//sătOZbg
	Judgment(Parameter);

	//je (endifA܂ else ܂ŏWv)
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x84;
	obp+=sizeof(long);

	//je̔Ԓn
	i3=obp;


	/////////////////////////
	// IfR[h
	/////////////////////////

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_IF );

	i2=CompileBuffer(ESC_ENDIF,0);

	//LVJXR[vx_E
	GetLexicalScopes().End();


	if(i2==ESC_ELSE){
		//jmp (endif܂)
		OpBuffer[obp++]=(char)0xE9;
		obp+=sizeof(long);

		*((long *)(OpBuffer+i3-sizeof(long)))=obp-i3;	//ifelseւ̃WṽItZbgl

		i3=obp;


		/////////////////////////
		// ElseR[h
		/////////////////////////

		//LVJXR[vxAbv
		GetLexicalScopes().Start( obp, SCOPE_TYPE_IF );

		CompileBuffer(ESC_ENDIF,0);

		//LVJXR[vx_E
		GetLexicalScopes().End();


		*((long *)(OpBuffer+i3-sizeof(long)))=obp-i3;	//jmpWṽItZbgl
	}
	else{
		*((long *)(OpBuffer+i3-sizeof(long)))=obp-i3;	//jeWṽItZbgl
	}
}

int GetLabelAddress(char *LabelName,int LineNum){
	extern int MaxLabelNum;
	extern LABEL *pLabelNames;
	int i;

	if(LabelName){
		for(i=0;i<MaxLabelNum;i++){
			if(pLabelNames[i].pName){
				if(lstrcmp(LabelName,pLabelNames[i].pName)==0) return pLabelNames[i].address;
			}
		}
	}
	else{
		for(i=0;i<MaxLabelNum;i++){
			if(pLabelNames[i].pName==0){
				if(LineNum==pLabelNames[i].line) return pLabelNames[i].address;
			}
		}
	}
	return -1;
}
void OpcodeGoto(char *Parameter){
	extern HANDLE hHeap;
	extern GOTOLABELSCHEDULE *pGotoLabelSchedule;
	extern int GotoLabelScheduleNum;
	int i,LineNum;

	if(Parameter[0]=='*'){
		i=GetLabelAddress(Parameter+1,0);

		//jmp ...
		OpBuffer[obp++]=(char)0xE9;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=(char *)HeapAlloc(hHeap,0,lstrlen(Parameter+1)+1);
			lstrcpy(pGotoLabelSchedule[GotoLabelScheduleNum].pName,Parameter+1);
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}
	else{
		LineNum=atoi(Parameter);
		i=GetLabelAddress(0,LineNum);

		//jmp ...
		OpBuffer[obp++]=(char)0xE9;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=0;
			pGotoLabelSchedule[GotoLabelScheduleNum].line=LineNum;
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}
}
void OpcodeWhile(char *Parameter){
	extern HANDLE hHeap;

	//ContinueAhX̃obNAbvƃZbg
	extern DWORD dwContinueAddress;
	DWORD dwTempContinue;
	dwTempContinue=dwContinueAddress;
	dwContinueAddress=obp;
	pobj_TempSchedule->lock((int *)&dwTempContinue);
	pobj_TempSchedule->lock((int *)&dwContinueAddress);

	if(!Parameter[0]) SetError(10,"While",cp);

	//sătOZbg
	Judgment(Parameter);

	//je (Wend ܂)
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x84;
	obp+=sizeof(long);

	//s̔Ԓn
	int je_schedule=obp;
	pobj_TempSchedule->lock(&je_schedule);

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_WHILE );

	//WhileRpC
	CompileBuffer(0,COM_WEND);

	GetLexicalScopes().CallDestructorsOfScopeEnd();

	//jmp ...
	OpBuffer[obp++]=(char)0xE9;
	*((long *)(OpBuffer+obp))=dwContinueAddress-(obp+sizeof(long));
	obp+=sizeof(long);
	pobj_TempSchedule->unlock();
	pobj_TempSchedule->unlock();

	//LVJXR[vx_E
	GetLexicalScopes().End();

	*((long *)(OpBuffer+je_schedule-sizeof(long)))=obp-je_schedule;	//jeWṽItZbgl
	pobj_TempSchedule->unlock();

	//ContinueAhX𕜌
	dwContinueAddress=dwTempContinue;
}

char szNextVariable[VN_SIZE];
void OpcodeFor(char *Parameter){
	extern HANDLE hHeap;
	Type resultType;
	int i,i2,i3;
	char temporary[VN_SIZE],variable[VN_SIZE],JudgeNum[VN_SIZE],StepNum[VN_SIZE];
	bool isError = false;

	//Pp[^擾
	i=GetOneParameter(Parameter,0,temporary);
	if(!Parameter[i]){
		SetError(12,"For",cp);
		isError = true;
		goto ErrorStep;
	}

	for(i2=0;;i2++){
		if(temporary[i2]=='='){
			variable[i2]=0;

			//JE^
			OpcodeCalc(temporary);
			break;
		}
		if(temporary[i2]=='\0'){
			SetError(12,"For",cp);
			isError = true;
			goto ErrorStep;
		}
		variable[i2]=temporary[i2];
	}

	//jmp ...
	OpBuffer[obp++]=(char)0xE9;
	i2=obp;
	obp+=sizeof(long);

	//ContinueAhX̃obNAbvƃZbg
	extern DWORD dwContinueAddress;
	DWORD dwTempContinue;
	dwTempContinue=dwContinueAddress;
	dwContinueAddress=obp;
	pobj_TempSchedule->lock((int *)&dwTempContinue);
	pobj_TempSchedule->lock((int *)&dwContinueAddress);

	//Qp[^擾ito`j
	i=GetOneParameter(Parameter,i,JudgeNum);

	//Rp[^擾istep`j
	if(Parameter[i]){
		i=GetOneParameter(Parameter,i,StepNum);
		if(Parameter[i]) SetError(12,"For",cp);
	}
	else lstrcpy(StepNum,"1");

	//JE^𑝉
	sprintf(temporary,"%s=(%s)+(%s)",variable,variable,StepNum);
	OpcodeCalc(temporary);

	*((long *)(OpBuffer+i2))=obp-(i2+sizeof(long));

	//ʂ
	sprintf(temporary,"(%s)>=0",StepNum);

	int reg;
	reg=REG_RAX;
	if( !NumOpe(&reg,temporary,Type(),resultType) ){
		return;
	}

	//cmp rax,0
	op_cmp_value(resultType.GetSize(),REG_RAX,0);

	//je [JE^̏ꍇ̔]
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x84;
	i2=obp;
	obp+=sizeof(long);

	//iJE^̏ꍇj
	sprintf(temporary,"%s<=(%s)",variable,JudgeNum);

	reg=REG_RAX;
	NumOpe(&reg,temporary,Type(),Type());

	//jmp [JE^̏ꍇ̔щz]
	OpBuffer[obp++]=(char)0xE9;
	i3=obp;
	obp+=sizeof(long);

	*((long *)(OpBuffer+i2))=obp-(i2+sizeof(long)); //jeWṽItZbgl

	//iJE^̏ꍇj
	sprintf(temporary,"%s>=(%s)",variable,JudgeNum);

	reg=REG_RAX;
	NumOpe(&reg,temporary,Type(),resultType);

	*((long *)(OpBuffer+i3))=obp-(i3+sizeof(long)); //jmpWṽItZbgl

	//cmp rax,0
	op_cmp_value(resultType.GetSize(),REG_RAX,0);

ErrorStep:

	//je ...
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x84;
	int je_schedule=obp;
	obp+=sizeof(long);
	pobj_TempSchedule->lock(&je_schedule);

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_FOR );

	//ForRpC
	CompileBuffer(0,COM_NEXT);

	GetLexicalScopes().CallDestructorsOfScopeEnd();

	if(szNextVariable[0]){
		if(lstrcmp(szNextVariable,variable)!=0){
			SetError(55,szNextVariable,cp);
		}
	}

	//jmp ...
	OpBuffer[obp++]=(char)0xE9;
	*((long *)(OpBuffer+obp))=dwContinueAddress-(obp+sizeof(long));
	obp+=sizeof(long);
	if( isError == false ){
		pobj_TempSchedule->unlock();
		pobj_TempSchedule->unlock();
	}

	//LVJXR[vx_E
	GetLexicalScopes().End();

	*((long *)(OpBuffer+je_schedule))=obp-(je_schedule+sizeof(long)); //jeWṽItZbgl
	pobj_TempSchedule->unlock();

	//ContinueAhX𕜌
	dwContinueAddress=dwTempContinue;
}

void OpcodeDo(char *Parameter){
	extern HANDLE hHeap;
	int i,i2,i3;

	if(Parameter[0]) SetError(10,"Do",cp);

	//ContinueAhX̃obNAbvƃZbg
	extern DWORD dwContinueAddress;
	DWORD dwTempContinue;
	dwTempContinue=dwContinueAddress;
	dwContinueAddress=obp;
	pobj_TempSchedule->lock((int *)&dwTempContinue);
	pobj_TempSchedule->lock((int *)&dwContinueAddress);

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_DO );

	//DoRpC
	CompileBuffer(0,COM_LOOP);

	GetLexicalScopes().CallDestructorsOfScopeEnd();

	extern char *basbuf;
	char temporary[VN_SIZE];
	for(i=cp-1;;i--){
		if(IsCommandDelimitation(basbuf[i])){
			i+=3;
			if(!(basbuf[i]=='0'||basbuf[i]=='1')){
				//[v
				break;
			}
			i3=i;

			for(i+=2,i2=0;;i++,i2++){
				if(IsCommandDelimitation(basbuf[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}

			//sătOZbg
			Judgment(temporary);

			if(basbuf[i3]=='0'){
				//While

				//je 5i[vIj
				OpBuffer[obp++]=(char)0x74;
				OpBuffer[obp++]=(char)0x05;
			}
			else if(basbuf[i3]=='1'){
				//Until

				//jne 5i[vIj
				OpBuffer[obp++]=(char)0x75;
				OpBuffer[obp++]=(char)0x05;
			}
			break;
		}
	}

	//jmp ...
	OpBuffer[obp++]=(char)0xE9;
	*((long *)(OpBuffer+obp))=dwContinueAddress-(obp+sizeof(long));
	obp+=sizeof(long);
	pobj_TempSchedule->unlock();
	pobj_TempSchedule->unlock();

	//jmp ...
	OpBuffer[obp++]=(char)0xE9;
	int je_schedule=obp;
	obp+=sizeof(long);
	pobj_TempSchedule->lock(&je_schedule);

	//LVJXR[vx_E
	GetLexicalScopes().End();

	*((long *)(OpBuffer+je_schedule))=obp-(je_schedule+sizeof(long)); //jmpWṽItZbgl
	pobj_TempSchedule->unlock();

	//ContinueAhX𕜌
	dwContinueAddress=dwTempContinue;
}
void OpcodeContinue(void){
	extern DWORD dwContinueAddress;

	if(dwContinueAddress==-1){
		SetError(12,"Continue",cp);
		return;
	}

	//jmp ...(Continue addr)
	OpBuffer[obp++]=(char)0xE9;

	*((long *)(OpBuffer+obp))=dwContinueAddress-(obp+sizeof(long));
	obp+=sizeof(long);
}

void OpcodeExitSub(void){
	extern DWORD *pExitSubSchedule;
	extern int ExitSubScheduleNum;
	extern HANDLE hHeap;

	if( UserProc::IsGlobalAreaCompiling() ){
		SetError(12,"Exit Sub/Function",cp);
		return;
	}

	//̃[JIuWFNg̃fXgN^Ăяo
	GetLexicalScopes().CallDestructorsOfReturn();

	//jmp ...(End Sub/Function)
	OpBuffer[obp++]=(char)0xE9;

	pExitSubSchedule=(DWORD *)HeapReAlloc(hHeap,0,pExitSubSchedule,(ExitSubScheduleNum+1)*sizeof(DWORD));
	pExitSubSchedule[ExitSubScheduleNum]=obp;
	ExitSubScheduleNum++;

	obp+=sizeof(long);
}

void AddCaseSchedule(void){
	extern DWORD *pCaseSchedule;
	extern int CaseScheduleNum;
	extern HANDLE hHeap;

	pCaseSchedule=(DWORD *)HeapReAlloc(hHeap,0,pCaseSchedule,(CaseScheduleNum+1)*sizeof(DWORD));
	pCaseSchedule[CaseScheduleNum]=obp;
	CaseScheduleNum++;
}
void OpcodeSelect( const char *lpszParms ){
	extern DWORD *pCaseSchedule;
	extern int CaseScheduleNum;
	extern int NowCaseSchedule;
	extern HANDLE hHeap;
	extern char *basbuf;
	int i,i2,i3,NowCaseCp;
	char temporary[VN_SIZE];

	DWORD *temp_pCaseSchedule;
	int temp_CaseScheduleNum;
	int temp_NowCaseSchedule;

	temp_pCaseSchedule=pCaseSchedule;
	temp_CaseScheduleNum=CaseScheduleNum;
	temp_NowCaseSchedule=NowCaseSchedule;
	pCaseSchedule=(DWORD *)HeapAlloc(hHeap,0,1);
	CaseScheduleNum=0;
	NowCaseSchedule=0;

	int reg1=REG_RAX;
	Type type1;
	if( !NumOpe(&reg1,lpszParms,Type(), type1 ) ){
		return;
	}

	if(type1.IsDouble()){
		//movsd qword ptr[rsp+offset],xmm_reg		X^bNt[𗘗p
		pobj_sf->push(reg1,sizeof(double));
	}
	else if(type1.IsSingle()){
		//movss dword ptr[rsp+offset],xmm_reg		X^bNt[𗘗p
		pobj_sf->push(reg1,sizeof(float));
	}
	else{
		ExtendTypeTo64(type1.GetBasicType(),reg1);

		//mov qword ptr[rsp+offset],reg     X^bNt[𗘗p
		pobj_sf->push(reg1);
	}

	for(i=cp;;i++){
		if(basbuf[i]=='\0'){
			HeapDefaultFree(pCaseSchedule);
			pCaseSchedule=temp_pCaseSchedule;
			CaseScheduleNum=temp_CaseScheduleNum;
			NowCaseSchedule=temp_NowCaseSchedule;
			SetError(22,"Select",cp);
			return;
		}
		if(basbuf[i]==1&&basbuf[i+1]==ESC_SELECTCASE){
			for(i2=0;;i++){
				if(basbuf[i]==1&&basbuf[i+1]==ESC_SELECTCASE) i2++;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_ENDSELECT){
					i2--;
					if(i2==0) break;
				}
			}
			continue;
		}
		if(basbuf[i]==1&&basbuf[i+1]==ESC_ENDSELECT) break;

		if(basbuf[i]==1&&basbuf[i+1]==ESC_CASE){
			NowCaseCp=i;

			i++;
			while(1){
				for(i++,i2=0;;i++,i2++){
					if(basbuf[i]=='\"'){
						i3=GetStringInQuotation(temporary+i2,basbuf+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}
					if(basbuf[i]=='('){
						i3=GetStringInPare(temporary+i2,basbuf+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}
					if(basbuf[i]=='['){
						i3=GetStringInBracket(temporary+i2,basbuf+i);
						i+=i3-1;
						i2+=i3-1;
						continue;
					}

					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					if(basbuf[i]==','){
						temporary[i2]=0;
						break;
					}

					temporary[i2]=basbuf[i];
				}

				//G[p
				i2=cp;
				cp=NowCaseCp;

				int reg2=REG_RDX;
				Type type2;
				if( !NumOpe(&reg2,temporary,type1,type2) ){
					return;
				}

				cp=i2;

				if(type1.IsObject()){
					std::vector<UserProc *> subs;
					type1.GetClass().GetMethods().Enum( CALC_EQUAL, subs );
					if( subs.size() == 0 ){
						return;
					}

					Parameters params;
					params.push_back( new Parameter( "", Type( type2 ) ) );

					//I[o[[h
					UserProc *pUserProc;
					pUserProc=OverloadSolution("==",subs, params, NULL);

					delete params[0];

					if(!pUserProc){
						//G[
						return;
					}


					//̃IuWFNg
					if(reg2!=REG_RDX){
						//mov rdx,reg2
						op_mov_RR(REG_RDX,reg2);
					}

					//mov rcx,qword ptr[rsp+offset]		X^bNt[Q
					pobj_sf->ref(REG_RCX);

					//call operator_proc	 ==Zq
					op_call(pUserProc);

					//test rax,rax
					op_test(REG_RAX,REG_RAX);

					//jne ...
					OpBuffer[obp++]=(char)0x0F;
					OpBuffer[obp++]=(char)0x85;
				}
				else{
					if(type1.IsDouble()){
						int xmm_reg;
						if(IsXmmReg(reg2)) xmm_reg=reg2;
						else xmm_reg=REG_XMM5;
						ChangeTypeToXmm_Double(type2.GetBasicType(),xmm_reg,reg2);

						//movsd xmm4,qword ptr[rsp+offset]	X^bNt[Q
						pobj_sf->ref(REG_XMM4,sizeof(double));

						//comiss xmm_reg1,xmm_reg2
						op_comisd(xmm_reg,REG_XMM4);
					}
					else if(type1.IsSingle()){
						int xmm_reg;
						if(IsXmmReg(reg2)) xmm_reg=reg2;
						else xmm_reg=REG_XMM5;
						ChangeTypeToXmm_Single(type2.GetBasicType(),xmm_reg,reg2);

						//movss xmm4,dword ptr[rsp+offset]	X^bNt[Q
						pobj_sf->ref(REG_XMM4,sizeof(float));

						//comiss xmm_reg1,xmm_reg2
						op_comiss(xmm_reg,REG_XMM4);
					}
					else{
						//̑^

						i2=NeutralizationType(type1.GetBasicType(),-1,type2.GetBasicType(),-1);

						//mov r14,qword ptr[rsp+offset]		X^bNt[Q
						pobj_sf->ref(REG_R14);

						//cmp reg2,r14
						op_cmp_reg(GetTypeSize(i2,-1),reg2,REG_R14);
					}

					//je ...
					OpBuffer[obp++]=(char)0x0F;
					OpBuffer[obp++]=(char)0x84;
				}
				AddCaseSchedule();
				obp+=sizeof(long);

				if(basbuf[i]!=',') break;
			}
		}
		if(basbuf[i]==1&&basbuf[i+1]==ESC_CASEELSE){
			//jmp ...
			OpBuffer[obp++]=(char)0xE9;
			AddCaseSchedule();
			obp+=sizeof(long);
		}
	}

	//X^bNt[1Xy[X
	pobj_sf->pop(REG_NON);

	//LVJXR[vxAbv
	GetLexicalScopes().Start( obp, SCOPE_TYPE_SELECT );

	//Select CaseRpC
	CompileBuffer(ESC_ENDSELECT,0);

	//jmp EndSelect
	OpBuffer[obp++]=(char)0xE9;
	AddCaseSchedule();
	obp+=sizeof(long);

	//ŏIXPW[
	for(i=NowCaseSchedule;i<CaseScheduleNum;i++){
		*(long *)(OpBuffer+pCaseSchedule[i])=obp-(pCaseSchedule[i]+sizeof(long));
	}
	HeapDefaultFree(pCaseSchedule);

	//LVJXR[vx_E
	GetLexicalScopes().End();

	pCaseSchedule=temp_pCaseSchedule;
	CaseScheduleNum=temp_CaseScheduleNum;
	NowCaseSchedule=temp_NowCaseSchedule;
}
void OpcodeCase(char *Parameter){
	extern DWORD *pCaseSchedule;
	extern int NowCaseSchedule;
	int i;

	if(!pCaseSchedule){
		SetError(30,"Case",cp);
		return;
	}

	//jmp EndSelect
	OpBuffer[obp++]=(char)0xE9;
	AddCaseSchedule();
	obp+=sizeof(long);

	i=0;
	while(1){
		//CaseXPW[
		*(long *)(OpBuffer+pCaseSchedule[NowCaseSchedule])=obp-(pCaseSchedule[NowCaseSchedule]+sizeof(long));
		NowCaseSchedule++;

		i=JumpOneParameter(Parameter,i);
		if(Parameter[i]=='\0') break;
	}
}

void OpcodeGosub(char *Parameter){
	extern HANDLE hHeap;
	extern GOTOLABELSCHEDULE *pGotoLabelSchedule;
	extern int GotoLabelScheduleNum;
	int i,LineNum;

	//call _System_GetEip
	extern UserProc *pSub_System_GetEip;
	op_call(pSub_System_GetEip);

	//add rax,offsetiGosubXe[gg̍ŏI|Cgj
	int schedule=obp,schedule2;
	op_add_RV(REG_RAX,0);
	schedule2=obp-sizeof(long);

	//߂prip
	//mov qword ptr[rsp+offset],rax     X^bNt[𗘗p
	pobj_sf->push(REG_RAX);


	if(Parameter[0]=='*'){
		i=GetLabelAddress(Parameter+1,0);

		//jmp ...
		OpBuffer[obp++]=(char)0xE9;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=(char *)HeapAlloc(hHeap,0,lstrlen(Parameter+1)+1);
			lstrcpy(pGotoLabelSchedule[GotoLabelScheduleNum].pName,Parameter+1);
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}
	else{
		LineNum=atoi(Parameter);
		i=GetLabelAddress(0,LineNum);

		//jmp ...
		OpBuffer[obp++]=(char)0xE9;
		if(i==-1){
			pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapReAlloc(hHeap,0,pGotoLabelSchedule,(GotoLabelScheduleNum+1)*sizeof(GOTOLABELSCHEDULE));
			pGotoLabelSchedule[GotoLabelScheduleNum].pName=0;
			pGotoLabelSchedule[GotoLabelScheduleNum].line=LineNum;
			pGotoLabelSchedule[GotoLabelScheduleNum].pos=obp;
			pGotoLabelSchedule[GotoLabelScheduleNum].now_cp=cp;
			GotoLabelScheduleNum++;
		}
		*((long *)(OpBuffer+obp))=i-(obp+sizeof(long));
		obp+=sizeof(long);
	}

	*((long *)(OpBuffer+schedule2))=obp-schedule;

	//X^bNt[ɖ߂
	pobj_sf->pop(REG_NON);

	SetError(-1,"Gosub ` ReturnXe[gg64rbgRpCŗp邱Ƃ͂ł܂B",cp);
}
void OpcodeReturn(char *Parameter){
	if( UserProc::IsGlobalAreaCompiling() ){
		SetError(62,NULL,cp);
	}
	else{
		//߂lZbg
		if(Parameter[0]){
			UserProc &proc = UserProc::CompilingUserProc();

			const char *temp = "_System_ReturnValue";
			if(proc.GetName()[0]==1&&proc.GetName()[1]==ESC_OPERATOR)
			{
			}
			else{
				temp=proc.GetName().c_str();
			}

			char temporary[VN_SIZE];
			sprintf(temporary,"%s=%s",temp,Parameter);
			OpcodeCalc(temporary);
		}

		//vV[W𔲂oiCreturnƓl̏sj
		OpcodeExitSub();
	}
}


////////////
// |C^
////////////

void OpcodeSetPtrData(char *Parameter,int type){
	int i;
	char temporary[VN_SIZE];

	if(Parameter[0]=='('){
		i=JumpStringInPare(Parameter,1);
		if(Parameter[i+1]=='\0'){
			for(i=0;;i++){
				Parameter[i]=Parameter[i+1];
				if(Parameter[i]=='\0') break;
			}
			Parameter[i-1]=0;
		}
	}

	//Pp[^擾
	i=GetOneParameter(Parameter,0,temporary);
	if(!Parameter[i]){
		SetError(1,NULL,cp);
		return;
	}

	int reg_ptr=REG_RAX;
	Type resultType;
	if( !NumOpe(&reg_ptr,temporary,Type(),resultType) ){
		return;
	}
	if(!resultType.IsWhole()){
		SetError(11,Parameter,cp);
		return;
	}

	//ʂi[Ă郌WX^ubLO
	pobj_BlockReg->lock(reg_ptr);

	//Qp[^擾
	i=GetOneParameter(Parameter,i,temporary);
	if(Parameter[i]){
		SetError(1,NULL,cp);
		return;
	}

	int temp_reg=REG_NON;
	if( !NumOpe(&temp_reg,temporary,Type(),resultType) ){
		return;
	}

	//WX^̃ubLO
	pobj_BlockReg->clear();

	if(type==DEF_DOUBLE){
		ChangeTypeToXmm_Double(resultType.GetBasicType(),REG_XMM0,temp_reg);

		//movsd qword ptr[reg_ptr],xmm0
		op_movsd_MR(REG_XMM0,reg_ptr,0,MOD_BASE);
	}
	else if(type==DEF_SINGLE){
		ChangeTypeToXmm_Single(resultType.GetBasicType(),REG_XMM0,temp_reg);

		//movss dword ptr[reg_ptr],xmm0
		op_movss_MR(REG_XMM0,reg_ptr,0,MOD_BASE);
	}
	else{
		ChangeTypeToWhole(resultType.GetBasicType(),type,REG_RCX,temp_reg);

		//mov ptr[reg_ptr],rcx
		op_mov_MR(GetTypeSize(type,-1),REG_RCX,reg_ptr,0,MOD_BASE);
	}
}
