#include <jenga/include/common/Environment.h>

#include <jenga/include/smoothie/Smoothie.h>

#include <LexicalScopingImpl.h>
#include <ClassImpl.h>
#include <Compiler.h>
#include <NamespaceSupporter.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

extern int GlobalOpBufferSize;


////////////////////////////
// ֐̍\̃|C^
////////////////////////////

// O[o֐AÓI\bh
UserProc
	*pSub_System_StartupProgram,
	*pSub_DebugSys_StartProc,
	*pSub_DebugSys_EndProc,
	*pSub_DebugSys_SaveContext,
	*pSub_System_GetEip,
	*pSub_System_InitDllGlobalVariables,
	*pSub_System_InitStaticLocalVariables,
	*pSub_System_Call_Destructor_of_GlobalObject,
	*pSub_System_End,
	*pSub_System_GetSp,
	*pSub_pow,
	*pSub_calloc,
	*pSub_realloc,
	*pSub_free,
	*pSub_System_GC_malloc_ForObject,
	*pSub_System_GC_malloc_ForObjectPtr,
	*pSub_System_GC_free_for_SweepingDelete,
	*pSubStaticMethod_System_TypeBase_InitializeUserTypes,

	*pSub_allrem,
	*pSub_aullrem,
	*pSub_allmul,
	*pSub_alldiv,
	*pSub_aulldiv,
	*pSub_allshl,
	*pSub_allshr,
	*pSub_aullshr,
	
	*pSub_esp_error;

// I\bh
UserProc
	*pUserProc_System_CGarbageCollection_RegisterGlobalRoots;


//////////////////////////////
// eZNV̈ʒuƃTCY
int FileSize_CodeSection,
	FileSize_ExportSection,
	FileSize_ImportSection,
	FileSize_DataSection,
	FileSize_RWSection,
	FileSize_RSrcSection,
	FileSize_RelocSection,
	FileSize_DebugSection;
int FilePos_CodeSection,
	FilePos_ExportSection,
	FilePos_ImportSection,
	FilePos_DataSection,
	FilePos_RWSection,
	FilePos_RSrcSection,
	FilePos_RelocSection,
	FilePos_DebugSection;
int MemSize_CodeSection,
	MemSize_ExportSection,
	MemSize_ImportSection,
	MemSize_DataSection,
	MemSize_RWSection,
	MemSize_RSrcSection,
	MemSize_RelocSection,
	MemSize_DebugSection;
int MemPos_CodeSection,
	MemPos_ExportSection,
	MemPos_ImportSection,
	MemPos_DataSection,
	MemPos_RWSection,
	MemPos_RSrcSection,
	MemPos_RelocSection,
	MemPos_DebugSection;
int bUse_CodeSection,
	bUse_ExportSection,
	bUse_ImportSection,
	bUse_DataSection,
	bUse_RWSection,
	bUse_RSrcSection,
	bUse_RelocSection,
	bUse_DebugSection;


void DebugVariable(void){
	char temporary[255];
	sprintf(temporary,"_DebugSys_dwThreadID[255]%c%cDWord",1,ESC_AS);
	OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
	sprintf(temporary,"_DebugSys_ProcNum[255]%c%cDWord",1,ESC_AS);
	OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
	sprintf(temporary,"_DebugSys_lplpObp[255]%c%c*ULONG_PTR",1,ESC_AS);
	OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
	sprintf(temporary,"_DebugSys_lplpSpBase[255]%c%c*ULONG_PTR",1,ESC_AS);
	OpcodeDim(temporary,DIMFLAG_INITDEBUGVAR);
}

void Compile(void){
	extern HWND hMainDlg;
	extern HWND hOwnerEditor;
	extern HANDLE hHeap;
	extern BOOL bDebugCompile;
	extern BOOL bDll;
	extern DWORD ImageBase;
	extern int obp_AllocSize;
	extern char *basbuf;
	extern char OutputFileName[MAX_PATH];

	int i,i2,i3,i4,i5;
	char temporary[MAX_PATH],*temp2;
	HANDLE hFile;


	//R[hZNṼ̈ʒu
	MemPos_CodeSection=		0x1000;

	//f[^ZNṼ̈ʒuij
	MemPos_DataSection=		0x10000000;


	//GNX|[g ZNV𗘗p邩ǂ
	if(bDll) bUse_ExportSection=1;
	else bUse_ExportSection=0;


	//////////////////
	// f[^e[u
	compiler.GetNativeCode().GetDataTable().Init();
	if(bDebugCompile){
		compiler.GetNativeCode().GetDataTable().Add( (long)0x00000002 );
	}


	//////////////////////
	// R[hȌ
	//////////////////////

	//dG[Ǘ̃mہiO[öRpCpj
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	//񋓑̂Ɋւ̏
	CEnumParent::InitEnum();

	//񋓑̂NXR[h𐶐
	char *temp;
	temp=CEnumParent::GenerateCodes();
	AddSourceCode(temp);
	HeapDefaultFree(temp);

	//֐|C^
	compiler.GetMeta().GetProcPointers().clear();

	// Oԏ擾
	NamespaceSupporter::CollectNamespaces(
		Smoothie::Lexical::source.GetBuffer(),
		compiler.GetMeta().GetNamespaces()
	);

	//NX擾iڍ׏GetAllClassInfoŎ擾j
	//   GetSubInfo֐̒ŎQƂIuWFNgOɎ擾B
	//     IuWFNg̓e܂ł͎擾Ȃ
	compiler.GetMeta().GetClasses().CollectClassesForNameOnly( Smoothie::Lexical::source );

	//TypeDef
	compiler.GetMeta().GetTypeDefs().Init();

	//萔擾
	GetConstInfo();

	//Tu[`i[U[`ADLL֐j̎ʎqAAhX擾
	Smoothie::Temp::pCompilingClass=0;
	GetSubInfo();

	//NX擾i - GetSubInfǒɌĂяoj
	compiler.GetMeta().GetClasses().GetAllClassInfo();

	if( !compiler.GetMeta().AutoWrite( Jenga::Common::Environment::GetAppDir() + "\\meta_test.xml" ) )
	{
		ts(0);
	}

	//R[hƍsԍ̊֌W
	extern LINEINFO *pLineInfo;
	extern int MaxLineInfoNum;
	pLineInfo=(LINEINFO *)HeapAlloc(hHeap,0,1);
	MaxLineInfoNum=0;


	///////////////////////////
	// ŒKvȊ֐擾
	///////////////////////////
	cp=-1;

	if(pSub_System_StartupProgram=GetSubHash("_System_StartupProgram",1))
		pSub_System_StartupProgram->Using();

	if(pSub_DebugSys_StartProc=GetSubHash("_DebugSys_StartProc",1))
		pSub_DebugSys_StartProc->Using();

	if(pSub_DebugSys_EndProc=GetSubHash("_DebugSys_EndProc",1))
		pSub_DebugSys_EndProc->Using();

	if(pSub_DebugSys_SaveContext=GetSubHash("_DebugSys_SaveContext",1))
		pSub_DebugSys_SaveContext->Using();

	if(pSub_System_GetEip=GetSubHash("_System_GetEip",1)){
		pSub_System_GetEip->Using();
		pSub_System_GetEip->ThisIsSystemProc();
	}

	if(pSub_System_InitDllGlobalVariables=GetSubHash("_System_InitDllGlobalVariables",1)){
		pSub_System_InitDllGlobalVariables->Using();
		pSub_System_InitDllGlobalVariables->ThisIsSystemProc();
	}

	if(pSub_System_InitStaticLocalVariables=GetSubHash("_System_InitStaticLocalVariables",1)){
		pSub_System_InitStaticLocalVariables->Using();
		pSub_System_InitStaticLocalVariables->ThisIsSystemProc();
	}

	if(pSub_System_Call_Destructor_of_GlobalObject=GetSubHash("_System_Call_Destructor_of_GlobalObject",1)){
		pSub_System_Call_Destructor_of_GlobalObject->Using();
		pSub_System_Call_Destructor_of_GlobalObject->ThisIsSystemProc();
	}

	if(pSub_System_End=GetSubHash("_System_End",1)){
		pSub_System_End->Using();
	}

	if(pSub_System_GetSp=GetSubHash("_System_GetSp",1)){
		pSub_System_GetSp->Using();
		pSub_System_GetSp->ThisIsSystemProc();
	}

	if(pSub_pow=GetSubHash("pow",1))
		pSub_pow->Using();

	if(pSub_calloc=GetSubHash("calloc",1))
		pSub_calloc->Using();

	if(pSub_realloc=GetSubHash("realloc",1))
		pSub_realloc->Using();

	if(pSub_free=GetSubHash("free",1))
		pSub_free->Using();

	if( pSub_System_GC_malloc_ForObject = GetSubHash( "_System_GC_malloc_ForObject",1 ) )
		pSub_System_GC_malloc_ForObject->Using();

	if( pSub_System_GC_malloc_ForObjectPtr = GetSubHash( "_System_GC_malloc_ForObjectPtr",1 ) )
		pSub_System_GC_malloc_ForObjectPtr->Using();

	if( pSub_System_GC_free_for_SweepingDelete = GetSubHash( "_System_GC_free_for_SweepingDelete",1 ) )
		pSub_System_GC_free_for_SweepingDelete->Using();

	if( pSubStaticMethod_System_TypeBase_InitializeUserTypes = GetSubHash( "ActiveBasic.Core._System_TypeBase.InitializeUserTypes",1 ) ){
		pSubStaticMethod_System_TypeBase_InitializeUserTypes->Using();
		pSubStaticMethod_System_TypeBase_InitializeUserTypes->ThisIsAutoGenerationProc();
	}

	if( pUserProc_System_CGarbageCollection_RegisterGlobalRoots = GetClassMethod( "_System_CGarbageCollection", "RegisterGlobalRoots" ) ){
		pUserProc_System_CGarbageCollection_RegisterGlobalRoots->Using();
		pUserProc_System_CGarbageCollection_RegisterGlobalRoots->ThisIsAutoGenerationProc();
	}

	pSub_allrem=GetSubHash("_allrem");
	pSub_allrem->Using();
	pSub_allrem->ThisIsSystemProc();

	pSub_aullrem=GetSubHash("_aullrem");
	pSub_aullrem->Using();
	pSub_aullrem->ThisIsSystemProc();

	pSub_allmul=GetSubHash("_allmul");
	pSub_allmul->Using();
	pSub_allmul->ThisIsSystemProc();

	pSub_alldiv=GetSubHash("_alldiv");
	pSub_alldiv->Using();
	pSub_alldiv->ThisIsSystemProc();

	pSub_aulldiv=GetSubHash("_aulldiv");
	pSub_aulldiv->Using();
	pSub_aulldiv->ThisIsSystemProc();

	pSub_allshl=GetSubHash("_allshl");
	pSub_allshl->Using();
	pSub_allshl->ThisIsSystemProc();

	pSub_allshr=GetSubHash("_allshr");
	pSub_allshr->Using();
	pSub_allshr->ThisIsSystemProc();

	pSub_aullshr=GetSubHash("_aullshr");
	pSub_aullshr->Using();
	pSub_aullshr->ThisIsSystemProc();

	pSub_esp_error=GetSubHash("_esp_error");
	pSub_esp_error->Using();




	//f[^e[uXPW[
	pobj_DataTableSchedule=new CSchedule();
	pobj_DataTableSchedule->SetFlag(SCHEDULE_FLAG_RELOC);

	//C|[ge[uXPW[
	pobj_ImportAddrSchedule=new CImportAddrSchedule();
	pobj_ImportAddrSchedule->SetFlag(SCHEDULE_FLAG_RELOC);

	//vV[W|C^XPW[
	pobj_SubAddrSchedule=new CSubAddrSchedule();

	//O[oϐAhXXPW[
	pobj_GlobalVarSchedule=new CSchedule();
	pobj_GlobalVarSchedule->SetFlag(SCHEDULE_FLAG_RELOC);

	//O[oϐ̏obt@
	extern BYTE *initGlobalBuf;
	initGlobalBuf=(BYTE *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);

	//P[V
	pobj_Reloc=new CReloc();

	obp_AllocSize=8192*2;
	OpBuffer=(char *)malloc(obp_AllocSize);
	obp=0;

	//LVJXR[v
	GetLexicalScopes().Init(obp);


	/////////////////////////////////////////////////////////////////
	// fobORpCp̃O𐶐
	/////////////////////////////////////////////////////////////////
#ifdef _DEBUG
	{
		ofstream ofs( ( Jenga::Common::Environment::GetAppDir() + "\\middle_code.txt" ).c_str() );
		ofs << basbuf << endl;
		ofs.close();
	}
#endif


	//////////////////////
	// O[os̈
	//////////////////////

	cp=-1;
	UserProc::CompileStartForGlobalArea();

	if(!bDll){
		// OԂĂ邩`FbN
		if( namespaceSupporter.GetLivingNamespaceScopes().size() ){
			SetError();
		}

		//xp̃m
		extern LABEL *pLabelNames;
		extern int MaxLabelNum;
		pLabelNames=(LABEL *)HeapAlloc(hHeap,0,1);
		MaxLabelNum=0;

		//GotoxXPW[
		extern GOTOLABELSCHEDULE *pGotoLabelSchedule;
		extern int GotoLabelScheduleNum;
		pGotoLabelSchedule=(GOTOLABELSCHEDULE *)HeapAlloc(hHeap,0,1);
		GotoLabelScheduleNum=0;

		//With̃m
		extern WITHINFO WithInfo;
		WithInfo.ppName=(char **)HeapAlloc(hHeap,0,1);
		WithInfo.pWithCp=(int *)HeapAlloc(hHeap,0,1);
		WithInfo.num=0;

		//ContinueAhX
		extern DWORD dwContinueAddress;
		dwContinueAddress=-1;


		//
		//OpBuffer[obp++]=(char)0xCC;

		//push ebp
		op_push(REG_EBP);

		if(bDebugCompile){
			//fobOp̕ϐ`
			DebugVariable();
		}

		//GCp̕ϐ`
		InitGCVariables();

		//_System_StartupProgram̌Ăяo
		op_call(pSub_System_StartupProgram);

		//NXɑÓIo`
		compiler.GetMeta().GetClasses().InitStaticMember();

		//O[os̈RpCJn
		CompileBuffer(0,0);

		//xp̃
		for(i=0;i<MaxLabelNum;i++){
			if(pLabelNames[i].pName) HeapDefaultFree(pLabelNames[i].pName);
		}
		HeapDefaultFree(pLabelNames);

		//GotomxXPW[
		for(i=0;i<GotoLabelScheduleNum;i++){
			if(pGotoLabelSchedule[i].pName){
				SetError(6,pGotoLabelSchedule[i].pName,pGotoLabelSchedule[i].now_cp);
				HeapDefaultFree(pGotoLabelSchedule[i].pName);
			}
			else{
				sprintf(temporary,"%d",pGotoLabelSchedule[i].line);
				SetError(6,temporary,pGotoLabelSchedule[i].now_cp);
			}
		}
		HeapDefaultFree(pGotoLabelSchedule);


		///////////////////////////////////////
		// O[oϐ̉
		///////////////////////////////////////

		//call _System_End
		extern UserProc *pSub_System_End;
		op_call(pSub_System_End);


		//xor eax,eaxieax0ɏj
		op_zero_reg(REG_EAX);

		//pop ebp
		op_pop(REG_EBP);

		//ret
		op_ret();

		//O[os̈̃R[hTCY
		GlobalOpBufferSize=obp;

		//With̃
		for(i=0;i<WithInfo.num;i++){
			SetError(22,"With",WithInfo.pWithCp[i]);
			HeapDefaultFree(WithInfo.ppName[i]);
		}
		HeapDefaultFree(WithInfo.ppName);
		HeapDefaultFree(WithInfo.pWithCp);

		// OԂĂ邩`FbN
		if( namespaceSupporter.GetLivingNamespaceScopes().size() ){
			SetError(63,NULL,-1);
		}

	}
	else{
		////////////////
		// DLL̏ꍇ
		////////////////

	}

	//dG[Ǘ̃iO[öpj
	for(i=0;i<SynonymErrorNum;i++) HeapDefaultFree(SynonymErrorWords[i]);
	HeapDefaultFree(SynonymErrorWords);
	SynonymErrorWords=0;


	StepCompileProgress();


	/////////////////////
	// [Js̈
	/////////////////////

	//vV[WRpCJn
	cp=0;
	CompileLocal();

	// I
	///////////////////////

	StepCompileProgress();



	////////////////////////////////
	// ňUO
	////////////////////////////////
	Diagnose();



	////////////////////////////////
	// gpDLL֐̃`FbN
	////////////////////////////////
	for(i=0;i<MAX_HASH;i++){
		extern DllProc **ppDeclareHash;
		const DllProc *pDllProc = ppDeclareHash[i];
		while(pDllProc){
			if( !pDllProc->IsUsing() ){
				pDllProc=pDllProc->pNextData;
				continue;
			}

			//G[`FbN
			HINSTANCE hLib;
			hLib=LoadLibrary( pDllProc->GetDllFileName().c_str() );
			if(!hLib){
				extern char OutputFileName[MAX_PATH];
				char temp2[MAX_PATH],temp3[MAX_PATH];
				_splitpath(OutputFileName,temp2,temp3,NULL,NULL);
				lstrcat(temp2,temp3);
				lstrcpy(temp3,pDllProc->GetDllFileName().c_str());
				GetFullPath(temp3,temp2);
				hLib=LoadLibrary(temp3);

				if(!hLib){
					SetError(-106,pDllProc->GetDllFileName().c_str(),pDllProc->GetCodePos());
				}
			}

			if(hLib){
				if(!GetProcAddress(hLib,pDllProc->GetAlias().c_str())){
					FreeLibrary(hLib);
					SetError(-107,pDllProc->GetAlias(),pDllProc->GetCodePos());
				}
				FreeLibrary(hLib);
			}

			pDllProc=pDllProc->pNextData;
		}
	}



	/////////////////////////////
	// \[Xf[^ǂݍ
	/////////////////////////////
	extern char ResourceFileName[MAX_PATH];
	GetResourceData(ResourceFileName);


	//////////////////////////////
	// GNX|[giDLL̂݁j
	//////////////////////////////
	IMAGE_EXPORT_DIRECTORY ImageExportDirectory;
	DWORD *lpdwExportAddressTable;
	DWORD *lpdwExportNamePointerTable;
	WORD *lpwExportOrdinalTable;
	char lpExportNames[8192];
	int ExportNamesLength;
	int ExportNum;
	int DllMain_EntryPoint;

	DllMain_EntryPoint=-1;
	ExportNum=0;
	ExportNamesLength=0;
	lpdwExportAddressTable=(DWORD *)HeapAlloc(hHeap,0,1);
	lpdwExportNamePointerTable=(DWORD *)HeapAlloc(hHeap,0,1);
	lpwExportOrdinalTable=(WORD *)HeapAlloc(hHeap,0,1);

	if(bUse_ExportSection){
		_splitpath(OutputFileName,NULL,NULL,lpExportNames,temporary);
		lstrcat(lpExportNames,temporary);
		ExportNamesLength=lstrlen(lpExportNames)+1;

		extern GlobalProc **ppSubHash;
		GlobalProc *pUserProc,*psi2;
		while(1){
			//ɃT[`
			temporary[0]=0;
			for(i=0,psi2=0;i<MAX_HASH;i++){
				pUserProc=ppSubHash[i];
				while(pUserProc){
					if(pUserProc->IsExport()){
						if(temporary[0]=='\0'){
							lstrcpy(temporary,pUserProc->GetName().c_str());
							psi2=pUserProc;
						}
						else{
							i3=lstrlen(temporary);
							i4=(int)pUserProc->GetName().size();
							if(i3<i4) i3=i4;
							if(memcmp(temporary,pUserProc->GetName().c_str(),i3)>0){
								lstrcpy(temporary,pUserProc->GetName().c_str());
								psi2=pUserProc;
							}
						}
					}
					pUserProc=pUserProc->pNextData;
				}
			}
			if(psi2==0) break;
			pUserProc=psi2;

			pUserProc->ExportOff();

			if( pUserProc->GetName() == "DllMain" ){
				DllMain_EntryPoint=pUserProc->beginOpAddress;
			}

			lpdwExportAddressTable=(DWORD *)HeapReAlloc(hHeap,0,lpdwExportAddressTable,(ExportNum+1)*sizeof(DWORD));
			lpdwExportAddressTable[ExportNum]=pUserProc->beginOpAddress;

			lpdwExportNamePointerTable=(DWORD *)HeapReAlloc(hHeap,0,lpdwExportNamePointerTable,(ExportNum+1)*sizeof(DWORD));
			lpdwExportNamePointerTable[ExportNum]=ExportNamesLength;

			lpwExportOrdinalTable=(WORD *)HeapReAlloc(hHeap,0,lpwExportOrdinalTable,(ExportNum+1)*sizeof(WORD));
			lpwExportOrdinalTable[ExportNum]=ExportNum;

			lstrcpy(lpExportNames+ExportNamesLength,pUserProc->GetName().c_str());
			ExportNamesLength+=lstrlen(lpExportNames+ExportNamesLength)+1;

			ExportNum++;
		}
		for(i=0;i<ExportNum;i++){
			lpdwExportNamePointerTable[i]+=
				sizeof(IMAGE_EXPORT_DIRECTORY)+	//GNX|[gfBNge[uщz
				ExportNum*sizeof(DWORD)+		//GNX|[g AhX e[uщz
				ExportNum*sizeof(DWORD)+		//GNX|[g|C^ e[uщz
				ExportNum*sizeof(WORD);			//GNX|[ge[uщz
		}

		ImageExportDirectory.Characteristics=0;
		ImageExportDirectory.TimeDateStamp=(DWORD)time(NULL);
		ImageExportDirectory.MajorVersion=0;
		ImageExportDirectory.MinorVersion=0;
		ImageExportDirectory.Name=sizeof(IMAGE_EXPORT_DIRECTORY)+
			ExportNum*sizeof(DWORD)+	//GNX|[g AhX e[uщz
			ExportNum*sizeof(DWORD)+	//GNX|[g|C^ e[uщz
			ExportNum*sizeof(WORD);		//GNX|[ge[uщz
		ImageExportDirectory.Base=1;
		ImageExportDirectory.NumberOfFunctions=ExportNum;
		ImageExportDirectory.NumberOfNames=ExportNum;
		ImageExportDirectory.AddressOfFunctions=sizeof(IMAGE_EXPORT_DIRECTORY);
		ImageExportDirectory.AddressOfNames=ImageExportDirectory.AddressOfFunctions+ExportNum*sizeof(DWORD);
		ImageExportDirectory.AddressOfNameOrdinals=ImageExportDirectory.AddressOfNames+ExportNum*sizeof(DWORD);
	}


	/////////////////////
	//C|[gDLL
	/////////////////////
	extern DllProc **ppDeclareHash;
	char **ppDllNames;
	int ImportDllNum;

	/*
	IMAGE_IMPORT_DESCRIPTOR1[size=0x14]	C|[gwb_
	IMAGE_IMPORT_DESCRIPTOR2[size=0x14]
	IMAGE_IMPORT_DESCRIPTOR3[size=0x14]
	...
	Dll1[size=0x10]
	Dll2[size=0x10]
	Dll3[size=0x10]
	...
	bNAbv e[uiqgRVAj
	qge[u
	C|[g AhX e[uibNAbvƓeAvOsɎsAhXɏj
	*/

	ppDllNames=(char **)HeapAlloc(hHeap,0,1);

	ImportDllNum=0;
	for(i=0;i<MAX_HASH;i++){
		const DllProc *pDllProc=ppDeclareHash[i];
		while(pDllProc){
			if( !pDllProc->IsUsing() ){
				pDllProc=pDllProc->pNextData;
				continue;
			}

			if( pDllProc->GetDllFileName().size() > 16 ){
				SetError(7,NULL,cp);
				break;
			}
			for(i2=0;i2<ImportDllNum;i2++){
				if( pDllProc->GetDllFileName() == ppDllNames[i2] ){
					break;
				}
			}
			if(i2==ImportDllNum){
				ppDllNames=(char **)HeapReAlloc(hHeap,0,ppDllNames,(ImportDllNum+1)*sizeof(char **));
				ppDllNames[ImportDllNum]=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,16);
				lstrcpy(ppDllNames[ImportDllNum],pDllProc->GetDllFileName().c_str());
				ImportDllNum++;
			}

			pDllProc=pDllProc->pNextData;
		}
	}

	//C|[g e[uAyуbNAbv e[u TCY̌vZ
	IMAGE_IMPORT_DESCRIPTOR *pImportTable;
	int LookupSize;
	LookupSize=0;
	pImportTable=(IMAGE_IMPORT_DESCRIPTOR *)HeapAlloc(hHeap,0,(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR));
	i3=(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR);
	for(i=0;i<ImportDllNum;i++){
		//C|[g e[uiIMAGE_IMPORT_DESCRIPTORj
		pImportTable[i].OriginalFirstThunk=i3+(ImportDllNum*0x10)+LookupSize;
		pImportTable[i].TimeDateStamp=0;
		pImportTable[i].ForwarderChain=0;
		pImportTable[i].Name=i3+i*0x10;
		for(i2=0;i2<MAX_HASH;i2++){
			const DllProc *pDllProc=ppDeclareHash[i2];
			while(pDllProc){
				if( !pDllProc->IsUsing() ){
					pDllProc=pDllProc->pNextData;
					continue;
				}

				if( pDllProc->GetDllFileName() == ppDllNames[i] ){
					//bNAbvf[^̃TCYǉ
					LookupSize+=sizeof(DWORD);
				}

				pDllProc=pDllProc->pNextData;
			}
		}
		LookupSize+=sizeof(DWORD);	//NULLp
	}
	memset(&pImportTable[i],0,sizeof(IMAGE_IMPORT_DESCRIPTOR));

	//bNAbv e[uAqg e[u
	DWORD *pLookupTable;
	pLookupTable=(DWORD *)HeapAlloc(hHeap,0,LookupSize*sizeof(DWORD)+1);
	char *pHintTable;
	int HintSize,HintAllocSize;
	HintSize=0;
	HintAllocSize=128*2;
	pHintTable=(char *)HeapAlloc(hHeap,0,HintAllocSize);
	i3+=ImportDllNum*0x10;
	for(i=0,i5=0;i<ImportDllNum;i++){
		for(i2=0;i2<MAX_HASH;i2++){
			DllProc *pDllProc=ppDeclareHash[i2];
			while(pDllProc){
				if( !pDllProc->IsUsing() ){
					pDllProc=pDllProc->pNextData;
					continue;
				}

				if( pDllProc->GetDllFileName() == ppDllNames[i] ){
					//bNAbv̈ʒuZbgiɃC|[g AhX e[uɃZbgȂj
					pDllProc->SetLookupAddress( i3+(i5*sizeof(DWORD)) );

					//bNAbv e[u
					pLookupTable[i5++]=i3+LookupSize+HintSize;

					//qg e[u
					pHintTable[HintSize++]=0;
					pHintTable[HintSize++]=0;
					lstrcpy(pHintTable+HintSize,pDllProc->GetAlias().c_str());
					i4=(int)pDllProc->GetAlias().size();
					HintSize+=i4+1;
					if(i4%2==0) pHintTable[HintSize++]=0;

					if(HintAllocSize<HintSize+128){
						HintAllocSize+=128;
						pHintTable=(char *)HeapReAlloc(hHeap,0,pHintTable,HintAllocSize);
					}
				}

				pDllProc=pDllProc->pNextData;
			}
		}
		pLookupTable[i5++]=0;
	}


	if(bDll){
		//DLL̏ꍇ̓P[V
		//Ȑ͊eZNṼ̃TCY肵ĂēxsB
		pobj_Reloc->ResetRelocBuffer();
	}



	//O[oϐ\̂obt@̗Lɂzus
	//ifobOŗpj
	extern int AllInitGlobalVarSize;
	BOOST_FOREACH( Variable *pVar, globalVars ){
		if(pVar->offset&0x80000000){
			pVar->offset=(pVar->offset&0x7FFFFFFF)+AllInitGlobalVarSize;
		}
	}



	////////////////////////////////////
	// fobOZNV𐶐
	////////////////////////////////////

	//@BR[hBasicR[h̊֌W𐮗
	extern LINEINFO *pLineInfo;
	extern int MaxLineInfoNum;
	int MinObp,MaxObp;
	LINEINFO *pTempLineInfo;
	pTempLineInfo=(LINEINFO *)HeapAlloc(hHeap,0,MaxLineInfoNum*sizeof(LINEINFO));
	i2=0;
	MaxObp=0;
	while(1){
		for(i3=0,MinObp=0x0FFFFFFF;i3<MaxLineInfoNum;i3++){
			if(pLineInfo[i3].TopObp<MinObp&&MaxObp<pLineInfo[i3].TopObp){
				MinObp=pLineInfo[i3].TopObp;
				i4=i3;
			}
		}
		if(MinObp==0x0FFFFFFF) break;
		pTempLineInfo[i2]=pLineInfo[i4];
		MaxObp=pTempLineInfo[i2].TopObp;
		i2++;
	}
	HeapDefaultFree(pLineInfo);
	pLineInfo=(LINEINFO *)HeapAlloc(hHeap,0,i2*sizeof(LINEINFO));
	memcpy(pLineInfo,pTempLineInfo,i2*sizeof(LINEINFO));
	MaxLineInfoNum=i2;
	HeapDefaultFree(pTempLineInfo);

	//fobOZNV𐶐
	CDebugSection *pobj_DebugSection;
	pobj_DebugSection=new CDebugSection();
	extern BOOL bDebugCompile;
	extern BOOL bError;
	if(bDebugCompile&&bError==0){
		pobj_DebugSection->make();
	}



	/////////////////////////////////////
	// eZNV̈ʒuƃTCYvZ
	/////////////////////////////////////

	//R[hZbṼt@C̃TCY
	if(obp%FILE_ALIGNMENT) FileSize_CodeSection=obp+(FILE_ALIGNMENT-obp%FILE_ALIGNMENT);
	else FileSize_CodeSection=obp;
	if(FileSize_CodeSection) bUse_CodeSection=1;
	else bUse_CodeSection=0;

	//GNX|[gZNṼt@C̃TCY
	i=	sizeof(IMAGE_EXPORT_DIRECTORY)+	//GNX|[gfBNge[uщz
		ExportNum*sizeof(DWORD)+		//GNX|[g AhX e[uщz
		ExportNum*sizeof(DWORD)+		//GNX|[g|C^ e[uщz
		ExportNum*sizeof(WORD)+			//GNX|[ge[uщz
		ExportNamesLength;				//V{obt@
	if(bUse_ExportSection){
		if(i%FILE_ALIGNMENT) FileSize_ExportSection=i+(FILE_ALIGNMENT-i%FILE_ALIGNMENT);
		else FileSize_ExportSection=i;
	}
	else FileSize_ExportSection=0;

	//C|[gZNṼt@C̃TCY
	i=(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR)+
		16*ImportDllNum+	//DLL
		LookupSize+			//bNAbve[u
		HintSize+			//qgi֐je[u
		LookupSize;			//C|[g AhX e[u
	if(i%FILE_ALIGNMENT) FileSize_ImportSection=i+(FILE_ALIGNMENT-i%FILE_ALIGNMENT);
	else FileSize_ImportSection=i;
	bUse_ImportSection=1;	//C|[gZNV͕K݂

	//f[^ZNṼt@C̃TCY
	if(compiler.GetNativeCode().GetDataTable().GetSize()%FILE_ALIGNMENT) FileSize_DataSection=compiler.GetNativeCode().GetDataTable().GetSize()+(FILE_ALIGNMENT-compiler.GetNativeCode().GetDataTable().GetSize()%FILE_ALIGNMENT);
	else FileSize_DataSection=compiler.GetNativeCode().GetDataTable().GetSize();
	if(FileSize_DataSection) bUse_DataSection=1;
	else bUse_DataSection=0;

	//C^uZNṼt@C̃TCYiO[oϐ݂̏̂i[j
	if(AllInitGlobalVarSize%FILE_ALIGNMENT) FileSize_RWSection=AllInitGlobalVarSize+(FILE_ALIGNMENT-AllInitGlobalVarSize%FILE_ALIGNMENT);
	else{
		if(AllInitGlobalVarSize) FileSize_RWSection=AllInitGlobalVarSize;
		else FileSize_RWSection=FILE_ALIGNMENT;
	}
	bUse_RWSection=1;

	//\[XZNṼt@C̃TCY
	char *RSrcSectionBuffer;
	int RSrcSectionSize;
	RSrcSectionBuffer=GetRSrcSectionBuffer(&RSrcSectionSize);
	if(RSrcSectionSize%FILE_ALIGNMENT) FileSize_RSrcSection=RSrcSectionSize+(FILE_ALIGNMENT-RSrcSectionSize%FILE_ALIGNMENT);
	else FileSize_RSrcSection=RSrcSectionSize;
	if(FileSize_RSrcSection) bUse_RSrcSection=1;
	else bUse_RSrcSection=0;

	//P[VZNṼt@C̃TCY
	if(pobj_Reloc->length%FILE_ALIGNMENT) FileSize_RelocSection=pobj_Reloc->length+(FILE_ALIGNMENT-pobj_Reloc->length%FILE_ALIGNMENT);
	else FileSize_RelocSection=pobj_Reloc->length;
	if(FileSize_RelocSection) bUse_RelocSection=1;
	else bUse_RelocSection=0;

	//fobOZNṼt@C̃TCY
	if(pobj_DebugSection->length%FILE_ALIGNMENT) FileSize_DebugSection=pobj_DebugSection->length+(FILE_ALIGNMENT-pobj_DebugSection->length%FILE_ALIGNMENT);
	else FileSize_DebugSection=pobj_DebugSection->length;
	if(FileSize_DebugSection) bUse_DebugSection=1;
	else bUse_DebugSection=0;


	//eZbṼt@C̈ʒu
	FilePos_CodeSection=	EXE_HEADER_SIZE;
	FilePos_ExportSection=	FilePos_CodeSection+
							FileSize_CodeSection;
	FilePos_ImportSection=	FilePos_ExportSection+
							FileSize_ExportSection;
	FilePos_DataSection=	FilePos_ImportSection+
							FileSize_ImportSection;
	FilePos_RWSection=		FilePos_DataSection+
							FileSize_DataSection;
	FilePos_RSrcSection=	FilePos_RWSection+
							FileSize_RWSection;
	FilePos_RelocSection=	FilePos_RSrcSection+
							FileSize_RSrcSection;
	FilePos_DebugSection=	FilePos_RelocSection+
							FileSize_RelocSection;


	//R[hZbṼ̃TCY
	if(FileSize_CodeSection%MEM_ALIGNMENT) MemSize_CodeSection=FileSize_CodeSection+(MEM_ALIGNMENT-FileSize_CodeSection%MEM_ALIGNMENT);
	else MemSize_CodeSection=FileSize_CodeSection;

	//GNX|[gZNṼ̃TCY
	if(FileSize_ExportSection%MEM_ALIGNMENT) MemSize_ExportSection=FileSize_ExportSection+(MEM_ALIGNMENT-FileSize_ExportSection%MEM_ALIGNMENT);
	else MemSize_ExportSection=FileSize_ExportSection;

	//C|[gZNṼ̃TCY
	if(FileSize_ImportSection%MEM_ALIGNMENT) MemSize_ImportSection=FileSize_ImportSection+(MEM_ALIGNMENT-FileSize_ImportSection%MEM_ALIGNMENT);
	else MemSize_ImportSection=FileSize_ImportSection;

	//f[^ZNṼ̃TCY
	if(FileSize_DataSection%MEM_ALIGNMENT) MemSize_DataSection=FileSize_DataSection+(MEM_ALIGNMENT-FileSize_DataSection%MEM_ALIGNMENT);
	else MemSize_DataSection=FileSize_DataSection;

	//C^uZNṼ̃TCY
	extern int AllGlobalVarSize;
	i=AllInitGlobalVarSize+AllGlobalVarSize;
	if(i%MEM_ALIGNMENT) MemSize_RWSection=i+(MEM_ALIGNMENT-i%MEM_ALIGNMENT);
	else MemSize_RWSection=i;

	//\[XZNṼ̃TCY
	if(FileSize_RSrcSection%MEM_ALIGNMENT) MemSize_RSrcSection=FileSize_RSrcSection+(MEM_ALIGNMENT-FileSize_RSrcSection%MEM_ALIGNMENT);
	else MemSize_RSrcSection=FileSize_RSrcSection;

	//P[VZNṼ̃TCY
	if(FileSize_RelocSection%MEM_ALIGNMENT) MemSize_RelocSection=FileSize_RelocSection+(MEM_ALIGNMENT-FileSize_RelocSection%MEM_ALIGNMENT);
	else MemSize_RelocSection=FileSize_RelocSection;

	//fobOZNṼ̃TCY
	if(FileSize_DebugSection%MEM_ALIGNMENT) MemSize_DebugSection=FileSize_DebugSection+(MEM_ALIGNMENT-FileSize_DebugSection%MEM_ALIGNMENT);
	else MemSize_DebugSection=FileSize_DebugSection;


	//eZbṼ̈ʒu
	if(bUse_ExportSection)	MemPos_ExportSection=	0x1000+
													MemSize_CodeSection;
	else					MemPos_ExportSection=0;
	if(bUse_ImportSection)	MemPos_ImportSection=	0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection;
	else					MemPos_ImportSection=0;
	if(bUse_DataSection)	MemPos_DataSection=		0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection;
	else					MemPos_DataSection=0;
	if(bUse_RWSection)		MemPos_RWSection=		0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection;
	else					MemPos_RWSection=0;
	if(bUse_RSrcSection)	MemPos_RSrcSection=		0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection;
	else					MemPos_RSrcSection=0;
	if(bUse_RelocSection)	MemPos_RelocSection=	0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection+
													MemSize_RSrcSection;
	else					MemPos_RelocSection=0;
	if(bUse_DebugSection)	MemPos_DebugSection=	0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection+
													MemSize_RSrcSection+
													MemSize_RelocSection;
	else					MemPos_DebugSection=0;



	/////////////////////////////
	// GCp̕ϐXPW[
	/////////////////////////////
	PerformedGcVarSchedule();



	////////////////////////////
	// GNX|[g̍Ĕzu
	////////////////////////////
	if(bUse_ExportSection){
		for(i=0;i<ExportNum;i++){
			lpdwExportAddressTable[i]+=MemPos_CodeSection;
			lpdwExportNamePointerTable[i]+=MemPos_ExportSection;
		}

		ImageExportDirectory.Name+=						MemPos_ExportSection;
		ImageExportDirectory.AddressOfFunctions+=		MemPos_ExportSection;
		ImageExportDirectory.AddressOfNames+=			MemPos_ExportSection;
		ImageExportDirectory.AddressOfNameOrdinals+=	MemPos_ExportSection;
	}


	////////////////////////////
	// C|[g̍Ĕzu
	////////////////////////////
	for(i=0,i5=0;i<ImportDllNum;i++){
		//C|[g e[uiIMAGE_IMPORT_DESCRIPTORj
		pImportTable[i].OriginalFirstThunk+=MemPos_ImportSection;
		pImportTable[i].Name+=MemPos_ImportSection;

		//C|[g AhX e[uibNAbvƃqgщzj
		pImportTable[i].FirstThunk=pImportTable[i].OriginalFirstThunk+
			LookupSize+			//bNAbve[u
			HintSize;			//qgi֐je[u

		for(i2=0;i2<MAX_HASH;i2++){
			const DllProc *pDllProc=ppDeclareHash[i2];
			while(pDllProc){
				if( !pDllProc->IsUsing() ){
					pDllProc=pDllProc->pNextData;
					continue;
				}

				if( pDllProc->GetDllFileName() == ppDllNames[i] ){
					//bNAbv e[u
					pLookupTable[i5++]+=MemPos_ImportSection;
				}

				pDllProc=pDllProc->pNextData;
			}
		}
		i5++;
	}


	////////////////////////////////////////
	//z֐f[^e[uXPW[
	compiler.GetMeta().GetClasses().ActionVtblSchedule(ImageBase,MemPos_CodeSection);


	//////////////////////////////
	// f[^e[uXPW[
	for(i=0;i<pobj_DataTableSchedule->num;i++){
		*((long *)(OpBuffer+pobj_DataTableSchedule->pObpValues[i]))+=ImageBase+MemPos_DataSection;
	}
	delete pobj_DataTableSchedule;


	//////////////////////////////////
	// C|[ge[uXPW[iC|[g AhX e[uwj
	for(i=0;i<pobj_ImportAddrSchedule->num;i++){
		const DllProc *pDllProc=pobj_ImportAddrSchedule->ppdi[i];
		*((long *)(OpBuffer+pobj_ImportAddrSchedule->pObpValues[i]))=
			ImageBase+
			MemPos_ImportSection+
			LookupSize+			//bNAbve[u
			HintSize+			//qgi֐je[u
			pDllProc->GetLookupAddress();
	}
	delete pobj_ImportAddrSchedule;


	////////////////////////////////////
	// vV[W|C^XPW[
	for(i=0;i<pobj_SubAddrSchedule->num;i++){
		if(pobj_SubAddrSchedule->ppsi[i]->beginOpAddress==0
			&&pobj_SubAddrSchedule->ppsi[i]->endOpAddress==0){
			SetError(300,NULL,-1);
		}

		if(pobj_SubAddrSchedule->pbCall[i]){
			*((long *)(OpBuffer+pobj_SubAddrSchedule->pObpValues[i]))=
				pobj_SubAddrSchedule->ppsi[i]->beginOpAddress-(pobj_SubAddrSchedule->pObpValues[i]+sizeof(long));
		}
		else{
			*((long *)(OpBuffer+pobj_SubAddrSchedule->pObpValues[i]))=
				pobj_SubAddrSchedule->ppsi[i]->beginOpAddress+ImageBase+MemPos_CodeSection;
		}
	}
	delete pobj_SubAddrSchedule;


	if(bDll){
		//DLL̏ꍇ̓P[V𐶐
		pobj_Reloc->ResetRelocBuffer();
	}



	//////////////////////////////////////
	// O[oϐAhXXPW[
	//////////////////////////////////////

	/*
	GlobalArea1 - obt@
	GlobalArea2 - obt@Ȃ
	*/
	for(i=0;i<pobj_GlobalVarSchedule->num;i++){
		if(*((long *)(OpBuffer+pobj_GlobalVarSchedule->pObpValues[i])) & 0x80000000){
			//obt@Ȃ
			*((long *)(OpBuffer+pobj_GlobalVarSchedule->pObpValues[i]))=
				AllInitGlobalVarSize+
				(*((long *)(OpBuffer+pobj_GlobalVarSchedule->pObpValues[i])) & 0x7FFFFFFF)+
				ImageBase+MemPos_RWSection;
		}
		else{
			//obt@
			*((long *)(OpBuffer+pobj_GlobalVarSchedule->pObpValues[i]))+=
				ImageBase+MemPos_RWSection;
		}
	}
	delete pobj_GlobalVarSchedule;



	////////////////////////////////
	// \[XAhXXPW[
	extern DWORD *lpdwRSrcAddrSchedule;
	extern int RSrcAddrScheduleNum;
	for(i=0;i<RSrcAddrScheduleNum;i++){
		*(DWORD *)(RSrcSectionBuffer+lpdwRSrcAddrSchedule[i])+=MemPos_RSrcSection;
	}
	HeapDefaultFree(lpdwRSrcAddrSchedule);


	//DosX^u
	char *DosStubBuffer;
	int DosStubSize;
	hFile=CreateFile(
		( Jenga::Common::Environment::GetAppDir() + "\\SubOperation\\dosstub.pgm" ).c_str(),
		GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		MessageBox(hOwnerEditor,"dosstub.pgm̓ǂݍ݂Ɏs","error",MB_OK);
		goto EndWriteOpcode;
	}
	DosStubSize=GetFileSize(hFile,NULL);
	DosStubBuffer=(char *)HeapAlloc(hHeap,0,DosStubSize);
	ReadFile(hFile,DosStubBuffer,DosStubSize,(DWORD *)&i2,NULL);
	CloseHandle(hFile);


	extern BOOL bError;
	if(bError) goto EndWriteOpcode;


	////////////////////////////
	// EXEt@C̃wb_
	////////////////////////////

	IMAGE_DOS_HEADER ImageDosHeader;
	ImageDosHeader.e_magic=	0x5A4D;
	ImageDosHeader.e_cblp=	0x0090;
	ImageDosHeader.e_cp=	0x0003;
	ImageDosHeader.e_crlc=	0;
	ImageDosHeader.e_cparhdr=4;
	ImageDosHeader.e_minalloc=0x0000;
	ImageDosHeader.e_maxalloc=0xFFFF;
	ImageDosHeader.e_ss=	0x0000;
	ImageDosHeader.e_sp=	0x00B8;
	ImageDosHeader.e_csum=	0x0000;
	ImageDosHeader.e_ip=	0x0000;
	ImageDosHeader.e_cs=	0x0000;
	ImageDosHeader.e_lfarlc=0x0040;
	ImageDosHeader.e_ovno=	0x0000;
	ImageDosHeader.e_res[0]=0;
	ImageDosHeader.e_res[1]=0;
	ImageDosHeader.e_res[2]=0;
	ImageDosHeader.e_res[3]=0;
	ImageDosHeader.e_oemid=	0x0000;
	ImageDosHeader.e_oeminfo=0x0000;
	ImageDosHeader.e_res2[0]=0;
	ImageDosHeader.e_res2[1]=0;
	ImageDosHeader.e_res2[2]=0;
	ImageDosHeader.e_res2[3]=0;
	ImageDosHeader.e_res2[4]=0;
	ImageDosHeader.e_res2[5]=0;
	ImageDosHeader.e_res2[6]=0;
	ImageDosHeader.e_res2[7]=0;
	ImageDosHeader.e_res2[8]=0;
	ImageDosHeader.e_res2[9]=0;
	ImageDosHeader.e_lfanew=0x0100;	//PEwb_̈ʒu


	/////////////////////////////////////////////
	// PEwb_
	/////////////////////////////////////////////

	IMAGE_NT_HEADERS ImagePeHdr;
	ImagePeHdr.Signature=IMAGE_NT_SIGNATURE;

	//}V^Cv
	ImagePeHdr.FileHeader.Machine=			IMAGE_FILE_MACHINE_I386;

	ImagePeHdr.FileHeader.NumberOfSections=		bUse_CodeSection+
												bUse_ExportSection+
												bUse_ImportSection+
												bUse_DataSection+
												bUse_RWSection+
												bUse_RSrcSection+
												bUse_RelocSection+
												bUse_DebugSection;	//ZNV
	ImagePeHdr.FileHeader.TimeDateStamp=		(DWORD)time(NULL);
	ImagePeHdr.FileHeader.PointerToSymbolTable=	0x00000000;
	ImagePeHdr.FileHeader.NumberOfSymbols=		0x00000000;
	ImagePeHdr.FileHeader.SizeOfOptionalHeader=	IMAGE_SIZEOF_NT_OPTIONAL32_HEADER;
	if(bDll){
		ImagePeHdr.FileHeader.Characteristics=	IMAGE_FILE_EXECUTABLE_IMAGE|
												IMAGE_FILE_32BIT_MACHINE|
												IMAGE_FILE_LINE_NUMS_STRIPPED|
												IMAGE_FILE_LOCAL_SYMS_STRIPPED|
												IMAGE_FILE_DLL;
	}
	else{
		ImagePeHdr.FileHeader.Characteristics=	IMAGE_FILE_EXECUTABLE_IMAGE|
												IMAGE_FILE_32BIT_MACHINE|
												IMAGE_FILE_LINE_NUMS_STRIPPED|
												IMAGE_FILE_LOCAL_SYMS_STRIPPED;
	}

	ImagePeHdr.OptionalHeader.Magic=				0x010B;
	ImagePeHdr.OptionalHeader.MajorLinkerVersion=	4;
	ImagePeHdr.OptionalHeader.MinorLinkerVersion=	0;
	ImagePeHdr.OptionalHeader.SizeOfCode=			FileSize_CodeSection;	//R[hTCYi.text̃ZbVTCYj
	ImagePeHdr.OptionalHeader.SizeOfInitializedData=FileSize_DataSection;	//f[^TCYi.datãZbVTCYj
	ImagePeHdr.OptionalHeader.SizeOfUninitializedData=0;					//f[^̃TCYiȂj
	if(bDll){
		if(DllMain_EntryPoint==-1)
			ImagePeHdr.OptionalHeader.AddressOfEntryPoint=0;
		else
			ImagePeHdr.OptionalHeader.AddressOfEntryPoint=MemPos_CodeSection+DllMain_EntryPoint;
	}
	else ImagePeHdr.OptionalHeader.AddressOfEntryPoint=	MemPos_CodeSection;
	ImagePeHdr.OptionalHeader.BaseOfCode=			MemPos_CodeSection;	//.text̃AhX
	ImagePeHdr.OptionalHeader.BaseOfData=			MemPos_DataSection;	//.datãAhX

	ImagePeHdr.OptionalHeader.ImageBase=			ImageBase;		//C[Wx[X
	ImagePeHdr.OptionalHeader.SectionAlignment=		MEM_ALIGNMENT;		//ZNVACg
	ImagePeHdr.OptionalHeader.FileAlignment=		FILE_ALIGNMENT;
	ImagePeHdr.OptionalHeader.MajorOperatingSystemVersion=4;
	ImagePeHdr.OptionalHeader.MinorOperatingSystemVersion=0;
	ImagePeHdr.OptionalHeader.MajorImageVersion=	0;
	ImagePeHdr.OptionalHeader.MinorImageVersion=	0;
	ImagePeHdr.OptionalHeader.MajorSubsystemVersion=4;
	ImagePeHdr.OptionalHeader.MinorSubsystemVersion=0;
	ImagePeHdr.OptionalHeader.Win32VersionValue=	0;
	ImagePeHdr.OptionalHeader.SizeOfImage=			EXE_HEADER_SIZE+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection+
													MemSize_RSrcSection+
													MemSize_RelocSection+
													MemSize_DebugSection;//ׂẴC[WTCY
	ImagePeHdr.OptionalHeader.SizeOfHeaders=		EXE_HEADER_SIZE;//wb_TCY
	ImagePeHdr.OptionalHeader.CheckSum=				0;
	extern unsigned short TypeOfSubSystem;
	ImagePeHdr.OptionalHeader.Subsystem=			TypeOfSubSystem;
	ImagePeHdr.OptionalHeader.DllCharacteristics=	0;
	ImagePeHdr.OptionalHeader.SizeOfStackReserve=	0x00100000;
	ImagePeHdr.OptionalHeader.SizeOfStackCommit=	0x00001000;
	ImagePeHdr.OptionalHeader.SizeOfHeapReserve=	0x00100000;
	ImagePeHdr.OptionalHeader.SizeOfHeapCommit=		0x00001000;
	ImagePeHdr.OptionalHeader.LoaderFlags=			0;
	ImagePeHdr.OptionalHeader.NumberOfRvaAndSizes=	IMAGE_NUMBEROF_DIRECTORY_ENTRIES;

	//f[^ fBNVi
	ImagePeHdr.OptionalHeader.DataDirectory[0].VirtualAddress=MemPos_ExportSection;
	ImagePeHdr.OptionalHeader.DataDirectory[0].Size=FileSize_ExportSection;
	ImagePeHdr.OptionalHeader.DataDirectory[1].VirtualAddress=MemPos_ImportSection;//C|[ge[u
	ImagePeHdr.OptionalHeader.DataDirectory[1].Size=FileSize_ImportSection;
	ImagePeHdr.OptionalHeader.DataDirectory[2].VirtualAddress=MemPos_RSrcSection;
	ImagePeHdr.OptionalHeader.DataDirectory[2].Size=RSrcSectionSize;
	ImagePeHdr.OptionalHeader.DataDirectory[3].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[3].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[4].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[4].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[5].VirtualAddress=MemPos_RelocSection;
	ImagePeHdr.OptionalHeader.DataDirectory[5].Size=pobj_Reloc->length;
	ImagePeHdr.OptionalHeader.DataDirectory[6].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[6].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[7].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[7].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[8].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[8].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[9].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[9].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[10].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[10].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[11].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[11].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[12].VirtualAddress=MemPos_ImportSection+
		(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR)+
		16*ImportDllNum+	//DLL
		LookupSize+			//bNAbve[u
		HintSize;			//qgi֐je[u
	ImagePeHdr.OptionalHeader.DataDirectory[12].Size=LookupSize;
	ImagePeHdr.OptionalHeader.DataDirectory[13].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[13].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[14].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[14].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[15].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[15].Size=0;


	//R[hZNVwb_
	IMAGE_SECTION_HEADER CodeSectionHeader;
	memset((char *)CodeSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)CodeSectionHeader.Name,".text");
	CodeSectionHeader.Misc.VirtualSize=			MemSize_CodeSection;
	CodeSectionHeader.VirtualAddress=			MemPos_CodeSection;	//JnAhX
	CodeSectionHeader.SizeOfRawData=			FileSize_CodeSection;
	CodeSectionHeader.PointerToRawData=			FilePos_CodeSection;	//t@C̊JnAhX
	CodeSectionHeader.PointerToRelocations=		0;
	CodeSectionHeader.PointerToLinenumbers=		0;
	CodeSectionHeader.NumberOfRelocations=		0;
	CodeSectionHeader.NumberOfLinenumbers=		0;
	CodeSectionHeader.Characteristics=			IMAGE_SCN_MEM_EXECUTE|
												IMAGE_SCN_MEM_READ|
												IMAGE_SCN_CNT_CODE;

	//GNX|[gZNVwb_
	IMAGE_SECTION_HEADER ExportSectionHeader;
	memset((char *)ExportSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)ExportSectionHeader.Name,".edata");
	ExportSectionHeader.Misc.VirtualSize=		MemSize_ExportSection;
	ExportSectionHeader.VirtualAddress=			MemPos_ExportSection;	//JnAhX
	ExportSectionHeader.SizeOfRawData=			FileSize_ExportSection;	//TCY
	ExportSectionHeader.PointerToRawData=		FilePos_ExportSection;	//t@C̊JnAhX
	ExportSectionHeader.PointerToRelocations=	0;
	ExportSectionHeader.PointerToLinenumbers=	0;
	ExportSectionHeader.NumberOfRelocations=	0;
	ExportSectionHeader.NumberOfLinenumbers=	0;
	ExportSectionHeader.Characteristics=		IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ;

	//C|[gZNVwb_
	IMAGE_SECTION_HEADER ImportSectionHeader;
	memset((char *)ImportSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)ImportSectionHeader.Name,".idata");
	ImportSectionHeader.Misc.VirtualSize=		MemSize_ImportSection;
	ImportSectionHeader.VirtualAddress=			MemPos_ImportSection;	//JnAhX
	ImportSectionHeader.SizeOfRawData=			FileSize_ImportSection;	//TCY
	ImportSectionHeader.PointerToRawData=		FilePos_ImportSection;	//t@C̊JnAhX
	ImportSectionHeader.PointerToRelocations=	0;
	ImportSectionHeader.PointerToLinenumbers=	0;
	ImportSectionHeader.NumberOfRelocations=	0;
	ImportSectionHeader.NumberOfLinenumbers=	0;
	ImportSectionHeader.Characteristics=		IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ;

	//f[^ZNVwb_
	IMAGE_SECTION_HEADER DataSectionHeader;
	memset((char *)DataSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)DataSectionHeader.Name,".sdata");
	DataSectionHeader.Misc.VirtualSize=			MemSize_DataSection;
	DataSectionHeader.VirtualAddress=			MemPos_DataSection;
	DataSectionHeader.SizeOfRawData=			FileSize_DataSection;
	DataSectionHeader.PointerToRawData=			FilePos_DataSection;
	DataSectionHeader.PointerToRelocations=		0;
	DataSectionHeader.PointerToLinenumbers=		0;
	DataSectionHeader.NumberOfRelocations=		0;
	DataSectionHeader.NumberOfLinenumbers=		0;
	DataSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ|
												IMAGE_SCN_MEM_WRITE;

	//C^uZNVwb_
	IMAGE_SECTION_HEADER RWSectionHeader;
	memset((char *)RWSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)RWSectionHeader.Name,".data");
	RWSectionHeader.Misc.VirtualSize=			AllInitGlobalVarSize+AllGlobalVarSize;
	RWSectionHeader.VirtualAddress=				MemPos_RWSection;
	RWSectionHeader.SizeOfRawData=				FileSize_RWSection;
	RWSectionHeader.PointerToRawData=			FilePos_RWSection;
	RWSectionHeader.PointerToRelocations=		0;
	RWSectionHeader.PointerToLinenumbers=		0;
	RWSectionHeader.NumberOfRelocations=		0;
	RWSectionHeader.NumberOfLinenumbers=		0;
	RWSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ|
												IMAGE_SCN_MEM_WRITE;

	//\[XZNVwb_
	IMAGE_SECTION_HEADER RSrcSectionHeader;
	memset((char *)RSrcSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)RSrcSectionHeader.Name,".rsrc");
	RSrcSectionHeader.Misc.VirtualSize=			RSrcSectionSize;
	RSrcSectionHeader.VirtualAddress=			MemPos_RSrcSection;
	RSrcSectionHeader.SizeOfRawData=			FileSize_RSrcSection;
	RSrcSectionHeader.PointerToRawData=			FilePos_RSrcSection;
	RSrcSectionHeader.PointerToRelocations=		0;
	RSrcSectionHeader.PointerToLinenumbers=		0;
	RSrcSectionHeader.NumberOfRelocations=		0;
	RSrcSectionHeader.NumberOfLinenumbers=		0;
	RSrcSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ;

	//P[VZNVwb_
	IMAGE_SECTION_HEADER RelocSectionHeader;
	memset((char *)RelocSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)RelocSectionHeader.Name,".reloc");
	RelocSectionHeader.Misc.VirtualSize=		pobj_Reloc->length;
	RelocSectionHeader.VirtualAddress=			MemPos_RelocSection;	//JnAhX
	RelocSectionHeader.SizeOfRawData=			FileSize_RelocSection;	//TCY
	RelocSectionHeader.PointerToRawData=		FilePos_RelocSection;	//t@C̊JnAhX
	RelocSectionHeader.PointerToRelocations=	0;
	RelocSectionHeader.PointerToLinenumbers=	0;
	RelocSectionHeader.NumberOfRelocations=		0;
	RelocSectionHeader.NumberOfLinenumbers=		0;
	RelocSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_DISCARDABLE|
												IMAGE_SCN_MEM_READ;

	//fobOZNVwb_
	IMAGE_SECTION_HEADER DebugSectionHeader;
	memset((char *)DebugSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)DebugSectionHeader.Name,".debug");
	DebugSectionHeader.Misc.VirtualSize=		pobj_DebugSection->length;
	DebugSectionHeader.VirtualAddress=			MemPos_DebugSection;	//JnAhX
	DebugSectionHeader.SizeOfRawData=			FileSize_DebugSection;	//TCY
	DebugSectionHeader.PointerToRawData=		FilePos_DebugSection;	//t@C̊JnAhX
	DebugSectionHeader.PointerToRelocations=	0;
	DebugSectionHeader.PointerToLinenumbers=	0;
	DebugSectionHeader.NumberOfRelocations=		0;
	DebugSectionHeader.NumberOfLinenumbers=		0;
	DebugSectionHeader.Characteristics=			IMAGE_SCN_MEM_DISCARDABLE|
												IMAGE_SCN_MEM_READ;


	hFile=CreateFile(OutputFileName,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		SetError(53,OutputFileName,-1);
		goto EndWriteOpcode;
	}

	//wb_
	WriteFile(hFile,(void *)&ImageDosHeader,sizeof(IMAGE_DOS_HEADER),(DWORD *)&i2,NULL);
	i=i2;

	//DosX^u
	WriteFile(hFile,DosStubBuffer,DosStubSize,(DWORD *)&i2,NULL);
	i+=i2;

	//0x0100܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,0x0100-i);
	WriteFile(hFile,temp2,0x0100-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	//PEwb_
	WriteFile(hFile,&ImagePeHdr,sizeof(IMAGE_NT_HEADERS),(DWORD *)&i2,NULL);
	i+=i2;

	//R[h ZNV wb_
	WriteFile(hFile,&CodeSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
	i+=i2;

	if(bUse_ExportSection){
		//GNX|[g ZNV wb_
		WriteFile(hFile,&ExportSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_ImportSection){
		//C|[g ZNV wb_
		WriteFile(hFile,&ImportSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_DataSection){
		//f[^ ZNV wb_
		WriteFile(hFile,&DataSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_RWSection){
		//C^uZNVwb_
		WriteFile(hFile,&RWSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_RSrcSection){
		//\[XZNVwb_
		WriteFile(hFile,&RSrcSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_RelocSection){
		//P[VZNVwb_
		WriteFile(hFile,&RelocSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_DebugSection){
		//fobOZNVwb_
		WriteFile(hFile,&DebugSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}

	//EXE_HEADER_SIZE܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,EXE_HEADER_SIZE-i);
	WriteFile(hFile,temp2,EXE_HEADER_SIZE-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	//R[h
	WriteFile(hFile,OpBuffer,obp,(DWORD *)&i2,NULL);
	i+=i2;

	//FilePos_ExportSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_ExportSection-i);
	WriteFile(hFile,temp2,FilePos_ExportSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_ExportSection){
		//GNX|[g fBNg e[u
		WriteFile(hFile,&ImageExportDirectory,sizeof(IMAGE_EXPORT_DIRECTORY),(DWORD *)&i2,NULL);
		i+=i2;

		//GNX|[g AhX e[u
		WriteFile(hFile,lpdwExportAddressTable,ExportNum*sizeof(DWORD),(DWORD *)&i2,NULL);
		i+=i2;

		//GNX|[g|C^ e[u
		WriteFile(hFile,lpdwExportNamePointerTable,ExportNum*sizeof(DWORD),(DWORD *)&i2,NULL);
		i+=i2;

		//GNX|[ge[u
		WriteFile(hFile,lpwExportOrdinalTable,ExportNum*sizeof(WORD),(DWORD *)&i2,NULL);
		i+=i2;

		//V{
		WriteFile(hFile,lpExportNames,ExportNamesLength,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_ImportSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_ImportSection-i);
	WriteFile(hFile,temp2,FilePos_ImportSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_ImportSection){
		//C|[g fBNg e[uiNullfBNg e[u܂ށj
		for(i3=0;i3<(ImportDllNum+1);i3++){
			WriteFile(hFile,&pImportTable[i3],sizeof(IMAGE_IMPORT_DESCRIPTOR),(DWORD *)&i2,NULL);
			i+=i2;
		}

		//DLL
		for(i3=0;i3<ImportDllNum;i3++){
			WriteFile(hFile,ppDllNames[i3],16,(DWORD *)&i2,NULL);
			i+=i2;
		}

		//bNAbv e[u
		WriteFile(hFile,pLookupTable,LookupSize,(DWORD *)&i2,NULL);
		i+=i2;

		//qg e[u
		WriteFile(hFile,pHintTable,HintSize,(DWORD *)&i2,NULL);
		i+=i2;

		//C|[g AhX e[u
		WriteFile(hFile,pLookupTable,LookupSize,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_DataSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_DataSection-i);
	WriteFile(hFile,temp2,FilePos_DataSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_DataSection){
		//f[^ e[u
		WriteFile(hFile,compiler.GetNativeCode().GetDataTable().GetPtr(),compiler.GetNativeCode().GetDataTable().GetSize(),(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_RWSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_RWSection-i);
	WriteFile(hFile,temp2,FilePos_RWSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_RWSection){
		//C^u f[^ e[uiO[oϐ̏obt@j
		initGlobalBuf=(BYTE *)HeapReAlloc(hHeap,
			HEAP_ZERO_MEMORY,
			initGlobalBuf,
			FileSize_RWSection);
		WriteFile(hFile,initGlobalBuf,FileSize_RWSection,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_RSrcSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_RSrcSection-i);
	WriteFile(hFile,temp2,FilePos_RSrcSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_RSrcSection){
		//\[Xobt@
		WriteFile(hFile,RSrcSectionBuffer,RSrcSectionSize,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_RelocSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_RelocSection-i);
	WriteFile(hFile,temp2,FilePos_RelocSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_RelocSection){
		//P[V
		WriteFile(hFile,pobj_Reloc->buffer,pobj_Reloc->length,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//t@CACgl
	if(i%FILE_ALIGNMENT){
		temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FILE_ALIGNMENT-i%FILE_ALIGNMENT);
		WriteFile(hFile,temp2,FILE_ALIGNMENT-i%FILE_ALIGNMENT,(DWORD *)&i2,NULL);
		HeapDefaultFree(temp2);
		i+=i2;
	}

	if(bUse_DebugSection){
		//fobOZNV
		WriteFile(hFile,pobj_DebugSection->buffer,pobj_DebugSection->length,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//t@CACgl
	if(i%FILE_ALIGNMENT){
		temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FILE_ALIGNMENT-i%FILE_ALIGNMENT);
		WriteFile(hFile,temp2,FILE_ALIGNMENT-i%FILE_ALIGNMENT,(DWORD *)&i2,NULL);
		HeapDefaultFree(temp2);
		i+=i2;
	}

	//ݏI
	CloseHandle(hFile);


EndWriteOpcode:

	//DosX^up̃
	HeapDefaultFree(DosStubBuffer);

	//GNX|[g e[u
	HeapDefaultFree(lpdwExportAddressTable);
	HeapDefaultFree(lpdwExportNamePointerTable);
	HeapDefaultFree(lpwExportOrdinalTable);

	//C|[gDLL
	HeapDefaultFree(pImportTable);
	for(i=0;i<ImportDllNum;i++)
		HeapDefaultFree(ppDllNames[i]);
	HeapDefaultFree(ppDllNames);

	//bNAbve[uɊւ
	HeapDefaultFree(pLookupTable);

	//qge[uɊւ
	HeapDefaultFree(pHintTable);

	//O[oϐ̏obt@
	HeapDefaultFree(initGlobalBuf);

	//R[hobt@
	free(OpBuffer);
	OpBuffer=0;

	//\[XZNVobt@
	HeapDefaultFree(RSrcSectionBuffer);

	//fobOZNVJ
	delete pobj_DebugSection;

	//P[V
	delete pobj_Reloc;

	//񋓑̂Ɋւ̔j
	CEnumParent::DestroyEnum();

	//NXɊւ郁
	compiler.GetMeta().GetClasses().Clear();
}
