#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Compiler.h>
#include <ProcedureImpl.h>
#include <NamespaceSupporter.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif

bool UserProcImpl::SetParamsAndReturnType( const char *sourceOfParams, int nowLine, bool isStatic ){
	int i = 0;
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//\[XR[ḧʒu
	this->codePos = nowLine;

	//p[^
	if(sourceOfParams[i]!='('){
		SmoothieException::Throw(1,NULL,nowLine);
		return 0;
	}
	i++;
	if(sourceOfParams[i]!=')'&& this->pParentClass ){
		//NX̃o֐̏ꍇ̂݁AfXgN^Ƀp[^ꍇɃG[
		if(this->GetName()[0]=='~'){
			SmoothieException::Throw(114,NULL,nowLine);
			i=JumpStringInPare(sourceOfParams,i);
		}
	}
	while(1){
		if(sourceOfParams[i]==')') break;

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		int subScripts[MAX_ARRAYDIM];
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']')){
				subScripts[0]=LONG_MAX;
				subScripts[1]=-1;

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subScripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		Type type( DEF_NON );
		char initValue[8192] = "";
		if( sourceOfParams[i] == '=' ){
			i++;
			i = GetOneParameter( sourceOfParams, i, initValue );

			// TODO: G[p fix me!!!
			//cp = nowLine;

			NumOpe_GetType( initValue, GetStringTypeInfo(), type );
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
			// Asw
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			Compiler::StringToType( temporary, type );

			if( type.IsNull() ){
				SmoothieException::Throw(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}

			if( type.IsObject() ){
				if( type.GetClass().IsBlittableType() ){
					// Blittable^̂Ƃ͊{^ƂĈ
					type = type.GetClass().GetBlittableType();
				}
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			SmoothieException::Throw(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef, initValue );
		if( isArray ){
			pParam->SetArray( subScripts );
		}

		//p[^ǉ
		this->params.push_back( pParam );

		if(sourceOfParams[i]==','){
			i++;
			continue;
		}
		else if(sourceOfParams[i]==')') continue;
		else{
			SmoothieException::Throw(1,NULL,nowLine);
			break;
		}
	}
	this->secondParmNum = (int)this->params.size();
	i++;
	if(sourceOfParams[i]=='('){
		i++;
		while(1){
			if(sourceOfParams[i]==')') break;

			//ByRef
			bool isRef;
			if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
				isRef = false;
				i+=2;
			}
			else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
				isRef = true;
				i+=2;
			}
			else isRef = false;

			//p[^
			bool isArray = false;
			int subScripts[MAX_ARRAYDIM];
			char name[VN_SIZE];
			sw=0;
			for(i2=0;;i++,i2++){
				if(sourceOfParams[i]=='('){
					if(!sw) sw=1;

					i3=GetStringInPare(name+i2,sourceOfParams+i);
					i2+=i3-1;
					i+=i3-1;
					continue;
				}
				if(sourceOfParams[i]=='['){
					if(!sw) sw=1;

					i3=GetStringInBracket(name+i2,sourceOfParams+i);
					i2+=i3-1;
					i+=i3-1;
					continue;
				}
				if(!IsVariableChar(sourceOfParams[i])){
					name[i2]=0;
					break;
				}
				name[i2]=sourceOfParams[i];
			}
			if(sw){
				//zp[^
				if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
				isArray = true;

				if((name[i2-2]=='('&&name[i2-1]==')')||
					(name[i2-2]=='['&&name[i2-1]==']')){
					subScripts[0]=LONG_MAX;
					subScripts[1]=-1;

					name[i2-2]=0;
				}
				else{
					GetArrange(name,temp2,subScripts);
					lstrcpy(name,temp2);
				}

				i2=lstrlen(name);
			}

			//^
			Type type( DEF_NON );
			if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
				i+=2;

				i2=0;
				while(sourceOfParams[i]=='*'){
					temporary[i2]=sourceOfParams[i];
					i++;
					i2++;
				}
				for(;;i++,i2++){
					if(!IsVariableChar(sourceOfParams[i])){
						if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
							temporary[i2++]=sourceOfParams[i++];
							temporary[i2]=sourceOfParams[i];
							continue;
						}
						temporary[i2]=0;
						break;
					}
					temporary[i2]=sourceOfParams[i];
				}

				Compiler::StringToType( temporary, type );

				if( type.IsNull() ){
					SmoothieException::Throw(3,temporary,nowLine);
					type.SetBasicType( DEF_PTR_VOID );
				}
			}
			else{
				type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
				SmoothieException::Throw(-103,temporary,nowLine);
			}

			Parameter *pParam = new Parameter( name, type, isRef );
			if( isArray ){
				pParam->SetArray( subScripts );
			}

			//p[^ǉ
			this->params.push_back( pParam );

			if(sourceOfParams[i]==','){
				i++;
				continue;
			}
			else if(sourceOfParams[i]==')') continue;
			else{
				SmoothieException::Throw(1,NULL,nowLine);
				break;
			}
		}
		i++;
	}

	if(sourceOfParams[i]){
		///////////////////
		// ߂l擾
		///////////////////

		if( !this->IsFunction() ){
			// Sub/Macrȍꍇ
			SmoothieException::Throw(38,this->GetName(),nowLine);
		}

		if( this->pParentClass ){
			if( this->GetName() == this->pParentClass->GetName() ||
				this->GetName()[0]=='~'){
				//NX̃RXgN^AfXgN^Function`̏ꍇ̓G[
				SmoothieException::Throw(115,NULL,nowLine);
			}
		}


		i2=lstrlen(sourceOfParams)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(sourceOfParams[i2]==')') break;

			if(sourceOfParams[i2]==1&&sourceOfParams[i2+1]==ESC_AS){
				i2+=2;
				i3=0;
				while(sourceOfParams[i2]=='*') temporary[i3++]=sourceOfParams[i2++];
				for(;;i2++,i3++){
					if(!IsVariableChar(sourceOfParams[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=sourceOfParams[i2];
				}
				Compiler::StringToType( temporary, this->returnType );
				if( this->returnType.IsNull() ) SmoothieException::Throw(3,temporary,nowLine);

				sw_as=1;
				break;
			}
		}

		if(!sw_as){
			SmoothieException::Throw(-104,this->GetName().c_str(),nowLine);

			this->returnType.SetBasicType( DEF_DOUBLE );
		}
	}
	else{
		//߂lȂSub`
		this->returnType.SetNull();
	}

	//Ap[^̈擾i_System_LocalThisl2mۂꍇj

	if( this->pParentClass && isStatic == false ){
		//IuWFNgȍꍇ́Ap[^_System_LocalThisnpƂėp
		string name = "_System_LocalThis";
		Type type( DEF_PTR_VOID );
		this->realParams.push_back( new Parameter( name, type ) );
	}

	if( this->returnType.IsStruct() ){
		//\̂߂lƂĎꍇ
		//p[^iThis|C^̏ꍇ͑p[^j߂lp̎QƐ錾ɂ

		string name = this->GetName();
		if(name[0]==1&&name[1]==ESC_OPERATOR){
			name="_System_ReturnValue";
		}
		Type type( DEF_STRUCT, this->returnType.GetIndex() );
		this->realParams.push_back( new Parameter( name, type, true ) );
	}

	//p[^Rs[
	BOOST_FOREACH( Parameter *pParam, params ){
		this->realParams.push_back( new Parameter( *pParam ) );
	}

	return true;
}

const NamespaceScopes &GlobalProc::GetNamespaceScopes() const
{
	if( HasParentClass() ){
		return GetParentClassPtr()->GetNamespaceScopes();
	}
	return namespaceScopes;
}
bool GlobalProc::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}

	return namespaceSupporter.IsSameAreaNamespace( GetNamespaceScopes(), namespaceScopes );
}
bool GlobalProc::IsEqualSymbol( const GlobalProc &globalProc ) const
{
	return IsEqualSymbol( globalProc.GetNamespaceScopes(), globalProc.GetName() );
}
bool GlobalProc::IsEqualSymbol( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = CClass::SplitName( fullName.c_str(), AreaName, NestName );

	return IsEqualSymbol( NamespaceScopes( AreaName ), NestName );
}

bool DllProcImpl::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}
	return namespaceSupporter.IsSameAreaNamespace( this->GetNamespaceScopes(), namespaceScopes );
}
bool DllProcImpl::SetParamsAndReturnType( const char *sourceOfParams, int nowLine ){
	int i = 0;
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//\[XR[ḧʒu
	this->codePos = nowLine;

	//p[^
	if(sourceOfParams[i]!='('){
		SmoothieException::Throw(1,NULL,nowLine);
		return 0;
	}
	i++;

	while(1){
		if(sourceOfParams[i]==')') break;

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		int subScripts[MAX_ARRAYDIM];
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']')){
				subScripts[0]=LONG_MAX;
				subScripts[1]=-1;

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subScripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		//^
		Type type( DEF_NON );
		if(lstrcmp(name,"...")==0) type.SetBasicType( DEF_ELLIPSE );
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			Compiler::StringToType( temporary, type );

			if( type.IsNull() ){
				SmoothieException::Throw(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			SmoothieException::Throw(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef );
		if( isArray ){
			pParam->SetArray( subScripts );
		}

		//p[^ǉ
		this->params.push_back( pParam );

		if(sourceOfParams[i]==','){
			i++;
			continue;
		}
		else if(sourceOfParams[i]==')') continue;
		else{
			SmoothieException::Throw(1,NULL,nowLine);
			break;
		}
	}
	i++;

	if(sourceOfParams[i]){
		///////////////////
		// ߂l擾
		///////////////////

		i2=lstrlen(sourceOfParams)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(sourceOfParams[i2]==')') break;

			if(sourceOfParams[i2]==1&&sourceOfParams[i2+1]==ESC_AS){
				i2+=2;
				i3=0;
				while(sourceOfParams[i2]=='*') temporary[i3++]=sourceOfParams[i2++];
				for(;;i2++,i3++){
					if(!IsVariableChar(sourceOfParams[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=sourceOfParams[i2];
				}
				Compiler::StringToType( temporary, this->returnType );
				if( this->returnType.IsNull() ) SmoothieException::Throw(3,temporary,nowLine);

				sw_as=1;
				break;
			}
		}
	}
	else{
		//߂lȂSub`
		this->returnType.SetNull();
	}

	return true;
}

bool ProcPointerImpl::SetParamsAndReturnType( const char *sourceOfParams, int nowLine ){
	int i = 0;
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//\[XR[ḧʒu
	this->codePos = nowLine;

	//p[^
	if(sourceOfParams[i]!='('){
		SmoothieException::Throw(1,NULL,nowLine);
		return 0;
	}
	i++;
	while(1){
		if(sourceOfParams[i]==')') break;

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		int subScripts[MAX_ARRAYDIM];
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']')){
				subScripts[0]=LONG_MAX;
				subScripts[1]=-1;

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subScripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		//^
		Type type( DEF_NON );
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			Compiler::StringToType( temporary, type );

			if( type.IsNull() ){
				SmoothieException::Throw(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			SmoothieException::Throw(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef );
		if( isArray ){
			pParam->SetArray( subScripts );
		}

		//p[^ǉ
		this->params.push_back( pParam );

		if(sourceOfParams[i]==','){
			i++;
			continue;
		}
		else if(sourceOfParams[i]==')') continue;
		else{
			SmoothieException::Throw(1,NULL,nowLine);
			break;
		}
	}
	i++;

	if(sourceOfParams[i]){
		///////////////////
		// ߂l擾
		///////////////////

		i2=lstrlen(sourceOfParams)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(sourceOfParams[i2]==')') break;

			if(sourceOfParams[i2]==1&&sourceOfParams[i2+1]==ESC_AS){
				i2+=2;
				i3=0;
				while(sourceOfParams[i2]=='*') temporary[i3++]=sourceOfParams[i2++];
				for(;;i2++,i3++){
					if(!IsVariableChar(sourceOfParams[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=sourceOfParams[i2];
				}
				Compiler::StringToType( temporary, this->returnType );
				if( this->returnType.IsNull() ) SmoothieException::Throw(3,temporary,nowLine);

				sw_as=1;
				break;
			}
		}
	}
	else{
		//߂lȂSub`
		this->returnType.SetNull();
	}

	//߂l̃G[`FbN
	if( IsFunction() ){
		// Function`

		if( this->ReturnType().IsNull() ){
			// ߂lȂ
			SmoothieException::Throw(26,this->GetName(),nowLine);
		}
	}
	else{
		if( !this->ReturnType().IsNull() ){
			// Sub`Ȃ̂ɁA߂l
			SmoothieException::Throw(38,this->GetName(),nowLine);
		}
	}

	return true;
}

int ProcPointersImpl::Add( const string &typeExpression )
{
	DWORD dwProcType = (DWORD)typeExpression[2];
	const string &paramStr = typeExpression.substr( 3 );

	Procedure::Kind kind = Procedure::Sub;
	if( dwProcType == ESC_FUNCTION ){
		kind = Procedure::Function;
	}

	ProcPointer *pProcPointer = new ProcPointerImpl( kind );

	//buffer[0]'('ƂȂĂ
	extern int cp;
	pProcPointer->SetParamsAndReturnType( paramStr.c_str(), cp );

	this->push_back( pProcPointer );

	return (int)this->size()-1;
}

void ProcPointersImpl::Clear()
{
	ProcPointersImpl &procPointers = *this;
	BOOST_FOREACH( ProcPointer *pProcPointer, procPointers ){
		delete pProcPointer;
	}
	this->clear();
}
