#include <Compiler.h>
#include <VariableImpl.h>

bool VariableImpl::IsEqualSymbol( const Symbol &symbol, bool isSupportStaticMember ) const
{
	if( GetName() == symbol.GetName()
		&& compiler.IsSameAreaNamespace( this->GetNamespaceScopes(), symbol.GetNamespaceScopes() ) )
	{
		return true;
	}

	if( isSupportStaticMember && symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( Symbol( namespaceScopes, name ), false );
	}
	return false;
}
