#pragma once

#include <CodeGenerator.h>
#include <MetaImpl.h>

class Compiler
{
	NativeCode nativeCode;
	MetaImpl metaImpl;

	NamespaceScopesCollection importedNamespaces;

public:
	NativeCode &GetNativeCode()
	{
		return nativeCode;
	}

	MetaImpl &GetMeta()
	{
		return metaImpl;
	}

	NamespaceScopesCollection &GetImportedNamespaces()
	{
		return importedNamespaces;
	}
	void SetImportedNamespaces( const NamespaceScopesCollection &namespaces )
	{
		this->importedNamespaces = namespaces;
	}
	bool ImportsNamespace( const std::string &namespaceStr )
	{
		NamespaceScopes namespaceScopes( namespaceStr );
		if( !this->GetMeta().GetNamespaces().IsExist( namespaceScopes ) ){
			return false;
		}

		this->importedNamespaces.push_back( namespaceScopes );

		return true;
	}

	static bool StringToType( const std::string &typeName, Type &type );
	static const std::string TypeToString( const Type &type );

	// w肳ꂽOԂGAƌȂ邩ǂ`FbN
	bool IsSameAreaNamespace( const NamespaceScopes &baseNamespaceScopes, const NamespaceScopes &entryNamespaceScopes ){
		if( entryNamespaceScopes.size() ){
			if( baseNamespaceScopes.IsCoverd( entryNamespaceScopes ) ){
				// ĂƂ͓ƌȂ
				return true;
			}
		}
		else{
			if( baseNamespaceScopes.size() ){
				// OԂ̔fKvȂƂ
				if( this->importedNamespaces.IsImported( baseNamespaceScopes )
					|| baseNamespaceScopes.IsLiving() ){
					// Usingw肪Ƃ
					// ܂
					// w肳ꂽOԂ݂̖OԃXR[vƓ̂Ƃ
					return true;
				}
			}
			else{
				return true;
			}
		}

		return false;
	}
};

static Compiler compiler;
