#pragma once

#include <jenga/include/smoothie/Procedure.h>


class UserProcImpl : public UserProc
{
public:
	UserProcImpl( const string &name, Kind kind, bool isMacro, bool isCdecl, bool isExport )
		: UserProc( name, kind, isMacro, isCdecl, isExport )
	{
	}
	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine, bool isStatic );
};

class GlobalProc : public UserProcImpl
{
	const NamespaceScopes namespaceScopes;
	const NamespaceScopesCollection importedNamespaces;
public:
	// nbVXgp
	GlobalProc *pNextData;

	GlobalProc( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name, Kind kind, bool isMacro, bool isCdecl, bool isExport ):
	  UserProcImpl( name, kind, isMacro, isCdecl, isExport ),
	  namespaceScopes( namespaceScopes ),
	  importedNamespaces( importedNamespaces ),
	  pNextData( NULL )
	{}
	~GlobalProc(){}

	virtual const NamespaceScopes &GetNamespaceScopes() const;
	virtual const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	virtual bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;
	virtual bool IsEqualSymbol( const GlobalProc &globalProc ) const;
	virtual bool IsEqualSymbol( const string &name ) const;
};

class DllProcImpl : public DllProc
{
public:
	DllProcImpl( const NamespaceScopes &namespaceScopes, const string &name, Kind kind, bool isCdecl, const string &dllFileName, const string &alias )
		: DllProc( namespaceScopes, name, kind, isCdecl, dllFileName, alias )
	{
	}

	virtual bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine );
};

class ProcPointerImpl : public ProcPointer
{
public:
	ProcPointerImpl( Kind kind ):
	  ProcPointer( kind )
	{
	}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine );
};

class ProcPointersImpl : public ProcPointers
{
public:
	ProcPointersImpl()
	{
	}
	~ProcPointersImpl()
	{
		Clear();
	}

	virtual int Add( const string &typeExpression );
	virtual void Clear();
};
