#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <LexicalScopingImpl.h>
#include <CodeGenerator.h>
#include <Compiler.h>
#include <VariableImpl.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

//ϐ
Variables globalVars;
int AllGlobalVarSize;
int AllInitGlobalVarSize;

int AllLocalVarSize;


void SetRelativeOffset( Type &resultType, RELATIVE_VAR *pRelativeVar,const char *lpPtrOffset){
	PushLongVariable(pRelativeVar);

	Type type;
	NumOpe( lpPtrOffset, Type(), type );
	ChangeTypeToLong( type.GetBasicType() );

	//pop ebx
	op_pop(REG_EBX);

	if( resultType.PtrLevel() ){
		resultType.PtrLevelDown();

		int typeSize = resultType.GetSize();
		if(typeSize>=2){
			//imul ebx,i2
			op_imul_RV( REG_EBX, typeSize );
		}
	}
	else{
		//G[
		SetError(1,NULL,cp);
		return;
	}

	//pop ecx
	op_pop(REG_ECX);

	//add ecx,ebx
	OpBuffer[obp++]=(char)0x03;
	OpBuffer[obp++]=(char)0xCB;
}
void SetRelativeOffset( RELATIVE_VAR &relativeVar ){
	if(relativeVar.dwKind==VAR_DIRECTMEM){
		//mov ecx,dword ptr[ecx]
		op_mov_RM( sizeof(long), REG_ECX, REG_ECX, 0, MOD_BASE );
	}
	else{
		//ڎQƂɐ؂ւ
		SetVarPtrToEax(&relativeVar);
		relativeVar.dwKind=VAR_DIRECTMEM;

		//mov ecx,dword ptr[eax]
		op_mov_RM( sizeof(long), REG_ECX, REG_EAX, 0, MOD_BASE );
	}
}
bool GetArrayOffset(const int *SubScripts,char *array, const Type &type){
	extern HANDLE hHeap;
	int i,i2,i3,i4;
	char temporary[VN_SIZE],*pParm[MAX_PARMS];

	for(i=0,i2=0,i3=0;;i++,i2++){
		if(array[i]=='('){
			i4=GetStringInPare(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]=='['){
			i4=GetStringInBracket(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]==','||array[i]=='\0'){
			if(SubScripts[i3]==-1){
				for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
				return 0;
			}

			temporary[i2]=0;

			pParm[i3]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(pParm[i3],temporary);

			i3++;

			if(array[i]=='\0'){
				if(SubScripts[i3]!=-1){
					for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
					return 0;
				}
				break;
			}

			i2=-1;
			continue;
		}
		temporary[i2]=array[i];
	}

	//push ecx
	op_push(REG_ECX);

	//push 0
	op_push_V(0);

	for(i=i3-1;i>=0;i--){
		Type tempType;
		BOOL bUseHeap;
		NumOpe( pParm[i], Type( DEF_LONG ), tempType, &bUseHeap );
		if( tempType.IsObject() ){
			//LXgZq̃I[o[[hɑΉ
			CallCastOperatorProc(
				tempType,
				bUseHeap, Type(DEF_LONG) );
			tempType.SetBasicType( DEF_LONG );
		}
		ChangeTypeToLong( tempType.GetBasicType() );

		//pop eax
		op_pop(REG_EAX);

		for(i2=i+1,i4=1;i2<i3;i2++) i4*=SubScripts[i2]+1;

		//imul eax,i4
		OpBuffer[obp++]=(char)0x69;
		OpBuffer[obp++]=(char)0xC0;
		*((long *)(OpBuffer+obp))=i4;
		obp+=sizeof(long);

		//add dword ptr[esp],eax
		OpBuffer[obp++]=(char)0x01;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;

		HeapDefaultFree(pParm[i]);
	}

	//pop eax
	op_pop(REG_EAX);

	//imul eax,TypeSize
	OpBuffer[obp++]=(char)0x69;
	OpBuffer[obp++]=(char)0xC0;
	*((long *)(OpBuffer+obp)) = type.GetSize();
	obp+=sizeof(long);

	//pop ecx
	op_pop(REG_ECX);

	//add ecx,eax
	OpBuffer[obp++]=(char)0x03;
	OpBuffer[obp++]=(char)0xC8;

	return 1;
}
bool _member_offset(bool isErrorEnabled, bool isWriteAccess, const CClass &objClass, const char *member, RELATIVE_VAR *pRelativeVar, Type &resultType, BOOL bPrivateAccess){

	//////////////////////////////////////
	// NXAz̍\vf͂
	//////////////////////////////////////

	char VarName[VN_SIZE];		//ϐ
	char array[VN_SIZE];		//1z
	char lpPtrOffset[VN_SIZE];	//2z
	char NestMember[VN_SIZE];	//qo
	CClass::RefType refType;
	lstrcpy(VarName,member);
	if(!GetVarFormatString(VarName,array,lpPtrOffset,NestMember,refType)) return false;


	////////////////////////////
	// oItZbg擾
	////////////////////////////

	int memberIndex;
	int offset = objClass.GetMemberOffset( VarName, &memberIndex );
	if(memberIndex==objClass.GetDynamicMembers().size()){
		if(isErrorEnabled) SetError(103,VarName,cp);
		return false;
	}

	CMember *pMember=objClass.GetDynamicMembers()[memberIndex];


	//ANZVreB`FbN
	if(&objClass==Smoothie::Temp::pCompilingClass){
		//NXIuWFNg̏ꍇ̓vCx[gANZXeF
		if(pMember->IsNoneAccess()){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return false;
		}
	}
	else{
		if((bPrivateAccess==0&&pMember->IsPrivate())||
			pMember->IsNoneAccess()){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return false;
		}
		else if(bPrivateAccess==0&&pMember->IsProtected()){
			if(isErrorEnabled) SetError(108,VarName,cp);
			return false;
		}
	}

	//Const`̏ꍇ͏݃ANZX𐧌
	//RXgN^RpC̏ꍇ͗OIɋ
	if( pMember->IsConst() &&		//萔oł
		isWriteAccess &&							//݃ANZXvĂ
		objClass.IsCompilingConstructor() == false	//RXgN^ RpC
		){
			//Const`̕ϐɏ݃ANZX悤Ƃꍇ
			SetError(61,VarName,cp);
	}

	resultType = pMember->GetType();

	//|C^ϐ̏ꍇ
	if( resultType.IsPointer() ){
		if(pMember->SubScripts[0]==-1){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(isErrorEnabled) SetError(16,member,cp);
			return false;
		}
	}

	if(offset){
		//add ecx,offset
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xC1;
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}

	if(array[0]){
		//zItZbg
		if(!GetArrayOffset(pMember->SubScripts,array,pMember->GetType())){
			if(isErrorEnabled) SetError(14,member,cp);
		}
	}
	else if(pMember->SubScripts[0]!=-1){
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );
	}

	if(NestMember[0]){
		//q\̏ꍇ

		if( resultType.IsObject() || resultType.IsStruct() ){
			if( refType != CClass::Dot ){
				if(isErrorEnabled) SetError(104,member,cp);
				return false;
			}

			if( resultType.IsObject() ){
				// QƓeւ̃|C^𒊏o
				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.IsObjectPtr() || resultType.IsStructPtr() ){
			//\̃|C^^oϐ

			if(lpPtrOffset[0]){
				//pObj[n].member
				if( ( resultType.IsObjectPtr() || resultType.IsStructPtr() )
					&& refType != CClass::Dot ){
						if(isErrorEnabled) SetError(104,member,cp);
						return false;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;
			}
			else{
				//pObj->member
				if( ( resultType.IsObjectPtr() || resultType.IsStructPtr() )
					&& refType != CClass::Pointer ){
						if(isErrorEnabled) SetError(104,member,cp);
						return false;
				}

				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.GetBasicType() == MAKE_PTR_TYPE(DEF_OBJECT,2)
			|| resultType.GetBasicType() == MAKE_PTR_TYPE(DEF_STRUCT,2)){
			//\̃|C^̃|C^^oϐ

			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if( refType != CClass::Pointer ){
					if(isErrorEnabled) SetError(104,member,cp);
					return false;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;

				//mov ecx,dword ptr[ecx]
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0x09;
			}
			else{
				if(isErrorEnabled) SetError(104,member,cp);
				return false;
			}
		}

		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			pMember->GetType().GetClass(),
			NestMember,
			pRelativeVar,
			resultType,
			0)) return false;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return true;
}

int LocalVar_ThisPtrOffset;
void SetThisPtrToReg(int reg){
	//g̃IuWFNgThis|C^regɃRs[

	RELATIVE_VAR RelativeVar;
	RelativeVar.dwKind=VAR_LOCAL;
	RelativeVar.bOffsetOffset=0;
	RelativeVar.offset=-LocalVar_ThisPtrOffset;

	SetReg_WholeVariable(DEF_PTR_VOID,&RelativeVar,reg);
}

bool GetVarOffset(bool isErrorEnabled,bool isWriteAccess,const char *NameBuffer,RELATIVE_VAR *pRelativeVar,Type &resultType,int *pss){
	char variable[VN_SIZE];

	if(NameBuffer[0]=='.'){
		GetWithName(variable);
		lstrcat(variable,NameBuffer);
	}
	else lstrcpy(variable,NameBuffer);

	// OԂ𕪗
	char namespaceStr[VN_SIZE]="", simpleName[VN_SIZE];
	compiler.GetMeta().GetNamespaces().SplitNamespace( variable, namespaceStr, simpleName );

	// 擪IuWFNg܂̓NXƓqoɕ
	CClass::RefType refType;
	char member[VN_SIZE],array[VN_SIZE],lpPtrOffset[VN_SIZE];
	GetVarFormatString(simpleName,array,lpPtrOffset,member,refType);

	// OԂ𕪗Ăꍇ͌
	char VarName[VN_SIZE];
	if( namespaceStr[0] ){
		sprintf( VarName, "%s.%s", namespaceStr, simpleName );
	}
	else{
		lstrcpy( VarName, simpleName );
	}

	const int *pSubScripts;
	bool bConst = false;


	if( UserProc::IsLocalAreaCompiling() ){
		//////////////////
		// [Jϐ
		//////////////////

		const Variable *pVar = UserProc::CompilingUserProc().localVars.BackSearch( Symbol( VarName ) );
		if( pVar ){
			//|C^ϐ̏ꍇ
			if( pVar->IsPointer() ){
				if( !pVar->IsArray() ){
					lstrcpy(lpPtrOffset,array);
					array[0]=0;
				}
			}
			else{
				if(lpPtrOffset[0]){
					SetError(16,variable,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}
			}

			pRelativeVar->offset=-pVar->offset;
			pRelativeVar->bOffsetOffset=0;
			if( pVar->IsRef() ){
				// Qƌ^
				pRelativeVar->dwKind = VAR_REFLOCAL;
			}
			else pRelativeVar->dwKind=VAR_LOCAL;
			resultType = *pVar;
			pSubScripts=pVar->GetSubScriptsPtr();
			bConst = pVar->IsConst();

			goto ok;
		}
	}

	if(Smoothie::Temp::pCompilingClass){
		//////////////////////
		// NXo̎Q
		//////////////////////

		if(lstrcmpi(variable,"This")==0){
			//ThisIuWFNg

			//This|C^ecxɃRs[
			SetThisPtrToReg(REG_ECX);

			pRelativeVar->dwKind=VAR_DIRECTMEM;

			resultType.SetType( DEF_OBJECT, Smoothie::Temp::pCompilingClass );
			return true;
		}

		if(memicmp(variable,"This.",5)==0){
			//ThisIuWFNg̃oQƂƂ
			SlideString(variable+5,-5);
			lstrcpy(VarName,variable);
		}
		else{
			//NXoQƂƂiʏj

			bool isFound = false;
			BOOST_FOREACH( CMember *pMember, Smoothie::Temp::pCompilingClass->GetDynamicMembers() ){
				if( pMember->GetName() == VarName ){
					isFound = true;
					break;
				}
			}
			if( !isFound ) goto NonClassMember;
		}

		//ConstCq̃\bhŃo݃ANZXƂ
		//iRXgN^AfXgN^j
		const CMethod *pMethod = compiler.GetMeta().GetClasses().GetNowCompilingMethodInfo();
		if( isWriteAccess &&
			pMethod->IsConst() &&
			Smoothie::Temp::pCompilingClass->IsCompilingConstructor() == false &&
			Smoothie::Temp::pCompilingClass->IsCompilingDestructor() == false
			){
				SetError(131, NULL, cp );
		}

		/////////////////////////////
		// this|C^ecxɃZbg

		//This|C^ecxɃRs[
		SetThisPtrToReg(REG_ECX);

		pRelativeVar->dwKind=VAR_DIRECTMEM;
		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			*Smoothie::Temp::pCompilingClass,
			variable,
			pRelativeVar,
			resultType,1)) return false;
		return true;
	}

NonClassMember:

	{
		const Variable *pVar;

		//////////////////////////
		// ÓI[Jϐ
		// "Static.Object.Method.Variable"
		//////////////////////////

		char temporary[VN_SIZE];
		if( UserProc::IsLocalAreaCompiling() ){
			GetNowStaticVarFullName(VarName,temporary);

			pVar = globalVars.Find( Symbol( temporary ) );
			if( pVar ){
				goto GlobalOk;
			}
		}


		//////////////////////////
		// NX̐ÓIo
		//////////////////////////

		if(member[0]){
			lstrcpy(temporary,member);

			// TODO: OԂlR[hɂȂĂȂ

			char tempMember[VN_SIZE];
			char tempArray[VN_SIZE];
			{
				CClass::RefType refType;
				GetVarFormatString(temporary,tempArray,lpPtrOffset,tempMember, refType );
			}

			int typeDefIndex = compiler.GetMeta().GetTypeDefs().GetIndex( VarName );
			if( typeDefIndex != -1 ){
				// TypeDef̌^Ƃ
				lstrcpy( VarName, compiler.GetMeta().GetTypeDefs()[typeDefIndex].GetBaseName().c_str() );
			}

			char temp2[VN_SIZE];
			sprintf(temp2,"%s.%s",VarName,temporary);
			pVar = globalVars.Find( Symbol( temp2 ) );
			if( pVar ){
				lstrcpy(member,tempMember);
				lstrcpy(array,tempArray);
				goto GlobalOk;
			}
		}

		if(Smoothie::Temp::pCompilingClass){
			//g̃NXÓIoQƂꍇ
			char temp2[VN_SIZE];
			sprintf(temp2,"%s.%s",Smoothie::Temp::pCompilingClass->GetName().c_str(),VarName);
			pVar = globalVars.Find( Symbol( temp2 ) );
			if( pVar ){
				goto GlobalOk;
			}
		}

		/////////////////////
		// O[oϐ
		/////////////////////

		pVar = globalVars.BackSearch( Symbol( VarName ) );
		if( pVar ){
			goto GlobalOk;
		}

		if(isErrorEnabled) SetError(3,variable,cp);
		pRelativeVar->dwKind=NON_VAR;
		return false;



GlobalOk:
		//|C^ϐ̏ꍇ
		if( pVar->IsPointer() ){
			if( !pVar->IsArray() ){
				lstrcpy(lpPtrOffset,array);
				array[0]=0;
			}
		}
		else{
			if(lpPtrOffset[0]){
				SetError(16,variable,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}
		}

		pRelativeVar->offset=pVar->offset;
		pRelativeVar->bOffsetOffset=0;
		if( pVar->IsRef() ){
			// Qƌ^
			pRelativeVar->dwKind = VAR_REFGLOBAL;
		}
		else pRelativeVar->dwKind=VAR_GLOBAL;
		resultType = *pVar;
		pSubScripts=pVar->GetSubScriptsPtr();
		bConst = pVar->IsConst();
	}



ok:

	if( bConst && isWriteAccess ){
		//Const`̕ϐɏ݃ANZX悤Ƃꍇ
		if( resultType.IsObject() ){
			//IuWFNg萔
			SetError(130, VarName, cp );
		}
		else{
			//ʂConstϐ
			SetError(61,VarName,cp);
		}
	}

	if(array[0]==0&&pSubScripts[0]!=-1){
		//z̐擪|C^ꍇ
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );
		if(pss) memcpy(pss,pSubScripts,MAX_ARRAYDIM);
		return true;
	}

	if(array[0]||member[0]){
		//xor ecx,ecxiecx0ɏj
		//ecx͕ϐx[XAhX̑΃ItZbg
		op_zero_reg(REG_ECX);

		pRelativeVar->bOffsetOffset=1;
	}
	if(array[0]){
		if(!GetArrayOffset(pSubScripts,array,resultType)){
			SetError(14,variable,cp);
			pRelativeVar->dwKind=NON_VAR;
			return false;
		}
	}
	if(member[0]){
		if( resultType.IsObject() || resultType.IsStruct() ){
			//ԃIuWFNg̃oQƁiobj.memberj
			if( refType != CClass::Dot ){
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}

			if( resultType.IsObject() ){
				// QƓeւ̃|C^𒊏o
				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.IsObjectPtr() || resultType.IsStructPtr() ){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//pObj[n].member
				if( refType != CClass::Dot ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;
			}
			else{
				//pObj->member
				if( refType != CClass::Pointer ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}

				SetVarPtrToEax(pRelativeVar);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				//mov ecx,dword ptr[eax]
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0x08;
			}
		}
		else if( resultType.GetBasicType()==MAKE_PTR_TYPE(DEF_OBJECT,2) || resultType.GetBasicType()==MAKE_PTR_TYPE(DEF_STRUCT,2)){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if( refType != CClass::Pointer ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}

				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;


				SetVarPtrToEax(pRelativeVar);

				//mov ecx,dword ptr[eax]
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0x08;
			}
			else{
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}
		}
		else{
			SetError(102,VarName,cp);
			pRelativeVar->dwKind=NON_VAR;
			return false;
		}

		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			resultType.GetClass(),
			member,pRelativeVar,resultType,0)) return false;

		return true;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return true;
}

bool SetInitGlobalData(int offset,const Type &type,const int *SubScripts,const char *lpszInitBuf){
	extern BYTE *initGlobalBuf;
	int i2,i3;
	char temporary[VN_SIZE];
	char InitBuf[VN_SIZE];
	lstrcpy( InitBuf, lpszInitBuf );

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		int typeSize = type.GetSize();

		if(SubScripts[0]!=-1){
			typeSize*=JumpSubScripts(SubScripts+1);
			int i=0;
			i2=0;
			while(1){
				if(SubScripts[0]<i2){
					SetError(41,0,cp);
					return 0;
				}
				i=GetOneParameter(InitBuf,i,temporary);
				if(!SetInitGlobalData(
					offset+i2*typeSize,
					type,
					SubScripts+1,
					temporary)) return false;
				i2++;
				if(InitBuf[i]=='\0') break;
			}
			return true;
		}

		if(type.IsStruct()){
			const CClass &objClass = type.GetClass();

			int i = 0;
			BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
				if(InitBuf[i]=='\0'){
					SetError(41,0,cp);
					return false;
				}

				i=GetOneParameter(InitBuf,i,temporary);

				i3=objClass.GetMemberOffset( pMember->GetName().c_str(), NULL );

				if(!SetInitGlobalData(offset+i3,
					pMember->GetType(),
					pMember->SubScripts,
					temporary)) return false;
			}
			return true;
		}

		SetError(41,0,cp);
		return false;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if( type.IsObject() || type.IsStruct() ){
		//IuWFNg܂͍\̂̏ꍇ͂肦Ȃ
		SetError(300,NULL,cp);
		return false;
	}

	if(SubScripts[0]!=-1){
		SetError(41,0,cp);
		return false;
	}

	double dbl;
	_int64 i64data;
	Type calcType;

	if( !StaticCalculation(false, InitBuf,type.GetBasicType(),&i64data,calcType) ){
		//If[^ꍇ
		return false;
	}
	if( calcType.IsReal() ){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		calcType,
		0,0);

	if( type.IsDouble() ){
		*(double *)(initGlobalBuf+offset)=(double)dbl;
	}
	else if( type.IsSingle() ){
		*(float *)(initGlobalBuf+offset)=(float)dbl;
	}
	else if( type.Is64() ){
		*(_int64 *)(initGlobalBuf+offset)=i64data;
	}
	else if( type.IsLong() || type.IsDWord() || type.IsPointer() ){
		if(type.GetBasicType()==typeOfPtrChar){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=compiler.GetNativeCode().GetDataTable().AddString(temp,lstrlen(temp));
			HeapDefaultFree(temp);

			//mov eax,DataPos
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=(long)i2;
			pobj_DataTableSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[offset],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			*(DWORD *)(initGlobalBuf+offset)=(DWORD)i64data;
		}
	}
	else if( type.IsWord() || type.IsInteger() ){
		*(WORD *)(initGlobalBuf+offset)=(WORD)i64data;
	}
	else if( type.IsSByte() || type.IsByte() || type.IsBoolean() ){
		*(BYTE *)(initGlobalBuf+offset)=(BYTE)i64data;
	}

	return true;
}
bool InitLocalVar(int offset,const Type &type,const int *SubScripts,const char *lpszInitBuf){
	int i,i2,i3;
	char temporary[VN_SIZE];
	char InitBuf[VN_SIZE];
	lstrcpy( InitBuf, lpszInitBuf );

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		int typeSize = type.GetSize();

		if(SubScripts[0]!=-1){
			typeSize*=JumpSubScripts(SubScripts+1);
			i=0;
			i2=0;
			while(1){
				if(SubScripts[0]<i2){
					SetError(41,0,cp);
					return false;
				}
				i=GetOneParameter(InitBuf,i,temporary);
				if(!InitLocalVar(
					offset+i2*typeSize,
					type,
					SubScripts+1,
					temporary)) return false;
				i2++;
				if(InitBuf[i]=='\0') break;
			}
			return true;
		}

		if(type.IsStruct()){
			const CClass &objClass = type.GetClass();

			int i = 0;
			BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
				if(InitBuf[i]=='\0'){
					SetError(41,0,cp);
					return false;
				}

				i=GetOneParameter(InitBuf,i,temporary);

				i3=objClass.GetMemberOffset( pMember->GetName().c_str(), NULL );

				if(!InitLocalVar(offset+i3,
					pMember->GetType(),
					pMember->SubScripts,
					temporary)) return false;

				if(InitBuf[i]=='\0') break;
			}
			return true;
		}

		SetError(41,0,cp);
		return false;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if(SubScripts[0]!=-1){
		SetError(41,0,cp);
		return false;
	}

	double dbl;
	_int64 i64data;
	Type calcType;

	if( !StaticCalculation(false, InitBuf,type.GetBasicType(),&i64data,calcType) ){
		//If[^ꍇ
		return false;
	}
	if( calcType.IsReal() ){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		calcType,
		0,0);

	if( type.IsDouble() ){
		//mov eax,HILONG(dbl)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=(long)*(long *)(((char *)(&dbl))+4);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset+sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		//mov eax,LOLONG(dbl)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=*(long *)(&dbl);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if( type.IsSingle() ){
		float flt;
		flt=(float)dbl;
		//mov eax,InitValue
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=*(long *)&flt;
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if( type.Is64() ){
		//mov eax,HILONG(i64data)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=(long)*(long *)(((char *)(&i64data))+4);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset+sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		//mov eax,LOLONG(i64data)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=*(long *)(&i64data);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if( type.IsDWord() || type.IsLong() || type.IsPointer() ){
		if(type.GetBasicType()==typeOfPtrChar){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=compiler.GetNativeCode().GetDataTable().AddString(temp,lstrlen(temp));
			HeapDefaultFree(temp);

			//mov eax,DataPos
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=(long)i2;
			pobj_DataTableSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov eax,InitValue
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=(long)i64data;
			obp+=sizeof(long);
		}

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if( type.IsWord() || type.IsInteger() ){
		//mov ax,InitValue
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0xB8;
		*((WORD *)(OpBuffer+obp))=(WORD)i64data;
		obp+=sizeof(WORD);

		//mov word ptr[ebp+offset],ax
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if( type.IsSByte() || type.IsByte() || type.IsBoolean() ){
		//mov byte ptr[ebp+offset],InitValue
		OpBuffer[obp++]=(char)0xC6;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
		*((BYTE *)(OpBuffer+obp))=(BYTE)i64data;
		obp+=sizeof(BYTE);
	}

	return true;
}

void dim( char *VarName,int *SubScripts,Type &type,const char *InitBuf,const char *ConstractParameter,DWORD dwFlags){
	if( UserProc::IsGlobalAreaCompiling() ){
		/////////////////////////
		// O[oϐ
		/////////////////////////

		AddGlobalVariable(VarName,SubScripts,type,InitBuf,ConstractParameter,dwFlags);
	}
	else{
		/////////////////
		// [Jϐ
		/////////////////

		if( UserProc::CompilingUserProc().localVars.DuplicateCheck( Symbol( VarName ) ) ){
			//Qd`̃G[
			SetError(15,VarName,cp);
			return;
		}

		bool isConst = ( dwFlags & DIMFLAG_CONST ) ? true:false;

		Variable *pVar = new VariableImpl( VarName, type, isConst );

		if( SubScripts[0] != -1 ){
			//z񂠂
			pVar->SetArray( SubScripts );
		}

		//RXgN^pp[^
		pVar->paramStrForConstructor = ConstractParameter;

		//LVJXR[v
		pVar->ScopeLevel=GetLexicalScopes().GetNowLevel();
		pVar->ScopeStartAddress=GetLexicalScopes().GetStartAddress();
		pVar->bLiving=TRUE;

		//G[p
		pVar->source_code_address=cp;

		// ϐǉ
		UserProc::CompilingUserProc().localVars.push_back( pVar );

		//ACgl
		if( pVar->IsStruct() ){
			int alignment = pVar->GetClass().iAlign;

			if( alignment ){
				if( AllLocalVarSize % alignment ){
					AllLocalVarSize += alignment - (AllLocalVarSize % alignment);
				}
			}

			if( alignment == PTR_SIZE*2 ){
				// |C^ɗvTCY傫ȃACgw肳ĂƂ
				// i:CONTEXT\̂Ȃǁj
				// ĂяõItZbgYl

				if( 0 == ( UserProc::CompilingUserProc().RealParams().GetMemorySize() + PTR_SIZE/*ret*/ ) % alignment ){
					AllLocalVarSize += PTR_SIZE;
				}
			}
		}

		AllLocalVarSize += pVar->GetMemorySize();
		pVar->offset = AllLocalVarSize;

		//LVJXR[v
		pVar->ScopeLevel=GetLexicalScopes().GetNowLevel();
		pVar->ScopeStartAddress=GetLexicalScopes().GetStartAddress();
		pVar->bLiving=TRUE;

		if(InitBuf[0]){
			//̂݁A݃ANZX
			if( isConst ){
				pVar->ConstOff();
			}

			int result = 0;
			if( !pVar->IsObject() ){
				result = InitLocalVar(-pVar->offset,
					*pVar,
					pVar->GetSubScriptsPtr(),
					InitBuf);
			}

			if(!result){
				//IȎꍇ͑Zs
				char temporary[8192];
				sprintf(temporary,"%s=%s",VarName,InitBuf);
				OpcodeCalc(temporary);
			}

			if( isConst ){
				pVar->ConstOn();
			}
		}
		else{
			//push 0
			op_push_V(0);

			//push VarSize
			op_push_V( pVar->GetMemorySize() );

			//mov eax,ebp
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xC5;

			//add eax,offset
			OpBuffer[obp++]=(char)0x05;
			*((long *)(OpBuffer+obp))=-pVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//push eax
			op_push(REG_EAX);

			//call FillMemory
			OpBuffer[obp++]=(char)0xFF;
			OpBuffer[obp++]=(char)0x15;
			DllProc *pDllProc = GetDeclareHash("FillMemory");
			pDllProc->Using();
			pobj_ImportAddrSchedule->add(pDllProc);
			obp+=sizeof(long);
		}
	}

	//NewĂяo
	if( type.IsObject() &&(dwFlags&DIMFLAG_NONCALL_CONSTRACTOR)==0&&InitBuf[0]=='\0'){
		char objectSize[255];
		if( SubScripts[0] == -1 ){
			objectSize[0] = 0;
		}
		else{
			if( SubScripts[1] != -1 ){
				SetError(300,NULL,cp);
			}
			sprintf( objectSize, "%d", SubScripts[0] );
		}
		Operator_New( type.GetClass(), objectSize, ConstractParameter, type );

		//pop eax
		op_pop( REG_EAX );

		RELATIVE_VAR RelativeVar;
		GetVarOffset( true, false, VarName, &RelativeVar, Type() );
		if( RelativeVar.dwKind == VAR_DIRECTMEM ){
			SetError();
		}
		SetVariableFromEax( DEF_OBJECT, DEF_OBJECT, &RelativeVar );
	}
}

void SetVarPtrToEax(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//lea eax,dword ptr[ecx+offset]
			OpBuffer[obp++]=(char)0x8D;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov eax,offset
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//mov eax,ecx
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xC1;

			//add eax,dword ptr[offset]
			op_add_RM( sizeof(long), REG_EAX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
		}
		else{
			//mov eax,dword ptr[offset]
			op_mov_RM( sizeof(long), REG_EAX, REG_NON, (int)pRelativeVar->offset, MOD_DISP32 );
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//lea eax,dword ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0x8D;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//lea eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8D;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		if(pRelativeVar->bOffsetOffset){
			//mov eax,ecx
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xC1;

			//add eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//mov eax,ecx
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0xC1;
	}
}
void SetVarPtrToReg(int reg,RELATIVE_VAR *pRelativeVar){
	if( reg != REG_EAX ){
		SetError();
		//TODO: 
	}
	SetVarPtrToEax( pRelativeVar );
}

bool Compile_AddGlobalRootsForGc(){
	UserProc *pUserProc_AddGlobalRootPtr = GetClassMethod( "_System_CGarbageCollection", "AddGlobalRootPtr" );
	if( !pUserProc_AddGlobalRootPtr ){
		SetError(3, "_System_CGarbageCollection.AddGlobalRootPtr", -1 );
		return false;
	}

	BOOST_FOREACH( const Variable *pVar, globalVars ){
		if( pVar->IsObject() || pVar->IsPointer() || pVar->IsStruct() ){
			// IuWFNg܂̓|C^Ƃ
			// \̂܂ށibΉj

			// ϐ̈ɗvLONG_PTRPʂ̌n
			op_push_V( pVar->GetMemorySize()/PTR_SIZE );


			/////////////////////////////
			// [g|C^n

			//mov eax,offset
			op_mov_RV(REG_EAX,(int)pVar->offset);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//push eax
			op_push( REG_EAX );

			//
			/////////////////////////////


			/////////////////////////////
			// This|C^n

			SetThisPtrToReg(REG_EAX);

			//push eax
			op_push( REG_EAX );

			//
			/////////////////////////////


			// call AddGlobalRootPtr
			op_call( pUserProc_AddGlobalRootPtr );

			ReallocNativeCodeBuffer();
		}
	}

	return true;
}
