#include <jenga/include/smoothie/Class.h>
#include <jenga/include/smoothie/SmoothieException.h>

string UserProc::GetFullName() const
{
	if( HasParentClass() ){
		return GetParentClass().GetName() + "." + GetName();
	}

	return GetName();
}
bool UserProc::IsVirtual() const
{
	if( pMethod == NULL ){
		return false;
	}
	return ( pMethod->IsVirtual() != 0 );
}
const NamespaceScopes &UserProc::GetNamespaceScopes() const
{
	if( !pParentClass ){
		SmoothieException::Throw();
	}
	return pParentClass->GetNamespaceScopes();
}
const NamespaceScopesCollection &UserProc::GetImportedNamespaces() const
{
	if( !pParentClass ){
		SmoothieException::Throw();
	}
	return pParentClass->GetImportedNamespaces();
}
bool UserProc::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	SmoothieException::Throw();
	return false;
}

bool DllProc::IsEqualSymbol( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = CClass::SplitName( fullName.c_str(), AreaName, NestName );

	if( IsEqualSymbol( NamespaceScopes( AreaName ), NestName ) ){
		return true;
	}

	if( isNest ){
		// ÓIol

		char AreaName2[VN_SIZE] = "";		//IuWFNgϐ
		char NestName2[VN_SIZE] = "";		//qo
		bool isNest = CClass::SplitName( AreaName, AreaName2, NestName2 );
		lstrcat( NestName2, "." );
		lstrcat( NestName2, NestName );

		return IsEqualSymbol( NamespaceScopes( AreaName2 ), NestName2 );
	}

	return false;
}

UserProc *UserProc::pCompilingUserProc = NULL;
