#pragma once

#include <vector>
#include <string>
#include <boost/foreach.hpp>

using namespace std;

class NamespaceScopes : public vector<string>
{
public:
	NamespaceScopes(){}
	NamespaceScopes( const string &namespaceStr );
	~NamespaceScopes(){}

	string ToString() const
	{
		string namespaceStr;
		const vector<string> &me = *this;

		bool isFirst = true;
		BOOST_FOREACH( const string &itemStr, me ){
			if( isFirst ){
				isFirst = false;
			}
			else{
				namespaceStr += ".";
			}

			namespaceStr += itemStr;
		}
		return namespaceStr;
	}

	// `FbN
	bool IsEqual( const string &name ) const
	{
		if( ToString() == name ){
			return true;
		}
		return false;
	}

	// `FbN
	bool IsEqual( const NamespaceScopes &namespaceScopes ) const
	{
		if( ToString() == namespaceScopes.ToString() ){
			return true;
		}
		return false;
	}

	// Ă邩`FbN
	// :
	// baseNamespaceScopes =  "Discoversoft"
	// entryNamespaceScopes = "Discoversoft.ActiveBasic"
	// ̏ꍇAentryNamespaceScopes  baseNamespaceScopes ɏĂB
	static bool IsBelong( const NamespaceScopes &baseNamespaceScopes, const NamespaceScopes &entryNamespaceScopes )
	{
		if( baseNamespaceScopes.size() > entryNamespaceScopes.size() ){
			return false;
		}

		for( int i=0; i<(int)baseNamespaceScopes.size(); i++ ){
			if( baseNamespaceScopes[i] != entryNamespaceScopes[i] ){
				return false;
			}
		}
		return true;
	}

	bool IsLiving() const;

	// Ă邩`FbN
	// :
	// this =   "Discoversoft.ActiveBasic"
	// living = "Discoversoft.ActiveBasic"
	// name =   "ActiveBasic"
	// ̏ꍇAliving  name ĂB
	bool IsCoverd( const string &name ) const;
	bool IsCoverd( const NamespaceScopes &namespaceScopes ) const;
};

class NamespaceScopesCollection : public vector<NamespaceScopes>
{
public:
	bool IsExist( const NamespaceScopes &namespaceScopes ) const
	{
		const NamespaceScopesCollection &namespaceScopesCollection = *this;
		BOOST_FOREACH( const NamespaceScopes &tempNamespaceScopes, namespaceScopesCollection ){
			if( tempNamespaceScopes.IsEqual( namespaceScopes ) ){
				return true;
			}
		}
		return false;
	}
	bool IsExist( const string &namespaceStr ) const
	{
		return IsExist( NamespaceScopes( namespaceStr ) );
	}

	bool IsImported( const NamespaceScopes &namespaceScopes ) const
	{
		const NamespaceScopesCollection &namespaceScopesCollection = *this;
		BOOST_FOREACH( const NamespaceScopes &tempNamespaceScopes, namespaceScopesCollection )
		{
			if( namespaceScopes.IsEqual( tempNamespaceScopes ) )
			{
				return true;
			}
		}
		return false;
	}

	void SplitNamespace( const char *fullName, char *namespaceStr, char *simpleName ) const;

	static bool CollectNamespaces( const char *source, NamespaceScopesCollection &namespaceScopesCollection );
};
