#include <stdlib.h>

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/Class.h>
#include <jenga/include/smoothie/SmoothieException.h>


CClass::CClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name )
	: isReady( false )
	, Prototype( namespaceScopes, name )
	, importedNamespaces( importedNamespaces )
	, ConstructorMemberSubIndex( -1 )
	, DestructorMemberSubIndex( -1 )
	, classType( Class )
	, pobj_InheritsClass( NULL )
	, vtblNum( 0 )
	, iAlign( 0 )
	, vtbl_offset( -1 )
	, isCompilingConstructor( false )
	, isCompilingDestructor( false )
	, pobj_NextClass( NULL )
{
}
CClass::~CClass(){
	// Io
	BOOST_FOREACH( CMember *member, dynamicMembers ){
		delete member;
	}

	// ÓIo
	BOOST_FOREACH( CMember *member, staticMembers ){
		delete member;
	}
}

bool CClass::IsInheritsInterface( const CClass *pInterfaceClass ) const
{
	BOOST_FOREACH( const InheritedInterface &objInterface, interfaces ){
		if( pInterfaceClass == &objInterface.GetInterfaceClass() ){
			return true;
		}
	}
	return false;
}

bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}

BOOL CClass::DupliCheckAll(const char *name){
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if( lstrcmp( name, pMethod->pUserProc->GetName().c_str() ) == 0 ){
			return 1;
		}
	}

	return 0;
}
BOOL CClass::DupliCheckMember(const char *name){
	//d`FbN

	// Io
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	// ÓIo
	BOOST_FOREACH( CMember *pMember, staticMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	return 0;
}

//ftHg RXgN^ \bh擾
const CMethod *CClass::GetConstructorMethod() const
{
	if( ConstructorMemberSubIndex == -1 ) return NULL;
	return methods[ConstructorMemberSubIndex];
}

//fXgN^ \bh擾
const CMethod *CClass::GetDestructorMethod() const
{
	if( DestructorMemberSubIndex == -1 ) return NULL;
	return methods[DestructorMemberSubIndex];
}

//TCY擾
int CClass::GetSize() const
{
	return GetMemberOffset( NULL, NULL );
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName, int *pMemberNum ) const
{
	int i2;

	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	int offset = IsExistVirtualFunctions() ? PTR_SIZE : 0;

	int alignment;
	if(iAlign) alignment=iAlign;
	else alignment=1;

	int iMaxAlign=0;
	int i = -1;
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		i++;

		i2 = pMember->GetType().GetSize();

		//ACgZo
		int member_size;
		if( pMember->GetType().IsStruct() ){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size=i2;
		}
		if(iMaxAlign<member_size) iMaxAlign=member_size;

		//ACgl
		if(iAlign&&iAlign<member_size){
			if(offset%alignment) offset+=alignment-(offset%alignment);
		}
		else{
			if(alignment<member_size) alignment=member_size;

			if(member_size==0){
				//oȂNX
				//ȂiItZbǧvZȂj
			}
			else{
				if(offset%member_size) offset+=member_size-(offset%member_size);
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if( pMember->GetName() == memberName ){
				if(pMemberNum) *pMemberNum=i;
				return offset;
			}
		}

		//zloTCY擾
		member_size=i2 * Variable::GetSubScriptCounts(pMember->SubScripts);

		//oTCYZ
		offset+= member_size;
	}

	if(iMaxAlign<alignment) alignment=iMaxAlign;

	//ACgl
	if(alignment){
		if(offset%alignment) offset+=alignment-(offset%alignment);
	}

	if(pMemberNum) *pMemberNum=i;
	return offset;
}

int CClass::GetAlignment() const
{
	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	int alignment = IsExistVirtualFunctions() ? PTR_SIZE : 0;

	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		int member_size;
		if(pMember->GetType().IsStruct()){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size = pMember->GetType().GetSize();
		}

		//ACgZbg
		if(alignment<member_size) alignment=member_size;
	}

	if(alignment==0) return 0;

	if(iAlign) alignment=iAlign;

	return alignment;
}



int CClass::GetFuncNumInVtbl( const UserProc *pUserProc ) const
{
	int n = 0;
	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if( pMethod->pUserProc == pUserProc ) break;
		if( pMethod->IsVirtual() ) n++;
	}
	return n;
}

bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if(pMethod->IsVirtual()){
			if(pMethod->IsAbstract()){
				return true;
			}
		}
	}

	return false;
}

// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile() const
{
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile() const
{
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile() const{
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile() const{
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pClass ) const
{
	pClass = pClass->pobj_InheritsClass;
	while( pClass ){
		if( this == pClass ) return true;
		pClass = pClass->pobj_InheritsClass;
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pClass ) const
{
	if( IsEquals( pClass ) ) return true;
	return IsSubClass( pClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}



int Classes::GetHashCode(const char *name) const{
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_CLASS_HASH;
	}

	return key;
}

void Classes::DestroyClass(CClass *pobj_c){
	if(pobj_c->pobj_NextClass){
		DestroyClass(pobj_c->pobj_NextClass);
	}

	delete pobj_c;
}

Classes::Classes():
	pStringClass( NULL ),
	pObjectClass( NULL ),
	pCompilingClass( NULL ),
	pCompilingMethod( NULL ),
	ppobj_IteClass( NULL ),
	iIteMaxNum( 0 ),
	iIteNextNum( 0 )
{
	memset( pobj_ClassHash, 0, MAX_CLASS_HASH * sizeof(CClass *) );
	Clear();
}
Classes::~Classes(){
	Clear();
}
void Classes::Clear()
{
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]) DestroyClass(pobj_ClassHash[i]);
	}

	if(ppobj_IteClass)
	{
		free(ppobj_IteClass);
		ppobj_IteClass = NULL;
	}
	memset( pobj_ClassHash, 0, MAX_CLASS_HASH * sizeof(CClass *) );
}

void Classes::ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection){
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				pobj_c->ActionVtblSchedule(ImageBase,MemPos_CodeSection);

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}

const CClass *Classes::Find( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = CClass::SplitName( fullName.c_str(), AreaName, NestName );

	return Find( NamespaceScopes( AreaName ), NestName );
}

bool Classes::Insert( CClass *pClass )
{
	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	int key;
	key=GetHashCode( pClass->GetName().c_str() );

	if(pobj_ClassHash[key]){
		CClass *pobj_c2;
		pobj_c2=pobj_ClassHash[key];
		while(1){
			if( pobj_c2->IsEqualSymbol( *pClass ) ){
				//OԋyуNXdꍇ
				SmoothieException::Throw(15,pClass->GetName());
				return false;
			}

			if(pobj_c2->pobj_NextClass==0) break;
			pobj_c2=pobj_c2->pobj_NextClass;
		}
		pobj_c2->pobj_NextClass=pClass;
	}
	else{
		pobj_ClassHash[key]=pClass;
	}
	return true;
}
CClass *Classes::Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine){
	//////////////////////////////////////////////////////////////////////////
	// NXǉ
	// Ô݂o^B̑̏SetClass\bhŁI
	//////////////////////////////////////////////////////////////////////////

	CClass *pClass = Create(namespaceScopes, importedNamespaces, name);

	if(lstrcmp(name,"String")==0){
		//StringNX
		pStringClass=pClass;
	}
	if( lstrcmp( name, "Object" ) == 0 ){
		pObjectClass = pClass;
	}

	if( !Insert( pClass ) )
	{
		return NULL;
	}

	return pClass;	
}



CClass *Classes::GetStringClassPtr() const
{
	if( !pStringClass ){
		SmoothieException::Throw();
		return NULL;
	}
	return pStringClass;
}
CClass *Classes::GetObjectClassPtr() const
{
	if( !pObjectClass ){
		SmoothieException::Throw();
		return NULL;
	}
	return pObjectClass;
}

void Classes::StartCompile( UserProc *pUserProc ){
	pCompilingClass = pUserProc->GetParentClassPtr();
	if( pCompilingClass ){
		pCompilingClass->Using();

		pCompilingMethod = pCompilingClass->GetMethods().GetMethodPtr( pUserProc );
		if( !pCompilingMethod ){
			pCompilingMethod = pCompilingClass->GetStaticMethods().GetMethodPtr( pUserProc );
			if( !pCompilingMethod ){
				SmoothieException::Throw(300);
			}
		}
	}
	else{
		pCompilingMethod = NULL;
	}
}
const CClass *Classes::GetNowCompilingClass() const
{
	return pCompilingClass;
}
const CMethod *Classes::GetNowCompilingMethodInfo(){
	return pCompilingMethod;
}




//////////////////////
// Ce[^
//////////////////////

void Classes::Iterator_Init() const
{
	if(ppobj_IteClass) free(ppobj_IteClass);

	iIteMaxNum=0;
	iIteNextNum=0;
	ppobj_IteClass=(CClass **)malloc(1);

	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				ppobj_IteClass=(CClass **)realloc(ppobj_IteClass,(iIteMaxNum+1)*sizeof(CClass *));
				ppobj_IteClass[iIteMaxNum]=pobj_c;
				iIteMaxNum++;

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}
void Classes::Iterator_Reset() const
{
	iIteNextNum = 0;
}
BOOL Classes::Iterator_HasNext() const
{
	if(iIteNextNum<iIteMaxNum) return 1;
	return 0;
}
CClass *Classes::Iterator_GetNext() const
{
	CClass *pobj_c;
	pobj_c=ppobj_IteClass[iIteNextNum];
	iIteNextNum++;
	return pobj_c;
}
int Classes::Iterator_GetMaxCount() const
{
	return iIteMaxNum;
}
