#pragma once

#include <jenga/include/common/BoostXmlSupport.h>

#include <jenga/include/smoothie/ObjectModule.h>

#include <ClassImpl.h>
#include <ProcedureImpl.h>

class MetaImpl : public Meta
{
	ClassesImpl classesImpl;
	Classes *pNowClassesForDebugger;

public:
	MetaImpl( ClassesImpl *pClasses )
		: Meta( new ProcPointersImpl() )
		, classesImpl()
		, pNowClassesForDebugger( &classesImpl )
	{
	}
	MetaImpl()
		: Meta()
	{
	}


	virtual Classes &GetClasses()
	{
		return *pNowClassesForDebugger;
	}
	virtual void SetClasses( Classes *pClasses )
	{
		this->pNowClassesForDebugger = pClasses;
	}

	virtual bool AutoWrite( const std::string &filePath )
	{
		std::ofstream ofs( filePath.c_str() );

		bool isSuccessful = false;
		try{
			boost::archive::xml_oarchive oa(ofs);

			// t@CǍ
			oa << boost::serialization::make_nvp( RootTagName(), *this );

			isSuccessful = true;
		}
		catch(...){
			// s
		}

		// ͂
		ofs.close();

		return isSuccessful;
	}


	// XMLVACYp
private:
	virtual const char *RootTagName() const
	{
		return "metaImpl";
	}
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Meta );
		ar & BOOST_SERIALIZATION_NVP( classesImpl );
	}
};
BOOST_IS_ABSTRACT( Meta );
