#pragma once

#include <jenga/include/smoothie/Class.h>

class ClassImpl: public CClass
{
public:
	ClassImpl( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name )
		: CClass( namespaceScopes, importedNamespaces, name )
	{
	}
	ClassImpl()
		: CClass()
	{
	}

	//p
	virtual bool Inherits( const char *inheritNames, int nowLine );
	virtual bool InheritsClass( const CClass &inheritsClass, int nowLine );
	virtual bool InheritsInterface( const CClass &inheritsClass, int nowLine );

	//oA\bh̒ǉ
	CMember *CreateMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );
	virtual void AddMember( Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer, int nowLine );
	virtual void AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );

	virtual void AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
		bool isVirtual, bool isOverride, char *buffer, int nowLine);

	virtual LONG_PTR GetVtblGlobalOffset(void) const;
	virtual void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);


	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( CClass );
	}
};
BOOST_IS_ABSTRACT( CClass );

class ClassesImpl : public Classes
{
public:
	ClassesImpl()
		: Classes()
	{
	}

	virtual CClass *Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name);
	virtual void CollectClassesForNameOnly( const BasicSource &source );

	virtual void InitStaticMember();

private:
	bool MemberVar_LoopRefCheck(const CClass &objClass);
public:
	virtual void GetClass_recur(const char *lpszInheritsClass);
	virtual void GetAllClassInfo();
	virtual void Compile_System_InitializeUserTypes();


	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		std::vector<ClassImpl *> vectorClasses;
		ar & BOOST_SERIALIZATION_NVP( vectorClasses );

		// ǂݍ݌̏
		Clear();
		BOOST_FOREACH( CClass *pClass, vectorClasses )
		{
			Insert( pClass );
		}
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		// ۑ
		std::vector<ClassImpl *> vectorClasses;
		vectorClasses.clear();
		Iterator_Reset();
		while( Iterator_HasNext() )
		{
			vectorClasses.push_back( dynamic_cast<ClassImpl *>(Iterator_GetNext()) );
		}

		ar & BOOST_SERIALIZATION_NVP( vectorClasses );
	}
};
BOOST_IS_ABSTRACT( Classes );
