#pragma once

#include <vector>
#include <string>

#include <jenga/include/common/BoostXmlSupport.h>

#include "Namespace.h"

using namespace std;

class Symbol
{
	NamespaceScopes namespaceScopes;
	string name;
public:
	Symbol( const NamespaceScopes &namespaceScopes, const string &name )
		: namespaceScopes( namespaceScopes )
		, name( name )
	{
	}
	Symbol( const char *fullName );
	Symbol( const string &fullName );
	Symbol()
	{
	}

	const NamespaceScopes &GetNamespaceScopes() const
	{
		return namespaceScopes;
	}
	const string &GetName() const
	{
		return name;
	}

private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		//ar & BOOST_SERIALIZATION_NVP( namespaceScopes );
		ar & BOOST_SERIALIZATION_NVP( name );
	}
};
