#pragma once

#include <vector>
#include <string>
#include <fstream>
#include <sstream>

#include <boost/archive/xml_oarchive.hpp>
#include <boost/archive/xml_iarchive.hpp>

namespace Jenga{
namespace Common{

using namespace std;

template<class T_xml_schema> class BoostXmlSupport{
	virtual const char *RootTagName() const = 0;

public:
	bool Read( istream& ifs )
	{
		bool isSuccessful = false;

		try{
			boost::archive::xml_iarchive ia(ifs);

			// t@CǍ
			ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			isSuccessful = true;
		}
		catch(...){
			// s
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}

	bool Write( ostream& ofs ) const
	{
		bool isSuccessful = false;

		try{
			boost::archive::xml_oarchive oa(ofs);

			// t@Cɏo
			oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			isSuccessful = true;
		}
		catch( ... ){
			// s
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}

	bool Read( const string &xmlFilePath )
	{
		bool isSuccessful = false;

		// ̓A[JCu̍쐬
		std::ifstream ifs( xmlFilePath.c_str() );
		
		bool result = Read(ifs);

		// ͂
		ifs.close();

		return result;
	}

	bool Write( const string &xmlFilePath ) const
	{
		// o̓A[JCu̍쐬
		std::ofstream ofs( xmlFilePath.c_str() );

		bool result = Write(ofs);

		// o͂
		ofs.close();

		return result;
	}

	bool ReadFromString( const wstring &xmlBuffer )
	{
		bool isSuccessful = false;

		// ̓A[JCu̍쐬
		std::istringstream iss( xmlBuffer );

		try{
			boost::archive::xml_iarchive ia(iss);

			// Xg[Ǎ
			ia >> boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			isSuccessful = true;
		}
		catch(...){
			// s
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}
	bool ToWString( wstring &xmlBuffer ) const
	{
		bool isSuccessful = false;

		// ̓A[JCu̍쐬
		std::ostringstream oss;

		try{
			boost::archive::xml_oarchive oa(oss);

			// Xg[֏o
			oa << boost::serialization::make_nvp( RootTagName(), *(T_xml_schema *)this );

			xmlBuffer = oss.str();

			isSuccessful = true;
		}
		catch(...){
			// s
		}

		if( !isSuccessful )
		{
			return false;
		}

		return true;
	}
};


}}
