#pragma once

#include <string>
#include <vector>

#include <memory.h>
#include <windows.h>

#define JENGA_SERIALIZER(param) ( isRead?(binaly.Read(param)):(binaly << param) );

class MemoryBlock
{
	int base;
	int size;
public:
	MemoryBlock( int base, int size )
		: base( base )
		, size( size )
	{
	}
	int GetBase() const
	{
		return base;
	}
	int GetSize() const
	{
		return size;
	}
};
class Binaly
{
	static const int alignment = 1024 * 1024;

	unsigned char *pBuffer;
	int size;
	int maxSize;

	std::vector<MemoryBlock> memoryBlocks;
	int indexOfMemoryBlocks;

	// 
	void Initialize()
	{
		maxSize = alignment;
		pBuffer = (unsigned char *)calloc( maxSize, 1 );
		size = 0;

		memoryBlocks.clear();
		indexOfMemoryBlocks = 0;
	}

	// ̈̍Ċm
	void Allocator( int newSize )
	{
		size = newSize;

		if( maxSize > newSize )
		{
			// mۍς݃̃TCY܂ĂƂ
			return;
		}

		while( maxSize <= newSize )
		{
			maxSize += alignment;
		}
		pBuffer = (unsigned char *)realloc( pBuffer, maxSize );
	}
	void AddMemorySize( int plusSize )
	{
		Allocator( size + plusSize );
	}
	void ReadMemoryCheck( int readSize )
	{
		if( (int)memoryBlocks.size() < indexOfMemoryBlocks )
		{
			throw "bad memory access";
		}

		if( memoryBlocks[indexOfMemoryBlocks].GetSize() != readSize )
		{
			throw "bad memory access";
		}
	}

public:
	Binaly( const Binaly &binaly )
	{
		Initialize();
	}
	Binaly( const unsigned char *pNewBuffer, int size )
	{
		Initialize();
	}
	Binaly()
	{
		Initialize();
	}
	~Binaly()
	{
		free( pBuffer );
	}

	void Clear()
	{
		free( pBuffer );
		Initialize();
	}

	void Add( const unsigned char *pBufferOfBlock, int sizeOfBlock )
	{
		int base = this->size;
		AddMemorySize( sizeOfBlock );
		memcpy( pBuffer + base, pBufferOfBlock, sizeOfBlock );

		memoryBlocks.push_back( MemoryBlock( base, sizeOfBlock ) );
	}
	void operator<< ( int i )
	{
		Add( (const unsigned char *)&i, sizeof(int) );
	}
	void operator<< ( double dbl )
	{
		Add( (const unsigned char *)&dbl, sizeof(double) );
	}
	void operator<< ( bool b )
	{
		Add( (const unsigned char *)&b, sizeof(bool) );
	}
	void operator<< ( const std::string &str )
	{
		Add( (const unsigned char *)str.c_str(), (int)str.size() );
	}
	void operator<< ( const char *lpszStr )
	{
		Add( (const unsigned char *)lpszStr, lstrlen(lpszStr) );
	}

	int GetNextSizeToReading()
	{
		return memoryBlocks[indexOfMemoryBlocks].GetSize();
	}
	void Read( unsigned char *pBuffer, int readSize )
	{
		ReadMemoryCheck( readSize );

		memcpy(
			pBuffer,
			this->pBuffer + memoryBlocks[indexOfMemoryBlocks].GetBase(),
			memoryBlocks[indexOfMemoryBlocks].GetSize()
		);

		indexOfMemoryBlocks++;
	}
	void Read( int &i )
	{
		Read( (unsigned char *)&i, sizeof(int) );
	}
	void Read( bool &b )
	{
		Read( (unsigned char *)&b, sizeof(bool) );
	}
	void Read( std::string &str )
	{
		str = std::string(
			(const char *)pBuffer + memoryBlocks[indexOfMemoryBlocks].GetBase(),
			memoryBlocks[indexOfMemoryBlocks].GetSize()
		);
	}
};
